{$F+,O+,I-}
UNIT RWBT;

(* 

    RWBT - ReneWave file transfer/archive routines

    RENEWAVE is Copyright (C) 1994-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of RENEWAVE.

    RENEWAVE is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RENEWAVE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RENEWAVE; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)

INTERFACE


VAR CountdownSecs : Byte;
    DoorProc      : FUNCTION(s:string;b:boolean):Byte;


PROCEDURE RWB_AddTime(Mins:Integer);
PROCEDURE RWB_ChatMode;
PROCEDURE RWB_DosShell;
FUNCTION  RWB_DummyDoorProc(s:string; b:boolean):Byte;
PROCEDURE RWB_CarrierLoss;

PROCEDURE RWB_ExecError(ErrNum:Byte; ArcOrProt:Boolean);
PROCEDURE RWB_ExitError(ArcOrProt:Boolean);
FUNCTION  RWB_RandomFilename:String;
PROCEDURE RWB_CheckLogoff;
FUNCTION  RWB_DoorMciConv(s:String):String;

FUNCTION  RWB_CompressPacket(ArchiveName,IncludeFiles:String) : Boolean;
FUNCTION  RWB_UnCompressPacket(ArchiveName:String):Boolean;
FUNCTION  RWB_SendFile(FileName:String):Boolean;
FUNCTION  RWB_ReceiveFile(FileName:String):Boolean;
FUNCTION  RWB_ShowPacketInfo(PacketPath,PacketName:String):Boolean;
PROCEDURE RWB_ShowULInfo;


IMPLEMENTATION


USES {$I FOSSTYPE.INC }

     DOS,      CRT,      MISC1,    MSTRINGS, UNIXDATE, MSRGGEN,
     RWMAIN,   RWLOGS,   RWSTRUCT, RECORDS,  RWVARS,   MSBWGEN,
     MSBWOVR,  RWBB,     RWACS,    RWMENUS,  EXECSWAP, FASTW,
     MSZ_MAIN;


PROCEDURE RWB_CarrierLoss;
BEGIN
END;


PROCEDURE RWB_ChatMode;
VAR Done,
    NewLine  : Boolean;
    TempS    : String;

    PROCEDURE DoWrap(VAR Line:String);
    VAR StrPos:Byte; WrapStuff:String;
    BEGIN
       NewLine := FALSE;
       StrPos := Length(Line);
       WrapStuff := '';
       IF StrPos > 0 THEN
          BEGIN
             WHILE (Line[StrPos] <> ' ') AND (StrPos > (Length(Line)-20)) DO Dec(StrPos);
             IF Line[StrPos] = ' ' THEN
                BEGIN
                   WrapStuff := Copy(Line,StrPos,Length(Line)-StrPos+1);
                   FOR StrPos := Length(Line) DOWNTO StrPos DO RWM_WriteColor(#8#32#8);
                END;
          END;
       WrapStuff := StripLeadingCh(WrapStuff,' ');
       RWM_WriteColor(#13#10+WrapStuff);
       Line := WrapStuff;
    END;

    PROCEDURE ReadLine(VAR TempLine:String);
    VAR CharNum:Byte; Ch:Char; Crap:STring; Local:Boolean;
    BEGIN
       CharNum := Length(TempLine);
       REPEAT
          REPEAT fk_IdleTick UNTIL KeyPressed OR fk_RemoteKeyPressed;
          Local := KeyPressed;
          IF Local THEN Ch := ReadKey ELSE Ch := fk_Read;
          CASE ch OF
             #0  : IF KeyPressed THEN
                      BEGIN
                         CASE ReadKey OF
{ ALT-C }                   #46 : BEGIN
                                     Done := TRUE;
                                     Exit;
                                  END;
{ LEFT  }                   #75 : IF fk_Host.StatusLineMod > 1 THEN Dec(fk_Host.StatusLineMod);
{ RIGHT }                   #77 : IF fk_Host.StatusLineMod < 3 THEN Inc(fk_Host.StatusLineMod);
{ ALT-- }                  #130 : RWB_AddTime(-5);
{ ALT-+ }                  #131 : RWB_AddTime(5);
{ ALT-J }                   #36 : RWB_DosShell;
                         END;
                         Ms_DrawStatus;
                      END;
             #8  : IF TempLine <> '' THEN
                      BEGIN
                         RWM_WriteColor(#8#32#8);
                         Dec(TempLine[0]);
                         Dec(CharNum);
                      END;
             #13 : TempLine := '';
             ELSE IF Ch <> #0 THEN
                BEGIN
                   Inc(CharNum);
                   TempLine := TempLine + Ch;
                   IF Local
                      THEN Crap := '^'+StrFunc(MsRg_General.SysopColor)
                      ELSE Crap := '^'+StrFunc(MsRg_General.UserColor);
                   RWM_WriteColor(Crap);
                   RWM_WriteColor(Ch);
                END;
          END;

          Done    := UpcaseStr(TempLine) = '/Q';
          NewLine := (Ch = #13) OR (CharNum >= 79);
       UNTIL NewLine OR Done;
    END;

BEGIN
   fk_WriteLn('',2);
   RWM_WriteColor(RWM_GetString(17));
   RWM_WriteColor(#13#10#13#10);
   TempS := '';
   REPEAT
      ReadLine(TempS);
      IF NewLine THEN DoWrap(TempS);
   UNTIL Done;
   fk_WriteLn('',1);
   RWM_WriteColor(RWM_GetString(18));
   RWM_WriteColor(#13#10+#13#10);
END;


PROCEDURE RWB_DosShell;
VAR TempScreen:^ScreenType;
BEGIN
   RWM_WriteColor(RWM_GetString(15)+#13#10);
   New(TempScreen);
   ReadScreen(TempScreen^);

   DoorProc(GetEnv('COMSPEC'),FALSE);

   WriteScreen(TempScreen^);
   Dispose(TempScreen);
   RWM_WriteColor(RWM_GetString(16)+#13#10);
END;


PROCEDURE RWB_AddTime(Mins:Integer);
BEGIN
   MsRg_User.TLToday := MsRg_User.TLToday+Mins;
   IF MsRg_User.TLToday < 0 THEN MsRg_User.TLToday := 0;
   MsRg_UserFileWrite(RgUserNum);
   fk_Client.TimeLeft := fk_Client.TimeLeft+(Mins*60);
   IF fk_Client.TimeLeft < 0 THEN fk_Client.TimeLeft := 0;
END;


PROCEDURE RWB_CheckLogoff;
VAR dow:Byte; CurrSecs,NewSecs:LongInt; ch:Char;
    OldNC:Procedure;
BEGIN
   RWM_KeyPressOff;

   IF (CountdownSecs = 0) OR (NOT (RwConfig.AllowGoodbye)) THEN Exit;
   fk_WriteLn('',1);
   IF (CountDownSecs < 255) THEN
      BEGIN
         RWM_WriteColor(RWM_GetString(90));
         RWM_WriteColor(PadRight(StrFunc(CountDownSecs),' ',3));
         CurrentSecs(CurrSecs,DOW);
         REPEAT
            CurrentSecs(NewSecs,DOW);
            RWM_WriteColor(#8#8#8+PadRight(StrFunc(CountdownSecs-(NewSecs-CurrSecs)),' ',3));
            IF fk_KeyPressed THEN ch := Upcase(fk_Read);
         UNTIL (ch IN [#13,#27]) OR (NewSecs - CurrSecs = CountDownSecs);
         IF (ch = #27) THEN Exit;
      END;
   RWL_WriteLog('=',RWL_LogTime+' User logged off; dropping carrier.');
   OldNC := fk_CarrierLoss;
   fk_CarrierLoss := RWB_CarrierLoss;
   fk_ToggleDTR(FALSE); Delay(1000);
   fk_ToggleDTR(TRUE);  Delay(1000);
   fk_CarrierLoss := OldNC;
   Halt(0);
END;


FUNCTION  RWB_ShowPacketInfo(PacketPath,PacketName:String):Boolean;
VAR ch,ch2       : Char;
    Choices      : String[6];
    f            : FILE;
    PktSize      : LongInt;
    Prot         : Byte;

    PROCEDURE Init;
    BEGIN
       CountdownSecs := 0;
       Prot := RWM_FindProt(RwUser.RwProtocol);
       Assign(f,PacketPath+PacketName);
       Reset(f,1);
       PktSize := FileSize(f);
       Close(f);
       RWL_WriteLog('-',RWL_LogTime+' Packet: '+PacketName);
       RWL_WriteLog('-',RWL_LogTime+'         '+StrFunc(PktSize)+' bytes');
       RWL_WriteLog('-',RWL_LogTime+'         '+MSBW_TransferTime(PktSize)+' minute(s)');
       Choices := RWM_GetStringR(106,6);
    END;

    PROCEDURE DispInfo;
    BEGIN
       fk_ClrScr;
       RwVariables^[1] := PacketName;
       RwVariables^[2] := StrFunc(PktSize);
       RwVariables^[3] := MSBW_TransferTime(PktSize);

       RWM_WriteColor(RWM_GetString(91));
       RWM_WriteColor(RWM_GetString(92));
       RWM_WriteColor(RWM_GetString(93));
       RWM_WriteColor(RWM_GetString(94));
       RWM_WriteColor(RWM_GetString(95));

       IF RwConfig.AllowGoodbye THEN
          BEGIN
             RWM_WriteColor(RWM_GetString(96));
             RWM_WriteColor(RWM_GetString(97));
          END;

       RWM_WriteColor(RWM_GetString(98));
       RWM_WriteColor(RWM_GetString(99));
       RWM_WriteColor(RWM_GetString(100));

       IF (FAttachNum > 0) AND EvalAcs(RwConfig.AttachAcs) THEN RWM_WriteColor(RWM_GetString(108));
       IF (FAttachNumI > 0) AND (RwConfig.RwProtocols[Prot].Batch=FALSE) THEN RWM_WriteColor(RWM_GetString(109));

       RWM_WriteColor(RWM_GetString(101));
    END;

    PROCEDURE GetChoice;
    BEGIN
       RWM_KeyPressOn;
       fk_PurgeInputBuffer;
       FlushKeyboard;
       IF WarpDL
          THEN ch := #13
          ELSE BEGIN
               ch := ' ';
               REPEAT
                  ch := Upcase(fk_Read);
               UNTIL Pos(ch,#13+Choices) > 0;
               fk_WriteLn('',2);
            END;
       RWM_KeyPressOff;
    END;

    PROCEDURE ProcChoice;
    BEGIN
       IF      ch = Choices[4] THEN RWM_ChooseProtocol
       ELSE IF ch = Choices[1] THEN
          BEGIN
             RWM_KeyPressOn;
             RWM_WriteColor(RWM_GetString(28));
             RWM_WriteColor(RWM_GetString(31));
             ch2 := RWM_GetYesOrNo(FALSE);
             fk_WriteLn('',2);
             RWL_WriteLog('-',RWL_LogTime+' Download session aborted!');
             RWM_KeyPressOff;
             IF (ch2 = RWM_GetCh(3,1))
                THEN RWB_ShowPacketInfo := TRUE
                ELSE BEGIN
                      RWL_WriteLog('=',RWL_LogTime+' Lastread pointers NOT updated');
                      RWB_ShowPacketInfo := FALSE;
                   END;
          END
       ELSE IF ch = Choices[2] THEN CountdownSecs := 10
       ELSE IF ch = Choices[3] THEN CountdownSecs := 255
       ELSE IF ch = Choices[6] THEN RWB_EditQueue;
    END;

    PROCEDURE DeInit;
    BEGIN
       IF (FAttachNumI > 0) AND NOT Regd AND NOT WarpDL THEN
          BEGIN
             RWM_WriteColor('|12Sorry, the file attaches you flagged could not be sent - file attach support'+#13#10);
             RWM_WriteColor('|12is a feature which is only available in registered copies of ReneWave.  Please'+#13#10);
             RWM_WriteColor('|12encourage your sysop to support the shareware concept register ReneWave!'+#13#10);
             RWM_Pause;
          END;
       IF (ch <> Choices[1]) THEN
          BEGIN
             IF (fk_Fossil.Baud > 0)
                THEN RWB_ShowPacketInfo := RWB_SendFile(PacketPath+PacketName)
                ELSE RWB_ShowPacketInfo := TRUE;
          END;
       IF (fk_Fossil.Baud > 0) THEN Erase(f);
    END;

BEGIN
   Init;
   REPEAT
      DispInfo;
      GetChoice;
      ProcChoice;
   UNTIL (ch <> Choices[4]) AND (ch <> Choices[6]);
   DeInit;
END;


PROCEDURE RWB_ShowULInfo;
VAR StrPos:Byte; p:RwProtRec;
BEGIN
   RWM_KeyPressOff;
   fk_ClrScr;
   IF NOT (RwPacketQwk IN RwUser.RwFlags) THEN RwVariables^[1] := 'NEW' ELSE RwVariables^[1] := 'REP';
   RWM_WriteColor(RWM_GetString(332));
   RWM_WriteColor(RWM_GetString(333));
   RWM_WriteColor(RWM_GetString(334));
END;


FUNCTION RWB_DoorMciConv(s:String):String;
VAR TempS : String;

    PROCEDURE InsertMci(Pos:Byte; Str:String);
    BEGIN
       Delete(TempS,Pos,2);
       Insert(Str,TempS,Pos);
    END;

BEGIN
   TempS := S;
   WHILE Pos('%A',TempS) > 0 DO InsertMCI(Pos('%A',TempS),StrFunc(fk_Fossil.Baud));
   WHILE Pos('%B',TempS) > 0 DO InsertMCI(Pos('%B',TempS),StrFunc(fk_Fossil.Locked));
   WHILE Pos('%C',TempS) > 0 DO InsertMCI(Pos('%C',TempS),MsRg_Node.Address);
   WHILE Pos('%D',TempS) > 0 DO InsertMCI(Pos('%D',TempS),MciF_FileName);
   WHILE Pos('%E',TempS) > 0 DO InsertMCI(Pos('%E',TempS),MsRg_Node.IRQ);
   WHILE Pos('%F',TempS) > 0 DO InsertMCI(Pos('%F',TempS),MciF_FileName);
   WHILE Pos('%I',TempS) > 0 DO InsertMCI(Pos('%I',TempS),MciF_ArcFileIncl);
   WHILE Pos('%L',TempS) > 0 DO InsertMCI(Pos('%L',TempS),MciF_TempLog);
   WHILE Pos('%M',TempS) > 0 DO InsertMCI(Pos('%M',TempS),RwConfig.RgMainDir);
   WHILE Pos('%N',TempS) > 0 DO InsertMCI(Pos('%N',TempS),StrFunc(fk_Host.Node));
   WHILE Pos('%P',TempS) > 0 DO InsertMCI(Pos('%P',TempS),StrFunc(fk_Fossil.Port));
   RWB_DoorMCIConv := TempS;
END;


FUNCTION RWB_RandomFilename:String;
VAR TempStr:String; StrPos:Byte;
BEGIN
   Randomize;
   TempStr := 'RW_';
   FOR StrPos := 4 TO 8 DO TempStr[StrPos] := Chr(Random(25)+65);
   TempStr[0] := Chr(8);
   TempStr := TempStr+'.'+RwNodeStr;
   RWB_RandomFilename := RwConfig.RwMainDir+TempStr;
END;


PROCEDURE RWB_ExitError(ArcOrProt:Boolean);
BEGIN
   RWM_WriteColor(#13#10+'|12');
   IF ArcOrProt
      THEN fk_WriteLn('Archiver unsucessfull.',2)
      ELSE fk_WriteLn('Transfer unsuccessfull.',2);
   fk_TextColor(7);
END;


PROCEDURE RWB_ExecError(ErrNum:Byte; ArcOrProt:Boolean);
VAR TempS,ErrorStr:String;
BEGIN
   IF ArcOrProt THEN TempS := 'archiver.' ELSE TempS := 'protocol.';
   fk_TextColor(12); TextAttr := 12;
   fk_WriteLn('',1);
   fk_Write('Error');
   Write(' (#'+StrFunc(ErrNum)+') ');
   fk_Write('executing '+TempS);
   Write(#8#32+'- ');
   CASE ErrNum OF
      2 : ErrorStr := 'File not found';
      3 : ErrorStr := 'Path not found';
      5 : ErrorStr := 'Access denied';
      6 : ErrorStr := 'Invalid handle';
      8 : ErrorStr := 'Not enough memory';
     10 : ErrorStr := 'Invalid environment';
     11 : ErrorStr := 'Invalid format';
     18 : ErrorStr := 'No more files';
     ELSE ErrorStr := 'Unknown Error';
   END;
   Write(ErrorStr);
   RWL_WriteLog('!',RWL_LogTime+'Error (#'+StrFunc(ErrNum)+') executing '+TempS+' - '+ErrorStr);
   { blah }
   fk_WriteLn('',2);
   Delay(2000);
   TextAttr := 7; fk_TextColor(7);
END;


PROCEDURE RWB_WriteBatchList(FileName:String);
VAR f:Text;
BEGIN
   Assign(f,RwWorkDir+'XF.LST');
   Rewrite(f);
   WriteLn(f,FileName);
   IF (FAttachNum > 0) AND Regd THEN
      BEGIN
         FAttach := FAttachRoot;
         WHILE (FAttach <> NIL) DO
            BEGIN
               IF FAttach^.Include THEN
                  BEGIN
                     CopyFile(FAttach^.RealFile,RwWorkDir+FAttach^.FileName,TRUE);
                     WriteLn(f,RwWorkDir+FAttach^.FileName);
                  END;
               FAttach := FAttach^.Next;
            END;
      END;
   Close(f);
END;


FUNCTION RWB_SendFile(FileName:String):Boolean;
VAR p:RwProtRec; CmdLine:String; ExecRes,ExitCode:Word; f:Text; Res:Boolean;

    PROCEDURE InitProt;
    BEGIN
       IF p.Batch
          THEN BEGIN
                MciF_FileName := '@'+RwWorkDir+'XF.LST';
                RWB_WriteBatchList(FileName);
             END
          ELSE MciF_FileName := FileName;

       MciF_TempLog  := RWB_DoorMciConv(p.LogFile);
       CmdLine       := RWB_DoorMciConv(MsRg_General.ProtPath+p.Send);
    END;

    PROCEDURE InitBatch;
    BEGIN
       Assign(f,RwWorkDir+'RWTEMP.BAT');
       Rewrite(f);
       WriteLn(f,'@ECHO OFF');
       WriteLn(f,RWB_DoorMciConv(p.EnvCmd));
       WriteLn(f,CmdLine);
       WriteLn(f,'EXIT');
       Close(f); IF IOResult <> 0 THEN ;
    END;

    FUNCTION CheckResult:Boolean;
    VAR TempRes:Boolean; lf:Text; s:String;
    BEGIN
       IF NOT p.Batch
          THEN BEGIN
                IF p.ResultT
                   THEN TempRes := DosExitCode = p.ErrLev
                   ELSE TempRes := DosExitCode <> p.ErrLev;
             END
          ELSE BEGIN
                TempRes := FALSE;
                IF FExists(MciF_TempLog) THEN
                   BEGIN
                      Assign(lf,MciF_TempLog);
                      Reset(lf);
                      WHILE NOT Eof(lf) DO
                         BEGIN
                            ReadLn(lf,s);
                            IF GetWord(s,11) = FileName THEN
                               BEGIN
                                  s := GetWord(s,1);
                                  TempRes := (s=p.ResultD[1]) OR (s=p.ResultD[2]) OR (s=p.ResultD[3]);
                                  IF NOT p.ResultT THEN TempRes := NOT TempRes;
                               END;
                         END;
                      Close(lf);
                   END;
             END;
       CheckResult := TempRes;
    END;

    PROCEDURE RunProt;
    BEGIN
       RWL_WriteLog('-',RWL_LogTime+' Executing "'+CmdLine+'"');
       ExecRes := DoorProc(RwWorkDir+'RWTEMP.BAT',TRUE);
       RWL_WriteLog('-',RWL_LogTime+' Debug: '+StrFunc(ExecRes));
       RWL_WriteLog('-',RWL_LogTime+' DOS exit code = '+StrFunc(ExitCode));
       Res := (ExecRes = 0) AND CheckResult;
       IF (ExecRes <> 0) THEN RWB_ExecError(ExecRes,FALSE) ELSE IF (Res=FALSE) THEN RWB_ExitError(FALSE);
       Erase(f); IF IOResult <> 0 THEN ;
    END;

    PROCEDURE DeInitProt;
    BEGIN
       IF Res
          THEN RWL_WriteLog('-',RWL_LogTime+' '+FileName+' successfully sent')
          ELSE RWL_WriteLog('?',RWL_LogTime+' File(s) transfer unsuccessful');
    END;

    PROCEDURE InternalSend;
    BEGIN
       DispName := fk_Client.Handle;
       Msz_LogFile := RwWorkDir+'MSZ.'+RwNodeStr;
       MciF_TempLog := Msz_LogFile;
       p.Batch := NOT (p.IntProt IN [Int_X,Int_X1K,Int_X1KG]);
       p.ResultT := TRUE;
       p.ResultD[2] := ' ';
       p.ResultD[3] := ' ';
       IF (p.IntProt=Int_Zap) OR (p.IntProt=Int_Z)
          THEN p.ResultD[1] := 'z'
          ELSE p.ResultD[1] := 'S';

       CASE p.IntProt OF
          Int_X     : Msz_ProtType := Send_X;
          Int_X1K   : Msz_ProtType := Send_X1K;
          Int_X1KG  : Msz_ProtType := Send_X1KG;
          Int_Y     : Msz_ProtType := Send_Y;
          Int_Y1K   : Msz_ProtType := Send_Y1K;
          Int_YG    : Msz_ProtType := Send_YG;
          Int_Z     : Msz_ProtType := Send_Z;
          Int_Zap   : Msz_ProtType := Send_Zap;
       END;

       IF (Msz_ProtType IN [Send_X,Send_X1K,Send_X1KG])
          THEN Msz_FileSpec := FileName
          ELSE BEGIN
                RWB_WriteBatchList(FileName);
                Msz_FileSpec := '@'+RwWorkDir+'XF.LST';
             END;
       RWL_WriteLog('-',RWL_LogTime+' Sending file(s) with "'+p.Desc+'"');
       Res := MSZ_RunMsz;
       IF p.Batch THEN Res := CheckResult;
    END;

BEGIN
   RWM_KeyPressOff;
   p := RwConfig.RwProtocols[RWM_FindProt(RwUser.RwProtocol)];
   IF Ord(p.IntProt) > 0
      THEN InternalSend
      ELSE BEGIN
            InitProt;
            InitBatch;
            RunProt;
         END;
   DeInitProt;
   RWB_SendFile := Res;
END;


function RWB_ReceiveFile(FileName:String):Boolean;
var
  p        : RwProtRec;
  CmdLine  : String;
  ExecRes,
  ExitCode : Word;
  f        : Text;
  Res      : Boolean;

  procedure InitProt;
  begin
    if p.Batch
      then
        MciF_FileName := ''
      else
        MciF_FileName := FileName;

    MciF_TempLog := RWB_DoorMciConv(p.LogFile);
    CmdLine := RWB_DoorMciConv(MsRg_General.ProtPath+p.Recv);
  end;

  procedure InitBatch;
  begin
    Assign(f,RwWorkDir+'RWTEMP.BAT');
    Rewrite(f);
    WriteLn(f,'@ECHO OFF');
    WriteLn(f,RWB_DoorMciConv(p.EnvCmd));
    WriteLn(f,CmdLine);
    WriteLn(f,'EXIT');
    Close(f);
  end;

  function CheckResult:Boolean;
  var
    TempRes  : Boolean;
    lf       : Text;
    s        : String;
  begin
    if not p.Batch
      then
        begin
          if p.ResultT
            then TempRes := DosExitCode = p.ErrLev
            else TempRes := DosExitCode <> p.ErrLev;
        end
      else ;

{ **> There is no beed for upload queue with batch protocols

        begin
          TempRes := FALSE;
          if FExists(MciF_TempLog)
            then
              begin
                Assign(lf,MciF_TempLog);
                Reset(lf);
                while not Eof(lf) do
                  begin
                    ReadLn(lf,s);
                    s := UpcaseStr(s);
                    if ExtractFName(GetWord(s,11)) = ExtractFName(FileName)
                      then
                        begin
                          s := GetWord(s,1);
                          TempRes := (s=p.ResultU[1]) OR (s=p.ResultU[2]) OR (s=p.ResultU[3]);
                          if not p.ResultT then TempRes := not TempRes;
                        end;
                  end;
                  Close(lf);
                end;
        end;
        }
    CheckResult := TempRes;
  end;

  procedure RunProt;
  begin
    RWL_WriteLog('-',RWL_LogTime+' Executing "'+CmdLine+'"');
    ExecRes := DoorProc(RwWorkDir+'RWTEMP.BAT',TRUE);
    RWL_WriteLog('-',RWL_LogTime+' DOS exit code = '+StrFunc(DosExitCode));
    Res := (ExecRes = 0) AND CheckResult;
    if (ExecRes <> 0)
      then
        RWB_ExecError(ExecRes,FALSE)
      else
        if (Res=FALSE)
          then
            RWB_ExitError(FALSE);
    Erase(f);
    if IOResult <> 0 then ;
  end;

  procedure DeInitProt;
  begin
    if Res
      then
        RWL_WriteLog('-',RWL_LogTime+' '+FileName+' successfully received')
      else
        RWL_WriteLog('?',RWL_LogTime+' File(s) transfer unsuccessful');
  end;

  procedure InternalRecv;
  begin
    DispName := fk_Client.Handle;
    Msz_LogFile := RwWorkDir+'MSZ.'+RwNodeStr;
    MciF_TempLog := Msz_LogFile;
    p.Batch := NOT (p.IntProt IN [Int_X,Int_X1K,Int_X1KG]);
    p.ResultT := TRUE;
    p.ResultU[2] := '';
    p.ResultU[3] := '';

    if (p.IntProt=Int_Zap) OR (p.IntProt=Int_Z)
      then
        p.ResultU[1] := 'Z'
      else
        p.ResultU[1] := 'R';

    case p.IntProt of
      Int_X     : Msz_ProtType := Recv_X;
      Int_X1K   : Msz_ProtType := Recv_X1K;
      Int_X1KG  : Msz_ProtType := Recv_X1KG;
      Int_Y     : Msz_ProtType := Recv_Y;
      Int_Y1K   : Msz_ProtType := Recv_Y1K;
      Int_YG    : Msz_ProtType := Recv_YG;
      Int_Z     : Msz_ProtType := Recv_Z;
      Int_Zap   : Msz_ProtType := Recv_Zap;
    end;

    Msz_FileSpec := FileName;
    if p.Batch
      then
        Msz_FileSpec := ''
      else
        Msz_FileSpec := FileName;
    RWL_WriteLog('-',RWL_LogTime+' Receiving file(s) with "'+p.Desc+'"');
    Res := MSZ_RunMsz;
    if p.Batch
      then
        Res := CheckResult;
  end;

begin
  RWM_KeyPressOff;
  p := RwConfig.RwProtocols[RWM_FindProt(RwUser.RwProtocol)];
  if Ord(p.IntProt) > 0
    then
      InternalRecv
    else
      begin
        InitProt;
        InitBatch;
        RunProt;
      end;
   DeInitProt;
   RWB_ReceiveFile := Res;
end;


FUNCTION RWB_CompressPacket(ArchiveName,IncludeFiles:String):Boolean;
VAR CmdLine:String; ExecRes,ExitCode:Word; ArcInfo:FileArcInfoRec;
BEGIN
   RWM_KeyPressOff;
   WITH MsRg_User,MsRg_General DO
      IF (DefArcType=0) OR (DefArcType > MaxArcs) OR (FileArcInfo[DefArcType].Active=FALSE)
         THEN RWM_ChooseArchiver;

   ArcInfo := MsRg_General.FileArcInfo[MsRg_User.DefArcType];

   MciF_FileName    := ArchiveName;
   MciF_ArcFileIncl := IncludeFiles;
   MciF_ArcFilePath := RwWorkDir;

   RWM_WriteColor(RWM_GetString(104));

   CmdLine := RWB_DoorMciConv(MsRg_General.ArcsPath+ArcInfo.ArcLine);

   RWL_WriteLog('-',RWL_LogTime+' Executing "'+CmdLine+'"');
   ExecRes := DoorProc(CmdLine,FALSE);
   ExitCode := DosExitCode;
   RWL_WriteLog('-',RWL_LogTime+' Exit code = '+StrFunc(ExitCode));
   fk_WriteLn('',1);

   IF (ExecRes <> 0) THEN RWB_ExecError(ExecRes,TRUE);
   IF (ExitCode <> ArcInfo.SuccLevel) THEN RWB_ExitError(FALSE);

   IF (ExecRes = 0) AND (ExitCode = ArcInfo.SuccLevel) AND FExists(ArchiveName)
      THEN RWL_WriteLog('-',RWL_LogTime+' '+ArchiveName+' successfully archived using '+ArcInfo.Ext)
      ELSE RWL_WriteLog('?',RWL_LogTime+' Archiver unsuccessful.');

   RWB_CompressPacket := (ExecRes = 0) AND (ExitCode = ArcInfo.SuccLevel) AND FExists(ArchiveName);
END;


function RWB_UnCompressPacket(ArchiveName:String):Boolean;
var
  CmdLine   : String;
  ExecRes,
  ExitCode  : Word;
  ArcInfo   : FileArcInfoRec;
begin
  RWM_KeyPressOff;

  with MsRg_User,MsRg_General do
    if (DefArcType=0) OR (DefArcType > MaxArcs) OR (FileArcInfo[DefArcType].Active=FALSE)
      then
        RWM_ChooseArchiver;

  ArcInfo := MsRg_General.FileArcInfo[MsRg_User.DefArcType];
  MciF_FileName := ArchiveName;
  MciF_ArcFileIncl := '*.*';
  MciF_ArcFilePath := RwWorkDir;

  RWM_WriteColor(RWM_GetString(105));

  CmdLine := RWB_DoorMciConv(MsRg_General.ArcsPath+ArcInfo.UnArcLine);
  RWL_WriteLog('-',RWL_LogTime+' Executing "'+CmdLine+'"');
  ExecRes := DoorProc(CmdLine,FALSE);
  ExitCode := DosExitCode;
  RWL_WriteLog('-',RWL_LogTime+' Exit code = '+StrFunc(ExitCode));
  fk_WriteLn('',1);

  if (ExecRes <> 0)
    then
      RWB_ExecError(ExecRes,TRUE);

  if (ExitCode <> ArcInfo.SuccLevel)
    then
      RWB_ExitError(FALSE);

  if (ExecRes = 0) AND (ExitCode = ArcInfo.SuccLevel)
     then
       RWL_WriteLog('-',RWL_LogTime+' '+ArchiveName+' successfully unarchived using '+ArcInfo.Ext)
     else
       RWL_WriteLog('?',RWL_LogTime+' Archiver unsuccessful.');

  RWB_UnCompressPacket := (ExecRes = 0) AND (ExitCode = ArcInfo.SuccLevel);
end;


FUNCTION RWB_DummyDoorProc(s:string; b:boolean):Byte;
BEGIN
END;


END.

