{$O+,F+,I-}
UNIT RWBD;

(* 

    RWBD - ReneWave mail packet bundling (downloads)

    RENEWAVE is Copyright (C) 1994-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of RENEWAVE.

    RENEWAVE is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RENEWAVE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RENEWAVE; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)

INTERFACE

USES  BWSTRUCT,RECORDS;

CONST FtiBuffMax = 64;

TYPE  UPointerRec = RECORD
         Update   : Boolean;
         BaseNum  : Word;
         LastMsg  : Word;
         LastDate : LongInt;
      END;

VAR   NukeEmailFile : FILE;
      NukeEmail     : Word;
      UPointerData  : UPointerRec;
      UPointerFile  : FILE OF UPointerRec;

TYPE  FtiBuffType   = Array[1..FtiBuffMax] OF FtiRec;
VAR   FtiBuff       : ^FtiBuffType;
      FtiBuffLen    : Word;

      NumOfTotal    : LongInt;


PROCEDURE RWD_InitPointerData;
PROCEDURE RWD_DeInitPointerData;
PROCEDURE RWD_NukeEmail;

PROCEDURE RWD_WriteInfConf(VAR Inf:Inf_AreaInfo);
PROCEDURE RWD_WriteInfSpecial;
PROCEDURE RWD_WriteInf;

PROCEDURE RWD_FlushFtiBuff;
PROCEDURE RWD_FlushMsgBuff;
PROCEDURE RWD_DeInitBundleFiles;
PROCEDURE RWD_UpdateGraph;
FUNCTION  RWD_ProcAllBases:Boolean;
FUNCTION  RWD_WriteDat:LongInt;
PROCEDURE RWD_WriteFti;


IMPLEMENTATION


USES  {$I FOSSTYPE.INC }

      DOS,      CRT,      MSTRINGS, MISC1,    UNIXDATE, RWBB,
      RWMAIN,   RWACS,    RWLOGS,   RWSTRUCT, MSBWGEN,  MSRGGEN,
      RWVARS,   MSBWOVR;


PROCEDURE RWD_InitPointerData;
BEGIN
   Assign(UPointerFile,RwConfig.RwWorkDir+'UPDPNTRS.'+RwNodeStr);
   Rewrite(UPointerFile);
   Assign(NukeEmailFile,RwConfig.RwWorkDir+'NUKEMSGS.'+RwNodeStr);
   Rewrite(NukeEmailFile,2);
END;


PROCEDURE RWD_DeInitPointerData;
BEGIN
   Close(NukeEmailFile); IF IOResult <> 0 THEN ;
   Close(UPointerFile);  IF IOResult <> 0 THEN ;
   NukeFiles(RwConfig.RwWorkDir+'UPDPNTRS.'+RwNodeStr);
   NukeFiles(RwConfig.RwWorkDir+'NUKEMSGS.'+RwNodeStr);
END;


PROCEDURE RWD_NukeEmail;
VAR ThisBase,i:Word;
BEGIN
   IF NOT (RwNukeEmail IN RwUser.RwFlags) OR (FileSize(NukeEmailFile)=0) THEN Exit;

   IF PrescanMode
      THEN WritePipe('|09 |11Nuking private e-mail/netmail messages')
      ELSE RWM_WriteColor(RWM_GetString(33));

   Assign(MsgHdrFile,MsRg_General.MsgPath+'EMAIL.HDR');
   Reset(MsgHdrFile);

   MsRg_UserFileOpen;
   MsRg_UserFileRead(RgUserNum);

   { Nuke the messages }

   Seek(NukeEmailFile,0);
   IF FileSize(NukeEmailFile) > 0 THEN
      FOR ThisMsg := 0 TO (FileSize(NukeEmailFile)-1) DO
         BEGIN
            BlockRead(NukeEmailFile,NukeEmail,1);
            IF NukeEmail < FileSize(MsgHdrFile) THEN
               BEGIN
                  Seek(MsgHdrFile,NukeEmail);
                  Read(MsgHdrFile,MsgHdr);

                  MsgTo   := UpcaseStr(MsgHdr.mTo.As);
                  MsgFrom := UpcaseStr(MsgHdr.From.As);
                  MsgSubj := UpcaseStr(MsgHdr.Subject);

                  IF MSBW_CheckPersonal THEN
                     BEGIN
                        MsgHdr.Status := MsgHdr.Status+[mdeleted];
                        Seek(MsgHdrFile,NukeEmail);
                        Write(MsgHdrFile,MsgHdr);
                        Dec(MsRg_User.Waiting);
                     END;
               END;
         END;

   MsRg_UserFileWrite(RgUserNum);
   MsRg_UserFileClose;
   Close(MsgHdrFile);
END;


PROCEDURE RWD_DeInitBundleFiles;
BEGIN
   Close(bwFtiFile); IF IOResult <> 0 THEN ;
   Close(bwDatFile); IF IOResult <> 0 THEN ;
   Close(bwInfFile); IF IOResult <> 0 THEN ;
END;


PROCEDURE RWD_WriteInfConf(VAR Inf:Inf_AreaInfo);
VAR Confs:Inf_AreaInfo; s:String; i:Word;
BEGIN
   FillChar(Confs,SizeOf(Confs),#0);
   WITH Confs,MsRg_User,MsRg_MArea DO
      BEGIN
         Str2Nul(StrFunc(ThisBase),AreaNum,6,#0);
         Str2Nul(FileName,EchoTag,21,#0);
         Str2Nul(StripColor(Name),Title,50,#0);

         IF RwBaseIdx^[ThisBase] = -MsRg_MArea.QwkIndex
            THEN AreaFlags := [Inf_Scanning]
            ELSE AreaFlags := [];

         IF (mbPrivate IN mbStat)
            THEN AreaFlags := AreaFlags + [Inf_NoPublic]
            ELSE AreaFlags := AreaFlags + [Inf_NoPrivate];

         IF EvalAcs(PostAcs) THEN IF NOT (rPost IN Flags) THEN AreaFlags := AreaFlags + [Inf_Post];
         IF (mbInternet IN mbStat) THEN IF (mbType IN [1..2]) THEN Network_Type := Inf_NetInternet;
         IF (Anonymous <> atno) THEN AreaFlags := AreaFlags + [Inf_AnyName];
         IF NOT (mbrealname IN mbStat) THEN AreaFlags := AreaFlags + [Inf_Alias];

         CASE mbType OF
             1,
             2 : AreaFlags := AreaFlags+[Inf_EchoArea];
            10 : BEGIN
                    IF EvalAcs(RwConfig.AnyNameEmail)
                       THEN Confs.AreaFlags := Confs.AreaFlags+[Inf_AnyName]
                       ELSE CASE RwConfig.NTypeEmail OF
                             NameAlias  : Confs.AreaFlags := Confs.AreaFlags+[Inf_Alias];
                             NameReal   : Confs.AreaFlags := Confs.AreaFlags-[Inf_Alias];
                             NameEither : Confs.AreaFlags := Confs.AreaFlags+[Inf_AnyName];
                          END;
                 END;
            11 : BEGIN
                    AreaFlags := AreaFlags+[Inf_Netmail];
                    IF EvalAcs(RwConfig.AnyNameNetmail)
                       THEN Confs.AreaFlags := Confs.AreaFlags+[Inf_AnyName]
                       ELSE CASE RwConfig.NTypeNetmail OF
                             NameAlias  : Confs.AreaFlags := Confs.AreaFlags+[Inf_Alias];
                             NameReal   : Confs.AreaFlags := Confs.AreaFlags-[Inf_Alias];
                             NameEither : Confs.AreaFlags := Confs.AreaFlags+[Inf_AnyName];
                          END;
                 END;
         END;
      END;
   Inf := Confs;
END;


PROCEDURE RWD_WriteInfSpecial;
VAR Confs:Inf_AreaInfo;
BEGIN
   FillChar(Confs,SizeOf(Confs),#0);
   Str2Nul(RwConfig.InetAreaNum,Confs.AreaNum,6,#0);
   Str2Nul(RwConfig.InetAreaTag,Confs.EchoTag,21,#0);
   Str2Nul(RwConfig.InetAreaDesc,Confs.Title,50,#0);
   Confs.AreaFlags := [Inf_Scanning,Inf_NoPublic,Inf_Post,Inf_NoHighBit,Inf_EchoArea,Inf_Netmail];
   Confs.Network_Type := Inf_NetInternet;
   BlockWrite(bwInfFile,Confs,SizeOf(Confs),BytesWritten);
END;


PROCEDURE RWD_WriteInf;
VAR s:String; NewsFNum:Byte; BwInf:Inf_Header;
BEGIN
   Assign(bwInfFile,RwWorkDir+RwConfig.BBSID+'.INF');
   Rewrite(bwInfFile,1);
   FillChar(bwInf,SizeOf(bwInf),#0);
   WITH bwInf DO
      BEGIN
         bwVersion := 3;

         InfHeaderLen := SizeOf(Inf_Header);
         InfAreaLen   := SizeOf(Inf_AreaInfo);
         MixLen       := SizeOf(MixRec);
         FtiLen       := SizeOf(FtiRec);
         UsesUPLFile  := TRUE;
         FromToLen    := 35; { 36 }
         SubjectLen   := 40; { 72 }

         FOR NewsFNum := 1 TO 5 DO
            WITH RwConfig.NewsFiles[NewsFNum] DO
               IF TheFile <> '' THEN
                  Str2Nul(ExtractFName(TheFile),ReaderFiles[NewsFNum][1],13,#0);

         Str2Nul(RwConfig.BBSID,PacketID,8,#0);
         Str2Nul(MsRg_User.RealName,UserName,43,#0);
         Str2Nul(MsRg_User.Name,UserAlias,43,#0);
         Str2Nul(MsRg_General.SysopName,Sysop,41,#0);
         str2Nul(MsRg_General.BBSName,SystemName,65,#0);
         Str2Nul(EncryptPW(RwUser.RwPass),Password,21,#0);

         Zone  := RwConfig.BBSZone;
         Net   := RwConfig.BBSNet;
         Node  := RwConfig.BBSNode;
         Point := RwConfig.BBSPoint;

         PasswordUsage := RwUser.PassUsage;
         MaxFREQs := RwConfig.FREQLimit;
         IF NOT EvalAcs(RwConfig.FileReqAcs) THEN bwInf.CtrlFlags := bwInf.CtrlFlags+[Inf_NoFreq];
         IF (RwFileList IN RwUser.BWaveFlags) THEN bwInf.FileListType := Inf_FListText;
         bwInf.MaxPacketSize := RwUser.MsgsLimit;

         Move(RwUser.BWaveFlags,UFlags,SizeOf(UFlags));
         FOR NewsFNum := 1 TO 10 DO
            BEGIN
               Str2Nul(RwUser.Keywords[NewsFNum],Keywords[NewsFNum],21,#0);
               Str2Nul(RwUser.Filters[NewsFNum],Filters[NewsFNum],21,#0);
            END;
         FOR NewsFNum := 1 TO 3 DO
            Str2Nul(RwUser.BundlMacros[NewsFNum][1],Macros,80,#0);


         Credits := MsRg_User.Credit;
         Debits  := MsRg_User.Debit;
         CanForward := EvalAcs(RwConfig.ForwardACS);

         bwInf.NetmailFlags := [];
         IF EvalAcs(RwConfig.ACS_Crash)    THEN bwInf.NetmailFlags := bwInf.NetmailFlags+[Inf_Crash];
         IF EvalAcs(RwConfig.ACS_FAttach)  THEN bwInf.NetmailFlags := bwInf.NetmailFlags+[Inf_Attach];
         IF EvalAcs(RwConfig.ACS_KillSent) THEN bwInf.NetmailFlags := bwInf.NetmailFlags+[Inf_KillSEnt];
         IF EvalAcs(RwConfig.ACS_Hold)     THEN bwInf.NetmailFlags := bwInf.NetmailFlags+[Inf_Hold];
         IF EvalAcs(RwConfig.ACS_Imm)      THEN bwInf.NetmailFlags := bwInf.NetmailFlags+[Inf_Imm];
         IF EvalAcs(RwConfig.ACS_FREQ)     THEN bwInf.NetmailFlags := bwInf.NetmailFlags+[Inf_FREQ];
         IF EvalAcs(RwConfig.ACS_Direct)   THEN bwInf.NetmailFlags := bwInf.NetmailFlags+[Inf_Direct];
         IF EvalAcs(RwConfig.ACS_UpdREQ)   THEN bwInf.NetmailFlags := bwInf.NetmailFlags+[Inf_UpdREQ];
      END;
   BlockWrite(bwInfFile,bwInf,SizeOf(bwInf));
   IF RwConfig.InetActive AND EvalAcs(RwConfig.InetAcs) THEN RWD_WriteInfSpecial;
   Close(bwInfFile);
   CopyFile(RwConfig.RwWorkDir+'BWINFTMP.'+RwNodeStr,RwWorkDir+RwConfig.BBSID+'.INF',FALSE);
END;


PROCEDURE RWD_FlushMsgBuff;
BEGIN
   IF MsgTxtBuffSize > 0 THEN
      BEGIN
         Seek(bwDatFile,FileSize(bwDatFile));
         BlockWrite(bwDatFile,MsgTxtBuff^[1],MsgTxtBuffSize);
      END;
   MsgTxtBuffSize := 0;
END;


FUNCTION RWD_WriteDat:LongInt;
VAR b:Byte; i:Word;
BEGIN
   IF (MsgHdr.Pointer+MsgHdr.TextSize-1) > FileSize(Dat) THEN
      BEGIN
         RWD_WriteDat := 0;
         Exit;
      END;
   IF (LongInt(MsgTxtBuffSize)+MsgHdr.TextSize) >= LongInt(MaxMsgBuffSize) THEN RWD_FlushMsgBuff;
   Seek(Dat,MsgHdr.Pointer-1);
   BlockRead(Dat,MsgTxtBuff^[MsgTxtBuffSize+1],MsgHdr.TextSize);
   i := MsgTxtBuffSize+1;
   REPEAT
      Move(MsgTxtBuff^[i],b,1);
      Move(MsgTxtBuff^[i+1],MsgTxtBuff^[i],b);
      MsgTxtBuff^[i+b] := #13;
      Inc(i,b+1);
   UNTIL (i >= MsgHdr.TextSize+MsgTxtBuffSize);
   Inc(MsgTxtBuffSize,MsgHdr.TextSize);
   RWD_WriteDat := MsgHdr.TextSize;
END;


PROCEDURE RWD_FlushFtiBuff;
BEGIN
   IF FtiBuffLen > FtiBuffMax THEN FtiBuffLen := FtiBuffMax;
   IF FtiBuffLen > 0 THEN
      BEGIN
         Seek(bwFtiFile,FileSize(bwFtiFile));
         BlockWrite(File(bwFtiFile),FtiBuff^[1],FtiBuffLen);
      END;
   FtiBuffLen := 0;
END;


PROCEDURE RWD_AddToFtiBuff(Fti:FtiRec);
BEGIN
   IF FtiBuffLen >= FtiBuffMax THEN RWD_FlushFtiBuff;
   Inc(FtiBuffLen);
   Move(Fti,FtiBuff^[FtiBuffLen],SizeOf(Fti));
END;


PROCEDURE RWD_WriteFti;
VAR Fti:FtiRec; s,s2:STRING;

    PROCEDURE PrepareAttrMasks;
    BEGIN
       IF (prvt    IN MsgHdr.Status) THEN Fti.Flags := Fti.Flags+[Fti_MsgPrivate];
       IF (netmail IN MsgHdr.Status) THEN
          WITH Fti,MsgHdr DO BEGIN
             IF (Private     IN Netattribute) THEN Flags := Flags+[Fti_MsgPrivate];
             IF (Crash       IN Netattribute) THEN Flags := Flags+[Fti_MsgCrash];
             IF (Recd        IN Netattribute) THEN Flags := Flags+[Fti_MsgRead];
             IF NOT (nSent   IN Netattribute) THEN Flags := Flags+[Fti_MsgSent];
             IF (FileAttach  IN Netattribute) THEN Flags := Flags+[Fti_MsgFile];
             IF (Intransit   IN Netattribute) THEN Flags := Flags+[Fti_MsgFWD];
             IF (Orphan      IN Netattribute) THEN Flags := Flags+[Fti_MsgOrphan];
             IF (KillSent    IN Netattribute) THEN Flags := Flags+[Fti_MsgKill];
             IF (Local       IN Netattribute) THEN Flags := Flags+[Fti_MsgLocal];
             IF (Hold        IN Netattribute) THEN Flags := Flags+[Fti_MsgHold];
             IF (FileRequest IN Netattribute) THEN Flags := Flags+[Fti_MsgFREQ];
          END;
       Fti.OrigZone := MsgHdr.from.zone;
       Fti.OrigNet := MsgHdr.from.net;
       Fti.OrigNode := MsgHdr.from.node;
    END; { PrepareAttrMasks }

BEGIN
   WITH MsgHdr,MsRg_MArea DO
       BEGIN
          FillChar(Fti,SizeOf(Fti),#0);

          IF (mbRealName IN mbStat)
             THEN Str2Nul(FormatName(From.Real),Fti.mFrom,36,#0)
             ELSE Str2Nul(FormatName(From.as),Fti.mFrom,36,#0);

          Str2Nul(FormatName(mTo.as),Fti.MTo,36,#0);
          Str2Nul(MsgHdr.Subject,Fti.Subject,72,#0);

          IF (mbType = 0) OR (QwkIndex < 3)
             THEN Str2Nul(Unix2DateStr(0,MsgHdr.Date),Fti.Date,20,#0)
             ELSE Str2Nul(OriginDate,Fti.Date,20,#0);

          Fti.MsgPtr := FilePos(bwDatFile)+MsgTxtBuffSize;
          IF (TextSize > 0) AND (Pointer > 0) AND (Pointer+TextSize-1 <= FileSize(Dat)) AND (TextSize < $FF00)
             THEN Fti.MsgSize := RWD_WriteDat
             ELSE Fti.MsgSize := 0;

          Fti.MsgNum := ThisMsg+1;
          PrepareAttrMasks;
          RWD_AddToFtiBuff(Fti);
       END;
END; { RWD_WriteFti }


PROCEDURE RWD_UpdateGraph;
VAR MsgsPerBlock:Real;
BEGIN
   IF GraphNumWrite >= 42 THEN Exit;
   MsgsPerBlock := GDL / 42;
   IF NumOfTotal >= (GraphNumWrite * MsgsPerBlock) + MsgsPerBlock THEN
      BEGIN
         RWM_WriteColor('|09');
         Inc(GraphNumWrite);
      END;
END;


FUNCTION  RWD_ProcAllBases:Boolean;
VAR ThisSelected  : Word;
    ch            : Char;
    Aborted,
    Found         : Boolean;
    bwMix         : MixRec;
    BwMixFile     : FILE OF MixRec;

    PROCEDURE CheckAborted;
    VAR ch:Char;
    BEGIN
       IF fk_KeyPressed THEN
          BEGIN
             ch := UpCase(fk_Read);
             IF Ch = ' ' THEN
                BEGIN
                   RWM_WriteColor(RWM_GetString(28));
                   RWL_WriteLog('#',RWL_LogTime+' Bundling aborted!');
                   Aborted := TRUE;
                   RWM_DeInitSTF;
                   RWD_FlushFtiBuff;
                   RWD_FlushMsgBuff;
                   fk_PurgeInputBuffer;
                   Close(MsgHdrFile);
                   Close(Dat);
                END;
          END;
    END;

    PROCEDURE OneBase;
    VAR FileName:String[80]; i:LongInt;
    BEGIN
       CASE MsRg_MArea.mbType OF
          10, 11 : BEGIN
                      FileName := MsRg_General.MsgPath+'EMAIL';
                      MsRg_Scn.LastRead := 0;
                   END;
              ELSE BEGIN
                      FileName := MsRg_General.MsgPath+MsRg_MArea.FileName;
                      MsRg_ScnOpen;
                      MsRg_ScnRead(RgUserNum-1);
                      MsRg_ScnClose;
                   END;
       END;

       IF NOT FExists(FileName+'.HDR') OR NOT FExists(FileName+'.DAT') THEN Exit;

       Assign(MsgHdrFile,FileName+'.HDR');
       Reset(MsgHdrFile);
       Assign(Dat,FileName+'.DAT');
       Reset(Dat,1);

       Assign(bwMixFile,RwWorkDir+RwConfig.BBSID+'.MIX');
       IF FExists(RwWorkDir+RwConfig.BBSID+'.MIX') THEN Reset(bwMixFile) ELSE Rewrite(bwMixFile);
       Seek(bwMixFile,FileSize(bwMixFile));
       FillChar(bwMix,SizeOf(bwMix),0);
       Str2Nul(StrFunc(ThisBase),bwMix.AreaNum,6,#0);
       bwMix.HdrPtr := FilePos(bwFtiFile)*SizeOf(FtiRec);
       bwMix.NumPersonal := ScanTable.MsgsPersonal;
       bwMix.NumMsgs := ScanTable.MsgsDownload;
       Write(bwMixFile,bwMix);
       Close(bwMixFile);

       IF (ScanTable.MsgsDownload = 0) OR (FileSize(MsgHdrFile) = 0) THEN
          BEGIN
             Close(MsgHdrFile);
             Close(Dat);
             Exit;
          END;

       RWM_ReadSTF;

       i := FileSize(MsgHdrFile)-1;
       IF (stb_BundleFirst IN ScanTable.BaseStat) THEN
          BEGIN
             IF (stb_BundleNew IN ScanTable.BaseStat)
                THEN i := ScanTable.PtrMsg+ScanTable.MsgsFirst-2
                ELSE i := ScanTable.MsgsFirst-1;
          END;

       IF i >= 0 THEN
          BEGIN
             Seek(MsgHdrFile,i);
             BlockRead(File(MsgHdrFile),MsgHdr,1);
             UPointerData.Update := stb_UpdatePointers IN ScanTable.BaseStat;
             UPointerData.LastMsg := FilePos(MsgHdrFile);
             UPointerData.LastDate := MsgHdr.Date;
          END;

       FOR ThisMsg := 0 TO (FileSize(MsgHdrFile)-1) DO
          IF ((stm_NoBundle IN ScanTableMsgArr^[ThisMsg+1])=FALSE) AND
             ((stm_ShouldDL IN ScanTableMsgArr^[ThisMsg+1])=TRUE) THEN
             BEGIN
                RWD_UpdateGraph;
                CheckAborted;
                IF Aborted THEN Exit;
                Seek(MsgHdrFile,ThisMsg);
                BlockRead(File(MsgHdrFile),MsgHdr,1);

                MsgTo   := UpcaseStr(MsgHdr.mTo.As);
                MsgFrom := UpcaseStr(MsgHdr.From.As);
                MsgSubj := UpcaseStr(MsgHdr.Subject);

                IF (MsRg_MArea.QwkIndex < 3) THEN
                   IF (stm_IsPersonal IN ScanTableMsgArr^[ThisMsg+1]) AND (MsgHdr.FileAttached = 0) THEN
                      BEGIN
                         NukeEmail := ThisMsg;
                         BlockWrite(NukeEmailFile,NukeEmail,1);
                      END;

                RWD_WriteFTI;
                Inc(NumOfTotal);
             END;

       RWD_FlushFtiBuff;
       RWD_FlushMsgBuff;
       RWM_DeInitSTF;
       Close(MsgHdrFile);
       Close(Dat);
    END;

    PROCEDURE Init;
    BEGIN
       RWM_KeyPressOff;
       Aborted := FALSE;
       NumOfTotal := 0;
       GraphNumWrite := 0;
       RWD_InitPointerData;
       RWM_WriteColor(RWM_GetString(20)+RWM_GetString(21)+#13);
       Assign(bwMixFile,RwWorkDir+RwConfig.BBSID+'.MIX');
       IF FExists(RwWorkDir+RwConfig.BBSID+'.MIX') THEN Reset(bwMixFile) ELSE Rewrite(bwMixFile);
       Close(bwMixFile);
    END;

BEGIN
   Init;

   FOR ThisBase := 0 TO MsRg_MAreaNum-1 DO
      IF (scn_Selected IN ScanInfo^[Abs(RwBaseIdx^[ThisBase])]) AND
         (scn_HasAccess IN ScanInfo^[Abs(RwBaseIdx^[ThisBase])]) THEN
         BEGIN
            RWM_STableRead(ThisBase);
            IF NOT (stb_SkipBase IN ScanTable.BaseStat) THEN
               BEGIN
                  UPointerData.Update   := FALSE;
                  UPointerData.BaseNum  := ThisBase;
                  UPointerData.LastMsg  := 0;
                  UPointerData.LastDate := 0;

                  MsRg_MAreaRead(ThisBase);
                  OneBase;
                  IF Aborted THEN
                     BEGIN
                        RWD_ProcAllBases := FALSE;
                        Exit;
                     END;
                  Write(UPointerFile,UPointerData);
               END;
         END;

   fk_TextColor(9);
   IF GraphNumWrite < 42 THEN FOR ThisSelected := GraphNumWrite TO 42 DO fk_Write('');
   RWM_KeyPressOn;
   RWD_ProcAllBases := True;
END;


END.
