{$O+,F+,I-}
UNIT RWAREAS;

(* 

    RWAREAS - ReneWave areas selection unit

    RENEWAVE is Copyright (C) 1994-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of RENEWAVE.

    RENEWAVE is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RENEWAVE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RENEWAVE; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)


INTERFACE


CONST RwAreasTplMax = 99;

TYPE  RwAreasTplRec = RECORD
                         AreaNum  : Word;
                         AreaStat : String[15];
                         AreaName : String[40];
                      END;
      RwAreasTplT   = Array[1..RwAreasTplMax] OF RwAreasTplRec;
VAR   RwAreasTpl    : ^RwAreasTplT;


PROCEDURE RWA_ToggleBase(ThisPos:LongInt; ToggleType:Char);
PROCEDURE RWA_ChooseAreas;


IMPLEMENTATION


USES  {$I FOSSTYPE.INC }

      DOS,      CRT,      MSTRINGS, MISC1,    RECORDS,  MSRGGEN,
      MSBWGEN,  RWMAIN,   RWINIT,   RWVARS,   RWSTRUCT, RWACS,
      RWERROR;

VAR   PageNum,
      ThisSelectNum  : Word;
      InputStr       : String;
      ToggleType     : Char;


PROCEDURE RWA_ToggleBase(ThisPos:LongInt; ToggleType:Char);
BEGIN
   MsRg_MAreaRead(ThisPos);
   IF NOT (scn_HasAccess IN ScanInfo^[MsRg_MArea.QwkIndex]) THEN Exit;
   CASE ToggleType OF
      '-' : ScanInfo^[MsRg_MArea.QwkIndex] := [];
      '+' : ScanInfo^[MsRg_MArea.QwkIndex] := [scn_Selected];
      'P' : ScanInfo^[MsRg_MArea.QwkIndex] := ScanInfo^[MsRg_MArea.QwkIndex]+[scn_Selected,scn_PersonalOnly]-[Scn_PersonalAll];
      'A' : ScanInfo^[MsRg_MArea.QwkIndex] := ScanInfo^[MsRg_MArea.QwkIndex]+[scn_Selected,scn_PersonalAll]-[Scn_PersonalOnly];
      'K' : ScanInfo^[MsRg_MArea.QwkIndex] := ScanInfo^[MsRg_MArea.QwkIndex]+[scn_Selected,scn_Keywords];
      'F' : ScanInfo^[MsRg_MArea.QwkIndex] := ScanInfo^[MsRg_MArea.QwkIndex]+[scn_Selected,scn_Filters];
      'T' : IF (scn_Selected IN ScanInfo^[MsRg_MArea.QwkIndex])
               THEN ScanInfo^[MsRg_MArea.QwkIndex] := []
               ELSE ScanInfo^[MsRg_MArea.QwkIndex] := [scn_Selected];
   END;
   ScanInfo^[MsRg_MArea.QwkIndex] := ScanInfo^[MsRg_MArea.QwkIndex]+[scn_HasAccess];
END;


PROCEDURE ToggleArea(StartA,StopA:String);
VAR StartArea,StopArea:LongInt; i,ThisPos:LongInt;

    PROCEDURE ChangeTheArea;
    BEGIN
       ThisPos := RWM_FindAlias(i)-1;
       IF NOT (scn_HasAccess IN ScanInfo^[Abs(RwBaseIdx^[ThisPos])]) THEN Exit;
       MsRg_MAreaRead(ThisPos);
       IF (mbForceRead IN MsRg_MArea.mbStat) AND NOT (EvalAcs(RwConfig.ForceOvrACS))
          THEN BEGIN
                RwVariables^[1] := StrFunc(i);
                RWM_WriteColor(RWM_GetString(66));
             END
          ELSE BEGIN
                RWA_ToggleBase(ThisPos,ToggleType);
                RwVariables^[1] := StrFunc(i);
                IF (scn_Selected IN ScanInfo^[MsRg_MArea.QwkIndex])
                   THEN BEGIN
                         IF      (scn_PersonalOnly IN ScanInfo^[MsRg_MArea.QwkIndex]) THEN RWM_WriteColor(RWM_GetString(76))
                         ELSE IF (scn_PersonalAll IN ScanInfo^[MsRg_MArea.QwkIndex])  THEN RWM_WriteColor(RWM_GetString(70))
                         ELSE IF (scn_Keywords IN ScanInfo^[MsRg_MArea.QwkIndex])     THEN RWM_WriteColor(RWM_GetString(71))
                         ELSE RWM_WriteColor(RWM_GetString(67));
                         {...}
                         IF (scn_Filters IN ScanInfo^[MsRg_MArea.QwkIndex]) THEN RWM_WriteColor(RWM_GetSTring(75));
                      END
                   ELSE RWM_WriteColor(RWM_GetString(68));
             END;
    END;

BEGIN
   StartArea := ValFunc(StartA);
   StopArea := ValFunc(StopA);

   IF (StartArea <= 0) OR (StartArea > AcsTableLen) THEN
      BEGIN
         RwVariables^[1] := StartA;
         RWM_WriteColor(RWM_GetString(65));
         Exit;
      END;

   IF (StopArea <= 0) OR (StopArea > AcsTableLen) THEN
      BEGIN
         RwVariables^[1] := StopA;
         RWM_WriteColor(RWM_GetString(65));
         Exit;
      END;

   IF (StartArea > StopArea) THEN Exit;

   FOR i := StartArea TO StopArea DO ChangeTheArea;
END; { ToggleArea }


FUNCTION GetInput:String;
VAR Ch:Char; TempRes:String; Num:Word;
BEGIN
   fk_TextColor(15);
   Num := 0;
   TempRes := '';
   REPEAT
      REPEAT
         ch := Upcase(fk_Read);
      UNTIL Pos(ch,fk_Host.ValidInput+#8+#13) > 0;
      IF (Ch IN [']','[','<','>','Q','?',#0]) AND (Num = 0)
         THEN BEGIN
               GetInput := ch;
               Exit;
            END
         ELSE IF (ch = #8) THEN
            BEGIN
               IF Num > 0 THEN
                  BEGIN
                     fk_Write(#8#32#8);
                     Delete(TempRes,Num,1);
                     Dec(Num);
                  END;
            END
         ELSE IF Ch = #13 THEN
            BEGIN
               GetInput := TempRes;
               Exit;
            END
         ELSE BEGIN
               Inc(Num);
               fk_Write(ch);
               TempRes := TempRes + ch;
            END;
   UNTIL (Num >= 78) OR (Ch = #13);
   GetInput := TempRes;
END; { GetInput }


PROCEDURE DisplayAreasTemplate;
VAR TplFile:Text; Line:String;

    PROCEDURE ParseLine(VAR Line:String);
    BEGIN
       Line := StripLeadingCh(Line,' ');
       Line := StripTrailingCh(Line,' ');

       IF (Length(Line) < 2) OR (Line[1] <> '"') THEN Exit;

       Line := Copy(Line,2,Length(Line)-1);
       Dec(Line[0]);

       RWM_WriteColor(Line);
    END;

BEGIN
   RwVariables^[1] := StrFunc(AcsTableLen);

   fk_Host.StatusLinePos := 0;
   fk_Host.StatusLineBuf := 0;

   fk_TextColor(7);

   IF NOT FExists(RwTpl_Areas) THEN RWE_ReportErr1(220,'Template file '+RwTpl_Areas+' not found!');

   Assign(TplFile,RwTpl_Areas);
   Reset(TplFile);
   WHILE NOT Eof(TplFile) DO
      BEGIN
         ReadLn(TplFile,Line);
         ParseLine(Line);
      END;
   Close(TplFile);

   fk_Host.StatusLineBuf := 1;
   fk_Host.StatusLinePos := 25;
END;


PROCEDURE InitBaseInfo;
VAR TplNum:Word; Forced:Boolean;
BEGIN
   TplNum := RWM_BaseAlias(ThisBase);
   IF (TplNum MOD RwTpl_AreasN = 0)
      THEN TplNum := RwTpl_AreasN
      ELSE TplNum := TplNum MOD RwTpl_AreasN;

   MsRg_MAreaRead(ThisBase);

   RwAreasTpl^[TplNum].AreaName := MsRg_MArea.Name;
   RwAreasTpl^[TplNum].AreaNum  := RWM_BaseAlias(ThisBase);
   RwAreasTpl^[TplNum].AreaStat := RepChar('-',3);

   IF (scn_Selected IN ScanInfo^[MsRg_MArea.QwkIndex]) THEN
      BEGIN
         RwAreasTpl^[TplNum].AreaStat[1] := '';
         {...}
         IF (scn_PersonalOnly IN ScanInfo^[MsRg_MArea.QwkIndex]) THEN RwAreasTpl^[TplNum].AreaStat[1] := 'P';
         IF (scn_PersonalAll  IN ScanInfo^[MsRg_MArea.QwkIndex]) THEN RwAreasTpl^[TplNum].AreaStat[1] := 'A';
         IF (scn_Keywords     IN ScanInfo^[MsRg_MArea.QwkIndex]) THEN RwAreasTpl^[TplNum].AreaStat[2] := 'K';
         IF (scn_Filters      IN ScanInfo^[MsRg_MArea.QwkIndex]) THEN RwAreasTpl^[TplNum].AreaStat[3] := 'F';
      END;

   IF (mbForceRead IN MsRg_MArea.mbStat) AND NOT EvalAcs(RwConfig.ForceOvrAcs)
      THEN RwAreasTpl^[TplNum].AreaStat := RWM_GetString(74);
END;


PROCEDURE MoveForward;
BEGIN
   IF (PageNum+1)*RwTpl_AreasN < AcsTableLen THEN Inc(PageNum);
END; { MoveForward }


PROCEDURE MoveBackward;
BEGIN
   IF PageNum > 0 THEN Dec(PageNum);
END; { MoveBackward }


PROCEDURE ParseArea(s:string);
VAR RangePos:Word; TempS:String; StartArea,StopArea:String;

    PROCEDURE GetToggleType;
    BEGIN
       IF (TempS[1] IN ['+','-','P','A','K','F','R'])
          THEN BEGIN
                ToggleType := TempS[1];
                Delete(TempS,1,1);
             END
          ELSE ToggleType := 'T';
    END;

    PROCEDURE GetToggleAreas;
    BEGIN
       IF Pos('-',TempS) > 1 THEN
          BEGIN
             RangePos := Pos('-',TempS);
             StartArea := Copy(TempS,1,RangePos-1);
             StopArea := Copy(TempS,RangePos+1,Length(TempS)-RangePos);
          END
       ELSE IF TempS[1] = '*' THEN
          BEGIN
             StartArea := '1';
             StopArea := StrFunc(AcsTableLen);
          END
       ELSE BEGIN
             StartArea := TempS;
             StopArea := TempS;
          END;
    END;

BEGIN
   TempS := s;
   RangePos := 0;
   GetToggleType;
   GetToggleAreas;
   ToggleArea(StartArea,StopArea);
END;


PROCEDURE ParseAreas;
VAR TempStr:String; FirstSpace:Word;
BEGIN
   RWM_KeyPressOff;

   fk_WriteLn('',2);
   InputStr := StripLeadingCh(InputStr,' ');
   InputStr := StripTrailingCh(InputStr,' ');
   IF Pos(' ',InputStr) = 0
      THEN ParseArea(InputStr)
      ELSE BEGIN
            InputStr := InputStr + ' ';
            REPEAT
               InputStr := StripLeadingCh(InputStr,' ');
               FirstSpace := Pos(' ',InputStr);
               IF FirstSpace = 0
                  THEN FirstSpace := Length(InputStr) + 1;
               TempStr := Copy(InputStr,1,FirstSpace - 1);
               ParseArea(TempStr);
               Delete(InputStr,1,FirstSpace);
            UNTIL Length(InputStr) = 0;
         END;
   RWM_KeyPressOn;
   RWM_Pause;
END;


PROCEDURE RWA_ChooseAreas;
VAR LastNum:Word;

    PROCEDURE InitChoose;
    BEGIN
       PageNum := 0;
       ThisSelectNum := 1;
       RwVariables^[1] := StrFunc(AcsTableLen);
       New(RwAreasTpl);
    END;

    FUNCTION CheckInputQuit:Boolean;
    BEGIN
       RWM_KeyPressOn;
       InputStr := GetInput;
       RWM_KeyPressOff;
       InputStr := StripLeadingCh(InputStr,' ');
       InputStr := StripTrailingCh(InputStr,' ');

       IF InputStr = RWM_GetCh(72,3)
          THEN CheckInputQuit := TRUE
          ELSE BEGIN
             IF (InputStr = '')  THEN MoveForward ELSE
             IF (InputStr = RWM_GetCh(72,2)) THEN MoveForward ELSE
             IF (InputStr = RWM_GetCh(72,1)) THEN MoveBackward ELSE
             IF (InputStr = RWM_GetCh(72,4)) THEN RWM_DispFile(RwHlp_Areas,TRUE,MsRg_USer.PageLen)
             ELSE ParseAreas;
             CheckInputQuit := FALSE;
          END;
   END;

BEGIN
   InitChoose;
   REPEAT
      ThisBase := RWM_FindAlias(Word(PageNum)*RwTpl_AreasN);
      LastNum := RWM_FindAlias(Word(PageNum+1)*RwTpl_AreasN-1);
      FillChar(RwAreasTpl^,SizeOf(RwAreasTpl^),0);
      REPEAT
         IF (scn_HasAccess IN ScanInfo^[Abs(RwBaseIdx^[ThisBase])]) THEN InitBaseInfo;
         Inc(ThisBase);
      UNTIL (ThisBase > LastNum) OR (ThisBase >= MsRg_MAreaNum);
      DisplayAreasTemplate;
   UNTIL CheckInputQuit;
   RWM_WriteScanInfo;
   Dispose(RwAreasTpl);
   RwAreasTpl := NIL;
END; { CA_ChooseAreas }


END.
