{$I-,O+}
UNIT MSZ_MISC;

(* 

    MSZ_MISC - X/Y/Zmodem code (miscellaneous routines)

    RENEWAVE is Copyright (C) 1994-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of RENEWAVE.

    RENEWAVE is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RENEWAVE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RENEWAVE; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)


INTERFACE


CONST MszVer      = '1.00 Beta-07';
      CpsAdj      : Byte = 0;

      ZBUFSIZE    : Word = 1024;
      ZBUFSIZEMAX = 8192;
      ZMAXHLEN    = 16;           { Max header info length }

      ABORT       = -5;
      FUBAR       = -4;
      RCDO        = -3;
      TIMEDOUT    = -2;

      SOH         = $01;   { Start of header }
      STX         = $02;   { Start of header in 1k mode }
      EOT         = $04;   { End of transmission }
      ACK         = $06;   { Acknowledge }
      NAK         = $15;   { Not acknowledged }
      CAN         = $18;   { Cancel transfer }
      ESC         = $1B;   { Escape }

TYPE  tHeader     = Array[0..3] OF BYTE;
      tBuffer     = Array[0..ZBUFSIZEMAX] OF BYTE;
      pBuffer     = ^tBuffer;

VAR   Cps         : Word;
      Errors      : Word;
      DataBuf     : pBuffer;
      TheFile     : FILE;    { File being transmitted }


PROCEDURE MSZ_WriteLog(Prot:Char; Bytes:LongInt; FileName:String; Success:Boolean);
PROCEDURE MSZ_GetInfoHeader(Buff:pBuffer; VAR FileName:String; VAR FileTotal,FileTime:LongInt);
FUNCTION  MSZ_CheckBadName(fn:String):String;
PROCEDURE MSZ_SendCan;
FUNCTION  MSZ_TimedRead(TimeOut:Integer):Integer;
FUNCTION  MSZ_TimedKeypress(TimeOut:Integer):Boolean;
PROCEDURE MSZ_GetBatchTotals(FileSpecs:String);

FUNCTION  Zmodem_FileCrc32(VAR f:File):LongInt;
FUNCTION  Zmodem_FindFile(Path:String; VAR Name:String; VAR size,time:LongInt):Boolean;
FUNCTION  Zmodem_ToUnixDate(fdate:LongInt):String;
FUNCTION  Zmodem_FromUnixDate(s:String):LongInt;


IMPLEMENTATION


USES  {$I c:\oldstuff\source\MSZ\FOSSTYPE.INC }

      {$IFDEF DELPHI}
      SysUtils,
      Windows,
      {$ENDIF}

      DOS,      MSTRINGS, MISC1,    CRC32,    UNIXDATE, MSZ_MAIN,
      MSZ_ZMOD, MSZ_XMOD, MSZ_VID,  TIMER,    CRT;


PROCEDURE MSZ_GetBatchTotals(FileSpecs:String);
VAR i:Byte; NumFiles:Word; FileName:String;

    PROCEDURE DoFile(FileSpec:String);
    VAR f:FILE; DirInfo:SearchRec; fn:String;
    BEGIN
       FFirst(FileSpec,AnyFile AND NOT VolumeID,DirInfo);
       WHILE DosError = 0 DO
          BEGIN
             fn := AddSlash(ExtractFDir(FExpand(FileSpec)))+DirInfo.Name;
             IF FExists(fn) THEN
                BEGIN
                   Assign(f,fn);
                   Reset(f,1);
                   BatchNum := BatchNum+1;
                   BatchTotal := BatchTotal+FileSize(f);
                   Close(f);
                END;
             FNext(DirInfo);
          END;
       {$IFDEF DELPHI} SYSUTILS.FindClose(DirInfo); {$ENDIF}
       {$IFDEF OS2}    FindClose(DirInfo); {$ENDIF}
    END;

    PROCEDURE DoList(ListFile:String);
    VAR f:Text; FileName:String;
    BEGIN
       Assign(f,ListFile);
       Reset(f);
       WHILE NOT Eof(f) DO
          BEGIN
             ReadLn(f,FileName);
             FileName := GetWord(FileName,1);
             FileName := StripLeadingCh(StripTrailingCh(UpcaseStr(FileName),' '),' ');
             IF (Length(FileName) > 0) THEN DoFile(FileName);
         END;
      Close(f);
    END;

BEGIN
   IF GetWordCount(FileSpecs) > 0 THEN
      FOR i := 1 TO GetWordCount(FileSpecs) DO
         BEGIN
            FileName := GetWord(FileSpecs,i);
            IF FileName[1] = '@'
               THEN BEGIN
                     FileName := Copy(FileName,2,Length(FileName)-1);
                     IF FExists(FileName) THEN DoList(FileName);
                  END
               ELSE DoFile(FileName);
         END;
END;


PROCEDURE MSZ_WriteLog(Prot:Char; Bytes:LongInt; FileName:String; Success:Boolean);
VAR f:Text;
BEGIN
   IF (FileName <> '') AND (Msz_LogFile <> '') THEN
      BEGIN
         Assign(f,Msz_LogFile);
         IF FExists(Msz_LogFile) THEN Append(f) ELSE Rewrite(f);
         IF IOResult = 0 THEN
            BEGIN
               IF Success
                  THEN Write(f,Prot+' ')
                  ELSE Write(f,'E ');
               IF bytes <= 999999
                  THEN Write(f,PadLeft(StrFunc(Bytes),' ',6)+' ')
                  ELSE Write(f,StrFunc(Bytes)+' ');
               IF fk_Fossil.Baud <= 99999
                  THEN Write(f,PadLeft(StrFunc(fk_Fossil.Baud),' ',5)+' bps ')
                  ELSE Write(f,StrFunc(fk_Fossil.Baud)+' bps ');
               IF FileTxStart >= 0
                  THEN Cps := Zmodem_GetCps(Bytes-FileTxStart,CurrentSecsFunc-StartTime)
                  ELSE Cps := Zmodem_GetCps(Bytes,CurrentSecsFunc-StartTime);
               IF Cps <= 9999
                  THEN Write(f,PadLeft(StrFunc(Cps),' ',4)+' cps ')
                  ELSE Write(f,StrFunc(Cps)+' cps ');
               IF Errors <= 999
                  THEN Write(f,PadLeft(StrFunc(Errors),' ',3)+' errors ')
                  ELSE Write(f,StrFunc(Errors)+' errors ');
               Write(f,'    0 '); { Flow control stoppages }
               Write(f,PadLeft(StrFunc(Bytes MOD 128),' ',4)+' ');
               Write(f,UpcaseStr(FileName)+' ');
               WriteLn(f,'-1');
               Close(f);
            END;
      END;
END;


PROCEDURE MSZ_GetInfoHeader(Buff:pBuffer; VAR FileName:String; VAR FileTotal,FileTime:LongInt);
VAR i:Byte; s:String; l:LongInt;
BEGIN
   { Get filename }
   i := 0;
   FileName[0] := #0;
   WHILE (Buff^[i] <> 0) AND (Ord(FileName[0]) < 255) DO
      BEGIN
         Inc(FileName[0]);
         FileName[Ord(FileName[0])] := Upcase(Chr(Buff^[i]));
         Inc(i);
      END;
   FileName := ExtractfName(FileName);

   {$IFDEF OS2}
   FileName := CutTo(ExtractFileName(FileName),8)+CutTo(ExtractFExt(FileName),4);
   {$ENDIF}

   { Get file size }
   Inc(i);
   s[0] := #0;
   WHILE (Buff^[i] <> 0) AND (Buff^[i] <> 32) AND (Ord(s[0]) < 20) DO
      BEGIN
         Inc(s[0]); s[Ord(s[0])] := Chr(Buff^[i]); Inc(i);
      END;
   FileTotal := ValFunc(s);

   { Get file time }
   Inc(i);
   s[0] := #0;
   WHILE (Buff^[i] >= $30) AND (Buff^[i] <= $37) AND (Ord(s[0]) < 20) DO
      BEGIN
         Inc(s[0]); s[Ord(s[0])] := Chr(Buff^[i]); Inc(i);
      END;
   IF s <> '' THEN FileTime := Zmodem_FromUnixDate(s) ELSE FileTime := 0;

   { Get file mode (unused) }
   Inc(i);
   s[0] := #0;
   WHILE (Buff^[i] <> 0) AND (Buff^[i] <> 32) AND (Ord(s[0]) < 20) DO
      BEGIN
         Inc(s[0]); s[Ord(s[0])] := Chr(Buff^[i]); Inc(i);
      END;

   { Get serial number (unused) }
   Inc(i);
   s[0] := #0;
   WHILE (Buff^[i] <> 0) AND (Buff^[i] <> 32) AND (Ord(s[0]) < 20) DO
      BEGIN
         Inc(s[0]); s[Ord(s[0])] := Chr(Buff^[i]); Inc(i);
      END;

   { Get batch number of files remaining }
   Inc(i);
   s[0] := #0;
   WHILE (Buff^[i] <> 0) AND (Buff^[i] <> 32) AND (Ord(s[0]) < 20) DO
      BEGIN
         Inc(s[0]); s[Ord(s[0])] := Chr(Buff^[i]); Inc(i);
      END;
   l := ValFunc(s);
   IF (l > 0) AND (BatchNum = 0) THEN BatchNum := l;

   { Get batch number of bytes remaining }
   Inc(i);
   s[0] := #0;
   WHILE (Buff^[i] <> 0) AND (Buff^[i] <> 32) AND (Ord(s[0]) < 20) DO
      BEGIN
         Inc(s[0]); s[Ord(s[0])] := Chr(Buff^[i]); Inc(i);
      END;
   l := ValFunc(s);
   IF (l > 0) AND (BatchTotal = 0) THEN BatchTotal := l;
END;


FUNCTION  MSZ_CheckBadName(fn:String):String;
CONST NumBadNames = 17;
      BadNames    : Array[1..NumBadNames] OF String[8] =
                    ('COM','COM0','COM1','COM2','COM3','COM4','COM5',
                     'COM6','COM7','LPT','LPT1','LPT2','LPT3','LPT4',
                     'CON','PRN','NUL');
VAR   i           : Byte;
BEGIN
   fn := UpcaseStr(fn);
   FOR i := 1 TO NumBadNames DO
      IF (fn = BadNames[i]) THEN
         BEGIN
            MSZ_CheckBadName := BadNames[i];
            Exit;
         END;
   MSZ_CheckBadName := '';
END;


PROCEDURE MSZ_SendCan;
{ Cancels transfer }
VAR i:Byte;
BEGIN
   fk_PurgeOutputBuffer;
   FOR i := 1 TO 8 DO Ms_WriteChar(Chr(CAN));
   FOR i := 1 TO 10 DO Ms_WriteChar(#8);
END;


FUNCTION MSZ_TimedRead(TimeOut:Integer):Integer;
VAR Time:LongInt; i:Integer;
BEGIN
   IF fk_RemoteKeyPressed
      THEN MSZ_TimedRead := Ord(Ms_ReadChar) AND $00FF
      ELSE BEGIN
            Time := TimeCounter+(TimeOut*100);
            REPEAT
               IF KeyPressed THEN IF (ReadKey = #27) THEN
                  BEGIN
                     MSZ_SendCan;
                     Zmodem_Message('Aborted from keyboard');
                     MSZ_TimedRead := ABORT;
                     Exit;
                   END;
               IF (Ms_CheckCarrier=FALSE) THEN
                  BEGIN
                     MSZ_TimedRead := RCDO;
                     Exit;
                  END;
               IF fk_RemoteKeyPressed THEN
                  BEGIN
                     MSZ_TimedRead := Ord(Ms_ReadChar) AND $00FF;
                     Exit;
                  END;
            UNTIL (TimeCounter > Time);
            MSZ_TimedRead := TIMEDOUT;
         END;
END;


FUNCTION  MSZ_TimedKeypress(TimeOut:Integer):Boolean;
VAR Time:LongInt;
BEGIN
   IF fk_RemoteKeyPressed
      THEN MSZ_TimedKeypress := TRUE
      ELSE BEGIN
            Time := TimeCounter+(TimeOut*100);
            REPEAT
               IF fk_RemoteKeyPressed OR NOT Ms_CheckCarrier THEN
                  BEGIN
                     MSZ_TimedKeypress := TRUE;
                     Exit;
                  END;
            UNTIL (TimeCounter > Time);
            MSZ_TimedKeypress := FALSE;
         END;
END;


FUNCTION Zmodem_FileCrc32(VAR f:File):LongInt;
VAR fBuf      : pBuffer;
    Crc       : LongInt;
    i         : Integer;
    {$IFDEF OS2}
    BytesRead : LongInt;
    {$ELSE}
    BytesRead : Integer;
    {$ENDIF}
BEGIN
   Crc := $FFFFFFFF;
   GetMem(fBuf,1024);
   Seek(f,0);
   IF (IOResult <> 0) THEN
      BEGIN
         REPEAT
            BlockRead(f,fBuf^,1024,BytesRead);
            FOR i := 0 TO (BytesRead-1) DO Crc := UpdC32(fBuf^[i],Crc);
         UNTIL (BytesRead < 1024) OR (IOResult <> 0);
         Seek(f,0);
      END;
   FreeMem(fBuf,1024);
   Zmodem_FileCrc32 := Crc;
END;


FUNCTION Zmodem_FindFile(Path:String; VAR Name:String; VAR size,time:LongInt):Boolean;
VAR sr: SearchRec;
BEGIN
   FFirst(Path,Archive,sr);
   IF (DosError <> 0) OR (IOResult <> 0) THEN
      BEGIN
         {$IFDEF DELPHI} SYSUTILS.FindClose(sr); {$ENDIF}
         {$IFDEF OS2}    FindClose(sr); {$ENDIF}
         Zmodem_FindFile := FALSE;
         Exit;
      END;
   name := sr.Name;
   size := sr.Size;
   time := sr.Time;
   {$IFDEF DELPHI} SYSUTILS.FindClose(sr); {$ENDIF}
   {$IFDEF OS2}    FindClose(sr); {$ENDIF}
   Zmodem_FindFile := TRUE;
END;


FUNCTION Zmodem_ToUnixDate(fDate:LongInt):String;
VAR dt:DateTime; Secs:LongInt; s:String;
BEGIN
   UnPackTime(fDate,dt);

   s := '';
   Secs := Date2Unix(Word(dt.Year),Word(dt.Month),Word(dt.Day),Word(dt.Hour),Word(dt.Min),Word(dt.Sec));
   WHILE (Secs <> 0) AND (Length(s) < 255) DO
      BEGIN
         s := Chr((Secs AND 7)+$30)+s;
         Secs := (Secs SHR 3)
      END;
   Zmodem_ToUnixDate := '0'+s;
END;


FUNCTION Zmodem_FromUnixDate(s:String):LongInt;
VAR dt:DateTime; Date:LongInt; i:Byte;
BEGIN
   Date := 0;
   FOR i := 1 TO Length(s) DO Date := (Date SHL 3)+Ord(s[i])-$30;
   Unix2Date(Date,Word(dt.Year),Word(dt.Month),Word(dt.Day),Word(dt.Hour),Word(dt.Min),Word(dt.Sec));
   PackTime(dt,Date);
   Zmodem_FromUnixDate := Date;
END;


END.
