{$R-,F+,I-,O-}
UNIT MSRGGEN;

(* 

    MSRGGEN - General Renegade file handling/manipulation routines

    RENEWAVE is Copyright (C) 1994-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of RENEWAVE.

    RENEWAVE is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RENEWAVE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RENEWAVE; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)

INTERFACE


USES  DOS,MSTRINGS,RECORDS;

CONST { Constant sizes/limits/maximums }

      OldExtSize       = 4;
      NewExtSize       = 9;

      MsRg_ExtSize     : Byte = NewExtSize;
      MsRg_UserVer     : Word = 0511;
      MsRg_UserRecSize : Word = SizeOf(UserRec);

(*- Data File Variables --------------------------------------------------*)

VAR   MsRg_General     : GeneralRec;                   { RENEGADE.DAT }
      MsRg_GeneralFile : FILE OF GeneralRec;

VAR   MsRg_User        : UserRec;
      MsRg_UserFile    : FILE;                         { USERS.DAT }
      MsRg_UserNum     : LongInt;

VAR   MsRg_UserIdxFile : FILE OF UserIdxRec;           { USERS.IDX }
      MsRg_UserIdx     : UserIdxRec;
      MsRg_UserIdxPos  : LongInt;

VAR   MsRg_ConfFile    : FILE OF ConfRec;              { CONFRENC.DAT }
      MsRg_ConfData    : ConfRec;

VAR   MsRg_StringFile  : FILE OF FStringRec;           { STRINGS.DAT }
      MsRg_Strings     : FStringRec;

VAR   MsRg_FAreaFile   : FILE OF UlRec;                { FBASES.DAT }
      MsRg_FArea       : UlRec;
      MsRg_FileBase    : LongInt;

VAR   MsRg_DirFile     : FILE OF UlfRec;               { <basename>.DIR }
      MsRg_Dir         : UlfRec;
      MsRg_FileNum     : LongInt;

VAR   MsRg_ExtFile     : FILE;                          { EXTENDED.DAT }
      MsRg_Ext         : VerbRec;
      MsRg_ExtPos      : LongInt;

VAR   MsRg_HistFile    : FILE OF HistoryRec;           { HISTORY.DAT }
      MsRg_History     : HistoryRec;
      MsRg_HistoryPos  : LongInt;

VAR   MsRg_ScnFile     : FILE OF ScanRec;
      MsRg_Scn         : ScanRec;
      MsRg_ScnPos      : LongInt;

VAR   MsRg_MAreaFile   : FILE OF BoardRec;             { MAREAS.DAT }
      MsRg_MArea       : BoardRec;
      MsRg_MsgArea     : LongInt;

(*- Other Variables ------------------------------------------------------*)

VAR   MsRg_CfgPath     : String;              { Path to CONFIG.TG }
      MsRg_TempPath    : String;

      MsRg_Error       : Byte;

VAR   MciF_MsgBaseNum,
      MciF_MinsLeft,
      MciF_ActualBaud,
      MciF_Baud,
      MciF_LockedBaud,
      MciF_Node,
      MciF_ComPort       : String[10];
      MciF_TempPath,
      MciF_TempLog,
      MciF_FileName,
      MciF_ArcFileIncl,
      MciF_ArcFilePath   : String[64];

VAR   SetMciStrings      : PROCEDURE;

TYPE  OldUserRec = { 10-05 USERS.DAT }
  record
    name:string[36];                  { system name      }
    realname:string[36];              { real name        }
    pw:string[20];                    { password         }
    ph:string[12];                    { phone #          }
    bday:string[8];                   { birthdate        }
    firston:string[8];                { first on date    }
    laston:string[8];                 { last on date     }
    street:string[30];                { street address   }
    citystate:string[30];             { city, state      }
    zipcode:string[10];               { zipcode          }
    usrdefstr:array[1..3] of string[35]; { definable strings }
    note:string[35];                  { SysOp note       }
    userstartmenu:string[8];          { menu to start at }
    lockedfile:string[8];             { print lockout msg}
    flags:set of uflags;              { flags            }
    sflags:set of suflags;            { status flags     }
    ar:set of acrq;                   { AR flags         }
    vote:array[1..25] of byte;        { voting data      }

    sex:char;                         { gender           }
    ttimeon,                          { total time on    }
    uk,                               { UL k             }
    dk:longint;                       { DL k             }
    tltoday,                          { # min left today }
    forusr,                           { forward mail to  }
    junkfp:integer;                   { Junk }

    uploads,downloads,                { # of ULs/# of DLs}
    loggedon,                         { # times on       }
    msgpost,                          { # message posts  }
    emailsent,                        { # email sent     }
    feedback,                         { # feedback sent  }
    timebank,                         { # mins in bank   }
    timebankadd,                      { # added today    }
    dlktoday,                         { # kbytes dl today}
    dltoday:word;                     { # files dl today }

    waiting,                          { mail waiting     }
    linelen,                          { line length      }
    pagelen,                          { page length      }
    ontoday,                          { # times on today }
    illegal,                          { # illegal logons }
    barf,
    lastmbase,                        { # last msg base  }
    lastfbase,                        { # last file base }
    sl,dsl:byte;                      { SL / DSL         }

    MsgBaseScan:array[0..255] of set of 0..7;
    FileBaseScan:array[0..255] of set of 0..7;
    crap:array[1..552] of byte;

    cols:colors;                      { user colors }

    garbage:byte;
    timebankwith:word;                { amount of time withdrawn today}
    passwordchanged:word;             { last day password changed }
    defarctype:byte;                  { default QWK archive type }
    lastconf:char;                    { last conference they were in }
    lastqwk:longint;                  { date/time of last qwk packet }
    getownqwk,                        { add own messages to qwk packet? }
    scanfilesqwk,                     { scan file bases for qwk packets? }
    privateqwk:boolean;               { get private mail in qwk packets? }

    credit,                           { Amount of credit a user has }
    debit:longint;                    { Amount of debit a user has }
    expiration:longint;               { Expiration date of this user }
    expireto:char;                    { Subscription level to expire to }
    ColorScheme:byte;                 { User's color scheme # }
    TeleConfEcho,                     { echo Teleconf lines? }
    TeleConfInt:boolean;              { interrupt during typing? }
  end;


{ RENEGADE.DAT - Main system configuration }
PROCEDURE MsRg_GeneralRead;
PROCEDURE MsRg_GeneralWrite;
FUNCTION  MsRg_ArcSearch(ArcExt:String):LongInt;

{ CONFRENC.DAT - Conferences configuration (single record) }
PROCEDURE MsRg_ConfRead;
PROCEDURE MsRg_ConfWrite;

{ FBASES.DAT - File area records }
PROCEDURE MsRg_FAreaOpen;
PROCEDURE MsRg_FAreaClose;
PROCEDURE MsRg_FAreaRead(RecNum:LongInt);
PROCEDURE MsRg_FAreaWrite(RecNum:LongInt);
FUNCTION  MsRg_FAreaGetDir:String;

{ <basename>.DIR - Individual files }
PROCEDURE MsRg_DirFileOpen;
PROCEDURE MsRg_DirFileClose;
PROCEDURE MsRg_DirFileRead(RecNum:LongInt);
PROCEDURE MsRg_DirFileWrite(RecNum:LongInt);
FUNCTION  MsRg_DirFileSize:LongInt;

{ EXTENDED.DAT - Extended descriptions }
PROCEDURE MsRg_ExtOpen;
PROCEDURE MsRg_ExtClose;
PROCEDURE MsRg_ExtRead(RecNum:LongInt);
PROCEDURE MsRg_ExtWrite(RecNum:LongInt);

{ STRINGS.DAT - language strings }
PROCEDURE MsRg_StringsRead;
PROCEDURE MsRg_StringsWrite;

{ HISTORY.DAT - System history/usage information from day 1 }
PROCEDURE MsRg_HistFileOpen;
PROCEDURE MsRg_HistFileClose;
PROCEDURE MsRg_HistFileRead(RecNum:LongInt);
PROCEDURE MsRg_HistFileWrite(RecNum:LongInt);

{ <basename>.SCN - Lastread/base selected information for each msg area }
PROCEDURE MsRg_ScnOpen;
PROCEDURE MsRg_ScnClose;
PROCEDURE MsRg_ScnRead(RecNum:LongInt);
PROCEDURE MsRg_ScnWrite(RecNum:LongInt);

{ MAREAS.DAT - Message area information }
PROCEDURE MsRg_MAreaOpen;
PROCEDURE MsRg_MAreaClose;
PROCEDURE MsRg_MAreaRead(RecNum:LongInt);
PROCEDURE MsRg_MAreaWrite(RecNum:LongInt);
FUNCTION  MsRg_MAreaNum:LongInt;

{ USERS.IDX - Index of user names }
PROCEDURE MsRg_UserIdxOpen;
PROCEDURE MsRg_UserIdxClose;
PROCEDURE MsRg_UserIdxRead(RecNum:LongInt);
PROCEDURE MsRg_UserIdxWrite(RecNum:LongInt);
FUNCTION  MsRg_UserIdxSearch(Name:String):LongInt;

{ USERS.DAT - Information on each user }
PROCEDURE MsRg_UserFileOpen;
PROCEDURE MsRg_UserFileClose;
PROCEDURE MsRg_UserFileRead(RecNum:LongInt);
PROCEDURE MsRg_UserFileWrite(RecNum:LongInt);
PROCEDURE MsRg_UserFrom1005(OldRec:OldUserRec; VAR NewRec:UserRec);
PROCEDURE MsRg_UserTo1005(OldRec:UserRec; VAR NewRec:OldUserRec);

FUNCTION  MsRg_MciString(s:String):String;

FUNCTION  MciFormat_Date:String;
FUNCTION  MciFormat_Time:String;
FUNCTION  MciFormat_TimeLeft:String;
FUNCTION  MciFormat_MrMs:String;
FUNCTION  MciFormat_UserPCR:String;


IMPLEMENTATION


USES  {$I FOSSTYPE.INC }

      CRT,UNIXDATE,MISC1,RWAREAS,RWACS,RWMAIN,RWSTRUCT;

CONST MciUpcase   : Boolean = FALSE;
      MciLocase   : Boolean = FALSE;
      MciStrip    : Boolean = FALSE;  { Strip colour from next MCI code? }
      MciCenter   : Integer = -1;
      MciLeft     : Integer = -1;
      MciRight    : Integer = -1;


FUNCTION MciFormat_Date:String;
VAR yy,mm,dd,junk:Word;
BEGIN
   GetDate(yy,mm,dd,Junk);
   MciFormat_Date := LeadingZero(mm,2)+'/'+LeadingZero(dd,2)+'/'+LeadingZero(yy-1900,2);
END;


FUNCTION MciFormat_Time:String;
VAR hh,mm,ss,junk:Word;
BEGIN
   GetTime(hh,mm,ss,Junk);
   MciFormat_Time := LeadingZero(hh,2)+':'+LeadingZero(mm,2)+':'+LeadingZero(ss,2);
END;


FUNCTION MciFormat_TimeLeft:String;
VAR TempS:String;
BEGIN
   TempS := LeadingZero(fk_Client.TimeLeft DIV 3600,2)+':';
   TempS := TempS+LeadingZero((fk_Client.TimeLeft MOD 3600) DIV 60,2)+':';
   TempS := TempS+LeadingZero(fk_Client.TimeLeft MOD 60,2);
   MciFormat_TimeLeft := TempS;
END;


FUNCTION MciFormat_MrMs:String;
BEGIN
   IF (MsRg_User.Sex = 'F')
      THEN MciFormat_MrMs := 'Ms'
      ELSE MciFormat_MrMs := 'Mr';
END;


FUNCTION MciFormat_UserPCR:String;
VAR TempS:String;
BEGIN
   IF MsRg_User.LoggedOn = 0
      THEN TempS := '0.00'
      ELSE Str((MsRg_User.MsgPost / MsRg_User.LoggedOn*100):0:2,TempS);
   MciFormat_UserPCR := TempS;
END;


FUNCTION MsRg_MciString(s:String):String;
VAR TempS:String; NewStrPos,StrPos,StrLen,PadTo:Byte; TempInt:Word;

    PROCEDURE DoMci;
    VAR Mci,MciExt:String; PadTo:Byte;

        PROCEDURE InsertMci(Str:String);
        VAR PadLen:Integer;
        BEGIN
           IF MciStrip THEN
              BEGIN
                 Str := StripColor(Str);
                 MciStrip := FALSE;
              END;
           IF MciLocase THEN BEGIN
                 Str := DowncaseStr(Str);
                 MciLocase := FALSE;
              END;
           IF MciUpcase THEN BEGIN
                 Str := UpcaseStr(Str);
                 MciUpcase := FALSE;
              END;
           IF MciCenter >= 0 THEN BEGIN
                 PadLen := MciCenter+(Length(Str)-Length(StripColor(Str)));
                 IF PadLen < 0 THEN PadLen := 0;
                 Str := PadCenter(Str,' ',PadLen);
                 MciCenter := -1;
              END;
           IF MciLeft >= 0 THEN BEGIN
                 PadLen := MciLeft+(Length(Str)-Length(StripColor(Str)));
                 IF PadLen < 0 THEN PadLen := 0;
                 Str := PadRight(Str,' ',PadLen);
                 MciLeft := -1;
              END;
           IF MciRight >= 0 THEN BEGIN
                 PadLen := MciRight+(Length(Str)-Length(StripColor(Str)));
                 IF PadLen < 0 THEN PadLen := 0;
                 Str := PadLeft(Str,' ',PadLen);
                 MciRight := -1;
              END;

           IF PadTo = 0 THEN Delete(TempS,NewStrPos,3) ELSE Delete(TempS,NewStrPos,6);
           PadTo := 0;
           Insert(Str,TempS,NewStrPos);
           NewStrPos := NewStrPos + Length(Str);
        END;

    BEGIN
       Mci := Copy(s,StrPos,3);
       IF (StrLen >= 6) AND (s[StrPos+3] = '#') AND (ValFunc(Copy(s,StrPos+4,2)) > 0)
          THEN BEGIN
                MciLeft := ValFunc(Copy(s,StrPos+4,2));
                PadTo := 1;
             END
          ELSE PadTo := 0;

       IF (Mci[1] = '%') THEN
          CASE Mci[2] OF
             '&' : BEGIN
                      IF      (Mci[3] IN ['0'..'9']) THEN InsertMci(RwVariables^[ValFunc(Mci[3])])
                      ELSE IF (Mci[3] IN ['A'..'Z']) THEN InsertMci(RwVariables^[Ord(Mci[3])-55])
                      ELSE IF (Mci[3] IN ['a'..'z']) THEN
                         BEGIN
                            TempInt := ValFunc(Copy(s,StrPos+3,2));
                            CASE Mci[3] OF
                               'a' : IF RwAreasTpl^[TempInt].AreaNum > 0
                                        THEN InsertMci(StrFunc(RwAreasTpl^[TempInt].AreaNum))
                                        ELSE InsertMci('');
                               'b' : IF RwAreasTpl^[TempInt].AreaNum > 0
                                        THEN InsertMci(RwAreasTpl^[TempInt].AreaStat)
                                        ELSE InsertMci('');
                               'c' : IF RwAreasTpl^[TempInt].AreaNum > 0
                                        THEN InsertMci(RwAreasTpl^[TempInt].AreaName)
                                        ELSE InsertMci('');
                            END;
                            Inc(StrPos,2);
                            Delete(TempS,NewStrPos,2);
                         END;
                   END;
             '*' : CASE Mci[3] OF
                      'H' : InsertMci(RwConfig.RwHelpDir);
                      'K' : InsertMci(StrFunc(RwConfig.MaxBaseMsgs));
                      'L' : InsertMci(StrFunc(RwConfig.MaxTotalMsgs));
                      'M' : InsertMci(RwConfig.RwMenuDir);
                      'N' : InsertMci(RwConfig.RwLangDir);
                      'P' : IF NOT (RwPacketQwk IN RwUser.RwFlags)
                               THEN InsertMci(RwConfig.BBSID)
                               ELSE InsertMci(MsRg_General.PacketName);
                      'T' : InsertMci(RwConfig.RwTextDir);
                      'Z' : InsertMci(RwConfig.RwMainDir);
                      'W' : InsertMci(RwConfig.RwWorkDir);
                   END;
             '!' : CASE Mci[3] OF
                      'A' : CASE RwUser.AttachMethod OF
                               0 : InsertMci('Flag NONE');
                               1 : InsertMci('Flag NEW attaches');
                               2 : InsertMci('Flag ALL attaches');
                            END;
                      'B' : InsertMci(RWM_RwMciStr(NOT (RwNotMyMail IN RwUser.BWaveFlags)));
                      'D' : InsertMci(RWM_RwMciStr(RwNukeEmail IN RwUser.RwFlags));
                      'E' : InsertMci(RWM_RwMciStr(RwXPert IN RwUser.BWaveFlags));
                      'H' : InsertMci(RWM_RwMciStr(RwHotkeys IN RwUser.BWaveFlags));
                      'I' : InsertMci(RWM_RwMciStr(RwFileList IN RwUser.BWaveFlags));
                      'M' : InsertMci(StrFunc(RwUser.MsgsLimit));
                      'N' : InsertMci(RWM_RwMciStr(RwNumericPkt IN RwUser.BWaveFlags));
                      'P' : InsertMci(RwUser.RwPass);
                      'F' : IF NOT (RwPacketQwk IN RwUser.RwFlags)
                               THEN InsertMci('Blue Wave')
                               ELSE InsertMci('QWK');
                      'U' : CASE RwUser.PassUsage OF
                               0 : InsertMci('<disabled>');
                               1 : InsertMci('Door Only');
                               2 : InsertMci('Reader Only');
                               3 : InsertMci('Door/Reader');
                            END;
                      '1' : InsertMci(MsRg_General.FileArcInfo[MsRg_User.DefArcType].Ext);
                      '2' : InsertMci(RwConfig.RwProtocols[RWM_FindProt(RwUser.RwProtocol)].Desc);
                      '3' : InsertMci(LeadingZero(RwUser.PktNumber,3));
                   END;
             '%' : CASE Mci[3] OF
                      'S' : BEGIN
                               MciStrip := TRUE;
                               Delete(TempS,NewStrPos,3);
                            END;
{ ~%C }               'C' : BEGIN
                               MciCenter := -1;
                               MciExt := '';
                               IF (s[StrPos+3] >= '0') AND (s[StrPos+3] <= '9') THEN MciExt := MciExt+s[StrPos+3];
                               IF (s[StrPos+4] >= '0') AND (s[StrPos+4] <= '9') THEN MciExt := MciExt+s[StrPos+4];
                               MciCenter := ValFunc(MciExt);
                               Inc(StrPos,Length(MciExt));
                               Delete(TempS,NewStrPos,3+Length(MciExt));
                            END;
{ %%L }               'L' : BEGIN
                               MciLeft := -1;
                               MciExt := '';
                               IF (s[StrPos+3] >= '0') AND (s[StrPos+3] <= '9') THEN MciExt := MciExt+s[StrPos+3];
                               IF (s[StrPos+4] >= '0') AND (s[StrPos+4] <= '9') THEN MciExt := MciExt+s[StrPos+4];
                               MciLeft := ValFunc(MciExt);
                               Inc(StrPos,Length(MciExt));
                               Delete(TempS,NewStrPos,3+Length(MciExt));
                            END;
{ %%M }               'M' : InsertMci(#13);
{ ~%R }               'R' : BEGIN
                               MciRight := -1;
                               MciExt := '';
                               IF (s[StrPos+3] >= '0') AND (s[StrPos+3] <= '9') THEN MciExt := MciExt+s[StrPos+3];
                               IF (s[StrPos+4] >= '0') AND (s[StrPos+4] <= '9') THEN MciExt := MciExt+s[StrPos+4];
                               MciRight := ValFunc(MciExt);
                               Inc(StrPos,Length(MciExt));
                               Delete(TempS,NewStrPos,3+Length(MciExt));
                            END;
{ ~%U }               'U' : BEGIN
                               MciUpcase := TRUE;
                               Delete(TempS,NewStrPos,3);
                            END;
{ ~%W }               'W' : BEGIN
                               MciLocase := TRUE;
                               Delete(TempS,NewStRPos,3);
                            END;
                   END;
             'A' : CASE Mci[3] OF
                      'B' : InsertMci(StrFunc(MsRg_User.Credit-MsRg_User.Debit));
                      'D' : InsertMci(MsRg_User.Street);
                      'O' : InsertMci(''{aborting off});
                   END;
             'B' : CASE Mci[3] OF
                      'D' : InsertMci(StrFunc(fk_Fossil.Baud));
                      'N' : InsertMci(MsRg_General.BBSName);
                      'P' : InsertMci(MsRg_General.BBSPhone);
                   END;
             'C' : CASE Mci[3] OF
                      'L' : InsertMci(#12);
                      'M' : InsertMci('');
                      'N' : InsertMci('');
                      'R' : InsertMci(StrFunc(MsRg_User.Credit));
                      'S' : InsertMci(MsRg_User.CityState);
                   END;
             'D' : CASE Mci[3] OF
                      '1' : InsertMci(MsRg_User.UsrDefStr[1]);
                      '2' : InsertMci(MsRg_User.UsrDefStr[2]);
                      '3' : InsertMci(MsRg_User.UsrDefStr[3]);
                      'A' : InsertMci(MciFormat_Date);
                      'B' : InsertMci(StrFunc(MsRg_User.Debit));
                      'S' : InsertMci(StrFUnc(MsRg_USer.dsl));
                   END;
             'E' : CASE Mci[3] OF
                      'S' : InsertMci(StrFunc(MsRg_User.EmailSent));
                      'W' : InsertMci(StrFunc(MsRg_User.Waiting));
                   END;
             'F' : CASE Mci[3] OF
                      '#' : InsertMci('');
                      'B' : InsertMci(MsRg_FArea.Name);
                      'D' : InsertMci(Unix2DateStr(1,MsRg_User.FirstOn));
                      'L' : InsertMci(StrFunc(MsRg_User.DSL));
                      'N' : InsertMci(ExtractName(MsRg_User.Realname,FALSE));
                   END;
             'G' : CASE Mci[3] OF
                      'N' : InsertMci(MciFormat_MrMs);
                   END;
             'I' : CASE Mci[3] OF
                      'L' : InsertMci(StrFunc(MsRg_User.Illegal));
                   END;
             'L' : CASE Mci[3] OF
                      'F' : InsertMci(#13#10);
                      'N' : InsertMci(ExtractName(MsRg_User.Realname,TRUE));
                   END;
             'M' : CASE Mci[3] OF
                      '#' : InsertMci(MciF_MsgBaseNum);
                      'B' : InsertMci(MsRg_MArea.Name);
                      'L' : InsertMci(StrFunc(fk_Client.TimeLeft DIV 60));
                   END;
             'N' : CASE Mci[3] OF
                      'D' : InsertMci(StrFunc(fk_Host.Node));
                   END;
             'O' : CASE Mci[3] OF
                      '7' : InsertMci(OnOffBoolean(NOT (Novice IN MsRg_User.Flags)));
                      '8' : InsertMci('');
                      '9' : InsertMci(OnOffBoolean(Color IN MsRg_User.Flags));
                   END;
             'P' : CASE Mci[3] OF
                      'C' : InsertMci(MciFormat_UserPCR);
                      'N' : InsertMci(MsRg_User.Ph);
                      'S' : InsertMci(StrFunc(MsRg_User.MsgPost));
                   END;
             'R' : CASE Mci[3] OF
                      'N' : InsertMci(MsRg_User.RealName);
                   END;
             'S' : CASE Mci[3] OF
                      'A' : InsertMci(MsRg_User.Street);
                      'L' : InsertMci(StrFunc(MsRg_User.SL));
                      'N' : InsertMci(MsRg_General.SysopName)
                   END;
             'T' : CASE Mci[3] OF
                      'A' : InsertMci(StrFunc(MsRg_User.TimeBankAdd));
                      'B' : InsertMci(StrFunc(MsRg_User.TimeBank));
                      'I' : InsertMci(MciFormat_Time);
                      'L' : InsertMci(MciFormat_TimeLeft);
                      'O' : InsertMci('');
                      'T' : InsertMci(StrFunc(MsRg_User.tTimeOn));
                   END;
             'U' : CASE Mci[3] OF
                      'N' : InsertMci(FormatName(MsRg_User.Name));
                   END;
             'Z' : CASE Mci[3] OF
                      'P' : InsertMci(MsRg_User.ZipCode);
                   END;
             ELSE Inc(NewStrPos,Length(Mci));
          END;

      IF PadTo = 0
         THEN Inc(StrPos,3)
         ELSE Inc(StrPos,6);
   END;


BEGIN
   TempS := s;
   SetMciStrings;
   StrPos := 1;
   NewStrPos := 1;
   WHILE StrPos <= Length(s) DO
      BEGIN
         IF (s[StrPos] = '%') AND (Length(s) >= StrPos+2)
            THEN DoMci
            ELSE BEGIN
                  Inc(StrPos);
                  Inc(NewStrPos);
               END;
      END;
   MsRg_MciString := TempS;
END;



{ RENEGADE.DAT - Main system configuration }
PROCEDURE MsRg_GeneralRead;
BEGIN
   Assign(MsRg_GeneralFile,MsRg_CfgPath+'RENEGADE.DAT');
   Reset(MsRg_GeneralFile);
   Seek(MsRg_GeneralFile,0);
   Read(MsRg_GeneralFile,MsRg_General);
   Close(MsRg_GeneralFile);
END;

PROCEDURE MsRg_GeneralWrite;
BEGIN
   Assign(MsRg_GeneralFile,MsRg_CfgPath+'RENEGADE.DAT');
   Reset(MsRg_GeneralFile);
   Seek(MsRg_GeneralFile,0);
   Write(MsRg_GeneralFile,MsRg_General);
   Close(MsRg_GeneralFile);
END;

FUNCTION  MsRg_ArcSearch(ArcExt:String):LongInt;
VAR Found:Boolean; ThisArc:Word;
BEGIN
   Found := FALSE;
   FOR ThisArc := 1 TO MaxArcs DO
      IF MsRg_General.FileArcInfo[ThisArc].Active THEN
         IF (MsRg_General.FileArcInfo[ThisArc].Ext = ArcExt) THEN
            BEGIN
               MsRg_ArcSearch := ThisArc;
               Exit;
            END;
   MsRg_ArcSearch := 0;
END;


{ CONFRENC.DAT - Conferences configuration (single record) }
PROCEDURE MsRg_ConfRead;
BEGIN
   Assign(MsRg_ConfFile,MsRg_General.DataPath+'CONFRENC.DAT');
   Reset(MsRg_ConfFile);
   Seek(MsRg_ConfFile,0);
   Read(MsRg_ConfFile,MsRg_ConfData);
   Close(MsRg_ConfFile);
END;

PROCEDURE MsRg_ConfWrite;
BEGIN
   Assign(MsRg_ConfFile,MsRg_General.DataPath+'CONFRENC.DAT');
   Reset(MsRg_ConfFile);
   Seek(MsRg_ConfFile,0);
   Write(MsRg_ConfFile,MsRg_ConfData);
   Close(MsRg_ConfFile);
END;


{ FBASES.DAT - File area records }
PROCEDURE MsRg_FAreaOpen;
BEGIN
   Assign(MsRg_FAreaFile,MsRg_General.DataPath+'FBASES.DAT');
   Reset(MsRg_FAreaFile);
   MsRg_FileBase := 0;
END;

PROCEDURE MsRg_FAreaClose;
BEGIN
   IF FileRec(MsRg_FAreaFile).Mode <> fmClosed THEN Close(MsRg_FAreaFile);
   IF IOResult <> 0 THEN ;
   MsRg_FileBase := -1;
END;

PROCEDURE MsRg_FAreaRead(RecNum:LongInt);
BEGIN
   IF RecNum >= FileSize(MsRg_FAreaFile) THEN Exit;
   MsRg_FileBase := RecNum;
   IF MsRg_FileBase < 0 THEN MsRg_FileBase := 0;
   Seek(MsRg_FAreaFile,MsRg_FileBase);
   Read(MsRg_FAreaFile,MsRg_FArea)
END;

PROCEDURE MsRg_FAreaWrite(RecNum:LongInt);
BEGIN
   IF RecNum > FileSize(MsRg_FAreaFile) THEN Exit;
   MsRg_FileBase := RecNum;
   IF MsRg_FileBase < 0 THEN MsRg_FileBase := 0;
   Seek(MsRg_FAreaFile,MsRg_FileBase);
   Write(MsRg_FAreaFile,MsRg_FArea)
END;

FUNCTION  MsRg_FAreaGetDir:String;
BEGIN
   IF (fbDirDlPath IN MsRg_FArea.FbStat)
      THEN MsRg_FAreaGetDir := MsRg_FArea.DLPath+MsRg_FArea.FileName
      ELSE MsRg_FAreaGetDir := MsRg_General.DataPath+MsRg_FArea.FileName;
END;


{ <basename>.DIR - Individual files }
PROCEDURE MsRg_DirFileOpen;
BEGIN
   Assign(MsRg_DirFile,MsRg_FAreaGetDir+'.DIR');
   Reset(MsRg_DirFile);
   MsRg_FileNum := 0;
END;

PROCEDURE MsRg_DirFileClose;
BEGIN
   IF FileRec(MsRg_DirFile).Mode <> fmClosed THEN Close(MsRg_DirFile);
   IF IOResult <> 0 THEN ;
   MsRg_FileNum := -1;
END;

PROCEDURE MsRg_DirFileRead(RecNum:LongInt);
BEGIN
   IF RecNum >= FileSize(MsRg_DirFile) THEN Exit;
   MsRg_FileNum := RecNum;
   IF MsRg_FileNum < 0 THEN MsRg_FileNum := 0;
   Seek(MsRg_DirFile,MsRg_FileNum);
   Read(MsRg_DirFile,MsRg_Dir)
END;

PROCEDURE MsRg_DirFileWrite(RecNum:LongInt);
BEGIN
   IF RecNum > FileSize(MsRg_DirFile) THEN Exit;
   MsRg_FileNum := RecNum;
   IF MsRg_FileNum < 0 THEN MsRg_FileNum := 0;
   Seek(MsRg_DirFile,MsRg_FileNum);
   Write(MsRg_DirFile,MsRg_Dir)
END;

FUNCTION  MsRg_DirFileSize:LongInt;
BEGIN
   MsRg_DirFileSize := (LongInt(MsRg_Dir.Blocks)*128)+LongInt(MsRg_Dir.SizeMod);
END;


{ EXTENDED.DAT - Extended descriptions }
PROCEDURE MsRg_ExtOpen;
BEGIN
   Assign(MsRg_ExtFile,MsRg_General.DataPath+'EXTENDED.DAT');
   Reset(MsRg_ExtFile,1);
   MsRg_ExtPos := 0;
END;

PROCEDURE MsRg_ExtClose;
BEGIN
   IF FileRec(MsRg_ExtFile).Mode <> fmClosed THEN Close(MsRg_ExtFile); IF IOResult <> 0 THEN ;
   MsRg_ExtPos := -1;
END;

PROCEDURE MsRg_ExtRead(RecNum:LongInt);
BEGIN
   IF (RecNum*MsRg_ExtSize*51) >= FileSize(MsRg_ExtFile) THEN Exit;
   MsRg_ExtPos := RecNum*MsRg_ExtSize*51;
   IF MsRg_ExtPos < 0 THEN MsRg_ExtPos := 0;
   Seek(MsRg_ExtFile,MsRg_ExtPos);
   BlockRead(MsRg_ExtFile,MsRg_Ext,MsRg_ExtSize*51);
END;

PROCEDURE MsRg_ExtWrite(RecNum:LongInt);
BEGIN
   IF (RecNum*MsRg_ExtSize*51) > FileSize(MsRg_ExtFile) THEN Exit;
   MsRg_ExtPos := RecNum*MsRg_ExtSize*51;
   IF MsRg_ExtPos < 0 THEN MsRg_ExtPos := 0;
   Seek(MsRg_ExtFile,MsRg_ExtPos);
   BlockWrite(MsRg_ExtFile,MsRg_Ext,MsRg_ExtSize*51);
END;


{ STRINGS.DAT - language strings }
PROCEDURE MsRg_StringsRead;
BEGIN
   Assign(MsRg_StringFile,MsRg_General.DataPath+'STRINGS.DAT');
   Reset(MsRg_StringFile);
   Seek(MsRg_StringFile,0);
   Read(MsRg_StringFile,MsRg_Strings);
   Close(MsRg_StringFile);
END;

PROCEDURE MsRg_StringsWrite;
BEGIN
   Assign(MsRg_StringFile,MsRg_General.DataPath+'STRINGS.DAT');
   Reset(MsRg_StringFile);
   Seek(MsRg_StringFile,0);
   Write(MsRg_StringFile,MsRg_Strings);
   Close(MsRg_StringFile);
END;


{ HISTORY.DAT - System history/usage information from day 1 }
PROCEDURE MsRg_HistFileOpen;
BEGIN
   MsRg_HistoryPos := 0;
   Assign(MsRg_HistFile,AddSlash(MsRg_General.DataPath)+'HISTORY.DAT');
   Reset(MsRg_HistFile);
   MsRg_Error := IOResult;
END;

PROCEDURE MsRg_HistFileClose;
BEGIN
   IF FileRec(MsRg_HistFile).Mode <> fmClosed THEN Close(MsRg_HistFile); IF IOResult <> 0 THEN ;
   MsRg_HistoryPos := -1;
END;

PROCEDURE MsRg_HistFileRead(RecNum:LongInt);
BEGIN
   IF RecNum >= FileSize(MsRg_HistFile) THEN Exit;
   MsRg_HistoryPos := RecNum;
   IF MsRg_HistoryPos < 0 THEN MsRg_HistoryPos := 0;
   Seek(MsRg_HistFile,MsRg_HistoryPos);
   Read(MsRg_HistFile,MsRg_History)
END;

PROCEDURE MsRg_HistFileWrite(RecNum:LongInt);
BEGIN
   IF RecNum > FileSize(MsRg_HistFile) THEN Exit;
   MsRg_HistoryPos := RecNum;
   IF MsRg_HistoryPos < 0 THEN MsRg_HistoryPos := 0;
   Seek(MsRg_HistFile,MsRg_HistoryPos);
   Write(MsRg_HistFile,MsRg_History);
END;


{ <basename>.SCN - Lastread/base selected information for each msg area }
PROCEDURE MsRg_ScnOpen;
BEGIN
   Assign(MsRg_ScnFile,MsRg_General.MsgPath+MsRg_MArea.FileName+'.SCN');
   IF FExists(MsRg_General.MsgPath+MsRg_MArea.FileName+'.SCN')
      THEN Reset(MsRg_ScnFile)
      ELSE Rewrite(MsRg_ScnFile);
   MsRg_ScnPos := 0;
END;

PROCEDURE MsRg_ScnClose;
BEGIN
   IF FileRec(MsRg_ScnFile).Mode <> fmClosed THEN Close(MsRg_ScnFile);
   IF IOResult <> 0 THEN ;
   MsRg_ScnPos := -1;
END;

PROCEDURE MsRg_BuildScn(RecNum:LongInt);
VAR Scn:ScanRec; i:Word;
BEGIN
   IF RecNum >= FileSize(MsRg_ScnFile) THEN
      BEGIN
         Scn.NewScan := TRUE;
         Scn.Lastread := 0;
         FOR i := FileSize(MsRg_ScnFile) TO RecNum DO
            BEGIN
               Seek(MsRg_ScnFile,i);
               Write(MsRg_ScnFile,Scn);
            END;
      END;
END;

PROCEDURE MsRg_ScnRead(RecNum:LongInt);
BEGIN
   MsRg_BuildScn(RecNum);
   MsRg_ScnPos := RecNum;
   IF MsRg_ScnPos < 0 THEN MsRg_ScnPos := 0;
   Seek(MsRg_ScnFile,MsRg_ScnPos);
   Read(MsRg_ScnFile,MsRg_Scn);
END;

PROCEDURE MsRg_ScnWrite(RecNum:LongInt);
BEGIN
   MsRg_BuildScn(RecNum);
   MsRg_ScnPos := RecNum;
   IF MsRg_ScnPos < 0 THEN MsRg_ScnPos := 0;
   Seek(MsRg_ScnFile,MsRg_ScnPos);
   Write(MsRg_ScnFile,MsRg_Scn)
END;


{ MAREAS.DAT - Message area information }
PROCEDURE MsRg_MAreaOpen;
BEGIN
   Assign(MsRg_MAreaFile,MsRg_General.DataPath+'MBASES.DAT');
   Reset(MsRg_MAreaFile);
   MsRg_MsgArea := 0;
END;

PROCEDURE MsRg_MAreaClose;
BEGIN
   IF FileRec(MsRg_MAreaFile).Mode <> fmClosed THEN Close(MsRg_MAreaFile);
   IF IOResult <> 0 THEN ;
   MsRg_MsgArea := -1;
END;

PROCEDURE MsRg_MAreaRead(RecNum:LongInt);
BEGIN
   IF RecNum >= FileSize(MsRg_MAreaFile)+2 THEN Exit;
   IF RecNum < 0 THEN MsRg_MsgArea := 0 ELSE MsRg_MsgArea := RecNum;
   CASE MsRg_msgArea OF
      0 : BEGIN
             FillChar(MsRg_MArea,SizeOf(MsRg_MArea),0);
             MsRg_MArea.Name := 'Private Messages';
             MsRg_MArea.FileName := 'EMAIL';
             MsRg_MArea.MciAcs := '%';
             MsRg_MArea.SysopAcs := 's255';
             MsRg_MArea.Anonymous := atno;
             MsRg_MArea.mbStat := [mbPrivate];
             IF RwConfig.ForceEmail THEN MsRg_MArea.mbStat := MsRg_MArea.mbStat+[mbForceRead];
             MsRg_MArea.mbType := 10;
             MsRg_MArea.QwkIndex := 1;
             IF NOT (remail IN MsRg_User.Flags)
                THEN MsRg_MArea.PostAcs := MsRg_General.NormPrivPost
                ELSE MsRg_MArea.PostAcs := '%';
          END;
      1 : BEGIN
             FillChar(MsRg_MArea,SizeOf(MsRg_MArea),0);
             MsRg_MArea.Name := 'Private Netmail';
             MsRg_MArea.FileName := 'NETMAIL';
             MsRg_MArea.PostAcs := MsRg_General.NetmailAcs;
             MsRg_MArea.MciAcs := '%';
             MsRg_MArea.SysopAcs := 's255';
             MsRg_MArea.Anonymous := atno;
             MsRg_MArea.mbStat := [mbPrivate,mbAddTear];
             IF RwConfig.ForceNetmail THEN MsRg_MArea.mbStat := MsRg_MArea.mbStat+[mbForceRead];
             MsRg_MArea.mbType := 11;
             MsRg_MArea.QwkIndex := 2;
             MsRg_MArea.Origin := MsRg_General.Origin;
             IF NOT (remail IN MsRg_User.Flags)
                THEN MsRg_MArea.PostAcs := MsRg_General.NormPrivPost
                ELSE MsRg_MArea.PostAcs := '%';
          END;
      ELSE BEGIN
            Seek(MsRg_MAreaFile,MsRg_MsgArea-2);
            Read(MsRg_MAreaFile,MsRg_MArea);
            MsRg_MArea.QwkIndex := MsRg_MArea.QwkIndex+3;
         END;
   END;
END;

PROCEDURE MsRg_MAreaWrite(RecNum:LongInt);
BEGIN
   IF RecNum > (FileSize(MsRg_MAreaFile)+2) THEN Exit;
   MsRg_MsgArea := RecNum;
   IF RecNum > 1 THEN
      BEGIN
         MsRg_MsgArea := RecNum;
         MsRg_MArea.QwkIndex := MsRg_MArea.QwkIndex-3;
         Seek(MsRg_MAreaFile,MsRg_MsgArea-2);
         Write(MsRg_MAreaFile,MsRg_MArea);
         MsRg_MArea.QwkIndex := MsRg_MArea.QwkIndex+3;
      END;
END;

FUNCTION MsRg_MAreaNum:LongInt;
BEGIN
   MsRg_MAreaNum := FileSize(MsRg_MAreaFile)+2;
END;


{ USERS.IDX - Index of user names }
PROCEDURE MsRg_UserIdxOpen;
BEGIN
   Assign(MsRg_UserIdxFile,MsRg_General.DataPath+'USERS.IDX');
   Reset(MsRg_UserIdxFile);
   MsRg_UserIdxPos := 0;
END;

PROCEDURE MsRg_UserIdxClose;
BEGIN
   IF FileRec(MsRg_UserIdxFile).Mode <> fmClosed THEN Close(MsRg_UserIdxFile);
   IF IOResult <> 0 THEN ;
   MsRg_UserIdxPos := -1;
END;

PROCEDURE MsRg_UserIdxRead(RecNum:LongInt);
BEGIN
   IF RecNum >= FileSize(MsRg_UserIdxFile) THEN Exit;
   MsRg_UserIdxPos := RecNum;
   IF MsRg_UserIdxPos < 0 THEN MsRg_UserIdxPos := 0;
   Seek(MsRg_UserIdxFile,MsRg_UserIdxPos);
   Read(MsRg_UserIdxFile,MsRg_UserIdx)
END;

PROCEDURE MsRg_UserIdxWrite(RecNum:LongInt);
BEGIN
   IF RecNum > FileSize(MsRg_UserIdxFile) THEN Exit;
   MsRg_UserIdxPos := RecNum;
   IF MsRg_UserIdxPos < 0 THEN MsRg_UserIdxPos := 0;
   Seek(MsRg_UserIdxFile,MsRg_UserIdxPos);
   Write(MsRg_UserIdxFile,MsRg_UserIdx);
END;

FUNCTION  MsRg_UserIdxSearch(Name:String):LongInt;
VAR UserFound:Boolean; TempUNum:LongInt;
BEGIN
   IF FileRec(MsRg_UserIdxFile).Mode = fmClosed THEN
      BEGIN
         MsRg_UserIdxSearch := -1;
         Exit;
      END;

   Name := UpcaseStr(Name);
   TempUNum := 0;
   UserFound := FALSE;
   Reset(MsRg_UserIdxFile);

   WHILE (TempUNum <= (FileSize(MsRg_UserIdxFile)-1)) AND (NOT UserFound) DO
      BEGIN
         MsRg_UserIdxRead(TempUNum);
         UserFound := (NOT MsRg_UserIdx.Deleted) AND (UpcaseStr(MsRg_UserIdx.Name) = Name);
         Inc(TempUNum);
      END;

   IF UserFound
      THEN MsRg_UserIdxSearch := MsRg_UserIdx.Number
      ELSE MsRg_UserIdxSearch := -1;
END;


{ USERS.DAT - Information on each user }
PROCEDURE MsRg_UserFileOpen;
BEGIN
   Assign(MsRg_UserFile,MsRg_General.DataPath+'USERS.DAT');
   Reset(MsRg_UserFile,1);
   MsRg_UserNum := 0;
END;

PROCEDURE MsRg_UserFileClose;
BEGIN
   IF FileRec(MsRg_UserFile).Mode <> fmClosed THEN Close(MsRg_UserFile);
   IF IOResult <> 0 THEN ;
   MsRg_UserNum := -1;
END;

PROCEDURE MsRg_UserFileRead(RecNum:LongInt);
VAR OldUser:OldUserRec;
BEGIN
   IF (RecNum*MsRg_UserRecSize) >= FileSize(MsRg_UserFile) THEN Exit;
   MsRg_UserNum := RecNum;
   IF MsRg_UserNum < 0 THEN MsRg_UserNum := 0;
   Seek(MsRg_UserFile,MsRg_UserNum*MsRg_UserRecSize);
   {...}
   IF MsRg_UserVer = 0511
      THEN BlockRead(MsRg_UserFile,MsRg_User,SizeOf(MsRg_User))
      ELSE BEGIN
            BlockRead(MsRg_UserFile,OldUser,SizeOf(OldUser));
            MsRg_UserFrom1005(OldUser,MsRg_User);
         END;
END;

PROCEDURE MsRg_UserFileWrite(RecNum:LongInt);
VAR OldUser:OldUserRec;
BEGIN
   IF (RecNum*MsRg_UserRecSize) > FileSize(MsRg_UserFile) THEN Exit;
   MsRg_UserNum := RecNum;
   IF MsRg_UserNum < 0 THEN MsRg_UserNum := 0;
   Seek(MsRg_UserFile,MsRg_UserNum*MsRg_USerRecSize);
   {...}
   IF MsRg_UserVer = 0511
      THEN BlockWrite(MsRg_UserFile,MsRg_User,SizeOf(MsRg_User))
      ELSE BEGIN
            BlockRead(MsRg_UserFile,OldUser,SizeOf(OldUser));
            Seek(MsRg_UserFile,MsRg_UserNum*MsRg_UserRecSize);
            MsRg_UserTo1005(MsRg_User,OldUser);
            BlockWrite(MsRg_UserFile,OldUser,SizeOf(OldUser));
         END;
END;

PROCEDURE MsRg_UserFrom1005(OldRec:OldUserRec; VAR NewRec:UserRec);
BEGIN
   FillChar(NewRec,SizeOf(NewRec),0);

   NewRec.Name            := OldRec.Name;
   NewRec.RealName        := OldRec.RealName;
   NewRec.Street          := OldRec.Street;
   NewRec.CityState       := OldRec.CityState;
   NewRec.ZipCode         := OldRec.ZipCode;
   NewRec.Ph              := OldRec.Ph;

   Move(OldRec.UsrDefStr,NewRec.UsrDefStr,SizeOf(NewRec.UsrDefStr));
   Move(OldRec.Vote,NewRec.Vote,SizeOf(NewRec.Vote));

   NewRec.BirthDate       := StrDate2Unix(1,OldRec.bday);
   NewRec.FirstOn         := StrDate2Unix(1,OldRec.FirstOn);
   NewRec.LastOn          := StrDate2Unix(1,OldRec.LastOn);

   NewRec.Note            := OldRec.Note;
   NewRec.userstartmenu   := OldRec.userstartmenu;
   NewRec.LockedFile      := OldRec.LockedFile;
   NewRec.Flags           := OldRec.Flags;
   NewRec.sFlags          := OldRec.sFlags;
   NewRec.Ar              := OldRec.Ar;
   NewRec.Sex             := OldRec.Sex;
   NewRec.tTimeOn         := OldRec.tTimeOn;
   NewRec.uk              := OldRec.uk;
   NewRec.dk              := OldRec.dk;
   NewRec.LastQwk         := OldRec.LastQwk;

   NewRec.tlToday         := OldRec.tlToday;
   NewRec.forusr          := OldRec.forusr;
   NewRec.Credit          := OldRec.Credit;
   NewRec.Debit           := OldRec.Debit;
   NewRec.Expiration      := OldRec.Expiration;
   NewRec.PasswordChanged := OldRec.PasswordChanged;
   NewRec.Uploads         := OldRec.Uploads;
   NewRec.Downloads       := OldRec.Downloads;
   NewRec.LoggedOn        := OldRec.LoggedOn;
   NewRec.MsgPost         := OldRec.MsgPost;
   NewRec.EmailSent       := OldRec.EmailSent;
   NewRec.Feedback        := OldRec.Feedback;
   NewRec.Timebank        := OldRec.Timebank;
   NewRec.TimebankAdd     := OldRec.TimebankAdd;
   NewRec.dlktoday        := OldRec.dlktoday;
   NewRec.dltoday         := OldRec.dltoday;
   NewRec.Timebankwith    := OldRec.Timebankwith;
   NewRec.Lastmbase       := OldRec.Lastmbase;
   NewRec.Lastfbase       := OldRec.Lastfbase;
   NewRec.Waiting         := OldRec.Waiting;
   NewRec.LineLen         := OldRec.LineLen;
   NewRec.PageLen         := OldRec.PageLen;
   NewRec.OnToday         := OldRec.OnToday;
   NewRec.Illegal         := OldRec.Illegal;
   NewRec.sl              := OldRec.sl;
   NewRec.dsl             := OldRec.dsl;
   NewRec.defarctype      := OldRec.defarctype;
   NewRec.ColorScheme     := OldRec.ColorScheme;
   NewRec.LastConf        := OldRec.LastConf;
   NewRec.ExpireTo        := OldRec.ExpireTo;
   NewRec.TeleConfEcho    := OldRec.TeleConfEcho;
   NewRec.TeleConfInt     := OldRec.TeleConfInt;
   NewRec.GetOwnQwk       := OldRec.GetOwnQwk;
   NewRec.ScanFilesQwk    := OldRec.ScanFilesQwk;
   NewRec.PrivateQwk      := OldRec.PrivateQwk;
   { NewRec.Subscription := }
END;


PROCEDURE MsRg_UserTo1005(OldRec:UserRec; VAR NewRec:OldUserRec);
BEGIN
   NewRec.Name            := OldRec.Name;
   NewRec.RealName        := OldRec.RealName;
   NewRec.Street          := OldRec.Street;
   NewRec.CityState       := OldRec.CityState;
   NewRec.ZipCode         := OldRec.ZipCode;
   NewRec.Ph              := OldRec.Ph;

   Move(OldRec.UsrDefStr,NewRec.UsrDefStr,SizeOf(NewRec.UsrDefStr));
   Move(OldRec.Vote,NewRec.Vote,SizeOf(NewRec.Vote));

   NewRec.bday            := Unix2DateStr(1,OldRec.BirthDate);
   NewRec.FirstOn         := Unix2DateStr(1,OldRec.FirstOn);
   NewRec.LastOn          := Unix2DateStr(1,OldRec.LastOn);

   NewRec.Note            := OldRec.Note;
   NewRec.userstartmenu   := OldRec.userstartmenu;
   NewRec.LockedFile      := OldRec.LockedFile;
   NewRec.Flags           := OldRec.Flags;
   NewRec.sFlags          := OldRec.sFlags;
   NewRec.Ar              := OldRec.Ar;
   NewRec.Sex             := OldRec.Sex;
   NewRec.tTimeOn         := OldRec.tTimeOn;
   NewRec.uk              := OldRec.uk;
   NewRec.dk              := OldRec.dk;
   NewRec.LastQwk         := OldRec.LastQwk;

   NewRec.tlToday         := OldRec.tlToday;
   NewRec.forusr          := OldRec.forusr;
   NewRec.Credit          := OldRec.Credit;
   NewRec.Debit           := OldRec.Debit;
   NewRec.Expiration      := OldRec.Expiration;
   NewRec.PasswordChanged := OldRec.PasswordChanged;
   NewRec.Uploads         := OldRec.Uploads;
   NewRec.Downloads       := OldRec.Downloads;
   NewRec.LoggedOn        := OldRec.LoggedOn;
   NewRec.MsgPost         := OldRec.MsgPost;
   NewRec.EmailSent       := OldRec.EmailSent;
   NewRec.Feedback        := OldRec.Feedback;
   NewRec.Timebank        := OldRec.Timebank;
   NewRec.TimebankAdd     := OldRec.TimebankAdd;
   NewRec.dlktoday        := OldRec.dlktoday;
   NewRec.dltoday         := OldRec.dltoday;
   NewRec.Timebankwith    := OldRec.Timebankwith;
   NewRec.Lastmbase       := OldRec.Lastmbase;
   NewRec.Lastfbase       := OldRec.Lastfbase;
   NewRec.Waiting         := OldRec.Waiting;
   NewRec.LineLen         := OldRec.LineLen;
   NewRec.PageLen         := OldRec.PageLen;
   NewRec.OnToday         := OldRec.OnToday;
   NewRec.Illegal         := OldRec.Illegal;
   NewRec.sl              := OldRec.sl;
   NewRec.dsl             := OldRec.dsl;
   NewRec.defarctype      := OldRec.defarctype;
   NewRec.ColorScheme     := OldRec.ColorScheme;
   NewRec.LastConf        := OldRec.LastConf;
   NewRec.ExpireTo        := OldRec.ExpireTo;
   NewRec.TeleConfEcho    := OldRec.TeleConfEcho;
   NewRec.TeleConfInt     := OldRec.TeleConfInt;
   NewRec.GetOwnQwk       := OldRec.GetOwnQwk;
   NewRec.ScanFilesQwk    := OldRec.ScanFilesQwk;
   NewRec.PrivateQwk      := OldRec.PrivateQwk;
   { NewRec.Subscription := }
END;


BEGIN
   MsRg_ExtSize := OldExtSize;
END.





