PROGRAM INSTALL;
{$R-,S-,D+,O+,F+,V-}

(* 

    RENEWAVE Installation Program

    RENEWAVE is Copyright (C) 1994-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of RENEWAVE.

    RENEWAVE is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RENEWAVE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RENEWAVE; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)

USES RECORDS,  RWSTRUCT, MSBWGEN,  CRT,      DOS,      MSTRINGS,
     MISC1,    CURSOR,   FASTW,    MYSHARE,  PACKUNIT, SCREENS,
     OVERLAY,  KEYINPUT, MSOBJ,    EXECSWAP;


VAR  SetupRW : FILE OF ConfigRec;
     SRW     : ConfigRec;
     f       : FILE;


PROCEDURE CreateSetupRW;
BEGIN
   FillChar(SRW,SizeOf(SRW),0);
   FillChar(SRW.LogOpts,SizeOf(SRW.LogOpts),TRUE);

   IF      GetEnv('RENEGADE') <> '' THEN SRW.RgMainDir := AddSlash(GetEnv('RENEGADE'))
   ELSE IF GetEnv('RG')       <> '' THEN SRW.RgMainDir := AddSlash(GetEnv('RG'))
   ELSE IF GetEnv('BBS')      <> '' THEN SRW.RgMainDir := AddSlash(GetEnv('BBS'))
   ELSE    SRW.RgMainDir := 'C:\RENEGADE\';

   SRW.RwMainDir         := 'C:\RENEWAVE\';
   SRW.RwMenuDir         := SRW.RwMainDir+'MENU\';
   SRW.RwWorkDir         := SRW.RwMainDir+'WORK\';
   SRW.RwTextDir         := SRW.RwMainDir+'TEXT\';
   SRW.RwHelpDir         := SRW.RwMainDir+'HELP\';
   SRW.RwLangDir         := SRW.RwMainDir+'LANGUAGE\';
   SRW.RwScanDir         := SRW.RwMainDir+'PRESCAN\';
   SRW.LogFile           := SRW.RwMainDir+'RENEWAVE.LOG';
   SRW.LocalULDir        := 'C:\BLUEWAVE\UPLOAD\';
   SRW.LocalDLDir        := 'C:\BLUEWAVE\DOWNLOAD\';

   SRW.FilesList         := SRW.RwMainDir+'NEWFILES.LST';
   SRW.TearLine          := 'Renegade v05-11 Exp';
   SRW.BragLine          := TRUE;
   SRW.BBSID             := 'RENEWAVE';
   SRW.AttachACS         := 's20';
   SRW.ForwardACS        := 's20';
   SRW.FileReqACS        := 's20';
   SRW.TimeoutMinutes    := 5;
   SRW.RwCommType        := 0;
   SRW.ForceEmail        := TRUE;
   SRW.ForceNetmail      := TRUE;
   SRW.ForceOvrACS       := 's200';
   SRW.HangUpOnTimeout   := TRUE;
   SRW.NukeLocalRep      := TRUE;
   SRW.SwapType          := Disk;
   SRW.FREQLimit         := 10;
   SRW.MaxPWTries        := 5;
   SRW.MaxTotalMsgs      := 5000;
   SRW.MaxTotalBytes     := 1000000;
   SRW.MaxBaseMsgs       := 2000;
   SRW.MaxBaseBytes      := 500000;
   SRW.MaxDupes          := 1000;
   SRW.AllowGoodbye      := TRUE;
   SRW.ImportPointers    := FALSE;
   SRW.ACS_Crash         := 's255';
   SRW.ACS_FAttach       := 's255';
   SRW.ACS_KillSent      := '^';
   SRW.ACS_Hold          := '^';
   SRW.ACS_Imm           := 's255';
   SRW.ACS_FREQ          := 's255';
   SRW.ACS_Direct        := 's255';
   SRW.ACS_UpdREQ        := 's255';
   SRW.ACS_AllEmail      := '%';
   SRW.ACS_NetStatus     := '%';
   SRW.BBSZone           := 1;
   SRW.BBSNet            := 259;
   SRW.BBSNode           := 412;
   SRW.BBSPoint          := 0;

   SRW.NTypeEmail        := NameAlias;
   SRW.NTypeNetmail      := NameReal;
   SRW.AnyNameEmail      := 's255';
   SRW.AnyNameNetmail    := 's255';
   SRW.CreditsPublic     := 0;
   SRW.CreditsEmail      := 0;
   SRW.DefaultNetAttr    := [Private,Local,KillSent];

   SRW.DefaultHotkeys    := TRUE;
   SRW.DefaultExpert     := FALSE;
   SRW.DefaultGraphics   := TRUE;
   SRW.DefaultNotMyMail  := TRUE;
   SRW.DefaultNumeric    := TRUE;
   SRW.DefaultFileList   := TRUE;
   SRW.DefaultQWK        := FALSE;
   SRW.DefaultNukeEmail  := TRUE;
   SRW.DefaultMsgsLimit  := 0;
   SRW.DefaultArc        := 'ZIP';
   SRW.DefaultProt       := 'Z';

   SRW.FileListType     := 1;
   SRW.FileListHdr      := '';
   SRW.FileListFtr      := '';
   SRW.FileListAreaT    := TRUE;
   SRW.FileListGrandT   := TRUE;
   SRW.FileListCredits  := FALSE;
   SRW.FileListOffline  := TRUE;
   SRW.FileListDates    := TRUE;
   SRW.FileListUploader := FALSE;
   SRW.FileListOptional := TRUE;
   SRW.FileListMaxDays  := 21;

   SRW.InetActive       := FALSE;
   SRW.InetAcs          := 's20';
   SRW.InetAreaNum      := 'INET';
   SRW.InetAreaTag      := 'INTERNET_EMAIL';
   SRW.InetAreaDesc     := 'Internet Email';
   SRW.InetToField      := 'UUCP';
   SRW.InetGateZone     := 1;
   SRW.InetGateNet      := 12;
   SRW.InetGateNode     := 98;
   SRW.InetGatePoint    := 0;
   SRW.InetMsgAttr      := [MsPrivate,MsLocal,MsKillSent];
   SRW.InetUseTo        := TRUE;

   SRW.RwProtocols[1].Active     := TRUE;
   SRW.RwProtocols[1].LogFile    := 'DSZ%N.LOG';
   SRW.RwProtocols[1].EnvCmd     := 'SET DSZLOG=DSZ%N.LOG';
   SRW.RwProtocols[1].Letter     := 'Z';
   SRW.RwProtocols[1].Batch      := TRUE;
   SRW.RwProtocols[1].ResultU[1] := 'Z';
   SRW.RwProtocols[1].ResultD[1] := 'z';
   SRW.RwProtocols[1].ResultT    := TRUE;
   SRW.RwProtocols[1].Desc       := 'Zmodem';
   SRW.RwProtocols[1].Recv       := 'DSZ portx %C,%E ha cts restrict rz -m %F';
   SRW.RwProtocols[1].Send       := 'DSZ portx %C,%E ha cts sz -m %F';
   SRW.RwProtocols[1].IntProt    := Int_Z;

   SRW.RwProtocols[2].Active     := TRUE;
   SRW.RwProtocols[2].LogFile    := 'DSZ%N.LOG';
   SRW.RwProtocols[2].EnvCmd     := 'SET DSZLOG=DSZ%N.LOG';
   SRW.RwProtocols[2].Letter     := 'Y';
   SRW.RwProtocols[2].Batch      := TRUE;
   SRW.RwProtocols[2].ResultU[1] := 'R';
   SRW.RwProtocols[2].ResultD[1] := 'S';
   SRW.RwProtocols[2].ResultT    := TRUE;
   SRW.RwProtocols[2].Desc       := 'Ymodem';
   SRW.RwProtocols[2].Recv       := 'DSZ portx %C,%E ha cts rb -k %F';
   SRW.RwProtocols[2].Send       := 'DSZ portx %C,%E ha cts sb -k %F';
   SRW.RwProtocols[2].IntProt    := Int_Y1K;

   SRW.RwProtocols[3].Active     := TRUE;
   SRW.RwProtocols[3].LogFile    := 'DSZ%N.LOG';
   SRW.RwProtocols[3].EnvCmd     := 'SET DSZLOG=DSZ%N.LOG';
   SRW.RwProtocols[3].Letter     := 'G';
   SRW.RwProtocols[3].Batch      := TRUE;
   SRW.RwProtocols[3].ResultU[1] := 'R';
   SRW.RwProtocols[3].ResultD[1] := 'S';
   SRW.RwProtocols[3].REsultT    := TRUE;
   SRW.RwProtocols[3].Desc       := 'Ymodem-G';
   SRW.RwProtocols[3].Recv       := 'DSZ portx %C,%E ha cts restrict rb -g %F';
   SRW.RwProtocols[3].Send       := 'DSZ portx %C,%E ha cts sb -g %F';
   SRW.RwProtocols[3].IntProt    := Int_YG;

   SRW.RwProtocols[4].Active     := TRUE;
   SRW.RwProtocols[4].Letter     := 'X';
   SRW.RwProtocols[4].Batch      := FALSE;
   SRW.RwProtocols[4].ErrLev     := 0;
   SRW.RwProtocols[4].ResultT    := TRUE;
   SRW.RwProtocols[4].Desc       := 'Xmodem';
   SRW.RwProtocols[4].Recv       := 'DSZ portx %C,%E ha cts rc %F';
   SRW.RwProtocols[4].Send       := 'DSZ portx %C,%E ha cts sx %F';
   SRW.RwProtocols[4].IntProt    := Int_X;

   SRW.RwProtocols[5].Active     := TRUE;
   SRW.RwProtocols[5].LogFile    := 'DSZ%N.LOG';
   SRW.RwProtocols[5].EnvCmd     := 'SET DSZLOG=DSZ%N.LOG';
   SRW.RwProtocols[5].Letter     := 'A';
   SRW.RwProtocols[5].Batch      := TRUE;
   SRW.RwProtocols[5].ResultU[1] := 'Z';
   SRW.RwProtocols[5].ResultD[1] := 'z';
   SRW.RwProtocols[5].Resultt    := TRUE;
   SRW.RwProtocols[5].Desc       := 'ZedZap (8k Zmodem)';
   SRW.RwProtocols[5].Recv       := 'MSZ /c:%P,%A,%B /F:ON /rZAP %F';
   SRW.RwProtocols[5].Send       := 'MSZ /c:%P,%A,%B /F:ON /sZAP %F';
   SRW.RwProtocols[5].IntProt    := Int_Zap;

   SRW.RwVer := 200;
END;


FUNCTION RunDoor(s:string;b:boolean):Byte;
VAR tb:byte;
    ww:word;
    FPath:PathStr; FName:NameStr; FExt:ExtStr; FDir:DirStr;
    Params,TempS:String;

    FUNCTION RandomFilename : String;
    VAR TempStr : String; StrPos : Byte;
    BEGIN
       Randomize;
       TempStr := '';
       FOR StrPos := 1 TO 8 DO TempStr[StrPos] := Chr(Random(25) + 65);
       TempStr[0] := Chr(8);
       TempStr := TempStr + '.RWI';
       RandomFilename := TempStr;
    END;

BEGIN
   Window(1,1,80,25);               { Expand window }
   ClrScr;
   TextAttr := 11+(1*16); Write(PadRight('Executing '+s,' ',80));
   tb := Pos(' ',s);
   IF tb > 0 THEN Params := Copy(s,tb+1,Length(s)-tb) ELSE Params := '';
   IF tb > 0 THEN FPath := Copy(s,1,tb-1) ELSE FPath := s;
   FSplit(FPath,FDir,FName,FExt);
   IF (FExt = '')
      THEN
         BEGIN
             FPath := FSearch(FName+'.EXE',FDir);
             IF FPath = '' THEN FPath := FSearch(FName+'.COM',FDir);
             IF FPath = '' THEN FPath := FSearch(FName+'.BAT',FDir);
         END;

   UseEmsIfAvailable := FALSE;
   InitExecSwap(HeapPtr,RandomFileName);

   TextAttr := 3; WriteLn('Swapping ',StrFunc(BytesSwapped), ' bytes out of memory...');
   TextAttr := 7;
   SwapVectors;
   IF b
      THEN ww := ExecWithSwap(GetEnv('COMSPEC'),'/C '+FPath+Params)
      ELSE ww := ExecWithSwap(FPath,Params);
   ShutDownExecSwap;
   SwapVectors;
   IF ww = 0 THEN ClrScr;
   RunDoor := ww;
END;


PROCEDURE DosShell; FAR;
VAR TScreen:^ScreenType;
BEGIN
   New(TScreen);
   ReadScreen(TScreen^);
   SetCursor(cmOn);
   RunDoor(GetEnv('COMSPEC'),FALSE);
   SetCursor(cmOff);
   WriteScreen(TScreen^);
   Dispose(TScreen);
END;


PROCEDURE Copyright;
BEGIN
   WritePipeXY(1,1,'|16|09|09|01|16');
   WritePipeXY(1,2,'|17|09|15 INSTALL - RENEWAVE v2.00 Installation Program                                |08|16');
   WritePipeXY(1,3,'|17|09|09 Copyright (C) 1994-2004 by Lars Hellsten and MatrixSoft, All Rights Reserved |08|16');
   WritePipeXY(1,4,'|17|09|07 Future Shock - The MatrixSoft Support BBS (416)LONGDEAD / 1:259/412          |08|16');
   WritePipeXY(1,5,'|16|01|08|08|16');
END;


PROCEDURE UnpackFile(FileSpec:String; Path:String; Overwrite:Boolean);
VAR AddFile:FILE; SearchInfo:SearchRec; i:LongInt; FName:String; FileNum:Byte; Verify:Char;
BEGIN
   TextAttr := 7;
   FOR FileNum := 1 TO PackIndexMax DO IF PackIndex[FileNum].FileName <> '' THEN
      IF MatchWildcards(FileSpec,PackIndex[FileNum].FileName) THEN
         BEGIN
            IF Path = '' THEN FName := '' ELSE FName := AddSlash(Path);
            FName := FName+PackIndex[FileNum].FileName;

            Verify := 'Y';
            IF FExists(FName) AND NOT Overwrite THEN
               BEGIN
                  Write(FName,' exists, overwrite? [Yes]: ');
                  REPEAT
                     Verify := Upcase(ReadKey);
                  UNTIL (Verify IN [#13,'Y','N']);
                  IF Verify = #13 THEN Verify := 'Y';
                  Write(#13);
                  ClrEol;
               END;

            IF Verify = 'Y'
               THEN BEGIN
                     Assign(AddFile,FName);
                     Rewrite(AddFile,1);
                     Write('Extracting: ',FName,' (0 bytes)      ');
                     Seek(f,PackIndex[FileNum].Offset);
                     i := 0;
                     WHILE i < PackIndex[FileNum].Size DO
                        BEGIN
                           IF (PackIndex[FileNum].Size-i) >= PackBuffMax
                              THEN PackBuffLen := PackBuffMax
                              ELSE PackBuffLen := PackIndex[FileNum].Size-i;
                           BlockRead(f,PackBuff^,PackBuffLen);
                           BlockWrite(AddFile,PackBuff^,PackBuffLen);
                           i := i+PackBuffLen;
                           Write(RepChar(#8,15),PadRight('('+NumberCommas(i)+' bytes)',' ',15));
                        END;
                     WriteLn(RepChar(#8,15),PadRight('('+StrFunc(PackIndex[FileNum].Size)+' bytes)',' ',15));
                     Close(AddFile);
                  END
               ELSE BEGIN
                     WriteLn('Extracting: Skipped ',FName);
                  END;
         END;
END;


PROCEDURE Handle_InstallMenu;
CONST Len      = 47;
VAR   ChoiceID : Integer;
      RwMenu   : PMenuType;
      s        : String;


   PROCEDURE Init_InstallMenu;
   CONST MenuItems = 8;
   TYPE  MenuDescT = Array[1..MenuItems] OF String[80];
   CONST MenuDesc  : MenuDescT =
         (' ReneWave directory          ',
          ' ReneWave menu directory     ',
          ' ReneWave work directory     ',
          ' ReneWave text directory     ',
          ' ReneWave help directory     ',
          ' ReneWave language directory ',
          '              The above paths are acceptable - install ReneWave               ',
          '                     Abort installation and quit to DOS                       ');
  BEGIN
      Menu_Init(RwMenu,1,6,80,23,3,25,MenuItems,FALSE,'ReneWave Installation');
      Menu_AddItem(RwMenu,1,-1,' ',FALSE,0,2,0,0,2,08,0,1,MenuDesc[1],'');
      Menu_AddItem(RwMenu,2,-1,' ',FALSE,1,3,0,0,2,09,0,1,MenuDesc[2],'');
      Menu_AddItem(RwMenu,3,-1,' ',FALSE,2,4,0,0,2,10,0,1,MenuDesc[3],'');
      Menu_AddItem(RwMenu,4,-1,' ',FALSE,3,5,0,0,2,11,0,1,MenuDesc[4],'');
      Menu_AddItem(RwMenu,5,-1,' ',FALSE,4,6,0,0,2,12,0,1,MenuDesc[5],'');
      Menu_AddItem(RwMenu,6,-1,' ',FALSE,5,7,0,0,2,13,0,1,MenuDesc[6],'');
      Menu_AddItem(RwMenu,7,-1,' ',FALSE,6,8,0,0,2,16,0,1,MenuDesc[7],'');
      Menu_AddItem(RwMenu,8,-1,' ',FALSE,7,0,0,0,2,17,0,1,MenuDesc[8],'');

      CreateSetupRW;
   END;

   PROCEDURE DrawChoice(MChoice:Integer; Str:String; Len:Byte);
   BEGIN
      GotoXY(32,RwMenu^.ItemData^[MChoice].YPos);
      TextAttr := 27;
      Write(PadRight(Str,' ',Len));
   END;

   PROCEDURE DrawInstall;
   BEGIN
      WritePipeXY(2,15,'|17|09');
      WritePipeXY(2,18,'|17|09');
      WritePipeXY(2,19,'|17|03 INSTALL will install ReneWave to the above directories.  The paths DOCS\ and');
      WritePipeXY(2,20,'|17|03 SAMPLES\ will be created for the documentation, and sample configuration');
      WritePipeXY(2,21,'|17|03 respectively.  Remember to run RWSETUP after this install program is done,');
      WritePipeXY(2,22,'|17|03 to customize ReneWave for use on your system.');
      DrawChoice(1,SRW.RwMainDir,Len);
      DrawChoice(2,SRW.RwMenuDir,Len);
      DrawChoice(3,SRW.RwWorkDir,Len);
      DrawChoice(4,SRW.RwTextDir,Len);
      DrawChoice(5,SRW.RwHelpDir,Len);
      DrawChoice(6,SRW.RwLangDir,Len);
   END;

   PROCEDURE CheckReplace(VAR s:String; Old,New:String);
   BEGIN
      IF Length(s) < Length(Old) THEN Exit;
      IF Copy(s,1,Length(Old))=Old THEN
         BEGIN
            Delete(s,1,Length(Old));
            Insert(New,s,1);
         END;
   END;

BEGIN
   ClrScr;
   Copyright;
   Init_InstallMenu;
   Menu_DrawMenu(RwMenu);
   Menu_ClearMenu(RwMenu);
   Menu_DrawItems(RwMenu);
   DrawInstall;
   REPEAT
      SetCursor(cmOff);
      Menu_GetChoice(RwMenu,ChoiceID);
      CASE ChoiceID OF
         1 : BEGIN
                s := SRW.RwMainDir;
                GetInput(SRW.RwMainDir,SRW.RwMainDir,FilePath,63,32,08,Len,TRUE);
                SRW.RwMainDir := AddSlash(FExpand(SRW.RwMainDir));

                CheckReplace(SRW.RwMenuDir,s,SRW.RwMainDir);
                CheckReplace(SRW.RwWorkDir,s,SRW.RwMainDir);
                CheckReplace(SRW.RwTextDir,s,SRW.RwMainDir);
                CheckReplace(SRW.RwHelpDir,s,SRW.RwMainDir);
                CheckReplace(SRW.RwLangDir,s,SRW.RwMainDir);
                DrawChoice(1,SRW.RwMainDir,Len);
                DrawChoice(2,SRW.RwMenuDir,Len);
                DrawChoice(3,SRW.RwWorkDir,Len);
                DrawChoice(4,SRW.RwTextDir,Len);
                DrawChoice(5,SRW.RwHelpDir,Len);
                DrawChoice(6,SRW.RwLangDir,Len);
             END;
         2 : BEGIN
                GetInput(SRW.RwMenuDir,SRW.RwMenuDir,FilePath,63,32,09,Len,TRUE);
                SRW.RwMenuDir := AddSlash(FExpand(SRW.RwMenuDir));
                DrawChoice(2,SRW.RwMenuDir,Len);
             END;
         3 : BEGIN
                GetInput(SRW.RwWorkDir,SRW.RwWorkDir,FilePath,63,32,10,Len,TRUE);
                SRW.RwWorkDir := AddSlash(FExpand(SRW.RwWorkDir));
                DrawChoice(3,SRW.RwWorkDir,Len);
             END;
         4 : BEGIN
                GetInput(SRW.RwTextDir,SRW.RwTextDir,FilePath,63,32,11,Len,TRUE);
                SRW.RwTextDir := AddSlash(FExpand(SRW.RwTextDir));
                DrawChoice(4,SRW.RwTextDir,Len);
             END;
         5 : BEGIN
                GetInput(SRW.RwHelpDir,SRW.RwHelpDir,FilePath,63,32,12,Len,TRUE);
                SRW.RwHelpDir := AddSlash(FExpand(SRW.RwHelpDir));
                DrawChoice(5,SRW.RwHelpDir,Len);
             END;
         6 : BEGIN
                GetInput(SRW.RwLangDir,SRW.RwLangDir,FilePath,63,32,13,Len,TRUE);
                SRW.RwLangDir := AddSlash(FExpand(SRW.RwLangDir));
                DrawChoice(6,SRW.RwLangDir,Len);
             END;
      END;
   UNTIL (ChoiceID >= 7) OR (ChoiceID = -1);
   Menu_DeInit(RwMenu);
   IF (ChoiceID = 7) THEN
      BEGIN
         TextAttr := 7;
         ClrScr;
         Copyright;
         WriteLn(' '+#8);

         DirMake(SRW.RwMainDir);
         DirMake(SRW.RwMenuDir);
         DirMake(SRW.RwWorkDir);
         DirMake(SRW.RwTextDir);
         DirMake(SRW.RwHelpDir);
         DirMake(SRW.RwLangDir);
         DirMake(SRW.RwMainDir+'SAMPLES\');
         DirMake(SRW.RwMainDir+'DOCS\');

         UnpackFile('*.EXE',SRW.RwMainDir,FALSE);
         UnpackFile('*.OVR',SRW.RwMainDir,FALSE);
         UnPackFile('*.RES',SRW.RwMainDir,FALSE);
         UnpackFile('RWHELP.*',SRW.RwMainDir,FALSE);
         UnpackFile('*.HLP',SRW.RwHelpDir,FALSE);
         UnpackFile('*.ASC',SRW.RwTextDir,FALSE);
         UnPackFile('*.MNU',SRW.RwMenuDir,FALSE);
         UnPackFile('*.TPL',SRW.RwTextDir,FALSE);
         UnPackFile('ENGLISH.*',SRW.RwLangDir,FALSE);
         UnpackFile('ENGLISH.RW',SRW.RwMainDir+'SAMPLES\',FALSE);
         UnpackFile('ENGLISH.RWC',SRW.RwMainDir+'SAMPLES\',FALSE);
         UnpackFile('RW_SERV.TXT',SRW.RwMainDir+'SAMPLES\',FALSE);
         UnpackFile('RW_*.ZIP',SRW.RwMainDir+'SAMPLES\',FALSE);
         UnPackFile('*.BAT',SRW.RwMainDir+'SAMPLES\',FALSE);
         UnPackFile('*.DOC',SRW.RwMainDir+'DOCS\',FALSE);
         UnpackFile('WHATSNEW.*',SRW.RwMainDir+'DOCS\',FALSE);
         UnpackFile('BETASITE.*',SRW.RwMainDir+'DOCS\',FALSE);
         UnPackFile('RWBETA.*',SRW.RwMainDir+'DOCS\',FALSE);
         UnPackFile('REGISTER.*',SRW.RwMainDir+'DOCS\',FALSE);
         UnPackFile('UPGRADE.*',SRW.RwMainDir+'DOCS\',FALSE);

         IF NOT FExists(SRW.RwMainDir+'SETUP.RW') THEN
            BEGIN
               Assign(SetupRW,SRW.RwMainDir+'SETUP.RW');
               Rewrite(SetupRW);
               Write(SetupRW,SRW);
               Close(SetupRW);
            END;

         WritePipe(#13#10+'*DONE*');
         ChDir(StripSlash(SRW.RwMainDir));
      END;
END;


PROCEDURE UpgradeSetup(RwPath:String);
BEGIN
   Assign(SetupRW,AddSlash(RwPath)+'SETUP.RW');
   Reset(SetupRW);
   Seek(SetupRW,0);
   Read(SetupRW,SRW);

   IF SRW.RwVer < 200 THEN SRW.RwCommType := 0;
   SRW.RwVer := 200;

   Seek(SetupRW,0);
   Write(SetupRW,SRW);
   Close(SetupRW);
END;


PROCEDURE InstallUpgrade;
VAR RwPath:String; f:File; StartOfs:LongInt;
BEGIN
   ClrScr;
   Copyright;
   WritePipeXY(1,07,'|07 INSTALL now requires the full path to the directory your current ReneWave');
   WritePipeXY(1,08,'|07 setup resides in.  This should be the path where RENEWAVE.EXE, RENEWAVE.OVR');
   WritePipeXY(1,09,'|07 and SETUP.RW are located.  INSTALL requires these three files.');
   WritePipeXY(1,11,'|07 ReneWave path: |15');
   RwPath := 'C:\RENEWAVE\';
   GetInput(RwPath,RwPath,FilePath,62,17,11,62,TRUE);
   IF RwPAth <> '' THEN RwPath := AddSlash(RwPath) ELSE RwPath := AddSlash(GetCurrentDir);

   IF FExists(RwPath+'SETUP.RW')
      THEN BEGIN
            TextAttr := 7;
            WriteLn(' ');
            ClrScr;
            Copyright;

            DirMake(RwPath+'SAMPLES\');
            DirMake(RwPath+'DOCS\');

            UnpackFile('*.EXE',RwPath,TRUE);
            UnpackFile('*.OVR',RwPath,TRUE);
            UnpackFile('*.RES',RwPath,TRUE);
            UnpackFile('RWHELP.*',RwPath,TRUE);
            UnpackFile('ENGLISH.*',RwPath+'SAMPLES\',TRUE);
            UnpackFile('RW_SERV.TXT',RwPAth+'SAMPLES\',TRUE);
            UnpackFile('RW_*.ZIP',RwPath+'SAMPLES\',TRUE);
            UnPackFile('*.BAT',RwPath+'SAMPLES\',TRUE);
            UnPackFile('*.DOC',RwPath+'DOCS\',TRUE);
            UnpackFile('WHATSNEW.*',RwPath+'DOCS\',TRUE);
            UnpackFile('BETASITE.*',RwPath+'DOCS\',TRUE);
            UnPackFile('RWBETA.*',RwPath+'DOCS\',TRUE);
            UnPackFile('REGISTER.*',RwPath+'DOCS\',TRUE);
            UnPackFile('UPGRADE.*',RwPath+'DOCS\',TRUE);

            UpgradeSetup(RwPath);
         END
      ELSE BEGIN
            TextAttr := 7;
            ClrScr;
            Copyright;
            WritePipeXY(1,7,'|12Error: couldn''t find SETUP.RW in specified path|07'+#13#10#13#10);
            Halt;
         END;
END;


PROCEDURE InstallRw;
VAR ch:Char; Pos:Byte;
BEGIN
   ClrScr;
   Copyright;

   WritePipeXY(1,07,'|07 This program will automatically install ReneWave for you.  If you are');
   WritePipeXY(1,08,'|07 currently using ReneWave v1.xx, you MUST select "Install a new copy of');
   WritePipeXY(1,09,'|07 ReneWave".  You CAN NOT UPGRADE from v1.xx to v2.xx due to the extensive');
   WritePipeXY(1,10,'|07 changes!  Please make sure you have read any upgrade or installation notes');
   WritePipeXY(1,11,'|07 included in the distribution archive before you proceed.');

   WritePipeXY(1,14,'|17|09|09|17|08');
   WritePipeXY(1,15,'|17|09|09                                                                              |16|08');
   WritePipeXY(1,16,'|17|09|09                                                                              |16|08');
   WritePipeXY(1,17,'|17|09|08|16|08');

   SetCursor(cmOff);
   Pos := 1;
   REPEAT
      IF Pos = 1
{         THEN WritePipeXY(3,15,'|25|15                               Quit to DOS                                  |16')
         ELSE WritePipeXY(3,15,'|17|07                               Quit to DOS                                  |16');}
         THEN WritePipeXY(3,15,'|25|15                      Install a new copy of ReneWave                        |16')
         ELSE WritePipeXY(3,15,'|17|07                      Install a new copy of ReneWave                        |16');
      IF Pos = 2
         THEN WritePipeXY(3,16,'|25|15                   Upgrade an existing copy of ReneWave                     |16')
         ELSE WritePipeXY(3,16,'|17|07                   Upgrade an existing copy of ReneWave                     |16');

      ch := Upcase(ReadKey);
      IF ch = #0 THEN
         BEGIN
            ch := ReadKey;
            CASE ch OF
              #72 : IF Pos > 1 THEN Dec(Pos);
              #80 : IF Pos < 2 THEN Inc(Pos);
            END;
         END;
   UNTIL (ch = #13) OR (ch = #27);
   SetCursor(cmOn);
   IF (ch = #13) THEN
      CASE Pos OF
         2 : InstallUpgrade;
         1 : Handle_InstallMenu;
      END;
END;


PROCEDURE RwInit;
VAR PackPath:String;
BEGIN
   New(PackBuff);
   New(LogicalScreen);
   HighIntensity(TRUE);

   SetCBreak(FALSE);
   BreakOff;

   IF MyShare.ShareInstalled THEN FileMode := 66;

   PackPath := FSearch('INSTALL.RW',GetEnv('PATH')+';'+GetEnv('RENEWAVE')+';'+ExtractFDir(ParamStr(0)));
   IF NOT FExists(PackPath) THEN
      BEGIN
         WriteLn;
         WriteLn('+ ERROR: Unable to initialize INSTALL.RW data file!');
         Halt(255);
      END;

   Assign(f,PackPath);
   ReseT(f,1);
   BlockRead(f,PackIndex,SizeOf(PackIndex));
   GetVideoAddress;
   InstallRw;
END;


PROCEDURE RwDone;
BEGIN
   Dispose(PackBuff);
   Dispose(LogicalScreen);
   HighIntensity(FALSE);
   TextAttr := 7;
   ClrScr;
   Copyright;
   WriteLn;
   Close(f);
   SetCursor(cmUnderline);
   SetCursor(cmOn);
END;


BEGIN
   RwInit;
   RwDone;
END.
