UNIT GetInp;

(* 

    RENEWAVE is Copyright (C) 1994-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of RENEWAVE.

    RENEWAVE is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RENEWAVE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RENEWAVE; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)


INTERFACE


PROCEDURE GetInput(VAR InStr;                  { String Passed }
                       WhatWas:String;         { What to Replace if Esc Hit }
                       ValidInput:String;      { Valid Input }
                       Len:Byte;               { Length allowed to type }
                       UpC:Boolean;            { Return uppercase? }
                       BackGroundColor,        { Back Ground Color }
                       ForeGroundColor:Byte;   { Fore Ground Color }
                       BackGroundChar:Char);   { Back Ground Character }


IMPLEMENTATION


USES Cursor, CRT;


PROCEDURE GetInput(VAR InStr;                  { String Passed }
                       WhatWas:String;         { What to Replace if Esc Hit }
                       ValidInput:String;      { Valid Input }
                       Len:Byte;               { Length allowed to type }
                       UpC:Boolean;            { Return uppercase? }
                       BackGroundColor,        { Back Ground Color }
                       ForeGroundColor:Byte;   { Fore Ground Color }
                       BackGroundChar:Char);   { Back Ground Character }
CONST BkSp = #8;
VAR
   c:Char;   {Character Which Will be checked}
   i,
   ThisPos,EOSPos:byte;
   KBFlags:byte ABSOLUTE $0040:$0017;
   NoAdd,FirstKey:boolean;
   NewString:String Absolute InStr;  { String which is being edited }


   PROCEDURE RewriteString(SubtNum:ShortInt);
   VAR TempI:byte;
   BEGIN
      IF ThisPos > 1 THEN
         FOR TempI := (ThisPos-SubtNum) DOWNTO 1 DO
            Write(#8);
      FOR TempI := 1 TO Len DO Write(BackGroundChar);
      FOR TempI := 1 TO Len DO Write(#8);
      Write(NewString);
      IF ThisPos <= Length(NewString) THEN
         FOR TempI := Length(NewString) DOWNTO ThisPos DO Write(#8)
   END;

   FUNCTION FirstKeyOff:Boolean;
   BEGIN
      FirstKeyOff := FALSE;
   END;

   PROCEDURE ToggleIns;
   BEGIN
      IF (KBFlags AND $80 = 0)
         THEN SetCursor(cmBlock)
         ELSE SetCursor(cmUnderline);
   END;

   PROCEDURE MoveLeft;
   BEGIN
      IF FirstKey THEN FirstKey := FirstKeyOff;
      IF (ThisPos = 1) THEN Exit;
      Dec(ThisPos);
      Write(#8);
   END;

   PROCEDURE MoveRight;
   BEGIN
      IF FirstKey THEN FirstKey := FirstKeyOff;
      IF (ThisPos = Len+1) OR (ThisPos = Length(NewString)+1) THEN Exit;
      Write(NewString[ThisPos]);
      Inc(ThisPos);
   END;

   PROCEDURE GotoHome;
   VAR b:byte;
   BEGIN
      IF FirstKey THEN FirstKey := FirstKeyOff;
      IF ThisPos = 1 THEN Exit;
      FOR b := 1 TO (ThisPos-1) DO Write(#8);
      ThisPos := 1;
   END;

   PROCEDURE GotoEnd;
   VAR b:byte;
   BEGIN
      IF FirstKey THEN FirstKey := FirstKeyOff;
      IF (ThisPos = Len+1) OR (ThisPos = Length(NewString)+1) THEN Exit;
      FOR b := ThisPos TO Length(NewString) DO
         Write(NewString[b]);
      ThisPos := Length(NewString)+1;
   END;

   PROCEDURE DelCh;
   BEGIN
      IF FirstKey THEN FirstKey := FirstKeyOff;
      IF (ThisPos = Len+1) OR (ThisPos = Length(NewString)+1) THEN Exit;
      Delete(NewString,ThisPos,1);
      Dec(EOSPos);
      RewriteString(1);
   END;

   PROCEDURE DelLine;
   VAR b:byte;
   BEGIN
      IF FirstKey THEN FirstKey := FirstKeyOff;
      FOR b := 1 TO Length(NewString) DO
         Write(BkSp+BackGroundChar+BkSp);
      ThisPos := 1;
      EOSPos := 0;
      NewString := '';
   END;


BEGIN
   SetCursor(cmOn);
   TextBackGround(BackGroundColor);
   TextColor(ForeGroundColor);
   FOR i := 1 TO Len DO Write(BackGroundChar);
   FOR i := 1 TO Len DO Write(#8);
   NewString := WhatWas;
   ThisPos := Length(NewString)+1;
   EOSPos := Length(NewString);
   FirstKey := Length(NewString) > 0;
   Write(WhatWas);
   KBFlags := KBFlags OR $80;
   IF (KBFlags AND $80 = 0)
      THEN SetCursor(cmBlock)
      ELSE SetCursor(cmUnderline);
   c := #0;
   WHILE ((c <> #13) AND (c <> #27)) DO { While C does not = CR or ESC }
      BEGIN
          NoAdd := FALSE;
          c := ReadKey;
          IF UpC THEN c := UpCase(c);
          CASE c OF
             #8 : IF (ThisPos > 1) THEN
                      BEGIN
                          IF FirstKey THEN FirstKey := FirstKeyOff;
                          Dec(ThisPos);
                          Dec(EOSPos);
                          Delete(NewString,ThisPos,1);
                          Write(#8);
                          RewriteString(1);
                          NoAdd := TRUE;
                      END;
             #27 : BEGIN
                      NoAdd := TRUE;
                      NewString := WhatWas;
                    END;
             #13 : NoAdd := TRUE;
             #25, #24 : DelLine;
             #0  : BEGIN
                      c := ReadKey;
                      WHILE KeyPressed DO c := ReadKey;
                      NoAdd := TRUE;
                      CASE c OF
                         #75 : MoveLeft;
                         #77 : MoveRight;
                         #83 : DelCh;
                         #82 : ToggleIns;
                         #71 : GotoHome;
                         #79 : GotoEnd;
                      END;
                   END;
          END;
          IF ((EOSPos < Len) OR FirstKey) AND (NoAdd = FALSE) AND
             (Pos(c,ValidInput) > 0)
             THEN
                BEGIN
                   IF NOT FirstKey
                      THEN
                         BEGIN
                            IF (KBFlags AND $80 > 0) THEN
                               BEGIN
                                  Insert(c,NewString,ThisPos);
                                  Inc(EOSPos);
                                  Inc(ThisPos);
                                  IF ThisPos <= EOSPos
                                     THEN RewriteString(2)
                                     ELSE Write(c);
                               END
                               ELSE BEGIN
                                  NewString[ThisPos] := c;
                                  Inc(ThisPos);
                                  Write(c);
                               END;
                         END
                      ELSE
                         BEGIN
                             FOR i := 1 TO Length(NewString) DO
                               Write(BkSp+BackGroundChar+BkSp);
                            IF FirstKey THEN FirstKey := FirstKeyOff;
                            ThisPos := 2;
                            EOSPos := 1;
                            NewString := c;
                            Write(c);
                         END;
                END;
      END;
   TextBackGround(0);
   SetCursor(cmOff);
END;


END.
