UNIT UnixDate;

(* 

    MSCOMMON is Copyright (C) 1994-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of the MSCOMMON library.

    MSCOMMON is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    MSCOMMON is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with MSCOMMON; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)

INTERFACE


CONST DaysPerMonth     : Array[1..12] OF Byte = (31,28,31,30,31,30,31,31,30,31,30,31);
      SecsPerYear      : LongInt  = 31536000;
      SecsPerLeapYear  : LongInt  = 31622400;
      SecsPerDay       : LongInt  = 86400;
      SecsPerHour      : Integer  = 3600;
      SecsPerMinute    : ShortInt = 60;
      WeekStr          : Array[0..7] OF String[10] =
                         ('Sunday','Monday','Tuesday','Wednesday','Thursday','Friday','Saturday','All Week');
      Months           : Array[1..12] OF String[3] =
                         ('Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec');

{ Miscellaneous }
FUNCTION LeapYear(Year:Word):Boolean;
FUNCTION Str2Month(s:String):Byte;

{ UNIX timestamp functions }
FUNCTION  DaysSince1970(Year,Month,Day:Word):LongInt;
FUNCTION  CurrentSecsFunc:LongInt;
PROCEDURE CurrentSecs(VAR Secs:LongInt; VAR DayOfWeek:Byte);
FUNCTION  Date2Unix(Year,Month,Day,Hour,Min,Sec:Word):LongInt;
PROCEDURE Unix2Date(TimeStamp:LongInt; VAR Y,M,D,H,Min,S:Word);
FUNCTION  Unix2DateStr(Format:Byte; TimeStamp:LongInt):String;
FUNCTION  Unix2Dos(Date:LongInt):LongInt;
FUNCTION  StrDate2Unix(Format:Byte; s:String):LongInt;

{ Renegade date functions }
FUNCTION  Date2RGF(Month,Day,Year:Word):Word;
FUNCTION  RGF2Unix(RgDate:Word):LongInt;
FUNCTION  CurrentRGF:Word;

{ DOS date functions }
FUNCTION DosCurrentTime:LongInt;
FUNCTION DosDate2Unix(d:LongInt):LongInt;
FUNCTION DosDateFormat(d:longint; format:byte):String;
FUNCTION Date2Dos(Year,Month,Day,Hour,Min,Sec:Word):LongInt;

{ Julian date functions }

FUNCTION  JulianCurrent:Word;
FUNCTION  Date2Julian(Day,Month,Year:Word):Word;
PROCEDURE Julian2Date(Date:Word; VAR Year,Month,Day:Word);
FUNCTION  Julian2Unix(Date:Word):LongInt;
FUNCTION  Julian2Dos(Date:Word):LongInt;


IMPLEMENTATION

USES DOS, MSTRINGS;


FUNCTION LeapYear(Year:Word):Boolean; ASSEMBLER;
ASM
   mov AX,Year
   mov DX,0
   mov BX,100
   div BX
   cmp DX,0
   je  @@CENTURY

   mov AX,Year
   mov DX,0
   mov BX,4
   div BX
   cmp DX,0
   jne @@FALSE
   mov AL,1
   jmp @@DONE

   @@CENTURY:

   mov AX,Year
   mov DX,0
   mov BX,400
   div BX
   cmp DX,0
   jne @@FALSE
   mov AL,1
   jmp @@DONE

   @@FALSE:

   mov AL,0

   @@DONE:
END;


FUNCTION Str2Month(s:String):Byte;
VAR TempRes,i:Byte;
BEGIN
   s := UpcaseStr(s);
   TempRes := 0;
   FOR i := 1 TO 12 DO
      IF (TempRes = 0) AND (s = UpcaseStr(Months[i]))
         THEN TempRes := i;
   Str2Month := TempRes;
END;


FUNCTION DaysSince1970(Year,Month,Day:Word):LongInt;
VAR Counter,CurrYear:Integer; TempDays:LongInt;
BEGIN
   TempDays := 0; CurrYear := 0; TempDays := 0;
   FOR CurrYear := 1970 TO (Year-1) DO IF LeapYear(CurrYear)
      THEN Inc(TempDays,366)
      ELSE Inc(TempDays,365);
   IF (LeapYear(Year)) AND (Month > 2) THEN Inc(TempDays);
   CASE month OF
       2 : TempDays := TempDays + 31;
       3 : TempDays := TempDays + 59;
       4 : TempDays := TempDays + 90;
       5 : TempDays := TempDays + 120;
       6 : TempDays := TempDays + 151;
       7 : TempDays := TempDays + 181;
       8 : TempDays := TempDays + 212;
       9 : TempDays := TempDays + 243;
      10 : TempDays := TempDays + 273;
      11 : TempDays := TempDays + 304;
      12 : TempDays := TempDays + 334;
   END;
   TempDays := TempDays + Day - 1;
   DaysSince1970 := TempDays;
END;


FUNCTION Date2Unix(Year,Month,Day,Hour,Min,Sec:Word):LongInt;
VAR TempRes:LongInt;
BEGIN
   TempRes := DaysSince1970(Year,Month,Day);
   TempRes := (((TempRes * 24 + Hour) * 60 + Min) * 60 + Sec);
   Date2Unix := TempRes;
END;


FUNCTION CurrentSecsFunc:LongInt;
{$IFDEF VIRTUALPASCAL}
VAR Year,Month,Day,DOW,Hour,Minute,Second,Sec100:LongInt;
{$ELSE}
VAR Year,Month,Day,DOW,Hour,Minute,Second,Sec100:Word;
{$ENDIF}
BEGIN
   GetDate(Year,Month,Day,DOW);
   GetTime(Hour,Minute,Second,Sec100);
   CurrentSecsFunc := Date2Unix(Year,Month,Day,Hour,Minute,Second);
END;


PROCEDURE CurrentSecs(VAR Secs : LongInt; VAR DayOfWeek : Byte);
{$IFDEF VIRTUALPASCAL}
VAR Year,Month,Day,DOW,Hour,Minute,Second,Sec100:LongInt;
{$ELSE}
VAR Year,Month,Day,DOW,Hour,Minute,Second,Sec100:Word;
{$ENDIF}
BEGIN
   GetDate(Year,Month,Day,DOW);
   GetTime(Hour,Minute,Second,Sec100);
   DayOfWeek := Byte(DOW);
   Secs := Date2Unix(Year,Month,Day,Hour,Minute,Second);
END;


PROCEDURE Unix2Date(TimeStamp:LongInt; VAR y,m,d,h,min,s:Word);
{$IFDEF OS2}
VAR t:LongInt; Done:Boolean; X,TotDays:LongInt;
{$ELSE}
VAR t:LongInt; Done:Boolean; X:ShortInt; TotDays:Integer;
{$ENDIF}
BEGIN
   y:=1970; m:=1; d:=1; h:=0; Min:=0; S:=0; t:=TimeStamp;

   IF (t > 0) THEN
      BEGIN
         s    := t MOD 60; t := t DIV 60;
         min  := t MOD 60; t := t DIV 60;
         h    := t MOD 24; t := t DIV 24;

         WHILE ((t >= 365) AND NOT LeapYear(y)) OR ((t >= 366) AND LeapYear(y)) DO
            BEGIN
               IF LeapYear(y) THEN Dec(t,366) ELSE Dec(t,365);
               Inc(y,1);
            END;

         IF LeapYear(y) THEN DaysPerMonth[2] := 29 ELSE DaysPerMonth[2] := 28;
         WHILE (t >= DaysPerMonth[m]) DO
            BEGIN
               Dec(t,DaysPerMonth[m]);
               Inc(m,1);
            END;
         d := t+1;
      END;
END;


FUNCTION StrDate2Unix(Format:Byte; s:String):LongInt;
{ Formats: 0 = 01 Jan 95  24:00:00 }
{          1 = mm/dd/yy            }
{          2 = dd/mm/yy            }
{          3 = yy/mm/dd            }
{$IFDEF OS2}
VAR Year,month,day,hour,min,sec:LongInt;
{$ELSE}
VAR Year,month,day,hour,min,sec:Word;
{$ENDIF}
BEGIN
   Year := 0; Month := 0; Day := 0; Hour := 0; Min := 0; Sec := 0;
   CASE Format OF
      0 : BEGIN
             Day   := ValFunc(Copy(s,1,2));      { 01 }
             Month := Str2Month(Copy(s,4,3));    { JAN }
             Year  := 1900+ValFunc(Copy(s,8,2)); { 95 }
             Hour  := ValFunc(Copy(s,12,2));     { 24 }
             Min   := ValFunc(Copy(s,15,2));     { 00 }
             Sec   := ValFunc(Copy(s,18,2));     { 00 }
          END;
      1 : BEGIN
             Month := ValFunc(Copy(s,1,2));
             Day := ValFunc(Copy(s,4,2));
             Year := 1900+ValFunc(Copy(s,7,2));
          END;
   END;
   StrDate2Unix := Date2Unix(Year,Month,Day,Hour,Min,Sec);
END;


FUNCTION Unix2DateStr(Format:Byte;TimeStamp:LongInt):String;
{ Formats: 0 = 01 Jan 95  05:30:28'   }
{          1 = mm/dd/yy               }
{          2 = dd/mm/yy               }
{          3 = yy/mm/dd               }
{          4 = mm-dd-yy               }
{          5 = hh:mm                  }
{          6 = mmddyyhhmm (PCB)       }

CONST MonthNames : Array[1..12] OF String[3] = ('Jan','Feb','Mar',
                                                'Apr','May','Jun',
                                                'Jul','Aug','Sep',
                                                'Oct','Nov','Dec');
VAR yy,mm,dd,hh,min,sec:Word;
BEGIN
   Unix2Date(TimeStamp,yy,mm,dd,hh,min,sec);
   CASE Format OF
      0 : Unix2DateStr := LeadingZero(dd,2)+' '+MonthNames[mm]+' '+LeadingZero(yy MOD 100,2)+'  '+
                          LeadingZero(hh,2)+':'+LeadingZero(min,2)+':'+LeadingZero(sec,2);
      1 : Unix2DateStr := LeadingZero(mm,2)+'/'+LeadingZero(dd,2)+'/'+LeadingZero(yy MOD 100,2);
      2 : Unix2DateStr := LeadingZero(dd,2)+'/'+LeadingZero(mm,2)+'/'+LeadingZero(yy MOD 100,2);
      3 : Unix2DateStr := LeadingZero(yy MOD 100,2)+'/'+LeadingZero(mm,2)+'/'+LeadingZero(dd,2);
      4 : Unix2DateStr := LeadingZero(mm,2)+'-'+LeadingZero(dd,2)+'-'+LeadingZero(yy MOD 100,2);
      5 : Unix2DateStr := LeadingZero(hh,2)+':'+LeadingZero(min,2);
      6 : Unix2DateStr := LeadingZero(mm,2)+LeadingZero(dd,2)+LeadingZero(yy MOD 100,2)+LeadingZero(hh,2)+LeadingZero(min,2);
   END;
END;


FUNCTION Unix2Dos(Date:LongInt):LongInt;
VAR dt:DateTime; i:LongInt;
BEGIN
   Unix2Date(Date,Word(dt.Year),Word(dt.Month),Word(dt.Day),Word(dt.Hour),Word(dt.Min),Word(dt.Sec));
   PackTime(dt,i);
   Unix2Dos := i;
END;


FUNCTION  Date2RGF(Month,Day,Year:Word):Word;
VAR AccumDays,Temp:LongInt;
BEGIN
   AccumDays := 0;
   FOR Temp := 1985 TO (Year-1) DO
     IF LeapYear(Temp)
        THEN AccumDays := AccumDays + 366
        ELSE AccumDays := AccumDays + 365;
   CASE Month OF
      2 : AccumDays := AccumDays + 31;
      3 : AccumDays := AccumDays + 59;
      4 : AccumDays := AccumDays + 90;
      5 : AccumDays := AccumDays + 120;
      6 : AccumDays := AccumDays + 151;
      7 : AccumDays := AccumDays + 181;
      8 : AccumDays := AccumDays + 212;
      9 : AccumDays := AccumDays + 243;
      10 : AccumDays := AccumDays + 273;
      11 : AccumDays := AccumDays + 304;
      12 : AccumDays := AccumDays + 334;
   END;
   AccumDays := AccumDays + Day - 1;
   IF (Month > 2) AND LeapYear(Year)
      THEN Inc(AccumDays);
   Date2RGF := AccumDays;
END;


FUNCTION  RGF2Unix(RgDate:Word):LongInt;
BEGIN
   RGF2Unix := (LongInt(RgDate)*24*60*60)+473385600;
END;


FUNCTION  CurrentRGF:Word;
VAR
{$IFDEF OS2}
   {$IFDEF SPEED}
   yy,mm,dd,temp,accumdays:Word;
   {$ELSE}
   yy,mm,dd,temp,accumdays:LongInt;
   {$ENDIF}
{$ELSE}
yy,mm,dd,temp,accumdays:Word;
{$ENDIF}
BEGIN
   GetDate(yy,mm,dd,temp);
   CurrentRGF := Date2RGF(mm,dd,yy);
END;


FUNCTION  DosCurrentTime:LongInt;
VAR dt   : DateTime;
    Res  : LongInt;
{$IFDEF VIRTUALPASCAL}
    Junk : LongInt;
{$ELSE}
    {$IFDEF SPEED}
    Junk : Byte;
    {$ELSE}
    Junk : Word;
    {$ENDIF}
{$ENDIF}
BEGIN
   WITH dt DO
      BEGIN
         {$IFDEF SPEED}
         GetDate2(Year,Month,Day,Junk);
         GetTime2(Hour,Min,Sec,Junk);
         {$ELSE}
         GetDate(Year,Month,Day,Junk);
         GetTime(Hour,Min,Sec,Junk);
         {$ENDIF}
      END;
   PackTime(dt,Res);
   DosCurrentTime := Res;
END;


(*

Format number

1 - Xpress method of display last usage date           Mmm DD,YYYY HH:MM:SSap
2 - opus display method for date written in messages   Mmm-DD-YY H:MMap
3 - Xpress Sysop menu display of last usage.           MM/DD/YY HH:MMap
4 - used for opus log                                  DD Mmm HH:MM:SS
5 - used for last usage date in user.bbs (opus)        DD Mmm YY HH:MM:SS
6 -                                                    Mmm DD, YY
7 - used for new files lister in OPUS 1.70             MM/DD/YY
8 - QWK date                                           MM-DD-YY
9 - QWK time                                           HH:MM

*)


FUNCTION Format_Date(dt:DateTime; Format:Byte):String;
VAR ms,ds,hs,m1s,ss,mhs,ampm:string[2]; ys:string[4];
BEGIN
   AmPm := 'am';
   WITH dt DO
      BEGIN
         ms  := LeadingZero(Month,2);
         ds  := LeadingZero(Day,2);
         ys  := LeadingZero(Year,4);
         mhs := LeadingZero(Hour,2);

         IF hour >= 12 THEN
            BEGIN
               AmPm := 'pm';
               IF hour > 12 THEN hour := Hour - 12;
            END;

         hs  := LeadingZero(Hour,2);
         m1s := LeadingZero(Min,2);
         ss  := LeadingZero(Sec,2);

         IF (Format < 1) OR (Format > 9) THEN Format := 1;

         CASE Format OF
            1 : Format_Date := Months[month]+' '+ds+','+ys+'  '+hs+':'+m1s+':'+ss+ampm;
            2 : Format_Date := Months[month]+'-'+ds+'-'+ys+' '+hs+':'+m1s+ampm;
            3 : Format_date := ms+'/'+ds+'/'+copy(ys,3,2)+' '+hs+':'+m1s+ampm;
            4 : Format_Date := ds+ ' '+Months[month]+' '+mhs+':'+m1s+':'+ss;
            5 : Format_Date := ds+ ' '+Months[month]+' '+ys+' '+mhs+':'+m1s+':'+ss;
            6 : Format_Date := Months[month]+' '+ds+','+ys;
            7 : Format_Date := ms+'/'+ds+'/'+copy(ys,3,2);
            8 : Format_Date := ms+'-'+ds+'-'+Copy(ys,3,2);
            9 : Format_Date := hs+':'+m1s;
         END;
    end;
 end;


FUNCTION DosDateFormat(d:longint;format:byte):String;
VAR dt:DateTime;
BEGIN
   UnpackTime(d,dt);
   DosDateFormat := Format_date(dt,format);
END;


FUNCTION DosDate2Unix(d:LongInt):LongInt;
VAR dt:DateTime;
BEGIN
   UnpackTime(d,dt);
   DosDate2Unix := Date2Unix(dt.year,dt.month,dt.day,dt.hour,dt.min,dt.sec);
END;


FUNCTION Date2Dos(Year,Month,Day,Hour,Min,Sec:Word):LongInt;
VAR dt:DateTime; i:LongInt;
BEGIN
   dt.Year := Year;
   dt.Month := Month;
   dt.Day := Day;
   dt.Hour := Hour;
   dt.Min := Min;
   dt.Sec := Sec;
   PackTime(dt,i);
   Date2Dos := i;
END;


FUNCTION JulianCurrent:Word;
{$IFDEF VIRTUALPASCAL}
VAR Day,Month,Year,Junk:LongInt;
{$ELSE}
VAR Day,Month,Year,Junk:Word;
{$ENDIF}
BEGIN
   GetDate(Day,Month,Year,Junk);
   JulianCurrent := Date2Julian(Day,Month,Year);
END;


FUNCTION Date2Julian(Day,Month,Year:Word):Word;
VAR Date:LongInt;
BEGIN
   IF (Year=1900) AND (Month < 3)
      THEN Date := 0
      ELSE BEGIN
            IF Month > 2
               THEN Month := Month-3
               ELSE BEGIN
                  Month := Month+9;
                  Year := Year-1;
               END;
            Year := Year-1900;
            Date := (1461*LongInt(Year) DIV 4)+(153*Month+2) DIV 5 + Day + 58;
         END;
   Date2Julian := Date;
END;


PROCEDURE Julian2Date(Date:Word; VAR Year,Month,Day:Word);
VAR Remainder,Factored:LongInt;
BEGIN
   IF Date = 0 THEN BEGIN Year := 0; Month := 0; Day := 0; Exit; END;
   {...}
   IF Date <= 58
      THEN BEGIN
            Year := 1900;
            IF Date <= 30
               THEN BEGIN
                     Month := 1;
                     Day := Date+1;
                  END
               ELSE BEGIN
                     Month := 2;
                     Day := Date-30;
                  END;
         END
      ELSE BEGIN
            Factored := 4*LongInt(Date)-233;
            Year := Factored DIV 1461;
            Remainder := (Factored MOD 1461 DIV 4 * 5) + 2;
            Month := Remainder DIV 153;
            Day := ((Remainder MOD 153) DIV 5)+1;
            Year := Year+1900;
            IF Month < 10
               THEN Month := Month+3
               ELSE BEGIN
                     Month := Month-9;
                     Inc(Year);
                  END;
         END;
END;


FUNCTION Julian2Unix(Date:Word):LongInt;
VAR Year,Month,Day:Word;
BEGIN
   Julian2Date(Date,Year,Month,Day);
   Julian2Unix := Date2Unix(Year,Month,Day,0,0,0);
END;


FUNCTION Julian2Dos(Date:Word):LongInt;
VAR dt:DateTime; i:LongInt;
BEGIN
   FillChar(dt,SizeOf(dt),0);
   Julian2Date(Date,Word(dt.Year),Word(dt.Month),Word(dt.Day));
   PackTime(dt,i);
   Julian2Dos := i;
END;


END.
