{$X+,O+}
UNIT RWREG;

(* 

    RENEWAVE is Copyright (C) 1994-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of RENEWAVE.

    RENEWAVE is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RENEWAVE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RENEWAVE; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)

INTERFACE

USES RWSTRUCT;

VAR  RwKey     : RwKeyRec;
     RwKeyFile : FILE;


PROCEDURE RWK_ReadKey(KeyPath:String);
PROCEDURE RWK_WriteKey(KeyPath:String);
FUNCTION  RWK_GenerateRegCode(TempKey:RwKeyRec):LongInt;
PROCEDURE RWK_GenerateRegInfo(VAR TempKey:RwKeyRec);
FUNCTION  RWK_CheckReg:Boolean;


IMPLEMENTATION


USES CRC32,MISC1,MSTRINGS;


PROCEDURE RWK_ReadKey(KeyPath:String);
VAR f:FILE; i:Integer;
BEGIN
   IF NOT FExists(KeyPath+'RENEWAVE.KEY') THEN
      BEGIN
         FillChar(RwKey,SizeOf(RwKey),0);
         Exit;
      END;

   Assign(f,KeyPath+'RENEWAVE.KEY');
   Reset(f,1);
   BlockRead(f,RwKey,SizeOf(RwKey),i);
   Close(f);
END;


PROCEDURE RWK_WriteKey(KeyPath:String);
VAR f:FILE; i:LongInt;
BEGIN
   Assign(f,KeyPath+'RENEWAVE.KEY');
   Rewrite(f,1);
   BlockWrite(f,RwKey,SizeOf(RwKey));
   Close(f);
END;


FUNCTION RWK_GenerateRegCode(TempKey:RwKeyRec):LongInt;
BEGIN
   RWK_GenerateRegCode := 0;
END;


PROCEDURE RWK_GenerateRegInfo(VAR TempKey:RwKeyRec);
BEGIN
END;


FUNCTION RWK_CheckReg:Boolean;
VAR TempKey:RwKeyRec; TempResult:Boolean;
BEGIN
   RWK_CheckReg := TRUE;
END;


END.
