Type

NDXRec = Record               { XXX.NDX -- XXX = conference number    }
   MessagePointer : LongInt;  { padded to 3 digits.                   }
   ConferenceNum : Byte;      { MessagePointer = Number of 128-byte   }
End;                          { blocks to the message header, start-  }
                    { ing at 1, not 0.  Note:  Block #1 is always the }
                    { packet header, so this can't be lower than 2    }

QWKHeaderIn = Record
   Status : Char;
   MSGNum : Array[1..7] of char; { ASCII left justified }
   Date : Array[1..8] of char; { MM-DD-YY }
   Time : Array[1..5] of char; { HH:MM }
   MSGTo : Array[1..25] of char;
   MSGFrom : Array[1..25] of char;
   Subject : Array[1..25] of char;
      { left justified space filled - uppercase }
   Password : Array[1..12] of char; { normally not needed }
   ReplyTo : Array[1..8] of char; { ASCII left justified }
   MSGSize : Array[1..6] of char; { # of 128 byte blocks including HDR of msg }
   Active : Char; { #225 = Active, #226 = Inactive }
   ConfNum : Word;
   Junk : Array[1..3] of char;
End;

PasQWKHeader = Record
   Private : Boolean;
   MSGNum : LongInt;
   Date : String[8]; { MM-DD-YY }
   Time : String[5]; { HH:MM }
   MSGTo,
   MSGFrom,
   Subject : String;
   Password : String[12];
   ReplyTo : LongInt;
   MSGSize : Word; { # of 128 byte text blocks including HDR of msg }
   Active : Boolean;
   ConfNum : Word;
End;
