UNIT MSTRINGS;

(* 

    MSCOMMON is Copyright (C) 1994-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of the MSCOMMON library.

    MSCOMMON is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    MSCOMMON is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with MSCOMMON; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)

{$IFDEF OS2}
{$DEFINE IS32}
{$ENDIF}

{$IFDEF DELPHI}
{$DEFINE IS32}
{$ENDIF}


INTERFACE


TYPE  ChStr2      = Array[1..02] OF Char;
      ChStr4      = Array[1..04] OF Char;
      ChStr5      = Array[1..05] OF Char;
      ChStr6      = Array[1..06] OF Char;
      ChStr7      = Array[1..07] OF Char;
      ChStr8      = Array[1..08] OF Char;
      ChStr9      = Array[1..09] OF Char;
      ChStr11     = Array[1..11] OF Char;
      ChStr12     = Array[1..12] OF Char;
      ChStr13     = Array[1..13] OF Char;
      ChStr14     = Array[1..14] OF Char;
      ChStr15     = Array[1..15] OF Char;
      ChStr16     = Array[1..16] OF Char;
      ChStr25     = Array[1..25] OF Char;
      ChStr26     = Array[1..26] OF Char;
      ChStr29     = Array[1..29] OF Char;
      ChStr30     = Array[1..30] OF Char;
      ChStr31     = Array[1..31] OF Char;
      ChStr32     = Array[1..32] OF Char;
      ChStr33     = Array[1..33] OF Char;
      ChStr35     = Array[1..35] OF Char;
      ChStr48     = Array[1..48] OF Char;
      ChStr51     = Array[1..51] OF Char;
      ChStr60     = Array[1..60] OF Char;
      ChStr61     = Array[1..61] OF Char;
      ChStr64     = Array[1..64] OF Char;

      bmTable     = Array[0..255] OF Byte;


{ Non-Delphi specific }
{$IFNDEF DELPHI}
PROCEDURE SetLength(VAR s:String; Len:Byte);
{$ENDIF}

{ String formatting routines }
FUNCTION  Downcase(Ch:Char):Char;
FUNCTION  DowncaseStr(s:String):String;
FUNCTION  ReplaceChar(s:String; OldChar,NewChar:Char):String;
FUNCTION  ReplaceStr(s:String; OldS,NewS:String):String;
FUNCTION  UpcaseStr(s:String):String;
FUNCTION  UpcaseStrPos(s:String; Start,Num:Byte):String;
FUNCTION  FormatName(name:string):String;
FUNCTION  ModemStrTrans(s:String):String;

{ String padding/formatting routines }
FUNCTION  RepStr(s:String; i:Byte):String;
FUNCTION  RepChar(ch:Char; i:byte):String;
FUNCTION  StripLeadingCh(s:string;ch:char):String;
FUNCTION  StripTrailingCh(s:string;ch:char):String;
FUNCTION  StripChar(s:string;ch:char):String;
FUNCTION  PadRight(s:string;ch:char;spaces:integer):String;
FUNCTION  PadLeft(s:string;ch:char;spaces:integer):String;
FUNCTION  PadCenter(s:String;ch:char;spaces:integer):String;
FUNCTION  CutTo(s:String;len:Byte):String;

{ Number related operations }
FUNCTION  StrFunc(i:longint):String;
FUNCTION  ValFunc(s:string):LongInt;
FUNCTION  LeadingZero(i:longint;spaces:integer):String;
FUNCTION  NumberCommas(i:LongInt):String;
FUNCTION  NumberCommasStr(s:String):String;

{ String search routines }
FUNCTION  GetWordCount(s:string):Byte;
FUNCTION  GetWord(s:string;wordnum:byte):String;
FUNCTION  GetSegment(s:string;wordnum:byte; sepchar:char):String;
FUNCTION  ExtractName(s:String; Last:Boolean):String;
FUNCTION  Position(str1,str2:String):Byte;
PROCEDURE bmCreateTable(VAR bmt:bmTable; Pattern:String; ExactCase:Boolean);
FUNCTION  bmSearch(VAR BMT:BMTable; VAR Buffer; BuffSize:word; Pattern:String; ExactCase:Boolean):Word;

{ String conversion routines }
FUNCTION  Nul2Str(VAR ChArrIn; MaxLen:Byte):String;
PROCEDURE Str2Nul(s:String; VAR ChArrOut; MaxLen:Byte; NulChar:Char);
FUNCTION  Qwk2Str(VAR Str; Len:Byte):String;

FUNCTION  OnOffBoolean(b:Boolean):String;
FUNCTION  YesNoBoolean(b:Boolean):String;


IMPLEMENTATION


{$IFNDEF DELPHI}
PROCEDURE SetLength(VAR s:String; Len:Byte);
BEGIN
   s[0] := Chr(Len);
END;
{$ENDIF}


FUNCTION Position(str1,str2:String):Byte;
BEGIN
   Position := Pos(Str1,Str2);
END;
{$IFDEF BLAH}
FUNCTION Position(str1,str2:String):Byte; ASSEMBLER;
ASM
        CLD              { string operations forward                 }
        LES   DI,Str2    { load in ES:DI pointer to str2             }
        XOR   CH,CH      { clear CH                                  }
        MOV   CL,[DI]    { length str2 --> CL                        }
        AND   CL,CL      { length str2 = 0?                          }
        JZ    @NotFound  { length str2 = 0, nothing to search in     }
        MOV   BH,CL      { length str2 --> BH                        }
        INC   DI         { make DI point to the 1st char of str2     }
        LDS   SI,Str1    { load in DS:SI pointer to str1             }
        LODSB            { load in AL length str1                    }
        AND   AL,AL      { length str1 = 0?                          }
        JZ    @NotFound  { length str1 = 0, nothing to search for    }
        DEC   AL         { 1st char need not be compared again       }
        SUB   CL,AL      { length str2 - length str1                 }
        JBE   @NotFound  { length str2 < length str1                 }
        MOV   AH,AL      { length str1 --> AH                        }
        LODSB            { load in AL 1st character of str1          }
@Start:
  REPNE SCASB            { scan for next occurrence 1st char in str2 }
        JNE   @NotFound  { no success                                }
        MOV   DX,SI      { pointer to 2nd char in str1 --> DX        }
        MOV   BL,CL      { number of chars in str2 to go --> BL      }
        MOV   CL,AH      { length str1 --> CL                        }
   REPE CMPSB            { compare until characters don't match      }
        JE    @Found     { full match                                }
        SUB   SI,DX      { current SI - prev. SI = # of chars moved  }
        SUB   DI,SI      { current DI - # of chars moved = prev. DI  }
        MOV   SI,DX      { restore pointer to 2nd char in str1       }
        MOV   CL,BL      { number of chars in str2 to go --> BL      }
        JMP   @Start     { scan for next occurrence 1st char in str2 }
@NotFound:
        XOR   AX,AX      { str1 is not in str2, result 0             }
        JMP   @Exit
@Found:
        ADD   BL,AH      { number of chars in str2 left              }
        MOV   AL,BH      { length str2 --> AX                        }
        SUB   AL,BL      { start position of str1 in str2            }
@Exit:                   { we are finished. }
END;
{$ENDIF}


PROCEDURE bmCreateTable(VAR bmt:bmTable; Pattern:String; ExactCase:Boolean);
VAR Index:Byte;
BEGIN
   FillChar(bmt,SizeOf(bmt),Length(Pattern));
   IF NOT ExactCase THEN FOR Index := 1 TO Length(Pattern) DO Pattern[Index] := Upcase(Pattern[Index]);
   FOR Index := 1 TO length(Pattern) DO BMT[ord(Pattern[Index])] := (length(Pattern) - Index)
END; { bmCreateTable }


FUNCTION bmSearch(VAR BMT:BMTable; VAR Buffer; BuffSize:word; Pattern:String; ExactCase:Boolean):Word;
VAR Buffer2 : Array[1..1] OF Char ABSOLUTE Buffer;
    Index1,
    Index2,
    PatSize : Word;
BEGIN
   PatSize := Length(Pattern);
   IF NOT ExactCase THEN
      BEGIN
         FOR Index1 := 1 TO BuffSize DO IF (Buffer2[Index1] > #96) AND (Buffer2[Index1] < #123) THEN Dec(Buffer2[Index1],32);
         FOR Index1 := 1 TO length(Pattern) DO Pattern[Index1] := upcase(Pattern[Index1])
      END;
   Index1 := PatSize;
   Index2 := PatSize;
   REPEAT
      IF (Buffer2[Index1] = Pattern[Index2])
         THEN BEGIN
               Dec(Index1);
               Dec(Index2)
            END
         ELSE BEGIN
               IF (succ(PatSize - Index2) > (BMT[ord(Buffer2[Index1])]))
                  THEN Inc(Index1, succ(PatSize - Index2))
                  ELSE Inc(Index1, BMT[ord(Buffer2[Index1])]);
               Index2 := PatSize
            END;
   UNTIL (Index2 < 1) OR (Index1 > BuffSize);
   IF (Index1 > BuffSize)
      THEN bmSearch := 0
      ELSE bmSearch := Succ(Index1)
END; { bmSearch }


PROCEDURE Str2Nul(s:String; VAR ChArrOut; MaxLen:Byte; NulChar:Char);
VAR TempArr : Array[1..255] OF Char;
BEGIN
   {$IFDEF DELPHI}
   IF Length(s) > MaxLen THEN SetLength(s,MaxLen);
   {$ELSE}
   IF Length(s) > MaxLen THEN s[0] := Chr(MaxLen);
   {$ENDIF}
   FillChar(TempArr,SizeOf(TempArr),NulChar);
   Move(s[1],TempArr,Length(s));
   Move(TempArr,ChArrOut,MaxLen);
END;


FUNCTION Nul2Str(VAR ChArrIn; MaxLen:Byte):String;
VAR ChArr:Array[1..256] OF Char ABSOLUTE ChArrIn; ThisPos,ToNul:Byte; s:string;
BEGIN
   s := '';
   FOR ThisPos := 1 TO MaxLen DO
      IF (ChArr[ThisPos]=#0) OR (ThisPos = MaxLen) THEN
         BEGIN
            IF NOT (ChArr[ThisPos]=#0) THEN ToNul := MaxLen ELSE ToNul := ThisPos-1;
            Move(ChArr[1],s[1],ToNul);
            {$IFDEF DELPHI}
            SetLength(s,ToNul);
            {$ELSE}
            s[0] := Chr(ToNul);
            {$ENDIF}
            Nul2Str := s;
            Exit;
         END;
   Nul2Str := s;
END;


FUNCTION Qwk2Str(VAR Str; Len:Byte):String;
VAR ChArr : Array[1..256] OF Char ABSOLUTE Str;
    TempS : String;
BEGIN
   {$IFDEF DELPHI}
   SetLength(TempS,Len);
   {$ELSE}
   TempS[0] := Chr(Len);
   {$ENDIF}
   Move(ChArr[1],TempS[1],Len);
   TempS := StripTrailingCh(TempS,' ');
   Qwk2Str := TempS;
END;


FUNCTION ExtractName(s:String; Last:Boolean):String;
VAR Temp:String; SpPos,StrPos:Byte;
BEGIN
   Temp := s; StrPos := Length(Temp);
   IF Pos(#32,Temp) <> 0 THEN
      BEGIN
         REPEAT
             Dec(StrPos)
         UNTIL (Temp[StrPos] = #32) OR (StrPos = 1);
         SpPos := StrPos;
         IF Last THEN Temp := Copy(Temp,SpPos+1,Length(Temp) - SpPos)
         ELSE Temp := Copy(Temp,1,SpPos - 1);
      END;
   ExtractName := FormatName(Temp);
END;


FUNCTION  OnOffBoolean(b:Boolean):String;
BEGIN
   IF b
      THEN OnOffBoolean := 'On '
      ELSE OnOffBoolean := 'Off';
END;


FUNCTION  YesNoBoolean(b:Boolean):String;
BEGIN
   IF b
      THEN YesNoBoolean := 'Yes'
      ELSE YesNoBoolean := 'No';
END;


FUNCTION ReplaceChar(s:String; OldChar,NewChar:Char):String;
VAR TempS:String; TempPos:Byte;
BEGIN
   TempS := s;
   WHILE Pos(OldChar,TempS) > 0 DO
      BEGIN
         TempPos := Pos(OldChar,TempS);
         Delete(TempS,TempPos,1);
         Insert(NewChar,TempS,TempPos);
      END;
   ReplaceChar := TempS;
END;


FUNCTION ReplaceStr(s:String; OldS,NewS:String):String;
VAR b:Byte; TempS:String;
BEGIN
   TempS := s;
   IF OldS <> NewS THEN
      BEGIN
         b := Pos(OldS,TempS);
         WHILE b > 0 DO
            BEGIN
               Delete(TempS,b,Length(OldS));
               Insert(NewS,TempS,b);
               b := Pos(OldS,TempS);
            END;
      END;
   ReplaceStr := TempS;
END;


FUNCTION RepStr(s:String; i:Byte):String;
VAR t:Byte; TempS:String;
BEGIN
   TempS := '';
   IF i > 0 THEN FOR t := 1 TO i DO TempS := TempS+s;
   RepStr := TempS;
END;


FUNCTION RepChar(ch:Char; i:byte):String;
VAR t:byte; TempS:String;
BEGIN
   TempS := '';
   IF i > 0 THEN FOR t := 1 TO i DO TempS := TempS + ch;
   RepChar := TempS;
END;


{$IFDEF DOS}
FUNCTION UpcaseStr(s:String):String; ASSEMBLER;
ASM
     push ds
     lds  si,s
     les  di,@result
     lodsb            { load and store length of string }
     stosb
     xor  ch,ch
     mov  cl,al
     jcxz @empty      { FIX for null length string }
   @upperLoop:
     lodsb
     cmp  al,'a'
     jb   @cont
     cmp  al,'z'
     ja   @cont
     sub  al,' '
   @cont:
     stosb
     loop @UpperLoop
   @empty:
     pop DS
END; { UpcaseStr }
{$ELSE}
FUNCTION UpcaseStr(s:String):String;
VAR StrPos:Byte;
BEGIN
   FOR StrPos := 1 TO Length(s) DO s[StrPos] := Upcase(s[StrPos]);
   UpcaseStr := s;
END;
{$ENDIF}


FUNCTION UpcaseStrPos(s:String; Start,Num:Byte):String;
VAR t:String; i:Byte;
BEGIN
   t := s;
   FOR i := Start TO (Start+Num-1) DO
      t[i] := Upcase(t[i]);
   UpcaseStrPos := t;
END;


FUNCTION Downcase(Ch : Char) : Char;
BEGIN
   If ('A' <= ch) AND (ch <= 'Z')
      Then Downcase := Chr(Ord(ch) + 32)
      Else Downcase := ch
END; { Downcase }


FUNCTION DowncaseStr(S:String):String;
VAR TempStr:String;  StrPos:Byte;
BEGIN
   {$IFDEF DELPHI}
   SetLength(TempStr,Length(s));
   {$ELSE}
   TempStr[0] := s[0];
   {$ENDIF}
   FOR StrPos := 1 TO Length(s) DO
      IF s[StrPos] IN ['A'..'Z']
         THEN TempStr[StrPos] := Chr(Ord(s[StrPos])+32)
         ELSE TempStr[StrPos] := s[StrPos];
   DowncaseStr := TempStr;
END; { DownCaseStr }


FUNCTION StrFunc(i:Longint):String;
VAR s:string[11];
BEGIN
  Str(i,s);
  StrFunc := s;
END;


FUNCTION ValFunc(s:string):LongInt;
VAR TempRes : LongInt;
    {$IFDEF VIRTUALPASCAL}
    Err     : LongInt;
    {$ELSE}
    Err     : Integer;
    {$ENDIF}
BEGIN
   Val(s,TempRes,Err);
   IF Err <> 0 THEN TempRes := -1;
   ValFunc := TempRes;
END;


FUNCTION StripLeadingCh(s:string;ch:char):string;
BEGIN
   {$IFDEF DELPHI}
   WHILE (Length(s) > 0) AND (s[1] = Ch) DO s := Copy(s,2,Length(s)-1);
   {$ELSE}
   WHILE (Ord(s[0]) > 0) AND (s[1] = Ch) DO s := Copy(s,2,Ord(s[0])-1);
   {$ENDIF}
   StripLeadingCh := s;
END;


FUNCTION StripTrailingCh(s:string; ch:char):string;
BEGIN
   {$IFDEF DELPHI}
   WHILE (s[Length(s)] = ch) AND (Length(s) > 0) DO SetLength(s,Length(s)-1);
   {$ELSE}
   WHILE (s[Ord(s[0])] = ch) AND (Ord(s[0]) > 0) DO Dec(s[0]);
   {$ENDIF}
   StripTrailingCh := s;
END;


FUNCTION  StripChar(s:string;ch:char):String;
VAR TempS:String;
BEGIN
   TempS := s;
   WHILE Pos(ch,TempS) > 0 DO Delete(TempS,Pos(ch,TempS),1);
   StripChar := TempS;
END;


FUNCTION PadRight(s:string;ch:char;spaces:integer):string;
VAR Temp:String; PadTo,i:Integer;
BEGIN
   IF Spaces < Length(s) THEN
      BEGIN
         PadRight := Copy(s,1,Spaces);
         Exit;
      END;
   PadTo := Spaces-Length(s);
   IF (PadTo <= 0)
      THEN PadRight := s
      ELSE BEGIN
            Temp := s;
            FOR i := 1 TO PadTo DO
               BEGIN
                  {$IFDEF DELPHI}
                  SetLength(Temp,Length(Temp)+1);
                  {$ELSE}
                  Inc(Temp[0]);
                  {$ENDIF}
                  Temp[Length(Temp)] := Ch;
               END;
            PadRight := temp;
         END;
END;


FUNCTION PadLeft(s:string;ch:char;spaces:integer):string;
VAR Temp:String; PadTo,i:integer;
BEGIN
   IF Spaces < Length(s) THEN
    BEGIN
       PadLeft := Copy(s,1,Spaces);
       Exit;
    END;
   PadTo := Spaces-Length(s);
   IF (PadTo <= 0)
      THEN PadLeft := s
      ELSE BEGIN
            Temp := s;
            FOR i := 1 TO PadTo DO Insert(ch,temp,1);
            PadLeft := temp;
         END;
END;


FUNCTION PadCenter(s:String;ch:char;spaces:integer):String;
VAR Temp:String; PadTo,i:integer;
BEGIN
   IF Spaces <= Length(s) THEN
      BEGIN
         PadCenter := Copy(s,1,Spaces);
         Exit;
      END;
   PadTo := Spaces-Length(s);
   IF (PadTo <= 0)
      THEN PadCenter := s
      ELSE BEGIN
            Temp := S;
            FOR i := 1 TO (PadTo DIV 2) DO Insert(ch,Temp,1);
            WHILE Length(Temp) < Spaces DO Temp := Temp + ch;
            PadCenter := temp;
         END;
END;


FUNCTION  CutTo(s:String;len:Byte):String;
BEGIN
   IF Length(s) > Len
      THEN CutTo := Copy(s,1,Len)
      ELSE CutTo := s;
END;


FUNCTION GetSegment(s:string;wordnum:byte; sepchar:char):String;
VAR TempS:String; pos1,pos2,b,wn:Byte;
BEGIN
   TempS := s+SepChar;
   wn := 1;
   pos1 := 1;
   pos2 := 0;
   FOR b := 1 TO Length(TempS) DO
      BEGIN
         IF TempS[b] = SepChar THEN
            BEGIN
               Inc(wn);
               IF wn = wordnum THEN pos1 := b+1;
               IF wn = (wordnum+1) THEN pos2 := b;
            END;
      END;
   GetSegment := Copy(TempS,pos1,pos2-pos1);
END;


FUNCTION GetWordCount(s:string):Byte;
VAR WordCount,StrPos:Byte;
BEGIN
   s := StripLeadingCh(StripTrailingCh(s,' '),' ');
   WHILE Pos('  ',s) > 0 DO Delete(s,Pos('  ',s),1);
   WordCount := 1;
   FOR StrPos := 1 TO Length(s) DO IF s[StrPos] = ' ' THEN Inc(WordCount);
   GetWordCount := WordCount;
END;


FUNCTION GetWord(s:string;wordnum:byte):String;
VAR TempS:String; pos1,pos2,b,wn:Byte;
BEGIN
   TempS := StripLeadingCh(StripTrailingCh(s,' '),' ');
   WHILE Pos('  ',TempS) > 0 DO Delete(TempS,Pos('  ',TempS),1);
   TempS := TempS + ' ';
   wn := 1;
   pos1 := 1;
   pos2 := 0;
   FOR b := 1 TO Length(TempS) DO
      BEGIN
         IF TempS[b] = ' ' THEN
            BEGIN
               Inc(wn);
               IF wn = wordnum THEN pos1 := b+1;
               IF wn = (wordnum+1) THEN pos2 := b;
            END;
      END;
   GetWord := Copy(TempS,pos1,pos2-pos1);
END;


FUNCTION LeadingZero(i:longint;spaces:integer):string;
VAR Temp:String;
BEGIN
   Str(i,Temp);
   WHILE Length(Temp) < Spaces DO Temp := '0'+Temp;
   LeadingZero := Temp;
END;


FUNCTION FormatName(name:string):String;
VAR TempS:String;
    StrPos:Byte;
BEGIN
   TempS := Name;
   TempS[1] := Upcase(TempS[1]);
   FOR StrPos := 2 TO Length(Name) DO
      IF TempS[StrPos-1] = ' '
         THEN TempS[StrPos] := Upcase(TempS[StrPos])
         ELSE TempS[StrPos] := Downcase(TempS[StrPos]);
   FormatName := TempS;
END;


FUNCTION NumberCommas(i:LongInt):String;
VAR TempS:String;
BEGIN
   Str(i,TempS);
   IF Length(TempS) > 3  THEN Insert(',',TempS,Length(TempS)-2);
   IF Length(TempS) > 7  THEN Insert(',',TempS,Length(TempS)-6);
   IF Length(TempS) > 11 THEN Insert(',',TempS,Length(TempS)-10);
   IF Length(TempS) > 15 THEN Insert(',',TempS,Length(TempS)-14);
   NumberCommas := TempS;
END;


FUNCTION  NumberCommasStr(s:String):String;
VAR TempS:String;
BEGIN
   TempS := s;
   IF Length(TempS) > 3  THEN Insert(',',TempS,Length(TempS)-2);
   IF Length(TempS) > 7  THEN Insert(',',TempS,Length(TempS)-6);
   IF Length(TempS) > 11 THEN Insert(',',TempS,Length(TempS)-10);
   IF Length(TempS) > 15 THEN Insert(',',TempS,Length(TempS)-14);
   NumberCommasStr := TempS;
END;


FUNCTION  ModemStrTrans(s:String):String;
VAR TempS:String; TempPos:Byte;
BEGIN
   TempS := s;
   WHILE Pos('|',TempS) > 0 DO
      BEGIN
         TempPos := Pos('|',TempS);
         Delete(TempS,TempPos,1);
         Insert(#13#10,TempS,TempPos);
      END;
   ModemStrTrans := TempS;
END;


END.




