{$I-}
UNIT MSTGGEN;

(* 

    MSCOMMON is Copyright (C) 1994-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of the MSCOMMON library.

    MSCOMMON is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    MSCOMMON is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with MSCOMMON; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)

{ !NOTICE! - This file is NOT complete right now - not even close, it   }
{ doesn't support Telegard 3.0's new MCI codes (it DOES support the new }
{ colour codes), and is missing support for about 8+ data files.        }

INTERFACE


USES  {$IFDEF DELPHI}
      SYSUTILS,
      {$ENDIF}

      DOS,
      MSTRINGS,
      TGRECORD;

CONST { Constant sizes/limits/maximums }
      DigitsBase36 : String[36] = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';

      MsTg_MaxBases    = 4096;        { Maximum message areas to support }
      MsTg_MsiMaxBuff  = 500;              { Size of *.MSI search buffer }

VAR   MsTg_ConfigFile  : FILE OF ConfigRec;    { CONFIG.TG system config }
      MsTg_Config      : ConfigRec;

VAR   MsTg_ConfFile    : FILE OF ConfRec;      { CONFRENC.DAT conferences }
      MsTg_ConfData    : ConfRec;

VAR   MsTg_NetworkFile : FILE OF NetworkRec;   { NETWORK.DAT network info }
      MsTg_Network     : NetworkRec;

VAR   MsTg_LangFile    : FILE OF LanguageRec;  { LANGUAGE.DAT languages }
      MsTg_Lang        : LanguageRec;
      MsTg_LangPos     : LongInt;

VAR   MsTg_ArcFile     : FILE OF ArchiveRec;   { ARCHIVE.DAT archivers }
      MsTg_Arc         : ArchiveRec;

VAR   MsTg_ProtFile    : FILE OF ProtRec;      { PROTOCOL.DAT protocols }
      MsTg_Prot        : ProtRec;

VAR   MsTg_MsgIdxFile  : FILE OF AreaIdxRec;   { MAREAS.IDX compression }
      MsTg_MsgIdx      : AreaIdxRec;           {   table }
      MsTg_MsgIdxPos   : LongInt;

VAR   MsTg_DirFile     : FILE OF fbRec;       { <basename>.FB files }
      MsTg_Dir         : fbRec;
      MsTg_FileNum     : LongInt;

const MsTg_MaxDescLines = 40;

type  PFlatDesc         = ^TFlatDesc;
      TFlatDesc         = record
                            Size  : Word;
                            Desc  : Array[1..1500] of Char;
                          end;

      PFormatDesc       = ^TFormatDesc;
      TFormatDesc       = record
                            Lines : Word;
                            Desc  : Array[1..MsTg_MaxDescLines] of String[50];
                          end;

var   MsTg_DescFile     : FILE;                { <basename>.FAD files }
      MsTg_DescPos      : LongInt;
      MsTg_Desc         : PFlatDesc;
      MsTg_DescFormat   : PFormatDesc;

VAR   MsTg_FIndexFile  : FILE OF FileIdxRec;   { FILES.IDX file index }
      MsTg_FIndex      : FileIdxRec;

VAR   MsTg_HistFile    : FILE OF HistoryRec;   { HISTORY.DAT BBS history }
      MsTg_History     : HistoryRec;
      MsTg_HistoryPos  : LongInt;

VAR   MsTg_FAreaFile   : FILE OF FAreaRec;
      MsTg_FArea       : FAreaRec;
      MsTg_FileBase    : LongInt;

VAR   MsTg_MAreaFile   : FILE OF MAreaRec;     { MAREAS.DAT message areas }
      MsTg_MArea       : MAreaRec;
      MsTg_MsgArea     : LongInt;

VAR   MsTg_MsiFile     : FILE OF mbScanRec;  { *.MSI lastrad poitners }
      MsTg_Msi         : mbScanRec;
      MsTg_MsiPos      : LongInt;

VAR   MsTg_NameIdxFile : FILE OF UserIdxRec;   { USERS.IDX sorted index }
      MsTg_NameIdx     : UserIdxRec;
      MsTg_NameIdxPos  : LongInt;
      MsTg_IdIdxFile   : FILE OF IdIdxRec;     { USERID.IDX sorted ID index }
      MsTg_IdIdx       : IdIdxRec;
      MsTg_IdIdxPos    : LongInt;

VAR   MsTg_UserFile    : FILE OF UserRec;      { USERS.DAT user file }
      MsTg_User        : UserRec;
      MsTg_UserNum     : LongInt;

TYPE  MsgIdxBuffType   = Array[1..1] OF AreaIdxRec;

VAR   MsgIdxBuff       : ^MsgIdxBuffType;     { List of area numbers and }
      MsgIdxBuffLen,                                     { their aliases }
      MsgIdxBuffPos    : Word;

      MsTg_CfgPath     : String;              { Path to CONFIG.TG }
      MsTg_TempPath    : String;
      MsTg_MsgsPath    : String;              { Path to current base msgs }

      { The following variables are totally dependant on run-time, and    }
      { are used for MCI/ACS processing - it's up to you to set them      }
      { properly if they're going to be used.  This can be done by either }
      { just dumping the data from MSTG_USER or if you're using something }
      { like FKFOSSIL, it'd be better to set the variables from the data  }
      { in FKFOSSIL, or other parts of your program...                    }

      MsTg_TimeLeft    : LongInt;    { Seconds left online }
      MsTg_SysNode     : Word;       { This node number }
      MsTg_SysBaud     : LongInt;    { The actual baud rate }
      MsTg_SysLocked   : LongInt;    { The locked baud rate }
      MsTg_SysPort     : Byte;       { The communications port }


{ Miscellaneous other routines }
FUNCTION  MsTg_FlagStr(Flags:acrqs):String;
FUNCTION  MsTg_AcFlagStr(Flags:uFlags):String;
FUNCTION  MsTg_UserIDStr(UserID:LongInt):String;
FUNCTION  MsTg_UserIDNum(UserID:String):LongInt;
PROCEDURE MsTg_WritePipe(s:String);
PROCEDURE MsTg_WritePipeXY(x,y:Byte; s:String);
PROCEDURE MsTg_WriteColor(s:String);
PROCEDURE MsTg_WriteColorXY(x,y:Byte; s:String);
{PROCEDURE MsTg_WriteColorMCI(s:String); }
FUNCTION  MsTg_StripColor(s:String):String;
FUNCTION  MsTg_MciFormat_Date:String;
FUNCTION  MsTg_MciFormat_Time:String;
FUNCTION  MsTg_MciFormat_TimeLeft:String;
FUNCTION  MsTg_MciFormat_UserPCR:String;
FUNCTION  MsTg_MciString(s:String):String;
FUNCTION  MsTg_MciStringDoor(s,FileProcess,FileList,FileInternal:String):String;
PROCEDURE MsTg_SplitAddr(Addr:String; VAR Zone,Net,Node,Point:Word);

{ CONFIG.TG - Main system configuration }
PROCEDURE MsTg_ConfigRead;
PROCEDURE MsTg_ConfigWrite;

{ CONFRENC.DAT - Conferences configuration (single record) }
PROCEDURE MsTg_ConfRead;
PROCEDURE MsTg_ConfWrite;

{ NETWORK.DAT - Network address and other information (single record) }
PROCEDURE MsTg_NetworkRead;
PROCEDURE MsTg_NetworkWrite;

{ ARCHIVER.DAT - Archiver prorams configuration (single record) }
PROCEDURE MsTg_ArcRead;
PROCEDURE MsTg_ArcWrite;
FUNCTION  MsTg_ArcSearch(ArcExt:String):LongInt;

{ PROTOCOL.DAT - Protocol drivers configuration (single record, A..Z) }
PROCEDURE MsTg_ProtRead;
PROCEDURE MsTg_ProtWrite;

{ FAREAS.DAT - File area records }
PROCEDURE MsTg_FAreaOpen;
PROCEDURE MsTg_FAreaClose;
PROCEDURE MsTg_FAreaRead(RecNum:LongInt);
PROCEDURE MsTg_FAreaWrite(RecNum:LongInt);
FUNCTION  MsTg_GetBaseFile:String;

{ <basename>.FB - Individual files }
PROCEDURE MsTg_DirFileOpen;
PROCEDURE MsTg_DirFileClose;
PROCEDURE MsTg_DirFileRead(RecNum:LongInt);
PROCEDURE MsTg_DirFileWrite(RecNum:LongInt);

{ <basename>.FAD - File descriptions }
PROCEDURE MsTg_DescOpen;
PROCEDURE MsTg_DescClose;
PROCEDURE MsTg_DescRead(RecNum:LongInt);
PROCEDURE MsTg_DescWrite(RecNum:LongInt);
procedure MsTg_FormatDesc(Source:PFlatDesc; Dest:PFormatDesc; LineLength:LongInt);

{ Support for <basename>.FSI pointers }
{ Support for upload and download *.QQQ and *.QQD queue files }

{ LANGUAGE.DAT languages information }
PROCEDURE MsTg_LangOpen;
PROCEDURE MsTg_LangClose;
PROCEDURE MsTg_LangRead(RecNum:LongInt);
PROCEDURE MsTg_LangWrite(RecNum:LongInt);
FUNCTION  MsTg_LangSearch(LangName:String):LongInt;

{ Support for *.BBS BBS listing files }
{ Support for EVENTS.DAT event data }
{ Support for IEMSI.DAT IEMSI connection data }
{ Support for LASTON.DAT last callers }
{ Support for LEVELS.DAT validation levels }
{ Support for MACRO.DAT user macros }
{ Support for MODEM.DAT/NODExxxx.DAT modem config files }
{ Support for SHORTMSG.DAT short messages }
{ Support for VOTING.DAT voting records }
{ Support for *.MNU menu files }


{ HISTORY.DAT - System history/usage information from day 1 }
PROCEDURE MsTg_HistFileOpen;
PROCEDURE MsTg_HistFileClose;
PROCEDURE MsTg_HistFileRead(RecNum:LongInt);
PROCEDURE MsTg_HistFileWrite(RecNum:LongInt);

{ MAREAS.DAT - Message area information }
PROCEDURE MsTg_MAreaOpen;
PROCEDURE MsTg_MAreaClose;
PROCEDURE MsTg_MAreaRead(RecNum:LongInt);
PROCEDURE MsTg_MAreaWrite(RecNum:LongInt);
FUNCTION  MsTg_MAreaFlagStr:String;
PROCEDURE MsTg_MAreaGetBasePath;

{ <basename>.MSI - Lastread/base selected information for each msg area }
PROCEDURE MsTg_MsiOpen;
PROCEDURE MsTg_MsiClose;
PROCEDURE MsTg_MsiRead(RecNum:LongInt);
PROCEDURE MsTg_MsiWrite(RecNum:LongInt);

{ USERS.IDX - Sorted index of user NAMES (both alias and real) }
PROCEDURE MsTg_NameIdxOpen;
PROCEDURE MsTg_NameIdxClose;
PROCEDURE MsTg_NameIdxRead(RecNum:LongInt);
PROCEDURE MsTg_NameIdxWrite(RecNum:LongInt);
FUNCTION  MsTg_NameIdxSearch(Name:String):LongInt;

{ FILES.IDX - Sorted index of file names }
PROCEDURE MsTg_FIndexOpen;
PROCEDURE MsTg_FIndexClose;
PROCEDURE MsTg_FIndexRead(RecNum:LongInt);
PROCEDURE MsTg_FIndexWrite(RecNum:LongInt);
FUNCTION  MsTg_FIndexSearch(FileName:String):Boolean;

{ USERID.IDX - Sorted index of user USERIDs }
PROCEDURE MsTg_IdIdxOpen;
PROCEDURE MsTg_IdIdxClose;
PROCEDURE MsTg_IdIdxRead(RecNum:LongInt);
PROCEDURE MsTg_IdIdxWrite(RecNum:LongInt);
FUNCTION  MsTg_IdIdxSearch(UserID:LongInt):LongInt;

{ USERS.DAT - Information on each user }
PROCEDURE MsTg_UserFileOpen;
PROCEDURE MsTg_UserFileClose;
PROCEDURE MsTg_UserFileRead(RecNum:LongInt);
PROCEDURE MsTg_UserFileWrite(RecNum:LongInt);


IMPLEMENTATION


USES CRT, UNIXDATE, MISC1;


PROCEDURE MsTg_WritePipe(s:String);
VAR StrPos,Err:Integer;  Col:Byte;
BEGIN
    StrPos := 1;
    REPEAT
       IF (s[StrPos] = '|') AND
          (s[StrPos+1] IN ['0'..'3']) AND
          (s[StrPos+2] IN ['0'..'9']) THEN
          BEGIN
             Val(Copy(s,StrPos+1,2),Col,Err);
             IF (Err = 0) AND (Col IN [0..31]) THEN
                 IF      Col IN [00..15] THEN TextColor(Col)
                 ELSE IF Col IN [16..23] THEN TextBackground(Col-16)
                 ELSE IF Col IN [24..31] THEN TextAttr := TextAttr OR Blink;
             Inc(StrPos,3)
          END
       ELSE BEGIN
             Write(s[StrPos]);
             Inc(StrPos)
          END
    UNTIL (StrPos > Length(s))
END;


PROCEDURE MsTg_WritePipeXY(x,y:Byte; s:String);
BEGIN
   GotoXY(x,y);
   MsTg_WritePipe(s);
END;


PROCEDURE MsTg_WriteColor(s:String);
VAR StrPos,Err:Integer;  Col:Byte;
BEGIN
    StrPos := 1;
    REPEAT
       IF      (s[StrPos] = '|') AND
               (s[StrPos+1] IN ['0'..'3']) AND
               (s[StrPos+2] IN ['0'..'9']) THEN
               BEGIN
                  Val(Copy(s,StrPos+1,2),Col,Err);
                  IF (Err = 0) AND (Col IN [0..31]) THEN
                      IF      Col IN [00..15] THEN TextColor(Col)
                      ELSE IF Col IN [16..23] THEN TextBackground(Col-16)
                      ELSE IF Col IN [24..31] THEN TextAttr := TextAttr OR Blink;
                  Inc(StrPos,3);
               END
       ELSE IF (s[StrPos] = '`') ANd
               (s[StrPos+1] IN ['0'..'9','A'..'F']) AND
               (s[StrPos+2] IN ['0'..'9','A'..'F']) THEN
               BEGIN
                  TextAttr := Hex2Int(s[StrPos+1]+s[StrPos+2]);
                  Inc(StrPos,3);
               END
       ELSE BEGIN
             Write(s[StrPos]);
             Inc(StrPos)
          END
    UNTIL (StrPos > Length(s))
END;


PROCEDURE MsTg_WriteColorXY(x,y:Byte; s:String);
BEGIN
   GotoXY(x,y);
   MsTg_WriteColor(s);
END;


FUNCTION MsTg_StripColor(s:String):String;
VAR TempS:String; StrPos,Len:Byte;
BEGIN
    Len := Length(s); StrPos := 1; TempS := '';
    REPEAT
       IF      (s[StrPos] = '|') THEN Inc(StrPos,3)
       ELSE IF (s[StrPos] = '`') THEN Inc(StrPos,3)
       ELSE BEGIN
          Inc(TempS[0]);
          TempS[Length(TempS)] := s[StrPos];
          Inc(StrPos);
       END;
    UNTIL (StrPos > Len);
    MsTg_StripColor := TempS;
END;


FUNCTION MsTg_MciFormat_Date:String;
VAR yy,mm,dd,junk:Word;
BEGIN
   GetDate(yy,mm,dd,Junk);
   MsTg_MciFormat_Date := LeadingZero(mm,2)+'/'+LeadingZero(dd,2)+'/'+LeadingZero(yy-1900,2);
END;


FUNCTION MsTg_MciFormat_Time:String;
VAR hh,mm,ss,junk:Word;
BEGIN
   GetTime(hh,mm,ss,Junk);
   MsTg_MciFormat_Time := LeadingZero(hh,2)+':'+LeadingZero(mm,2)+':'+LeadingZero(ss,2);
END;


FUNCTION MsTg_MciFormat_TimeLeft:String;
VAR TempS:String;
BEGIN
   TempS := LeadingZero(MsTg_TimeLeft DIV 3600,2)+':';
   TempS := TempS+LeadingZero((MsTg_TimeLeft MOD 3600) DIV 60,2)+':';
   TempS := TempS+LeadingZero(MsTg_TimeLeft MOD 60,2);
   MsTg_MciFormat_TimeLeft := TempS;
END;


FUNCTION MsTg_MciFormat_UserPCR:String;
VAR TempS:String;
BEGIN
   IF MsTg_User.TotalCalls = 0
      THEN TempS := '0.00'
      ELSE Str((MsTg_User.PubPost / MsTg_User.TotalCalls*100):0:2,TempS);
   MsTg_MciFormat_UserPCR := TempS;
END;


FUNCTION MsTg_MciString(s:String):String;
VAR TempS:String; StrPos,StrLen,PadTo:Byte;

   PROCEDURE InsertMci(Str:String);
   BEGIN
      Delete(TempS,StrPos,3);
      IF PadTo > 0
         THEN Insert(PadRight(Str,' ',PadTo),TempS,StrPos)
         ELSE Insert(Str,TempS,StrPos);
   END;


   PROCEDURE DoMci;
   VAR Mci:String;
   BEGIN
      Mci := Copy(s,StrPos,3);
      Inc(StrPos,3)
   END;


BEGIN
   IF Length(s) = 0 THEN Exit;
   TempS := s;
   StrPos := 1;
   REPEAT
      IF (s[StrPos] = '%') AND (Length(TempS) >= 3)
         THEN DoMci
         ELSE Inc(StrPos);
   UNTIL StrPos > Length(TempS);
   MsTg_MciString := TempS;
END;


FUNCTION MsTg_MciStringDoor(s,FileProcess,FileList,FileInternal:String):String;
VAR TempS:String;

   PROCEDURE InsertMci(Pos:Byte; Str:String);
   BEGIN
      Delete(TempS,Pos,3);
      Insert(Str,TempS,Pos);
   END;

BEGIN
   TempS := s;
   { Yes this is a cheezy/slow way to do it, but I'm lazy... :) }
   WHILE Pos('~CB',TempS) > 0 DO InsertMCI(Pos('~CB',TempS),StrFunc(MsTg_SysBaud));
   WHILE Pos('~CA',TempS) > 0 DO InsertMCI(Pos('~CA',TempS),StrFunc(MsTg_SysLocked));
   WHILE Pos('%D',TempS) > 0 DO InsertMCI(Pos('%D',TempS),FileList);
   WHILE Pos('~AF',TempS) > 0 DO InsertMCI(Pos('~AF',TempS),FileProcess);
   WHILE Pos('~AI',TempS) > 0 DO InsertMCI(Pos('~AI',TempS),FileInternal);
   WHILE Pos('~PF',TempS) > 0 DO InsertMCI(Pos('~PF',TempS),FileProcess);
   WHILE Pos('%M',TempS) > 0 DO InsertMCI(Pos('%M',TempS),MsTg_CfgPath);
   WHILE Pos('~CN',TempS) > 0 DO InsertMCI(Pos('~CN',TempS),StrFunc(MsTg_SysNode));
   WHILE Pos('~CP',TempS) > 0 DO InsertMCI(Pos('~CP',TempS),StrFunc(MsTg_SysPort));
   MsTg_MciStringDoor := TempS;
END;


PROCEDURE MsTg_SplitAddr(Addr:String; VAR Zone,Net,Node,Point:Word);
VAR ColonPos:Byte; s:String;
BEGIN
   Zone := 0;  Net := 0;  Node := 0;  Point := 0;  s := Addr;

   ColonPos := Pos(':',s); IF ColonPos <= 1 THEN Exit;          { Net }
   Zone := ValFunc(Copy(s,1,ColonPos-1)); Delete(s,1,ColonPos);

   ColonPos := Pos('/',s); IF ColonPos <= 1 THEN Exit;          { Node }
   Net  := ValFunc(Copy(s,1,ColonPos-1)); Delete(s,1,ColonPos);

   ColonPos := Pos('.',s); IF ColonPos <= 1 THEN ColonPos := Length(s)+1;
   Node := ValFunc(Copy(s,1,ColonPos-1));

   IF ColonPos > Length(s) THEN Exit;
   Delete(s,1,ColonPos);
   Point := ValFunc(Copy(s,1,Length(s)));
END;


FUNCTION MsTg_FlagStr(Flags:acrqs):String;
VAR TempS:String; ch:Char;
BEGIN
   TempS := '--------------------------';
   FOR ch := 'A' TO 'Z' DO IF (ch IN Flags) THEN TempS[Ord(ch)-64] := Ch;
   MsTg_FlagStr := TempS;
END;


FUNCTION MsTg_AcFlagStr(Flags:uFlags):String;
VAR TempS:String;
BEGIN
   TempS := '-----------/-234---';

   IF (rLogon        IN Flags) THEN TempS[01] := 'L';
   IF (rchat         IN Flags) THEN TempS[02] := 'C';
   IF (ramsg         IN Flags) THEN TempS[03] := 'A';
   IF (rpostan       IN Flags) THEN TempS[04] := '*';
   IF (rpostpvt      IN Flags) THEN TempS[05] := 'E';
   IF (rpostnet      IN Flags) THEN TempS[06] := 'N';
   IF (rpost         IN Flags) THEN TempS[07] := 'P';
   IF (rvoting       IN Flags) THEN TempS[08] := 'K';
   IF (rmsg          IN Flags) THEN TempS[09] := 'M';
   IF (rpostecho     IN Flags) THEN TempS[10] := 'G';
   IF (fnodlratio    IN Flags) THEN TempS[12] := '1';
   IF (fnopostratio  IN Flags) THEN TempS[13] := '2';
   IF (fnofilepts    IN Flags) THEN TempS[14] := '3';
   IF (fnodeletion   IN Flags) THEN TempS[15] := '4';
   IF (fnodailyratio IN Flags) THEN TempS[16] := '5';
   IF (fnodltime     IN Flags) THEN TempS[17] := '6';
   IF (fnopwchange   IN Flags) THEN TempS[18] := '7';

   MsTg_AcFlagStr := TempS;
END;


FUNCTION MsTg_UserIDNum(UserID:String):LongInt;
BEGIN
   MsTg_UserIDNum := ((Pos(UserID[1],DigitsBase36)-1)*RaiseTo(36,5))+
                     ((Pos(UserID[2],DigitsBase36)-1)*RaiseTo(36,4))+
                     ((Pos(UserID[4],DigitsBase36)-1)*RaiseTo(36,3))+
                     ((Pos(UserID[5],DigitsBase36)-1)*RaiseTo(36,2))+
                     ((Pos(UserID[6],DigitsBase36)-1)*RaiseTo(36,1))+
                     ((Pos(UserID[7],DigitsBase36)-1)*RaiseTo(36,0));
END;


FUNCTION MsTg_UserIDStr(UserID:LongInt):String;
VAR TempS : String;
    TData : RECORD w1:Word; b3,b4:Byte; END ABSOLUTE UserID;
BEGIN
   MsTg_UserIDStr := HexDigit(TData.B3 DIV 16)+
                     HexDigit(TData.B3 MOD 16)+'-'+
                     Int2Hex (TData.w1);
END;


PROCEDURE MsTg_ConfigRead;
BEGIN
   Assign(MsTg_ConfigFile,MsTg_CfgPath+'CONFIG.TG');
   Reset(MsTg_ConfigFile);
   Seek(MsTg_ConfigFile,0);
   Read(MsTg_ConfigFile,MsTg_Config);
   Close(MsTg_ConfigFile);
END;


PROCEDURE MsTg_ConfigWrite;
BEGIN
   Assign(MsTg_ConfigFile,MsTg_CfgPath+'CONFIG.TG');
   Reset(MsTg_ConfigFile);
   Seek(MsTg_ConfigFile,0);
   Write(MsTg_ConfigFile,MsTg_Config);
   Close(MsTg_ConfigFile);
END;


PROCEDURE MsTg_ConfRead;
BEGIN
   Assign(MsTg_ConfFile,MsTg_Config.DataPath+'CONFRENC.DAT');
   Reset(MsTg_ConfFile);
   Seek(MsTg_ConfFile,0);
   Read(MsTg_ConfFile,MsTg_ConfData);
   Close(MsTg_ConfFile);
END;


PROCEDURE MsTg_ConfWrite;
BEGIN
   Assign(MsTg_ConfFile,MsTg_Config.DataPath+'CONFRENC.DAT');
   Reset(MsTg_ConfFile);
   Seek(MsTg_ConfFile,0);
   Write(MsTg_ConfFile,MsTg_ConfData);
   Close(MsTg_ConfFile);
END;


PROCEDURE MsTg_NetworkRead;
BEGIN
   Assign(MsTg_NetworkFile,MsTg_Config.DataPath+'NETWORK.DAT');
   Reset(MsTg_NetworkFile);
   Seek(MsTg_NetworkFile,0);
   Read(MsTg_NetworkFile,MsTg_Network);
   Close(MsTg_NetworkFile);
END;


PROCEDURE MsTg_NetworkWrite;
BEGIN
   Assign(MsTg_NetworkFile,MsTg_Config.DataPath+'NETWORK.DAT');
   Reset(MsTg_NetworkFile);
   Seek(MsTg_NetworkFile,0);
   Write(MsTg_NetworkFile,MsTg_Network);
   Close(MsTg_NetworkFile);
END;


PROCEDURE MsTg_ArcRead;
BEGIN
   Assign(MsTg_ArcFile,MsTg_Config.DataPath+'ARCHIVE.DAT');
   Reset(MsTg_ArcFile);
   Seek(MsTg_ArcFile,0);
   Read(MsTg_ArcFile,MsTg_Arc);
   Close(MsTg_ArcFile);
END;


PROCEDURE MsTg_ArcWrite;
BEGIN
   Assign(MsTg_ArcFile,MsTg_Config.DataPath+'ARCHIVE.DAT');
   Reset(MsTg_ArcFile);
   Seek(MsTg_ArcFile,0);
   Write(MsTg_ArcFile,MsTg_Arc);
   Close(MsTg_ArcFile);
END;


FUNCTION MsTg_ArcSearch(ArcExt:String):LongInt;
VAR Found:Boolean;  ThisArc:Word;
BEGIN
   Found := FALSE;
   MsTg_ArcRead;
   ThisArc := 1;
   WHILE (ThisArc <= MaxArcs) AND (NOT Found) DO
      BEGIN
         Found := (MsTg_Arc[ThisArc].Active) AND
                  (MsTg_Arc[ThisArc].Extension = ArcExt);
         Inc(ThisArc);
      END;
   IF Found
      THEN MsTg_ArcSearch := ThisArc-1
      ELSE MsTg_ArcSearch := 0;
END;


PROCEDURE MsTg_ProtRead;
BEGIN
   Assign(MsTg_ProtFile,MsTg_Config.DataPath+'PROTOCOL.DAT');
   Reset(MsTg_ProtFile);
   Seek(MsTg_ProtFile,0);
   Read(MsTg_ProtFile,MsTg_Prot);
   Close(MsTg_ProtFile);
END;


PROCEDURE MsTg_ProtWrite;
BEGIN
   Assign(MsTg_ProtFile,MsTg_Config.DataPath+'PROTOCOL.DAT');
   Reset(MsTg_ProtFile);
   Seek(MsTg_ProtFile,0);
   Read(MsTg_ProtFile,MsTg_Prot);
   Close(MsTg_ProtFile);
END;


PROCEDURE MsTg_FAreaOpen;
BEGIN
   Assign(MsTg_FAreaFile,MsTg_Config.DataPath+'FAREAS.DAT');
   Reset(MsTg_FAreaFile);
   MsTg_FileBase := 0;
END;


procedure MsTg_FAreaClose;
begin
  if FileRec(MsTg_FAreaFile).Mode <> fmClosed
    then Close(MsTg_FAreaFile);
  MsTg_FileBase := -1;
end;


procedure MsTg_FAreaRead(RecNum:LongInt);
begin
  if RecNum >= FSize(MsTg_FAreaFile)
    then Exit;
  MsTg_FileBase := RecNum;
  if MsTg_FileBase < 0
    then MsTg_FileBase := 0;
  Seek(MsTg_FAreaFile,MsTg_FileBase);
  Read(MsTg_FAreaFile,MsTg_FArea);
end;


PROCEDURE MsTg_FAreaWrite(RecNum:LongInt);
BEGIN
   IF RecNum > FileSize(MsTg_FAreaFile) THEN Exit;
   MsTg_FileBase := RecNum;
   IF MsTg_FileBase < 0 THEN MsTg_FileBase := 0;
   Seek(MsTg_FAreaFile,MsTg_FileBase);
   Write(MsTg_FAreaFile,MsTg_FArea)
END;


FUNCTION MsTg_GetBaseFile:String;
BEGIN
   MsTg_GetBaseFile := MsTg_FArea.FilePath+MsTg_FArea.FileName;
END;


PROCEDURE MsTg_DirFileOpen;
BEGIN
   Assign(MsTg_DirFile,MsTg_GetBaseFile+'.FB');
   Reset(MsTg_DirFile);
   MsTg_FileNum := 0;
END;


PROCEDURE MsTg_DirFileClose;
BEGIN
   {$I-}
    IF FileRec(MsTg_DirFile).Mode <> fmClosed THEN Close(MsTg_DirFile);
    IF IOResult <> 0 THEN ;
    MsTg_FileNum := -1;
   {$I+}
END;


PROCEDURE MsTg_DirFileRead(RecNum:LongInt);
BEGIN
   IF RecNum >= FileSize(MsTg_DirFile) THEN Exit;
   MsTg_FileNum := RecNum;
   IF MsTg_FileNum < 0 THEN MsTg_FileNum := 0;
   Seek(MsTg_DirFile,MsTg_FileNum);
   Read(MsTg_DirFile,MsTg_Dir)
END;


PROCEDURE MsTg_DirFileWrite(RecNum:LongInt);
BEGIN
   IF RecNum > FileSize(MsTg_DirFile) THEN Exit;
   MsTg_FileNum := RecNum;
   IF MsTg_FileNum < 0 THEN MsTg_FileNum := 0;
   Seek(MsTg_DirFile,MsTg_FileNum);
   Write(MsTg_DirFile,MsTg_Dir)
END;


procedure MsTg_DescOpen;
begin
  Assign(MsTg_DescFile,MsTg_GetBaseFile+'.FAD');
  Reset(MsTg_DescFile,1);
  MsTg_DescPos := 0;
end;

procedure MsTg_DescClose;
begin
  if FileRec(MsTg_DescFile).Mode <> fmClosed
    then Close(MsTg_DescFile);
  MsTg_DescPos := -1;
end;

procedure MsTg_DescRead(RecNum:LongInt);
begin
  if RecNum >= FileSize(MsTg_DescFile) then Exit;
  MsTg_DescPos := RecNum;
  if MsTg_DescPos < 0 then MsTg_DescPos := 0;
  Seek(MsTg_DescFile,MsTg_DescPos);
  Read(MsTg_DescFile,MsTg_Desc);
end;

procedure MsTg_DescWrite(RecNum:LongInt);
begin
   IF RecNum > FileSize(MsTg_DescFile) THEN Exit;
   MsTg_DescPos := RecNum;
   IF MsTg_DescPos < 0 THEN MsTg_DescPos := 0;
   Seek(MsTg_DescFile,MsTg_DescPos);
   Write(MsTg_DescFile,MsTg_Desc);
end;

procedure MsTg_FormatDesc(Source:PFlatDesc; Dest:PFormatDesc; LineLength:LongInt);
var
  l,l2  : LongInt;
  Chop  : Boolean;
begin
  Dest^.Lines := 1;
  FillChar(Dest^.Desc,SizeOf(Dest^.Desc),#0); { nullify destination }
  l := 0;

  if (Source^.Size > 0) and (LineLength > 5) then { just to be sure }
    begin

      { Don't truncate long lines if text is free-flowing (no CRs) }
      Chop := FALSE;
      for l2 := 1 to Source^.Size do
        if Source^.Desc[l] = #13 then Chop := TRUE;

      { Format the description }
      while (Dest^.Lines < MsTg_MaxDescLines) and (l < Source^.Size) do
        begin
          Inc(l);
          if (Source^.Desc[l] = #13)
            then
              Inc(Dest^.Lines)
            else
              begin
                Dest^.Desc[Dest^.Lines] := Dest^.Desc[Dest^.Lines]+Source^.Desc[l];
                if (Length(Dest^.Desc[Dest^.Lines]) >= LineLength) and (Chop=FALSE)
                  then
                    Inc(Dest^.Lines);
              end;
        end; { while }

    end;
end;

type  PFlatDesc         = ^TFlatDesc;
      TFlatDesc         = record
                            Size  : Word;
                            Desc  : Array[1..1500] of Char;
                          end;

      PFormatDesc       = ^TFormatDesc;
      TFormatDesc       = record
                            Lines : Word;
                            Desc  : Array[1..MsTg_MaxDescLines] of String[50];
                          end;

var   MsTg_DescFile     : FILE;                { <basename>.FAD files }
      MsTg_DescPos      : LongInt;
      MsTg_Desc         : PFlatDesc;
      MsTg_DescFormat   : PFormatDesc;

  fbrec=                { *.FA : File records }
  record
     filename    : string[12];                { filename }
     descofs     : longint;                   { offset of file desc }
     desclength  : word;                      { length of description }
                                              {  - does not include 13 }
                                              {    byte filename ID }
     size        : longint;                   { length of file (bytes) }
     uldate,                                  { date uploaded }
     filedate,                                { date on file }
     dldate      : unixtime;                  { date last downloaded }
     filestatus  : set of fbstat;             { file status }
     filepoints,                              { points }
     downloads   : word;                      { number downloads }
     uploader    : string[36];                { uploader's name }
     passwordCRC : longint;                   { CRC of password to dl }
     reserved1   : array[1..12] of byte;      { RESERVED }
  end;

 { The description is stored in a continuous character file--the
   description for a file can be found by searching to the description
   offset and reading a 13 byte signature, then the description of
   the appropriate length.  If the 13 byte signature does NOT match the
   filename field, then the description is invalid }




PROCEDURE MsTg_LangOpen;
BEGIN
   Assign(MsTg_LangFile,MsTg_Config.DataPath+'LANGUAGE.DAT');
   Reset(MsTg_LangFile);
   MsTg_LangPos := 0;
END;


PROCEDURE MsTg_LangClose;
BEGIN
   {$I-}
    IF FileRec(MsTg_LangFile).Mode <> fmClosed THEN Close(MsTg_LangFile);
    IF IOResult <> 0 THEN ;
    MsTg_LangPos := -1;
   {$I+}
END;


PROCEDURE MsTg_LangRead(RecNum:LongInt);
BEGIN
   IF RecNum >= FileSize(MsTg_LangFile) THEN Exit;
   MsTg_LangPos := RecNum;
   IF MsTg_LangPos < 0 THEN MsTg_LangPos := 0;
   Seek(MsTg_LangFile,MsTg_LangPos);
   Read(MsTg_LangFile,MsTg_Lang);
END;


PROCEDURE MsTg_LangWrite(RecNum:LongInt);
BEGIN
   IF RecNum > FileSize(MsTg_LangFile) THEN Exit;
   MsTg_LangPos := RecNum;
   IF MsTg_LangPos < 0 THEN MsTg_LangPos := 0;
   Seek(MsTg_LangFile,MsTg_LangPos);
   Write(MsTg_LangFile,MsTg_Lang);
END;


FUNCTION MsTg_LangSearch(LangName:String):LongInt;
{ Doesn't use a buffer to search, since there's usually so few languages }
{ and the LANGUAGE.DAT file is so small that it doesn't really matter }
VAR RecNum:Word;  TempRes:LongInt;
BEGIN
   TempRes := -1;
   FOR RecNum := 0 TO (FileSize(MsTg_LangFile)-1) DO
      BEGIN
         MsTg_LangRead(RecNum);
         IF UpcaseStr(LangName) = UpcaseStr(MsTg_Lang.FileName) THEN
            BEGIN
               TempRes := RecNum;
               Break;
            END;
      END;
   MsTg_LangSearch := TempRes;
END;


PROCEDURE MsTg_HistFileOpen;
BEGIN
   Assign(MsTg_HistFile,MsTg_Config.DataPath+'HISTORY.DAT');
   Reset(MsTg_HistFile);
   MsTg_HistoryPos := 0;
END;


PROCEDURE MsTg_HistFileClose;
BEGIN
   {$I-}
    IF FileRec(MsTg_HistFile).Mode <> fmClosed THEN Close(MsTg_HistFile);
    IF IOResult <> 0 THEN ;
    MsTg_HistoryPos := -1;
   {$I+}
END;


PROCEDURE MsTg_HistFileRead(RecNum:LongInt);
BEGIN
   IF RecNum >= FileSize(MsTg_HistFile) THEN Exit;
   MsTg_HistoryPos := RecNum;
   IF MsTg_HistoryPos < 0 THEN MsTg_HistoryPos := 0;
   Seek(MsTg_HistFile,MsTg_HistoryPos);
   Read(MsTg_HistFile,MsTg_History)
END;


PROCEDURE MsTg_HistFileWrite(RecNum:LongInt);
BEGIN
   IF RecNum > FileSize(MsTg_HistFile) THEN Exit;
   MsTg_HistoryPos := RecNum;
   IF MsTg_HistoryPos < 0 THEN MsTg_HistoryPos := 0;
   Seek(MsTg_HistFile,MsTg_HistoryPos);
   Write(MsTg_HistFile,MsTg_History);
END;


PROCEDURE MsTg_MAreaOpen;
BEGIN
   Assign(MsTg_MAreaFile,MsTg_Config.DataPath+'MAREAS.DAT');
   Reset(MsTg_MAreaFile);
   MsTg_MsgArea := 0;
END;


PROCEDURE MsTg_MAreaClose;
BEGIN
   {$I-}
    IF FileRec(MsTg_MAreaFile).Mode <> fmClosed THEN Close(MsTg_MAreaFile);
    IF IOResult <> 0 THEN ;
    MsTg_MsgArea := -1;
   {$I+}
END;


PROCEDURE MsTg_MAreaRead(RecNum:LongInt);
BEGIN
   IF RecNum >= FileSize(MsTg_MAreaFile) THEN Exit;
   MsTg_MsgArea := RecNum;
   IF MsTg_MsgArea < 0 THEN MsTg_MsgArea := 0;
   Seek(MsTg_MAreaFile,MsTg_MsgArea);
   Read(MsTg_MAreaFile,MsTg_MArea)
END;


PROCEDURE MsTg_MAreaWrite(RecNum:LongInt);
BEGIN
   IF RecNum > FileSize(MsTg_MAreaFile) THEN Exit;
   MsTg_MsgArea := RecNum;
   IF MsTg_MsgArea < 0 THEN MsTg_MsgArea := 0;
   Seek(MsTg_MAreaFile,MsTg_MsgArea);
   Write(MsTg_MAreaFile,MsTg_MArea)
END;


FUNCTION MsTg_MAreaFlagStr:String;
VAR Flags:String;
BEGIN
   Flags := '---------';

   IF (mbRealName    IN MsTg_MArea.mStatus) THEN Flags[1] := 'R';
   IF (mbVisible     IN MsTg_MArea.mStatus) THEN Flags[2] := 'V';
   IF (mbAnsi        IN MsTg_MArea.mStatus) THEN Flags[3] := 'A';
   IF (mb8bit        IN MsTg_MArea.mStatus) THEN Flags[4] := '8';
   IF (mbStrip       IN MsTg_MArea.mStatus) THEN Flags[5] := 'S';
   IF (mbStripColour IN MsTg_MArea.mStatus) THEN Flags[6] := 'C';
   IF (mbAddTear     IN MsTg_MArea.mStatus) THEN Flags[7] := 'T';
   IF (mbInternet    IN MsTg_MArea.mSTatus) THEN Flags[8] := 'U';
   IF (mbNoPubStat   IN MsTg_MArea.mStatus) THEN Flags[9] := 'N';

   MsTg_MAreaFlagStr := Flags;
END;


PROCEDURE MsTg_MAreaGetBasePath;
BEGIN
   IF MsTg_MArea.MsgPath = ''
      THEN MsTg_MsgsPath := AddSlash(MsTg_Config.MsgPath)
      ELSE MsTg_MsgsPath := AddSlash(MsTg_MArea.MsgPath);
END;


PROCEDURE MsTg_MsiOpen;
BEGIN
   MsTg_MAreaGetBasePath;
   Assign(MsTg_MsiFile,MsTg_MsgsPath+MsTg_MArea.FileName+'.MSI');
   IF FExists(MsTg_MsgsPath+MsTg_MArea.FileName+'.MSI')
      THEN Reset(MsTg_MsiFile)
      ELSE Rewrite(MsTg_MsiFile);
   MsTg_MsiPos := 0;
END;


PROCEDURE MsTg_MsiClose;
BEGIN
   {$I-}
    IF FileRec(MsTg_MsiFile).Mode <> fmClosed THEN Close(MsTg_MsiFile);
    IF IOResult <> 0 THEN ;
    MsTg_MsiPos := -1;
   {$I+}
END;


PROCEDURE MsTg_MsiRead(RecNum:LongInt);
VAR i:Word;
BEGIN
   IF RecNum >= FileSize(MsTg_MsiFile) THEN
      BEGIN
         FillChar(MsTg_Msi,SizeOf(MsTg_Msi),MsTg_MArea.ScanType <> 1);
         FOR i := FileSize(MsTg_MsiFile) TO RecNum DO
            BEGIN
               Seek(MsTg_MsiFile,i);
               Write(MsTg_MsiFile,MsTg_Msi);
            END;
      END;
   MsTg_MsiPos := RecNum;
   IF MsTg_MsiPos < 0 THEN MsTg_MsiPos := 0;
   Seek(MsTg_MsiFile,MsTg_MsiPos);
   Read(MsTg_MsiFile,MsTg_Msi)
END;


PROCEDURE MsTg_MsiWrite(RecNum:LongInt);
BEGIN
   IF RecNum > FileSize(MsTg_MsiFile) THEN Exit;
   MsTg_MsiPos := RecNum;
   IF MsTg_MsiPos < 0 THEN MsTg_MsiPos := 0;
   Seek(MsTg_MsiFile,MsTg_MsiPos);
   Write(MsTg_MsiFile,MsTg_Msi)
END;


PROCEDURE MsTg_FIndexOpen;
BEGIN
   Assign(MsTg_FIndexFile,MsTg_Config.DataPath+'FILES.IDX');
   Reset(MsTg_FIndexFile);
END;


PROCEDURE MsTg_FIndexClose;
BEGIN
   {$I-}
    IF FileRec(MsTg_FIndexFile).Mode <> fmClosed THEN Close(MsTg_FIndexFile);
    IF IOResult <> 0 THEN ;
   {$I+}
END;


PROCEDURE MsTg_FIndexRead(RecNum:LongInt);
BEGIN
   IF RecNum >= FileSize(MsTg_FIndexFile) THEN Exit;
   IF RecNum < 0 THEN RecNum := 0;
   Seek(MsTg_FIndexFile,RecNum);
   Read(MsTg_FIndexFile,MsTg_FIndex)
END;


PROCEDURE MsTg_FIndexWrite(RecNum:LongInt);
BEGIN
   IF RecNum > FileSize(MsTg_FIndexFile) THEN Exit;
   IF RecNum < 0 THEN RecNum := 0;
   Seek(MsTg_FIndexFile,RecNum);
   Write(MsTg_FIndexFile,MsTg_FIndex);
END;


FUNCTION MsTg_FIndexSearch(FileName:String):Boolean;
VAR Num,High,Low,Mid,Res,Unsorted:LongInt;

    PROCEDURE Init;
    BEGIN
       FileName := UpcaseStR(StripChar(FileName,' '));
       MsTg_FIndexRead(0);
       Unsorted := MsTg_FIndex.FileBase;
       Num := Unsorted-2;
       IF Num = 1 THEN Dec(Unsorted);
       Res := -1;
    END;

    FUNCTION BinarySearch:LongInt;
    { Binary search on sorted records }
    VAR High,Low,Mid:LongInt;
    BEGIN
       Low  := 0;
       High := Num;

       WHILE High >= Low DO
          BEGIN
             Mid := (High+Low) DIV 2;

             MsTg_FIndexRead(Mid+1);
             MsTg_FIndex.FileName := UpcaseStr(MsTg_FIndex.FileName);
             MsTg_FIndex.FileName := StripChar(MsTg_FIndex.FileName,' ');

             IF (FileName > MsTg_FIndex.FileName) THEN Low := Mid + 1
             ELSE IF (FileName < MsTg_FIndex.FileName) THEN High := Mid - 1
             ELSE High := -1;
          END;

      IF (High = -1)
         THEN BinarySearch := Mid+1
         ELSE BinarySearch := -1;
    END;

    FUNCTION SequentialSearch:LongInt;
    VAR i:LongInt;
    BEGIN
       FOR i := Unsorted TO (FileSize(MsTg_FIndexFile)-1) DO
          BEGIN
             MsTg_FIndexRead(i);
             IF FileName = MsTg_FIndex.FileName THEN
                BEGIN
                   SequentialSearch := i;
                   Exit;
                END;
          END;
       SequentialSearch := -1;
    END;

BEGIN
   Init;

   IF (Num > 1) THEN Res := BinarySearch;
   IF (Unsorted < FileSize(MsTg_FIndexFile)) AND (Res = -1) THEN Res := SequentialSearch;

   IF Res > -1
      THEN BEGIN
            MsTg_FIndexRead(Res);
            MsTg_FIndexSearch := TRUE;
         END
      ELSE MsTg_FIndexSearch := FALSE;
END;


PROCEDURE MsTg_NameIdxOpen;
BEGIN
   Assign(MsTg_NameIdxFile,MsTg_Config.DataPath+'USERS.IDX');
   Reset(MsTg_NameIdxFile);
   MsTg_NameIdxPos := 0;
END;


PROCEDURE MsTg_NameIdxClose;
BEGIN
   {$I-}
    IF FileRec(MsTg_NameIdxFile).Mode <> fmClosed THEN Close(MsTg_NameIdxFile);
    IF IOResult <> 0 THEN ;
    MsTg_NameIdxPos := -1;
   {$I+}
END;


PROCEDURE MsTg_NameIdxRead(RecNum:LongInt);
BEGIN
   IF RecNum >= FileSize(MsTg_NameIdxFile) THEN Exit;
   MsTg_NameIdxPos := RecNum;
   IF MsTg_NameIdxPos < 0 THEN MsTg_NameIdxPos := 0;
   Seek(MsTg_NameIdxFile,MsTg_NameIdxPos);
   Read(MsTg_NameIdxFile,MsTg_NameIdx)
END;


PROCEDURE MsTg_NameIdxWrite(RecNum:LongInt);
BEGIN
   IF RecNum > FileSize(MsTg_NameIdxFile) THEN Exit;
   MsTg_NameIdxPos := RecNum;
   IF MsTg_NameIdxPos < 0 THEN MsTg_NameIdxPos := 0;
   Seek(MsTg_NameIdxFile,MsTg_NameIdxPos);
   Write(MsTg_NameIdxFile,MsTg_NameIdx);
END;


FUNCTION MsTg_NameIdxSearch(Name:String):LongInt;
VAR Num,High,Low,Mid,Res,Unsorted:LongInt;

    PROCEDURE Init;
    BEGIN
       Name := UpcaseStr(Name);
       MsTg_NameIdxRead(0);
       Unsorted := MsTg_NameIdx.Number; {?}
       Num := Unsorted-2;
       IF Num = 1 THEN Dec(Unsorted);
       Res  := -1;
    END;

    FUNCTION BinarySearch:LongInt;
    { Binary search on sorted records }
    VAR High,Low,Mid:LongInt;
    BEGIN
       Low  := 0;
       High := Num;

       WHILE High >= Low DO
          BEGIN
             Mid := (High+Low) DIV 2;
             MsTg_NameIdxRead(Mid+1);
             IF (Name > MsTg_NameIdx.Name) THEN Low := Mid + 1
             ELSE IF (Name < MsTg_NameIdx.Name) THEN High := Mid - 1
             ELSE High := -1;
          END;

      IF (High = -1)
         THEN BinarySearch := Mid+1
         ELSE BinarySearch := -1;
    END;

    FUNCTION SequentialSearch:LongInt;
    VAR i:LongInt;
    BEGIN
       FOR i := Unsorted TO (FileSize(MsTg_NameIdxFile)-1) DO
          BEGIN
             MsTg_NameIdxRead(i);
             IF Name = MsTg_NameIdx.Name THEN
                BEGIN
                   SequentialSearch := i;
                   Exit;
                END;
          END;
       SequentialSearch := -1;
    END;

BEGIN
   Init;

   IF (Num > 1) THEN Res := BinarySearch;
   IF (Unsorted < FileSize(MsTg_NameIdxFile)) AND (Res = -1) THEN Res := SequentialSearch;

   IF Res > -1
      THEN BEGIN
            MsTg_NameIdxRead(Res);
            MsTg_NameIdxSearch := MsTg_NameIdx.Number;
         END
      ELSE MsTg_NameIdxSearch := -1;
END;


PROCEDURE MsTg_IdIdxOpen;
BEGIN
   Assign(MsTg_IdIdxFile,MsTg_Config.DataPath+'USERID.IDX');
   Reset(MsTg_IdIdxFile);
   MsTg_IdIdxPos := 0;
END;


PROCEDURE MsTg_IdIdxClose;
BEGIN
   {$I-}
    IF FileRec(MsTg_IdIdxFile).Mode <> fmClosed THEN Close(MsTg_IdIdxFile);
    IF IOResult <> 0 THEN ;
    MsTg_IdIdxPos := -1;
   {$I+}
END;


PROCEDURE MsTg_IdIdxRead(RecNum:LongInt);
BEGIN
   IF RecNum >= FileSize(MsTg_IdIdxFile) THEN Exit;
   MsTg_IdIdxPos := RecNum;
   IF MsTg_IdIdxPos < 0 THEN MsTg_IdIdxPos := 0;
   Seek(MsTg_IdIdxFile,MsTg_IdIdxPos);
   Read(MsTg_IdIdxFile,MsTg_IdIdx)
END;


PROCEDURE MsTg_IdIdxWrite(RecNum:LongInt);
BEGIN
   IF RecNum > FileSize(MsTg_IdIdxFile) THEN Exit;
   MsTg_IdIdxPos := RecNum;
   IF MsTg_IdIdxPos < 0 THEN MsTg_IdIdxPos := 0;
   Seek(MsTg_IdIdxFile,MsTg_IdIdxPos);
   Write(MsTg_IdIdxFile,MsTg_IdIdx);
END;


FUNCTION  MsTg_IdIdxSearch(UserID:LongInt):LongInt;
VAR Num,High,Low,Mid,Res,Unsorted:LongInt;

    PROCEDURE Init;
    BEGIN
       MsTg_IdIdxRead(0);
       Unsorted := MsTg_IdIdx.Number; {?}
       Num := Unsorted-2;
       IF Num = 1 THEN Dec(Unsorted);
       Res  := -1;
    END;

    FUNCTION BinarySearch:LongInt;
    { Binary search on sorted records }
    VAR High,Low,Mid:LongInt;
    BEGIN
       Low  := 0;
       High := Num;

       WHILE High >= Low DO
          BEGIN
             Mid := (High+Low) DIV 2;
             MsTg_IdIdxRead(Mid+1);
             IF      (UserID > MsTg_IdIdx.UserID) THEN Low := Mid + 1
             ELSE IF (UserID < MsTg_IdIdx.UserID) THEN High := Mid - 1
             ELSE High := -1;
          END;

      IF (High = -1)
         THEN BinarySearch := Mid+1
         ELSE BinarySearch := -1;
    END;

    FUNCTION SequentialSearch:LongInt;
    VAR i:LongInt;
    BEGIN
       FOR i := Unsorted TO (FileSize(MsTg_IdIdxFile)-1) DO
          BEGIN
             MsTg_IdIdxRead(i);
             IF UserID = MsTg_IdIdx.UserID THEN
                BEGIN
                   SequentialSearch := i;
                   Exit;
                END;
          END;
       SequentialSearch := -1;
    END;

BEGIN
   Init;

   IF (Num > 1) THEN Res := BinarySearch;
   IF (Unsorted < FileSize(MsTg_IdIdxFile)) AND (Res = -1) THEN Res := SequentialSearch;

   IF Res > -1
      THEN BEGIN
            MsTg_IdIdxRead(Res);
            MsTg_IdIdxSearch := MsTg_IdIdx.Number;
         END
      ELSE MsTg_IdIdxSearch := -1;
END;



PROCEDURE MsTg_UserFileOpen;
BEGIN
   Assign(MsTg_UserFile,MsTg_Config.DataPath+'USERS.DAT');
   Reset(MsTg_UserFile);
   MsTg_UserNum := 0;
END;


PROCEDURE MsTg_UserFileClose;
BEGIN
   {$I-}
    IF FileRec(MsTg_UserFile).Mode <> fmClosed THEN Close(MsTg_UserFile);
    IF IOResult <> 0 THEN ;
    MsTg_UserNum := -1;
   {$I+}
END;


PROCEDURE MsTg_UserFileRead(RecNum:LongInt);
BEGIN
   IF RecNum >= FileSize(MsTg_UserFile) THEN Exit;
   MsTg_UserNum := RecNum;
   IF MsTg_UserNum < 0 THEN MsTg_UserNum := 0;
   Seek(MsTg_UserFile,MsTg_UserNum);
   Read(MsTg_UserFile,MsTg_User)
END;


PROCEDURE MsTg_UserFileWrite(RecNum:LongInt);
BEGIN
   IF RecNum > FileSize(MsTg_UserFile) THEN Exit;
   MsTg_UserNum := RecNum;
   IF MsTg_UserNum < 0 THEN MsTg_UserNum := 0;
   Seek(MsTg_UserFile,MsTg_UserNum);
   Write(MsTg_UserFile,MsTg_User);
END;


BEGIN
   MsTg_CfgPath := AddSlash(GetEnv('TELEGARD'));
   IF NOT FExists(MsTg_CfgPath+'CONFIG.TG') THEN MsTg_CfgPath := AddSlash(GetEnv('TG'));
   IF NOT FExists(MsTg_CfgPath+'CONFIG.TG') THEN MsTg_CfgPath := AddSlash(GetEnv('BBS'));
   IF NOT FExists(MsTg_CfgPath+'CONFIG.TG') THEN MsTg_CfgPath := GetCurrentDir;
END.
