(* 

    FASTWDOS - DOS Screen Save/Restore Routines

    MSCOMMON is Copyright (C) 1993-2004 by Lars Hellsten and MatrixSoft(tm).

    This file is part of the MSCOMMON library.

    MSCOMMON is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    MSCOMMON is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with MSCOMMON; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*)


USES  DOS, CRT;


PROCEDURE FastWrite(Col,Row,Attr:Byte; Str:String); Assembler;
ASM
       push  DS                    { Save DS                            }
       mov   CH,Row                { CH = Row                           }
       mov   BL,Col                { BL = Column                        }
                                   { Set up ES:DI for LDS               }
       xor   AX,AX                 { AX = 0                             }
       mov   CL,AL                 { CL = 0                             }
       mov   BH,AL                 { BH = 0                             }
       dec   CH                    { convert to DOS 0..24 coords        }
       shr   CX,1                  { CX = Row * 128                     }
       mov   DI,CX                 { Store in DI                        }
       shr   DI,1                  { DI = Row * 64                      }
       shr   DI,1                  { DI = Row * 32                      }
       add   DI,CX                 { DI = (Row * 160)                   }
       dec   BX                    { convert to DOS 0..79 coords        }
       shl   BX,1                  { Account for attribute bytes        }
       add   DI,BX                 { DI = (Row * 160) + (Col * 2)       }
       add   DI,0                  { Add base address                   }
       mov   ES,VideoSeg           { ES:DI points to first Row,Col Attr }
       mov   CL,SnowProne          { Need to wait?                      }
       lds   SI,Str                { DS:SI points to Str[0]             }
       cld                         { Set direction to forward           }
       lodsb                       { AX = Length(St); DS:SI -> Str[1]   }
       xchg  AX,CX                 { CX = Length; AL = CheckSnow        }
       jcxz  @Exit                 { exit if string empty               }
       mov   AH,Attr               { AH = display attribute             }
       rcr   AL,1                  { If CheckSnow is False...           }

  @NoWait:
       lodsb                       { Load next character into AL        }
       stosw                       { Move video word into place         }
       loop  @NoWait               { Get next character                 }
  @Exit:
       pop   DS                    { clean up and go home               }
END;


{$L MOVESCRN.OBJ }
PROCEDURE WriteScr(VAR s:ScreenType); EXTERNAL;
PROCEDURE ReadScr(VAR s:ScreenType); EXTERNAL;


PROCEDURE WriteFast(x,y:Byte; s:String; Attr:Byte);
VAR TempS:String;
BEGIN
   TempS := s;
   FastWrite(x,y,Attr,TempS);
END;


PROCEDURE WriteScreen(VAR s:ScreenType);
BEGIN
   IF SnowProne
      THEN WriteScr(s)
      ELSE Screen^ := s;
END;


PROCEDURE ReadScreen (VAR s:ScreenType);
BEGIN
   IF SnowProne
      THEN ReadScr(s)
      ELSE s := Screen^;
END;


PROCEDURE FastClr(ch:Char; x1,y1,x2,y2,Attr:Byte);
VAR s:String; lnum:Byte;
BEGIN
   IF x2 < x1 THEN Exit;
   IF Y2 < y1 THEN Exit;
   s := '';
   FOR LNum := x1 TO x2 DO
      s := s+ch;
   FOR LNum := y1 TO y2 DO
      WriteFast(x1,LNum,s,Attr);
END;


FUNCTION EGAVGASystem:Boolean;
VAR Regs:Registers;
BEGIN
   Regs.AX := $1C00;
   Regs.CX := 7;
   Intr($10,Regs);
   IF Regs.AL = $1C THEN  { VGA }
      BEGIN
         EGAVGASystem := TRUE;
         Exit;
      END;
   Regs.AX := $1200;
   Regs.BL := $32;
   Intr($10,Regs);
   IF Regs.AL = $12 THEN { MCGA }
      BEGIN
         EGAVGASystem := TRUE;
         Exit;
      END;
   Regs.AH := $12;
   Regs.BL := $10;
   Regs.CX := $FFFF;
   Intr($10,Regs);
   EGAVGASystem := (Regs.CX <> $FFFF); { EGA }
END; { EGAVGASystem }


FUNCTION GetVideoMode:Byte;
VAR Regs:registers;
BEGIN
   Regs.AX := $0F00;
   Intr($10,Regs);
   GetVideoMode := Regs.AL;
END; { GetVideoMode }


PROCEDURE GetVideoSeg;
BEGIN
   SnowProne := FALSE;
   IF GetVideoMode = 7
      THEN VideoSeg := $B000 { Monochrome }
      ELSE BEGIN
         VideoSeg := $B800; { Colour }
         SnowProne := NOT EGAVGASystem
      END;
END;


PROCEDURE HighIntensity(State:Boolean);
CONST BlinkBit    = $20;
      ModeSelOfs  = 4;
VAR   Regs        : Registers;
      CrtMode     : Byte ABSOLUTE $0040:$0065;
      CrtPortBase : Word ABSOLUTE $0040:$0063;

      FUNCTION EgaBios:Boolean; { test For the existance of EGA/VGA BIOS }
      VAR Regs:Registers;
      BEGIN
         Regs.AH := $12;
         Regs.BX := $FF10;
         Intr($10,Regs);
         EgaBios := Regs.BX <> $FF10;
      END;

BEGIN
   IF EgaBios
      THEN BEGIN
            Regs.AX := $1003;
            IF State
               THEN Regs.BL := 0
               ELSE Regs.BL := 1;
            Intr($10,Regs);
         END
      ELSE BEGIN
            IF State
               THEN CrtMode := CrtMode AND NOT BlinkBit
               ELSE CrtMode := CrtMode OR BlinkBit;
            Port[CrtPortBase+ModeSelOfs] := CrtMode;
         END;
END;


PROCEDURE ScreenScroll(Direction:ScrollType; Lines,Top,Bot,SCol,FCol,FillAttr: Byte);
BEGIN
   IF (Direction = Up) THEN
    ASM
       MOV Ah, 06h
       MOV Al, Lines
       MOV Bh, FillAttr
       MOV Ch, Top
       MOV Cl, SCol
       MOV Dh, Bot
       MOV Dl, FCol
       INT 10h
    END
   ELSE
    ASM
       MOV Ah, 07h
       MOV Al, Lines
       MOV Bh, FillAttr
       MOV Ch, Top
       MOV Cl, SCol
       MOV Dh, Bot
       MOV Dl, FCol
       INT 10h
    END;
END;
