program node_update;
uses crt,dos;
type

  ModemFlags=         { MODEM.DAT status flags }
  (
    lockedport,       { COM port locked at constant rate }
    xonxoff,          { XON/XOFF (software) flow control }
    ctsrts            { CTS/RTS (hardware) flow control }
  );

newlinerec=
{$IFDEF WIN32} packed {$ENDIF} record
    InitBaud:longint;                 { initialization baud }
    ComPort:byte;                     { COM port number }
    MFlags:set of ModemFlags;         { status flags }
    Init,                             { init string }
    Answer,                           { answer string or blank }
    Hangup,                           { hangup string }
    Offhook:string[30];               { phone off-hook string }
    DoorPath,                         { door drop files written to }
    TeleConfNormal,
    TeleConfAnon,                     { Teleconferencing strings }
    TeleConfGlobal,
    TeleConfPrivate:string[40];
    OK,
    RING,
    RELIABLE,
    CALLERID,
    NOCARRIER:string[20];
    CONNECT:array [1..22] of string[20];
    { 300, 600, 1200, 2400, 4800, 7200, 9600, 12000, 14400, 16800, 19200,
      21600, 24000, 26400, 28800, 31200, 33600, 38400, 57600, 115200 + 2 extra }
    UseCallerID:boolean;              { Insert Caller ID into sysop note? }
    LogonACS:string[20];                { ACS string to logon this node }
    IRQ,
    Address:string[10];               { used only for functional MCI codes
                                        %C = Comport address
                                        %E = IRQ
                                      }
    AnswerOnRing:byte;                { Answer after how many rings? }
    MultiRing:boolean;                { Answer Ringmaster or some other type
                                        of multiple-ring system ONLY }
    NodeTelnetUrl : String[65];
  end;

oldlinerec=
{$IFDEF WIN32} packed {$ENDIF} record
    InitBaud:longint;                 { initialization baud }
    ComPort:byte;                     { COM port number }
    MFlags:set of ModemFlags;         { status flags }
    Init,                             { init string }
    Answer,                           { answer string or blank }
    Hangup,                           { hangup string }
    Offhook:string[30];               { phone off-hook string }
    DoorPath,                         { door drop files written to }
    TeleConfNormal,
    TeleConfAnon,                     { Teleconferencing strings }
    TeleConfGlobal,
    TeleConfPrivate:string[40];
    OK,
    RING,
    RELIABLE,
    CALLERID,
    NOCARRIER:string[20];
    CONNECT:array [1..22] of string[20];
    { 300, 600, 1200, 2400, 4800, 7200, 9600, 12000, 14400, 16800, 19200,
      21600, 24000, 26400, 28800, 31200, 33600, 38400, 57600, 115200 + 2 extra }
    UseCallerID:boolean;              { Insert Caller ID into sysop note? }
    LogonACS:string[20];                { ACS string to logon this node }
    IRQ,
    Address:string[10];               { used only for functional MCI codes
                                        %C = Comport address
                                        %E = IRQ
                                      }
    AnswerOnRing:byte;                { Answer after how many rings? }
    MultiRing:boolean;                { Answer Ringmaster or some other type
                                        of multiple-ring system ONLY }
  end;

var
  NewNodeF : File of NewLineRec;
  OldNodeF : File of OldLineRec;
  NewNode  : NewLineRec;
  OldNode  : OldLineRec;
  NumOfNodes : Integer;
  OnNode      : Integer;
  RGDataPath  : String;

function IntToStr( intin : longint) : string;
var s : string;
begin
    s:='';
    Str(intin, S);
    IntToStr := s;
end;

begin

  writeln('Simple node*.dat Patcher');
  writeln;
  write(' How many nodes does you bbs have: ');readln(NumOfNodes);
  write(' Where is your Renegade data Path: ');readln(RGDataPath);

  if RGDataPath[Length(RGDataPath)] <> '\' then RGDataPath := RGDataPath + '\';

  writeln;

  for OnNode := 1 to NumOfNodes do begin

      assign(NewNodeF,RGDataPath+'node'+IntToStr(OnNode)+'.new');
      rewrite(NewNodeF);


      assign(OldNodeF,RGDataPath+'node'+IntToStr(OnNode)+'.dat');
      reset(OldNodeF);


      read(OldNodeF,OldNode);
      FillChar(NewNode,SizeOf(NewNode),#0);

      with oldnode do begin
       NewNode.InitBaud := InitBaud;
       NewNode.ComPort := Comport;
       if LockedPort in MFlags then NewNode.MFlags := NewNode.MFlags + [LockedPort];
       if XONXOFF in MFlags then NewNode.MFlags := NewNode.MFlags + [XONXOFF];
       if CTSRTS in MFlags then NewNode.MFlags := NewNode.MFlags + [CTSRTS];
       NewNode.Init := Init;
       NewNode.Answer := Answer;
       NewNode.Hangup := Hangup;
       NewNode.Offhook := OffHook;
       NewNode.CALLERID := CallerID;
       NewNode.DoorPath := DoorPath;
       NewNode.UseCallerID := UseCallerID;
       NewNode.TeleConfNormal := TeleConfNormal;
       NewNode.TeleConfAnon := TeleConfAnon;
       NewNode.TeleConfGlobal := TeleConfGlobal;
       NewNode.TeleConfPrivate := TeleConfPrivate;
       NewNode.OK := OK;
       NewNode.RING := RING;
       NewNode.RELIABLE := RELIABLE;
       NewNode.NOCARRIER := NOCARRIER;
       NewNode.CONNECT[1]  := CONNECT[1];    NewNode.CONNECT[2] := CONNECT[2];
       NewNode.CONNECT[3]  := CONNECT[3];    NewNode.CONNECT[4] := CONNECT[4];
       NewNode.CONNECT[5]  := CONNECT[5];    NewNode.CONNECT[6] := CONNECT[6];
       NewNode.CONNECT[7]  := CONNECT[7];    NewNode.CONNECT[8] := CONNECT[8];
       NewNode.CONNECT[9]  := CONNECT[9];    NewNode.CONNECT[10] := CONNECT[10];
       NewNode.CONNECT[11] := CONNECT[11];   NewNode.CONNECT[12] := CONNECT[12];
       NewNode.CONNECT[13] := CONNECT[13];   NewNode.CONNECT[14] := CONNECT[14];
       NewNode.CONNECT[15] := CONNECT[15];   NewNode.CONNECT[16] := CONNECT[16];
       NewNode.CONNECT[17] := CONNECT[17];   NewNode.CONNECT[18] := CONNECT[18];
       NewNode.CONNECT[19] := CONNECT[19];   NewNode.CONNECT[20] := CONNECT[20];
       NewNode.LogonACS    := LogonACS;
       NewNode.IRQ          := IRQ;
       NewNode.Address      := Address;
       NewNode.AnswerOnRing := AnswerOnRing;
       NewNode.MultiRing    := MultiRing;
      end;



      write(NewNodeF,NewNode);
      writeln('Working on node: ',OnNode);

      close(NewNodeF);
      close(OldNodeF);
      Erase(OldNodeF);
      Rename(NewNodeF,RGDataPath+'node'+IntToStr(OnNode)+'.dat');
  end;

  writeln('All done');

end.