Program BBSList_Patch;
Uses CRT;
Type

  OldBBSListRec=                        { *.BBS file records }
    record
      PhoneNumber:string[20];        { Phone number of BBS }
      BBSName,                       { Name of BBS }
      SysOpName:string[30];          { SysOp of BBS }
      Description:string[60];        { Description of BBS }
      Software,                      { Software used by BBS }
      Speed:string[8];               { Highest connect speed of BBS }
      DateAdded,                     { Date entry was added }
      DateEdited:longint;            { Date entry was last edited }
      UserID,                        { User ID of person adding this }
      Next:longint;                  { Next Record # }
      Reserved:array[1..78] of byte; { Reserved }
    end;

  BBSListRec=                  { *.BBS file records }
  {$IFDEF WIN32} packed {$ENDIF} record
      RecordNum   :longint;    { Number of the Record For Edit }
      UserID      :longInt;    { User ID of person adding this }
      BBSName     :string[30]; { Name of BBS                   }
      SysOpName   :string[30]; { SysOp of BBS                  }
      TelnetUrl   :string[60]; { Telnet Urls                   }
      WebSiteUrl  :string[60]; { Web Site Url                  }
      PhoneNumber :string[20]; { Phone number of BBS           }
      Software    :string[8];  { Software used by BBS          }
      Speed       :string[8];  { Highest connect speed of BBS  }
      Description :string[60]; { Description of BBS            }
      Description2:string[60]; { Second line of descrition     }
      DateAdded   :longint;    { Date entry was added          }
      DateEdited  :longint;    { Date entry was last edited    }
      Next        :longint;    { not done yet                  }
      Prev        :longint;    { not done yet                  }
      xa          :string[8];  { sysop definable A             }
      xb          :string[30]; { sysop definable B             }
      xc          :string[30]; { sysop definable C             }
      xd          :string[40]; { sysop definable D             }
      xe          :string[60]; { sysop definable E             }
      xf          :string[60]; { sysop definable F             }
   end;

  ModemFlags=         { MODEM.DAT status flags }
  (
    lockedport,       { COM port locked at constant rate }
    xonxoff,          { XON/XOFF (software) flow control }
    ctsrts            { CTS/RTS (hardware) flow control }
  );

newlinerec=
{$IFDEF WIN32} packed {$ENDIF} record
    InitBaud:longint;                 { initialization baud }
    ComPort:byte;                     { COM port number }
    MFlags:set of ModemFlags;         { status flags }
    Init,                             { init string }
    Answer,                           { answer string or blank }
    Hangup,                           { hangup string }
    Offhook:string[30];               { phone off-hook string }
    DoorPath,                         { door drop files written to }
    TeleConfNormal,
    TeleConfAnon,                     { Teleconferencing strings }
    TeleConfGlobal,
    TeleConfPrivate:string[40];
    OK,
    RING,
    RELIABLE,
    CALLERID,
    NOCARRIER:string[20];
    CONNECT:array [1..22] of string[20];
    { 300, 600, 1200, 2400, 4800, 7200, 9600, 12000, 14400, 16800, 19200,
      21600, 24000, 26400, 28800, 31200, 33600, 38400, 57600, 115200 + 2 extra }
    UseCallerID:boolean;              { Insert Caller ID into sysop note? }
    LogonACS:string[20];                { ACS string to logon this node }
    IRQ,
    Address:string[10];               { used only for functional MCI codes
                                        %C = Comport address
                                        %E = IRQ
                                      }
    AnswerOnRing:byte;                { Answer after how many rings? }
    MultiRing:boolean;                { Answer Ringmaster or some other type
                                        of multiple-ring system ONLY }
    NodeTelnetUrl : String[65];
  end;

oldlinerec=
{$IFDEF WIN32} packed {$ENDIF} record
    InitBaud:longint;                 { initialization baud }
    ComPort:byte;                     { COM port number }
    MFlags:set of ModemFlags;         { status flags }
    Init,                             { init string }
    Answer,                           { answer string or blank }
    Hangup,                           { hangup string }
    Offhook:string[30];               { phone off-hook string }
    DoorPath,                         { door drop files written to }
    TeleConfNormal,
    TeleConfAnon,                     { Teleconferencing strings }
    TeleConfGlobal,
    TeleConfPrivate:string[40];
    OK,
    RING,
    RELIABLE,
    CALLERID,
    NOCARRIER:string[20];
    CONNECT:array [1..22] of string[20];
    { 300, 600, 1200, 2400, 4800, 7200, 9600, 12000, 14400, 16800, 19200,
      21600, 24000, 26400, 28800, 31200, 33600, 38400, 57600, 115200 + 2 extra }
    UseCallerID:boolean;              { Insert Caller ID into sysop note? }
    LogonACS:string[20];                { ACS string to logon this node }
    IRQ,
    Address:string[10];               { used only for functional MCI codes
                                        %C = Comport address
                                        %E = IRQ
                                      }
    AnswerOnRing:byte;                { Answer after how many rings? }
    MultiRing:boolean;                { Answer Ringmaster or some other type
                                        of multiple-ring system ONLY }
  end;

  fstringrec=                     { STRING.DAT }
  record
    anonymous:string[80];             { "[Anonymous]" string }
    note:array[1..2] of string[80];   { Logon notes (L #1-2) }
    lprompt:string[80];               { Logon prompt (L #3) }
    echoc:char;                       { Echo char for PWs }
    yourpassword,                     { "Your password:" }
    yourphonenumber,                  { "Your phone number:" }
    engage,                           { "Engage Chat" }
    endchat,                          { "End Chat" }
    wait,                             { "SysOp Working" }
    pause,                            { "Pause" }
    entermsg1,                        { "Enter Message" line #1 }
    entermsg2,                        { "Enter Message" line #2 }
    newscan1,                         { "NewScan begin" }
    newscan2,                         { "NewScan done" }
    newuserpassword,                  { "Newuser password:"}
    automsgt:string[80];              { Auto-Message title }
    autom:char;                       { Auto-Message border characters }

    shelldos1,                        { " >> SysOp shelling to DOS ..." }
    readingemail,                     { "Read mail (?=Help) :" }
    chatcall1,                        { "Paging SysOp, please wait..." }
    chatcall2,                        { ">>><*><<<" }
    shuttleprompt,                    { "Enter your user name or number : " }
    namenotfound,                     { "Name NOT found in user list." }
    bulletinline,                     { Bulletin line }
    protocolp,                        { "Protocol (?=List) :" }

    listline,                         { "List files - P to pause" }
    newline,                          { "Search for new files -" }
    searchline,                       { "Search all dirs for file mask" }
    findline1,                        { "Search for descriptions... " }
    findline2,                        { "Enter the string to search for.." }
    downloadline,                     { "Download - " }
    uploadline,                       { "Upload - " }
    viewline,                         { "View interior files - " }
    nofilecredits,                    { "Insufficient file credits." }
    unbalance,                        { "Your UL/DL ratio is unbalanced" }

    ilogon,                           { "Logon incorrect" }
    gfnline1,                         { "[Enter]=All files" }
    gfnline2,                         { "File mask: " }
    batchadd,                         { "File added to batch queue." }
    addbatch,                         { "Batch download flagging - " }
    readq,                            { "Begin reading at [1-54] (Q=Quit): " }
    sysopprompt,                      { "System password: " }
    default,                          { "Press [Enter] to use defaults" }
    newscanall,                       { ")[ Newscan All ](" }
    newscandone,                      { ")[ Newscan Done ](" }
    chatreason:string[80];            { 'Give me a good reason to chat' }
    quote_line:array[1..2] of string[80]; { Quoting so and so to so and so }
    userdefques:array[1..3] of string[80];{ user defined question 1...3}
    userdefed:array[1..3] of string[10];  { user def'd q, user editor strings}
    continue:string[80];              { Continue? }
  end;


var
  OldBBSList  : OldBBSListRec;
  OldBBSListF : File of OldBBSListRec;
  BBSList     : BBSListRec;
  BBSListF    : File of BBSListRec;
  RGDataPath  : String;
  OnRec       : Longint;

  NewNodeF : File of NewLineRec;
  OldNodeF : File of OldLineRec;
  NewNode  : NewLineRec;
  OldNode  : OldLineRec;
  NumOfNodes : Integer;
  OnNode      : Integer;

  s : fstringrec;
  sf : file of fstringrec;
  stxt : text;


function IntToStr( intin : longint) : string;
var s : string;
begin
    s:='';
    Str(intin, S);
    IntToStr := s;
end;

Procedure update_bbslist;
var bbslistname : string;
begin
  writeln('-Convertting bbslist.tpl -> bbslist.dat');

  assign(OldBBSListF,RGDataPath + 'bbslist.tpl');
  {$I-}reset(OldBBSListF);{$I+}
  if ioresult <> 0 then begin writeln('No, bbslist.tpl to modify'); exit; end;

  assign(BBSListF,RGDataPath + 'bbslist.new');
  {$I-}rewrite(BBSListF);{$I+}
  if ioresult <> 0 then begin
     writeln('-Error Accessing bbslist.new');
     exit;
  end;

 OnRec := 0;
 While OnRec <> FileSize(OldBBSListF) do begin

       seek(OldBBSListF,OnRec);
       read(OldBBSListF,OldBBSList);

       FillChar(BBSList,SizeOf(BBSList),#0);
       with OldBBSList do begin
            BBSList.RecordNum    := OnRec;
            BBSList.UserID       := UserID;
            BBSList.BBSName      := BBSName;
            BBSList.SysOpName    := SysOpName;
            BBSList.TelnetUrl    := '';
            BBSList.WebSiteUrl   := '';
            BBSList.PhoneNumber  := PhoneNumber;
            BBSList.Software     := Software;
            BBSList.Speed        := Speed;
            BBSList.Description  := Description;
            BBSList.Description2 := '';
            BBSList.DateAdded    := DateAdded;
            BBSList.DateEdited   := DateEdited;
            BBSList.Next         := 0;
            BBSList.Prev         := 0;
            BBSList.xa           := '';
            BBSList.xb           := '';
            BBSList.xc           := '';
            BBSList.xd           := '';
            BBSList.xe           := '';
            BBSList.xf           := '';
       end;{with}

       seek(BBSListF,OnRec);
       write(BBSListF,BBSList);

       writeln('-Records #:',OnRec+1,' of ',filesize(oldbbslistf),' convertted ');

       Inc(OnRec);

 end;{while}

       writeln('- done convertting');
       close(oldbbslistf);
       close(bbslistf);

       writeln('startting to rename the files');

       rename(oldbbslistf,RGDataPath+'bbslist.old');
       rename(bbslistf,RGDataPath+'bbslist.dat');

       writeln('-Renamed BBSList.dat -> bbslist.old');
       writeln('-Renamed BBSList.new -> bbslist.dat');
       writeln('-all done.. ;) ');
end;
procedure update_nodes;
  function fileexists(Num : integer) : boolean;
  var f:file;
  begin
    assign(newnodef,rgdatapath+'data\node'+IntToStr(OnNode)+'.dat');
     {$I-}reset(newnodef);{$I+}
    close(newnodef);
    if ioresult = 0 then fileexists := true
    else fileexists := false;
  end;
begin
  writeln('-Updatting node*.dat');

  NumOfNodes := 1;
  while fileexists(NumOfNodes) do Inc(NumOfNodes);

  for OnNode := 1 to NumOfNodes do begin

      assign(NewNodeF,RGDataPath+'node'+IntToStr(OnNode)+'.new');
      rewrite(NewNodeF);

      assign(OldNodeF,RGDataPath+'node'+IntToStr(OnNode)+'.dat');
      reset(OldNodeF);

      read(OldNodeF,OldNode);
      FillChar(NewNode,SizeOf(NewNode),#0);

      with oldnode do begin
       NewNode.InitBaud := InitBaud;
       NewNode.ComPort := Comport;
       if LockedPort in MFlags then NewNode.MFlags := NewNode.MFlags + [LockedPort];
       if XONXOFF in MFlags then NewNode.MFlags := NewNode.MFlags + [XONXOFF];
       if CTSRTS in MFlags then NewNode.MFlags := NewNode.MFlags + [CTSRTS];
       NewNode.Init := Init;
       NewNode.Answer := Answer;
       NewNode.Hangup := Hangup;
       NewNode.Offhook := OffHook;
       NewNode.CALLERID := CallerID;
       NewNode.DoorPath := DoorPath;
       NewNode.UseCallerID := UseCallerID;
       NewNode.TeleConfNormal := TeleConfNormal;
       NewNode.TeleConfAnon := TeleConfAnon;
       NewNode.TeleConfGlobal := TeleConfGlobal;
       NewNode.TeleConfPrivate := TeleConfPrivate;
       NewNode.OK := OK;
       NewNode.RING := RING;
       NewNode.RELIABLE := RELIABLE;
       NewNode.NOCARRIER := NOCARRIER;
       NewNode.CONNECT[1]  := CONNECT[1];    NewNode.CONNECT[2] := CONNECT[2];
       NewNode.CONNECT[3]  := CONNECT[3];    NewNode.CONNECT[4] := CONNECT[4];
       NewNode.CONNECT[5]  := CONNECT[5];    NewNode.CONNECT[6] := CONNECT[6];
       NewNode.CONNECT[7]  := CONNECT[7];    NewNode.CONNECT[8] := CONNECT[8];
       NewNode.CONNECT[9]  := CONNECT[9];    NewNode.CONNECT[10] := CONNECT[10];
       NewNode.CONNECT[11] := CONNECT[11];   NewNode.CONNECT[12] := CONNECT[12];
       NewNode.CONNECT[13] := CONNECT[13];   NewNode.CONNECT[14] := CONNECT[14];
       NewNode.CONNECT[15] := CONNECT[15];   NewNode.CONNECT[16] := CONNECT[16];
       NewNode.CONNECT[17] := CONNECT[17];   NewNode.CONNECT[18] := CONNECT[18];
       NewNode.CONNECT[19] := CONNECT[19];   NewNode.CONNECT[20] := CONNECT[20];
       NewNode.LogonACS    := LogonACS;
       NewNode.IRQ          := IRQ;
       NewNode.Address      := Address;
       NewNode.AnswerOnRing := AnswerOnRing;
       NewNode.MultiRing    := MultiRing;
      end;



      write(NewNodeF,NewNode);
      writeln('Working on node: ',OnNode);

      close(NewNodeF);
      close(OldNodeF);
      Erase(OldNodeF);
      Rename(NewNodeF,RGDataPath+'node'+IntToStr(OnNode)+'.dat');
  end;
  writeln('-Done updatting node*.dat');

end;
procedure update_dumpstrings;
begin

  writeln('-Convertting String.dat -> Renegade.lng');

  assign(sf,RGDataPath+'data\string.dat');
   reset(sf);
   read(sf,s);
  close(sf);

  assign(stxt,RGDataPath+'data\renegade.lng');
   rewrite(stxt);
    writeln(stxt,';"[Anonymous]" string : 80 Chars');
    writeln(stxt,'[01]'+s.anonymous);
    writeln(stxt,';Logon note (L #1) : 80 Chars');
    writeln(stxt,'[02]'+s.note[1]);
    writeln(stxt,';Logon note (L #2) : 80 Chars');
    writeln(stxt,'[03]'+s.note[2]);
    writeln(stxt,';Logon note (L #3) : 80 Chars');
    writeln(stxt,'[04]'+s.lprompt);
    writeln(stxt,';{ Echo char for PWs } : 1 Char');
    writeln(stxt,'[05]'+s.echoc);
    writeln(stxt,';{ "Your password:" }');
    writeln(stxt,'[06]'+s.yourpassword);
    writeln(stxt,';{ "Your phone number:" }');
    writeln(stxt,'[07]'+s.yourphonenumber);
    writeln(stxt,';{ "Engage Chat" }');
    writeln(stxt,'[08]'+s.engage);
    writeln(stxt,';{ "End Chat" }');
    writeln(stxt,'[09]'+s.endchat);
    writeln(stxt,';{ "SysOp Working" }');
    writeln(stxt,'[10]'+s.wait);
    writeln(stxt,';{ "Pause" }');
    writeln(stxt,'[11]'+s.pause);
    writeln(stxt,';{ "Enter Message" line #1 }');
    writeln(stxt,'[12]'+s.entermsg1);
    writeln(stxt,';{ "Enter Message" line #2 }');
    writeln(stxt,'[13]'+s.entermsg2);
    writeln(stxt,';{ "NewScan begin" }');
    writeln(stxt,'[14]'+s.newscan1);
    writeln(stxt,';{ "NewScan done" }');
    writeln(stxt,'[15]'+s.newscan2);
    writeln(stxt,';{ "Newuser password:"}');
    writeln(stxt,'[16]'+s.newuserpassword);
    writeln(stxt,';{ Auto-Message title }');
    writeln(stxt,'[17]'+s.automsgt);
    writeln(stxt,';{ Auto-Message border characters } : 1 Char');
    writeln(stxt,'[18]'+s.autom);
    writeln(stxt,';{ " >> SysOp shelling to DOS ..." }');
    writeln(stxt,'[19]'+s.shelldos1);
    writeln(stxt,';{ "Read mail (?=Help) :" }');
    writeln(stxt,'[20]'+s.readingemail);
    writeln(stxt,';{ "Paging SysOp, please wait..." }');
    writeln(stxt,'[21]'+s.chatcall1);
    writeln(stxt,';{ ">>><*><<<" Chat Call }');
    writeln(stxt,'[22]'+s.chatcall2);
    writeln(stxt,';{ "Enter your user name or number : " } Shuttle Prompt');
    writeln(stxt,'[23]'+s.shuttleprompt);
    writeln(stxt,';{ "Name NOT found in user list." }');
    writeln(stxt,'[24]'+s.namenotfound);
    writeln(stxt,';{ Bulletin line Prompt}');
    writeln(stxt,'[25]'+s.bulletinline);
    writeln(stxt,';{ "Protocol (?=List) :" Protocols List}');
    writeln(stxt,'[26]'+s.protocolp);
    writeln(stxt,';{ "List files - P to pause" }');
    writeln(stxt,'[27]'+s.listline);
    writeln(stxt,';{ "Search for new files -" }');
    writeln(stxt,'[28]'+s.newline);
    writeln(stxt,';{ "Search all dirs for file mask" }');
    writeln(stxt,'[29]'+s.searchline);
    writeln(stxt,';{ "Search for descriptions... " }');
    writeln(stxt,'[30]'+s.findline1);
    writeln(stxt,';{ "Enter the string to search for.." }');
    writeln(stxt,'[31]'+s.findline2);
    writeln(stxt,';{ "Download - " }');
    writeln(stxt,'[32]'+s.downloadline);
    writeln(stxt,';{ "Upload - " }');
    writeln(stxt,'[33]'+s.uploadline);
    writeln(stxt,';{ "View interior files - " }');
    writeln(stxt,'[34]'+s.viewline);
    writeln(stxt,';{ "Insufficient file credits." }');
    writeln(stxt,'[35]'+s.nofilecredits);
    writeln(stxt,';{ "Your UL/DL ratio is unbalanced" }');
    writeln(stxt,'[36]'+s.unbalance);
    writeln(stxt,';{ "Logon incorrect" }');
    writeln(stxt,'[37]'+s.ilogon);
    writeln(stxt,';{ "[Enter]=All files" }');
    writeln(stxt,'[38]'+s.gfnline1);
    writeln(stxt,';{ "File mask: " }');
    writeln(stxt,'[39]'+s.gfnline2);
    writeln(stxt,';{ "File added to batch queue." }');
    writeln(stxt,'[40]'+s.batchadd);
    writeln(stxt,';{ "Batch download flagging - " }');
    writeln(stxt,'[41]'+s.addbatch);
    writeln(stxt,';{ "Begin reading at [1-54] (Q=Quit): " }');
    writeln(stxt,'[42]'+s.readq);
    writeln(stxt,';{ "System password: " }');
    writeln(stxt,'[43]'+s.sysopprompt);
    writeln(stxt,';{ "Press [Enter] to use defaults" }');
    writeln(stxt,'[44]'+s.default);
    writeln(stxt,';{ ")[ Newscan All ](" }');
    writeln(stxt,'[45]'+s.newscanall);
    writeln(stxt,';{ ")[ Newscan Done ](" }');
    writeln(stxt,'[46]'+s.newscandone);
    writeln(stxt,';{ Give me a good reason to chat }');
    writeln(stxt,'[47]'+s.chatreason);
    writeln(stxt,';{ Quoting so and so to so and so }');
    writeln(stxt,'[48]'+s.quote_line[1]);
    writeln(stxt,';{ Quoting so and so to so and so }');
    writeln(stxt,'[49]'+s.quote_line[2]);
    writeln(stxt,';{ user defined question 1}');
    writeln(stxt,'[50]'+s.userdefques[1]);
    writeln(stxt,';{ user defined question 2}');
    writeln(stxt,'[51]'+s.userdefques[2]);
    writeln(stxt,';{ user defined question 3}');
    writeln(stxt,'[52]'+s.userdefques[3]);
    writeln(stxt,';{ user def''d q, user editor strings} : 10 Chars');
    writeln(stxt,'[53]'+s.userdefed[1]);
    writeln(stxt,';{ user def''d q, user editor strings} : 10 Chars');
    writeln(stxt,'[54]'+s.userdefed[2]);
    writeln(stxt,';{ user def''d q, user editor strings} : 10 Chars');
    writeln(stxt,'[55]'+s.userdefed[3]);
    writeln(stxt,';{ Continue? }');
    writeln(stxt,'[56]'+s.continue);
    writeln(stxt,';{Waitting for telnet} : 60 Chars');
    writeln(stxt,'[57] Waitting for Telnet');
    writeln(stxt,';Node open or empty');
    writeln(stxt,'[58] Empty');
    writeln(stxt,';Invisible Login Q     : 255 Chars');
    writeln(stxt,'[59] Invisible Login: ');
    writeln(stxt,';{Waitting for telnet} : 60 Chars');
    writeln(stxt,'[57]|02Waiting For Logon');
    writeln(stxt,';{Where from           : 60 Chars');
    writeln(stxt,'[58]          |08-');
    writeln(stxt,';Invisible Login Q     : 255 Chars');
    writeln(stxt,'[59]Invisible Login: ');
    writeln(stxt,';Cant Email');
    writeln(stxt,'[60]|11Can''t send mail to that user.');
    writeln(stxt,';Sendemail');
    writeln(stxt,'[61]%LF|03Enter User Number, Name, or Partial Search String: ');
    writeln(stxt,';Can''t send to other node');
    writeln(stxt,'[62]|11Can''t send msgs to Node %ND.');
    writeln(stxt,';Sending mass-mail to: ');
    writeln(stxt,'[63]|01Sending Mail-Mass to: ');
    writeln(stxt,';Sending mass-mail to All Users.');
    writeln(stxt,'[64]|01Sending mass-mail to ALL USERS.');
    writeln(stxt,';You are not authorized to send netmail.');
    writeln(stxt,'[65]|01You are not allowed to send nemail.');
    writeln(stxt,';Is this to be a netmail message: ');
    writeln(stxt,'[66]%LF|09Is this to be a netmail message: ');
    writeln(stxt,';You have no mail waiting.');
    writeln(stxt,'[67]%LF^5You have no mail waiting.');
    writeln(stxt,';Sorry, you must read and reply to (or delete) your mail.');
    writeln(stxt,'[68]Sorry, you must read and reply to (or delete) your mail.');
    writeln(stxt,';Scan for new files since MM/DD/YYYY: ');
    writeln(stxt,'[69]%LF|03Scan for |11NEW |03Files since |11MM|03/|11DD|03/|11YYYY|03: ');
  close(stxt);

  writeln('-done convertting String.dat -> Renegade.lng');
end;

Begin

  clrscr;
  writeln;
  writeln('Renegade v01-10.4 -> v05-19.04');
  writeln;
    write('Where is Renegade locatted [C:\RG?]:');readln(RGDataPath);

  if RGDataPath =  '' then RGDataPath := 'C:\RG';
  if RGDatapath <> '' then begin
     if RGDataPath[Length(RGDataPath)] <> '\' then RGDataPath := RGDataPath + '\';
  end;

{update_bbslist;}
{update_nodes;}
update_dumpstrings;
writeln('All data files are updated.. Please, follow the readme for other updates');

End.