{$A+,B-,D-,E-,F+,I-,L-,N-,O+,R-,S+,V-}

{ Logon functions }

unit Logon;

interface

uses crt, dos, overlay, common, timefunc;

function Getuser:boolean;

implementation

uses newusers,  mail0, mail1, Email, User, maint, ShortMsg,
     cuser,  doors,  archive1,  menus, menus2, Event;

var
  gotname:boolean;
  olduser:userrec;

function Hex(i : longint; j:byte) : String;
const
  hc : array[0..15] of Char = '0123456789ABCDEF';
var
  one,two,three,four: Byte;
begin
  one   := (i and $000000FF);
  two   := (i and $0000FF00) shr 8;
  three := (i and $00FF0000) shr 16;
  four  := (i and $FF000000) shr 24;

  Hex[0] := chr(j);          { Length of String = 4 or 8}
  if (j = 4) then
    begin
      Hex[1] := hc[two shr 4];
      Hex[2] := hc[two and $F];
      Hex[3] := hc[one shr 4];
      Hex[4] := hc[one and $F];
    end
  else
    begin
      Hex[8] := hc[one and $F];
      Hex[7] := hc[one shr 4];
      Hex[6] := hc[two and $F];
      Hex[5] := hc[two shr 4];
      hex[4] := hc[three and $F];
      hex[3] := hc[three shr 4];
      hex[2] := hc[four and $F];
      hex[1] := hc[four shr 4];
    end;
end {Hex} ;

procedure Iemsi;
var
    Tries: byte;
    T1, T2: longint;
    Emsi_Irq: string [20];
    done, Success: boolean;
    S, Isi: string;
    C: char;
    I: integer;
    buffer: array [1..2048] of char;
    Buffptr: integer;
    U: Userrec;
    Nextitempointer: integer;

function Nextitem: string;
  var S: Astr;
  begin
      S := '';
      while (Nextitempointer < 2048) and (buffer [Nextitempointer] <> #0) and
             (buffer [Nextitempointer] <> '{') do
          inc (Nextitempointer);

      if (buffer [Nextitempointer] = '{') then
          inc (Nextitempointer);

      while (Nextitempointer < 2048) and (buffer [Nextitempointer] <> #0) and
             (buffer [Nextitempointer] <> '}') do
      begin
          S := S + buffer [Nextitempointer];
          inc (Nextitempointer);
      end; { while }
      if (buffer [Nextitempointer] = '}') then
          inc (Nextitempointer);
      Nextitem := S;
  end; { ? }

begin
    fillchar (Iemsirec, sizeof (Iemsirec), 0);
    if (Speed = 0) or (not General.Useiemsi) then exit;

    write ('Attempting IEMSI negotiation ... ');
    fillchar (buffer, sizeof (buffer), 0);
    T1 := Timer;
    T2 := Timer;
    Tries := 0;
    done := false;
    Success := false;
    Emsi_Irq := '**EMSI_IRQ8E08'^M^L;
    Com_Flush_Recv;
    Serialout (Emsi_Irq);
    S := '';

    repeat
        Hangup := not Com_Carrier;
        if (abs (T1 - Timer) > 2) then
        begin
            T1 := Timer;
            inc (Tries);
            if (Tries >= 2) then
                done := true
            else
            begin
                Com_Flush_Recv;
                Serialout (Emsi_Irq);
            end; { if else }
        end; { if }
        if (abs (T2 - Timer) >= 8) then
            done := true;
        C := Cinkey;
        if (C > #0) then
        begin
            if (length (S) >= 160) then
                delete (S, 1, 120);
            S := S + C;
            if (pos ('**EMSI_ICI', S) > 0) then
            begin
                delete (S, 1, pos ('EMSI_ICI', S) - 1);
                move (S [1], buffer [1], length (S) );
                Buffptr := length (S);
                T1 := Timer;
                repeat
                    C := Cinkey;
                    if not (C in [#0, #13] ) then
                    begin
                        inc (Buffptr);
                        buffer [Buffptr] := C;
                    end; { if }
                until (Hangup) or (abs (Timer - T1) > 4) or (C = ^M) or (Buffptr = 2048);
                S [0] := #8;
                move (buffer [Buffptr - 7], S [1], 8);
                dec (Buffptr, 8);
                if (S = Hex (Updatecrc32 ($Ffffffff, buffer [1], Buffptr), 8) ) then
                begin
                    Loadurec (U, 1);
                    Isi := '{Renegade,'+ Ver+ '}{'+ General.Bbsname+ '}{'+ U.Citystate+
                    '}{'+ General.Sysopname+ '}{'+ Hex (Getpackdatetime, 8) +
                    '}{Live free or die!}{}{Everything!}';
                    Isi := 'EMSI_ISI'+ Hex (length (Isi), 4) + Isi;
                    Isi := Isi + Hex (Updatecrc32 ($Ffffffff, Isi [1], length (Isi) ), 8);
                    Isi := '**' + Isi + ^M;
                    Com_Flush_Recv;
                    Serialout (Isi);
                    Tries := 0;  T1 := Timer;  S := '';
                    repeat
                        if (abs (Timer - T1) >= 3) then
                        begin
                            T1 := Timer;
                            inc (Tries);
                            Com_Flush_Recv;
                            Serialout (Isi);
                        end; { if }
                        C := Cinkey;
                        if (C > #0) then
                        begin
                            if (length (S) >= 160) then
                                delete (S, 1, 120);
                            S := S + C;
                            if (pos ('**EMSI_ACK', S) > 0) then
                            begin
                                Com_Flush_Recv;
                                Com_Purge_Send;
                                done := true;
                                Success := true;
                            end { if }
                            else
                                if (pos ('**EMSI_NAKEEC3', S) > 0) then
                                begin
                                    Com_Flush_Recv;
                                    Serialout (Isi);
                                    inc (Tries);
                                end; { if }
                        end; { if }
                    until (Tries >= 3) or (done);
                end { if }
                else
                begin
                    Serialout ('**EMSI_NAKEEC3');
                    T1 := Timer;
                end; { if else }
            end; { if }
        end; { if }
    until (done) or (Hangup);
    if (Success) then
    begin
        writeln ('success.');
        Sl1 ('Successful IEMSI negotiation.');
    end { if }
    else
        writeln ('failure.');

    Nextitempointer := 1;

    with Iemsirec do
    begin
        Username := Nextitem;
        handle := Nextitem;
        Citystate := Nextitem;
        Ph := Nextitem;
        S := Nextitem;
        Pw := Allcaps (Nextitem);
        I := Value ('$'+ Nextitem);
        if (I > 0) then
            Bdate := Pd2Date (I);
    end; { with }

    Com_Flush_Recv;

end; { ? }


procedure Check_Ansi;
var
    L: longint;
    C: char;
    Ox, x, y: byte;
    S: Astr;

procedure Ansiresponse (var x, y: byte);
  var
      Xs, Ys: string [4];
  begin
      {Called everytime??}
      L:= Timer + 2;
      C:= #0;
      Xs := ''; Ys := '';  x := 0;  y := 0;
      while (L > Timer) and (C <> ^[) and (not Hangup) do
          if (not Empty) then
              C := Com_Recv;        { must be low level to avoid ansi-eater }

      if (C = ^[) then begin
          L := Timer + 1;
          while (L > Timer) and (C <> ';') and (not Hangup) do
              if (not Empty) then begin
                 C := Com_Recv;
                 if (C in ['0'..'9'] ) and (length (Ys) < 4) then Ys := Ys + C;
              end; { if }

          L := Timer + 1;
          while (L > Timer) and (C <> 'R') and (not Hangup) do
              if (not Empty) then begin
                  C := Com_Recv;
                  if (C in ['0'..'9'] ) and (length (Xs) < 4) then Xs := Xs + C;
              end; { if }
          x := Value (Xs);
          y := Value (Ys);
      end; { if }
  end; { ? }

begin
    textattr := 10;
    write('Attempting to detect emulation ... ');
    Thisuser.flags := Thisuser.flags - [Avatar, Ansi, Vt100];
    Thisuser.Sflags := Thisuser.Sflags - [Rip];
    if (Speed = 0) then begin
        Thisuser.flags := Thisuser.flags + [Ansi];
        exit;
    end; { if }
    Com_Flush_Recv;
    Serialout(^M^M^['[!'#8#8#8);
    L := Timer + 2;
    C := #0;
    S := '';

    while (L > Timer) and (C <> 'R') and (not Hangup) do if (not Empty) then C := Com_Recv;

    if (C = 'R') then begin
        L := Ticks+ 3;
        while (not Empty) and (Ticks < L) do;
        C := Com_Recv;
        if (C = 'I') then begin
            L := Ticks+ 3;
            while (not Empty) and (Ticks < L) do;
            C := Com_Recv;
            if (C = 'P') then begin
                Thisuser.Sflags := Thisuser.Sflags + [Rip];
                S := 'RIP';
            end; { if }
        end; { if }
        Com_Flush_Recv;
    end; { if }

    Serialout (^M^M^['[6n'#8#8#8#8);
    Ansiresponse(x, y);
    if (x + y > 0) then begin
        Thisuser.flags := Thisuser.flags + [Ansi];
        if (S <> '') then S := S + '/Ansi'
        else S := 'Ansi';
        Serialout(^V^F);
        Serialout(^['[6n'#8#8);
        Ox := x;
        Ansiresponse(x, y);
        if (x = Ox + 1) then begin
           Thisuser.flags := Thisuser.flags + [Avatar];
           if (S <> '') then S := S + '/Avatar'
           else S := 'Avatar';
        end { if }
        else Serialout (#8#8);
    end; { if }
    if (S <> '') then Print('|10' + S + ' detected.')
    else begin
         textattr := 7;
         writeln;
    end; { if else }

end; { ? }


procedure Getpws (var Ok: boolean; var Tries: integer);
var
    S, S1: Astr;
    Phone: string [4];
    Mheader: Mheaderrec;
begin
    Ok:= true;
    if (not (Fastlogon and (not General.Localsec) ) ) then begin

        if (Iemsirec.Pw = '') then begin
            Prompt(Fstring.Yourpassword);
            Echo := false;
            input(S, 20);
            Echo := true;
        end { if }
        else begin
            S := Iemsirec.Pw;
            Iemsirec.Pw := '';
        end; { if else }


        if (General.Phonepw) then
            if (Iemsirec.Ph = '') then
            begin
                Prompt(Fstring.Yourphonenumber);
                Echo := false;
                input (Phone, 4);
                Echo := true;
            end { if }
        else
        begin
            Phone := copy(Iemsirec.Ph, length (Iemsirec.Ph) - 3, 4);
            Iemsirec.Ph := '';
        end { if else }
        else
            Phone := copy(Thisuser.Ph, length (Thisuser.Ph) - 3, 4);


    end; { end if not fast logon and local security off }


    if (not (Fastlogon and (not General.Localsec) ) ) and
        ((Thisuser.Pw <> Crc32(S) ) or (copy (Thisuser.Ph, length (Thisuser.Ph) - 3, 4) <> Phone) )
    then
    begin
        Prompt(Fstring.Ilogon);
        if (not Hangup) and (Usernum<> 0) then begin
            S:= '* Illegal logon attempt! Tried: '+
            Caps (Thisuser.name) + ' #' + Cstr (Usernum) + ' PW=' + S;
            if (General.Phonepw) then S := S + ', PH#=' + Phone;
            Ssm (1, S);
            Sl1 (S);
        end; { if }
        inc (Thisuser.Illegal);
        if (Usernum <> - 1) then Saveurec(Thisuser, Usernum);
        inc (Tries);
        if (Tries>= General.Maxlogontries) then begin
            Hangup:= true;
            Nl;
        end; { if }
        Ok:= false;
    end; { if }

    if (Ok) then Status_Screen(General.Curwindow, '', false, S1);

    if ((Aacs (General.Spw) ) and (Ok) and (Incom) and (not Hangup) ) then begin
        Prompt(Fstring.Sysopprompt);
        Echo:= false;
        input(S, 20);
        Echo:= true;
        if (S <> General.Sysoppw) then
        begin
            Prompt (Fstring.Ilogon);
            Sl1 ('* Illegal System password: ' + S); inc (Tries);
            if (Tries>= General.Maxlogontries) then Hangup:= true;
            Ok:= false;
        end; { if }
    end; { if }

    if (Ok) and not (Aacs (Liner.Logonacs) ) then
    begin
        Printf ('nonode');
        if Nofile then Print ('You don''t have the required ACS to logon to this node!');
        Sysoplog (Thisuser.name+ ': Attempt to logon node '+ Cstr (Node) + ' without access.');
        Hangup:= true;
    end; { if }

    if ( (Ok) and (General.Shuttlelog) and (Lockedout in Thisuser.Sflags) ) then
    begin
        Printf (Thisuser.Lockedfile);
        Sysoplog (Thisuser.name+ ': Attempt to access system when locked out^7 <--');
        Hangup:= true;
    end; { if }

    if (Usernum > 0) and (Onnode(Usernum) > 0) and not (Cosysop) then begin
       Printf ('multilog');
       if (Nofile) then Print (^M^J'You are already logged in on another node!'^M^J);
       Hangup := true;
    end; { if }

    if not Fastlogon and Ok and not Hangup and (General.Birthdatecheck > 0) and
        (Thisuser.Loggedon mod General.Birthdatecheck = 0) then
    begin
        Prt (^M^J'Please verify your date of birth (mm/dd/yyyy) : ');
        Inputformatted (S, '##/##/####', false);
        Nl;
        if (Date2Pd (S) <> Thisuser.Birthdate) then begin
            dec (Thisuser.Loggedon);
            Sl1 ('*'+Thisuser.name+' Failed birthday verification. Tried = '+ S+ ' Actual = '+ Pd2Date(Thisuser.Birthdate));
            Ssm (1, Thisuser.name + ' failed birthday verification on '+ Date);
            Printf ('WRNGBDAY');
            Irt := '\'#1'Failed birthdate check';
            Mheader.Status := [];
            Semail (1, Mheader);
            Hangup := true;
        end; { if }
    end; { if }

    Useron := Ok;
end; { ? }

procedure Tryiemsilogon;
var
    I, Zz: integer;
    Ok: boolean;
begin
    if (Iemsirec.Username <> '') then
    begin
        I := Searchuser (Iemsirec.Username, true);

        if (I = 0) and (Iemsirec.handle <> '') then
            I := Searchuser (Iemsirec.handle, true);

        if (I > 0) then begin
            Zz := Usernum;
            Usernum := 0;
            Olduser := Thisuser;
            Loadurec (Thisuser, I);
            Usernum := Zz;
            Getpws(Ok, Zz);
            Gotname := Ok;
            Nl;
            if (not Gotname) then
            begin
                Thisuser := Olduser;
                Update_Screen;
            end { if }
            else
            begin
                Usernum := I;
                if (Pd2Date(Thisuser.Laston) <> Date) then
                    with Thisuser do
                    begin
                        Ontoday:= 0; Tltoday:= General.Timeallow [Sl];
                        Timebankadd:= 0; Dltoday:= 0; Dlktoday:= 0;
                        Timebankwith:= 0;
                    end; { with }
                Useron:= true;
                Update_Screen;
                Sysoplog ('Logged in IEMSI as '+ Caps (Thisuser.name) );
            end; { if else }
        end { if }
        else Print(Fstring.Namenotfound);
    end; { if }
end; { ? }

procedure Doshuttle;
var Cmd, Newmenucmd: Astr;
    Tries, I, J: integer;
    done, Loggedon, Ok, Cmdnothid, Cmdexists: boolean;
begin
    Nl;
    Printf ('preshutl');

    Gotname := false;
    Loggedon := false;

    Tryiemsilogon;

    Curmenu:= General.Menupath+ 'shuttle.mnu';
    Readin;

    I:= 1;
    Newmenucmd:= '';
    while ( (I<= Noc) and (Newmenucmd= '') ) do
    begin
        if (Menucommand^ [I].Ckeys= 'FIRSTCMD') then
        begin
            if (Aacs (Menucommand^ [I].Acs) ) then
            begin
                Newmenucmd:= 'FIRSTCMD';
                Domenuexec (Cmd, Newmenucmd);
            end; { if }
        end; { if }
        inc (I);
    end; { while }

    Tries:= 0;

    Chelplevel:= 2;
    repeat
        Tshuttlelogon:= 0;
        Mainmenuhandle (Cmd);
        {if (gotname) or (noneedname)) then
      begin}
        Newmenucmd:= ''; J := 0; done := false;
        repeat
            Fcmd (Cmd, J, Noc, Cmdexists, Cmdnothid);
            if (J <> 0) then
                if (Menucommand^ [J].Cmdkeys<> 'OP') and (Menucommand^ [J].Cmdkeys<> 'O2') and
                    (Menucommand^ [J].Cmdkeys [1] <> 'H') and (Menucommand^ [J].Cmdkeys [1] <> '-') and
                    (not Gotname) then
                begin
                    Prompt (Fstring.Shuttleprompt);
                    Finduser (Usernum);
                    if (Usernum >= 1) then
                    begin
                        I:= Usernum;
                        Usernum:= 0;
                        Olduser := Thisuser;
                        Loadurec (Thisuser, I);
                        Usernum:= I;
                        Getpws (Ok, Tries);
                        Gotname:= Ok;
                        Nl;
                        if (not Gotname) then
                        begin
                            Thisuser := Olduser;
                            Update_Screen;
                        end { if }
                        else
                        begin
                            if (Pd2Date (Thisuser.Laston) <> Date) then
                                with Thisuser do
                                begin
                                    Ontoday:= 0; Tltoday:= General.Timeallow [Sl];
                                    Timebankadd:= 0; Dltoday:= 0; Dlktoday:= 0;
                                    Timebankwith:= 0;
                                end; { with }
                            Useron:= true;
                            Update_Screen;
                            Sysoplog ('Logged on to Shuttle Menu as '+ Caps (Thisuser.name) );
                            Domenucommand (done, Menucommand^ [J].Cmdkeys+ Menucommand^ [J].Options, Newmenucmd);
                        end; { if else }
                    end { if }
                    else
                    begin
                        Print (Fstring.Ilogon);
                        inc (Tries);
                    end; { if else }
                end { if }
            else
                Domenucommand (done, Menucommand^ [J].Cmdkeys+ Menucommand^ [J].Options, Newmenucmd);
        until (J = 0) or (done);
        case Tshuttlelogon of
            1 : if (Thisuser.Sl > General.Validation ['A'].Newsl) then
                    Loggedon := true
                else
                begin
                    Sl1 ('* Illegal Shuttle Logon attempt');
                    Printf ('noshutt');
                    if (Nofile) then
                        Print ('You have not been validated yet.');
                    inc (Tries);
                end; { if else }
            2 : begin
                    Nl;                                     {bluewolf}
                    if (not General.Closedsystem) and Pynq(fstring.LogonAsNew) then
                    begin
                        Newuserinit;
                        Newuser;
                        if (Usernum > 0) and (not Hangup) then
                        begin
                            Gotname:= true;
                            Useron:= true;
                            Dailymaint;
                        end; { if }
                        Curmenu:= General.Menupath+ 'shuttle.mnu';
                        Readin;
                    end; { if }
                end; { case label }
        end; { case }
        {end;}
        if (Tries= General.Maxlogontries) then Hangup:= true;
    until (Loggedon) or (Hangup);
end; { ? }

function Getuser: boolean;
var
    Pw, S, Acsreq: Astr;
    Lng: longint;
    Tries, I, Ttimes, Zz, Eventnum: integer;
    done, Nu, Ok, Toomuch, Acsuser: boolean;
begin
    Wasnewuser:= false;
    fillchar(Thisuser, sizeof (Thisuser), 0);
    Thisuser.Tltoday:= 15;  Creditslastupdated := Getpackdatetime;
    Extratime:= 0; Freetime:= 0; Choptime:= 0; Credittime := 0;
    Chatchannel := 0;
    with Thisuser do begin
        Usernum:= - 1;
        name:= 'Nobody'; Realname:= 'Nobody';  Colorscheme := 1;
        Sl:= 0; Dsl:= 0; Ar:= [];
        flags:= General.Validation ['A'].Newac+ [Hotkey, Pause, Novice, color];
        Linelen:= 80; Pagelen:= 25;
    end; { with }
    Timeon := Getpackdatetime;
    Mread:= 0; Extratime:= 0; Freetime:= 0; Credittime := 0;
    Sl1 ('');
    S:= '^3Logon node '+ Cstr (Node) + '^5 ['+ Dat+ ']^4 (';
    if (Speed > 0) then begin
        S := S + Cstr (Actualspeed) + ' baud';
        if (Reliable) then S := S + '/Reliable)'
        else  S := S + ')';
        if (Calleridnumber > '') then begin
            if not Telnet then S := S + ' Number: ' + Calleridnumber
            else S := S + ' IP Number: ' + Calleridnumber;
        end; { if }
    end { if }
    else S := S + 'Keyboard)';
    Sl1(S);
    Nu:= false;
    Nl;
    Pw:= '';
    if (Actualspeed < General.Minimumbaud) and (Speed > 0) then begin
        if (General.Minbaudhitime - General.Minbaudlowtime > 1430) then begin
            if (General.Minbaudoverride <> '') then begin
                Prt ('Baud rate override password: ');
                Echo := false;
                input (S, 20);
                Echo := true;
            end; { if }
            if (General.Minbaudoverride = '') or (S <> General.Minbaudoverride) then begin
                Printf('nobaud.asc');
                if (Nofile) then Print('You must be using at least '+ Cstr (General.Minimumbaud) + ' baud to call this BBS.');
                Hangup:= true;
                exit;
            end; { if }
        end { if }
        else
            if (not Intime (Timer, General.Minbaudlowtime, General.Minbaudhitime) ) then begin
                if General.Minbaudoverride<> '' then begin
                    Prt ('Baud rate override password: ');
                    Echo:= false;
                    input (S, 20);
                    Echo:= true;
                end; { if }
                if (General.Minbaudoverride = '') or (S <> General.Minbaudoverride) then begin
                    Printf ('nobaudh.asc');
                    if (Nofile) then
                        Print ('Hours for those using less than '+ Cstr (General.Minimumbaud) + ' baud are from '+
                            Ctim (General.Minbaudlowtime) + ' to '+ Ctim (General.Minbaudhitime) );
                    Hangup:= true;
                    exit;
                end; { if }
            end { if }
            else
                if (not Hangup) then
                    if ( (General.Minbaudlowtime <> 0) or (General.Minbaudhitime <> 0) ) then begin
                        Printf ('yesbaudh.asc');
                        if (Nofile) then begin
                            Print ('NOTE: Callers at less than '+ Cstr (General.Minimumbaud) + ' baud are');
                            Print ('restricted to the following hours ONLY:');
                            Print ('  '+ Ctim (General.Minbaudlowtime) + ' to '+ Ctim (General.Minbaudhitime) );
                        end; { if }
                    end; { if }
    end; { if }
    Acsuser:= false;
    for I:= 1 to Numevents do
        with Events [I]^ do
            if ( (Etype= 'A') and (Active) and (Checkeventtime (I, 0) ) ) then begin
                Acsuser:= true;
                Acsreq:= Events [I]^.Execdata;
                Eventnum:= I;
            end; { if }
    Check_Ansi;
    Iemsi;
    Gotname := false;
    if ((General.Shuttlelog) and (not Fastlogon) and (not Hangup) ) then Doshuttle;
    Setc(7);
    Cls;
    Nl;
    Printf ('prelogon');
    if Acsuser then begin Printf ('acsea'+ Cstr (Eventnum) );
        if (Nofile) then Print ('Restricted: Only certain users allowed online at this time.'^M^J);
    end; { if }
    if (not Gotname) then Tryiemsilogon; { here  -1 }
    Ttimes:= 0; Tries:= 0;
    repeat
        repeat
            if (Usernum <> - 1) and (Ttimes >= General.Maxlogontries) then Hangup := true;
            Olduser := Thisuser;    { userrec }
            if (not Gotname) then begin
                if (Fstring.Note[1] <> '') then Print(Fstring.Note[1]);
                if (Fstring.Note[2] <> '') then Print(Fstring.Note[2]);
                if (Fstring.Lprompt <> '') then Prompt(Fstring.Lprompt);
                Finduser(Usernum);
                inc(Ttimes);
                if Acsuser and (Usernum = -1) then begin
                    Printf ('acseb'+ Cstr (Eventnum));
                    if (Nofile) then begin
                        Print ('This time window allows certain other users to get online.');
                        Print ('Please call back later, after it has ended.');
                    end; { if }
                    Hangup:= true;
                end; { if }
                if (not Hangup) and (Usernum = 0) then begin
                    Print(Fstring.Namenotfound);
                    if not (General.Shuttlelog) then
                        if (not General.Closedsystem) and Pynq(fstring.logonasnew) then Usernum := -1;
                    Nl;
                end; { if }
            end; { if }
        until (Usernum <> 0) or (Hangup);

        if Acsuser and (Usernum = -1) then begin
           Printf ('acseb'+ Cstr (Eventnum) );

           if (Nofile) then begin
               Print ('This time window allows certain other users to get online.');
               Print ('Please call back later, after it has ended.');
           end; { if }
           Hangup:= true;

        end; { if }

        Ok:= true; done:= false;
        if (not Hangup) then begin
            if (Usernum = -1) then begin
                Newuserinit;
                Nu := true;
                done:= true; Ok:= false;
            end { if }
            else begin
                I:= Usernum;
                Usernum:= 0;
                Loadurec(Thisuser, I);
                Usernum:= I;
                Temppause := (Pause in Thisuser.flags);
                Newdate := Pd2Date(Thisuser.Laston);
                Board := Thisuser.Lastmbase;
                Fileboard := Thisuser.Lastfbase;
                if (Autodetect in Thisuser.Sflags) then begin
                    if (Rip in Olduser.Sflags) then Thisuser.Sflags := Thisuser.Sflags + [Rip]
                    else Thisuser.Sflags := Thisuser.Sflags - [Rip];
                    if (Ansi in Olduser.flags) then Thisuser.flags := Thisuser.flags + [Ansi]
                    else Thisuser.flags := Thisuser.flags - [Ansi];
                    if (Avatar in Olduser.flags) then Thisuser.flags := Thisuser.flags + [Avatar]
                    else Thisuser.flags := Thisuser.flags - [Avatar];
                end; { if }
                if (Pd2Date(Thisuser.Laston) <> Date) then
                    with Thisuser do begin
                        Ontoday:= 0; Tltoday:= General.Timeallow [Sl];
                        Timebankadd:= 0; Dltoday:= 0; Dlktoday:= 0;
                        Timebankwith:= 0;
                    end { with }
                else if General.Percall then Thisuser.Tltoday := General.Timeallow [Thisuser.Sl];
                if (Thisuser.Expiration <= Getpackdatetime) and
                    (Thisuser.Expiration > 0) and
                    (Thisuser.Expireto in ['A'..'Z'] ) then begin
                    Autovalidate (Thisuser, Usernum, Thisuser.Expireto);
                    Sysoplog ('Subscription expired to level ' + Thisuser.Expireto);
                end; { if }
                if (Calleridnumber > '') then Thisuser.Callerid := Calleridnumber;
                Saveurec(Thisuser, Usernum);
                if (not Gotname) then Getpws(Ok, Tries);
                if (Ok) then done:= true;
                if not done then begin
                    Thisuser := Olduser;
                    Usernum := 0;
                    Update_Screen;
                end; { if }
            end; { if else }
        end; { if }
    until ( (done) or (Hangup) );
    reset (Schemefile);
    if (Thisuser.Colorscheme > 0) and
        (Thisuser.Colorscheme <= filesize (Schemefile) ) then seek (Schemefile, Thisuser.Colorscheme-1)
    else Thisuser.Colorscheme := 1;
    read (Schemefile, Scheme);
    close (Schemefile);
    if Acsuser and not (Aacs(Acsreq)) then begin
        Printf('acseb'+ Cstr (Eventnum) );
        if (Nofile) then begin
            Print ('This time window allows certain other users to get online.');
            Print ('Please call back later, after it has ended.');
        end; { if }
        Hangup:= true;
    end; { if }
    if not (Aacs(Liner.Logonacs) ) and (not Hangup) then begin
        Printf('nonode');
        if Nofile then Print ('You don''t have the required ACS to logon to this node!');
        Sysoplog (Thisuser.name+ ': Attempt to logon node '+ Cstr (Node) + ' without access.');
        Hangup:= true;
    end; { if }
    if ( (Lockedout in Thisuser.Sflags) and (not Hangup) ) then begin
        Printf (Thisuser.Lockedfile);
        Sysoplog (Thisuser.name+ ': Attempt to access system when locked out^7 <--');
        Hangup:= true;
    end; { if }
    if ((not Nu) and (not Hangup) ) then begin
        Toomuch:= false;
        if (Accountbalance < General.Creditminute) and (General.Creditminute > 0) and
           not (Fnocredits in Thisuser.flags) then begin
            Printf ('nocreds');
            Sysoplog (Thisuser.name+ ': insufficient credits for logon.');
            if (Nofile) then Print ('You have insufficient credits for online time.');
            if (General.Creditfreetime < 1) then
                Hangup := true
            else begin
                Thisuser.Tltoday := General.Creditfreetime div General.Creditminute;
                inc(Thisuser.Credit, General.Creditfreetime);
            end; { if else }
        end { if }
        else
            if ( ( (Rlogon in Thisuser.flags) or (General.Callallow [Thisuser.Sl] = 1) ) and
                    (Thisuser.Ontoday>= 1) and (Pd2Date (Thisuser.Laston) = Date) )
            then begin
                Printf ('2manycal');
                if (Nofile) then Print ('You can only log on once per day.');
                Toomuch:= true;
            end { if } else
                if ( (Thisuser.Ontoday>= General.Callallow [Thisuser.Sl] ) and
                        (Pd2Date (Thisuser.Laston) = Date) ) then begin
                    Printf ('2manycal');
                    if (Nofile) then
                        Print ('You can only log on '+ Cstr (General.Callallow [Thisuser.Sl] ) + ' times per day.');
                    Toomuch:= true;
                end { if } else
                    if (Thisuser.Tltoday <= 0) and not (General.Percall) then begin
                        Printf ('notlefta');
                        if (Nofile) then
                            Prompt ('You can only log on for '+ Cstr (General.Timeallow [Thisuser.Sl] ) + ' minutes per day.');
                        Toomuch:= true;
                        if (Thisuser.Timebank> 0) then begin
                            Print (^M^J^M^J'^5However, you have '+ Cstr (Thisuser.Timebank) +
                                ' minutes left in your Time Bank.');
                            Dyny:= true;
                            if Pynq ('Withdraw from Time Bank? ') then begin
                                Prt ('Withdraw how many minutes? '); Inu (Zz); Lng:= Zz;
                                if (Lng> 0) then begin
                                    if (Lng> Thisuser.Timebank) then Lng:= Thisuser.Timebank;
                                    dec (Thisuser.Timebankadd, Lng);
                                    if (Thisuser.Timebankadd< 0) then Thisuser.Timebankadd:= 0;
                                    dec (Thisuser.Timebank, Lng);
                                    inc (Thisuser.Tltoday, Lng);
                                    Print ('^5In your account: ^3'+ Cstr (Thisuser.Timebank) +
                                        '^5   Time left online: ^3' + Formattedtime (Nsl) );
                                    Sysoplog ('TimeBank: Withdrew '+ Cstr (Lng) + ' minutes at logon.');
                                end; { if }
                            end; { if }
                            if (Nsl>= 0) then Toomuch:= false else Print ('Hanging up.');
                        end; { if }
                    end; { if }
        if (Toomuch) then begin
            Sl1 (Thisuser.name+ ' Attempt to exceed time/call limits.');
            Hangup:= true;
        end; { if }
        if (Tries= General.Maxlogontries) then Hangup:= true;
        if (not Hangup) then inc (Thisuser.Ontoday);
    end; { if }
    if ( Usernum > 0 ) and (not Hangup) then begin
        Getuser:= Nu;
        if (not Fastlogon) then begin
            Printf ('welcome');
            if (not Nofile) then Pausescr (false);
            I:= 0;
            repeat
                inc (I);
                Printf ('welcome'+ Cstr (I) );
                if (not Nofile) then Pausescr(false);
            until (I= 9) or (Nofile) or (Hangup);
        end; { if }
        Useron:= true;
        Update_Screen;
        Update_Node(254);
        Inittrapfile;
        Useron:= false;
        Cls;
    end; { if }
    if (Hangup) then Getuser:= false;
end; { ? }


end.
