{$A+,B-,D-,E-,F+,I-,L-,N-,O+,R-,S+,V-}

unit file0;

interface

uses crt,dos,overlay, myio, common;

procedure countdown;
function align(const fn:astr):astr;
function baddlpath:boolean;
function badulpath:boolean;
function existdir(fn:astr):boolean;
procedure fileinfo(var f:ulfrec; editing:boolean);
procedure initfileboard;
function fit(const f1,f2:astr):boolean;
procedure gfn(var fn:astr);
function isgifdesc(const d:astr):boolean;
function isgifext(const fn:astr):boolean;
function isul(const s:astr):boolean;
function iswildcard(const s:astr):boolean;
procedure nrecno(const fn:astr; var rn:integer);
procedure lrecno(const fn:astr; var rn:integer);
procedure recno(fn:astr; var rn:integer);
function tcheck(s:longint; i:integer):boolean;
procedure verbfileinfo(var pt:longint; editing:boolean);

implementation

function Align (const Fn: Astr): Astr;
var F, E: Astr; C, C1: integer;
begin
   C:= pos ('.', Fn);
   if (C= 0) then begin
      F:= Fn; E:= '   ';
   end { if }
   else begin
      F:= copy (Fn, 1, C- 1); E:= copy (Fn, C+ 1, 3);
   end; { if else }
   F:= Mln (F, 8);
   E:= Mln (E, 3);
   C:= pos ('*', F); if (C<> 0) then for C1:= C to 8 do F [C1] := '?';
   C:= pos ('*', E); if (C<> 0) then for C1:= C to 3 do E [C1] := '?';
   C:= pos (' ', F); if (C<> 0) then for C1:= C to 8 do F [C1] := ' ';
   C:= pos (' ', E); if (C<> 0) then for C1:= C to 3 do E [C1] := ' ';
   Align:= F+ '.'+ E;
end; { ? }

function Baddlpath: boolean;
begin
   if (Badfpath) and Aacs (Memuboard.Acs) then begin
      Print (^M^J'^7File base #'+ Cstr (Fileboard) + ': Unable to perform command.');
      Sysoplog ('^5Bad DL file path: "'+ Memuboard.Dlpath+ '".');
      Print ('^5Please inform the SysOp.');
      Sysoplog ('Invalid DL path (file base #'+ Cstr (Fileboard) + '): "'+
         Memuboard.Dlpath+ '"');
   end; { if }
   Baddlpath:= Badfpath;
end; { ? }

function Badulpath: boolean;
begin
   if (Badufpath) then begin
      Print (^M^J'^7File base #'+ Cstr (Fileboard) + ': Unable to perform command.');
      Sysoplog ('^5Bad UL file path: "'+ Memuboard.Ulpath+ '".');
      Print ('^5Please inform the SysOp.');
      Sysoplog ('Invalid UL path (file base #'+ Cstr (Fileboard) + '): "'+
         Memuboard.Ulpath+ '"');
   end; { if }
   Badulpath:= Badufpath;
end; { ? }

function Existdir (Fn: Astr): boolean;
var Dirinfo: searchrec;
begin
   while (Fn [length (Fn) ] = '\') do dec (Fn [0] );
   if (length (Fn) = 2) and (Fn [2] = ':') then Existdir := true
   else begin
      findfirst (Fn, anyfile, Dirinfo);
      Existdir:= (doserror= 0) and (Dirinfo.attr and $10= $10);
   end; { if else }
end; { ? }

procedure Initfileboard; { loads in memuboard ... }
var
   S: Astr;
   Index: integer;
begin
   Loadfileboard (Fileboard);
   S:= Memuboard.Dlpath;
   dec (S [0] );
   if ( (length (S) = 2) and (S [2] = ':') ) then Badfpath := false
   else if not (Fbcdrom in Memuboard.Fbstat) then Badfpath := not Existdir (S)
   else Badfpath := false;

   S:= Memuboard.Ulpath;
   dec (S [0] );

   if ( (length (S) = 2) and (S [2] = ':') ) then Badufpath:= false
   else if not (Fbcdrom in Memuboard.Fbstat) then Badufpath := not Existdir (S)
   else Badufpath := false;

   if (not Dirfileopen1) then
      if ( filerec (Dirfile).mode <> fmclosed) then close (Dirfile);

   Dirfileopen1:= false;

   if (Fbdirdlpath in Memuboard.Fbstat) then assign (Dirfile, Memuboard.Dlpath+ Memuboard.Filename+ '.DIR')
   else assign (Dirfile, General.Datapath+ Memuboard.Filename+ '.DIR');
   reset (Dirfile);

   if (ioresult = 2) then rewrite (Dirfile);

   if (ioresult <> 0) then begin
      Sysoplog ('error opening '+ Memuboard.Filename+ '.DIR');
      exit;
   end; { if }

   if (Fbdirdlpath in Memuboard.Fbstat) then assign (Scnfile, Memuboard.Dlpath+ Memuboard.Filename+ '.SCN')
   else assign (Scnfile, General.Datapath+ Memuboard.Filename+ '.SCN');
   reset (Scnfile);

   if (ioresult = 2) then rewrite (Scnfile);

   if (ioresult <> 0) then begin
      Sysoplog ('error opening '+ Memuboard.Filename+ '.DIR');
      exit;
   end; { if }

   if (Usernum - 1 >= filesize (Scnfile) ) then begin
      seek (Scnfile, filesize (Scnfile) );
      Newscanfbase := true;
      for Index := filesize (Scnfile) to Usernum - 1 do write (Scnfile, Newscanfbase);
   end { if }
   else begin
      seek (Scnfile, Usernum - 1);
      read (Scnfile, Newscanfbase);
   end; { if else }

   close (Scnfile);

   Lasterror := ioresult;

   Bnp:= false;
end; { ? }

procedure fileinfo(var f:ulfrec; editing:boolean);
var
  s:astr;
  s2:string[5];
  x:longint;
  i,j:integer;
begin
  j := 0;
  with f do
    begin
      if (editing) then
        s2 := '1. '
      else
        s2 := '';
      printacr('^1' + s2 + 'Filename         : ^0'+sqoutsp(filename));
      if (editing) then
        s2 := '2. ';
      printacr('^1' + s2 + 'File size        : ^2'+ConvertBytes(longint(blocks) * 128 + sizemod));
      if (editing) then
        s2 := '3. ';
      printacr('^1' + s2 + 'Description      : ^9' + description);
      if (f.vpointer <> -1) then verbfileinfo(f.vpointer, editing);
      if (editing) then s2 := '4. ';
      printacr('^1' + s2 + 'Uploaded by      : ^4' + caps(stowner));
      if (editing) then s2 := '5. ';
      printacr('^1' + s2 + 'Uploaded on      : ^5' + date);
      if (editing) then s2 := '6. ';
      printacr('^1' + s2 + 'Times downloaded : ^5' + FormatNumber(Downloaded));
      if (not editing) then
        printacr('^1Time to download : ^5' + ctim(128 * longint(blocks) div rate));
      if (editing) then s2 := '7. ';
      s := '^1' + s2 + 'Credit cost      : ^4';
      if (credits > 0) then s := s + FormatNumber(credits)
      else s := s + 'FREE';
      if (notval in filestat) then s:=s+' ^8'+'<NV>';
      if (isrequest in filestat) then s:=s+' ^9'+'Ask (Request File)';
      if (resumelater in filestat) then s:=s+' ^7'+'Resume later';
      if (hatched in filestat) then s:=s+' ^7'+'Hatched';
      printacr(s);
    end;
end;

function fit(const f1,f2:astr):boolean;
var tf:boolean; c:byte;
begin
  tf:=TRUE;
  for c:=1 to 12 do
      if (f1[c]<>f2[c]) and (f1[c]<>'?') then tf:=FALSE;
  if f2='' then tf:=FALSE;
  fit:=tf;
end;

procedure gfn(var fn:astr);
begin
  print(fstring.gfnline1);
  prt(fstring.gfnline2); input(fn,12);
  if (pos('.',fn)=0) then fn:=fn+'*.*';
  fn:=align(fn);
end;

function isgifdesc(const d:astr):boolean;
begin
  isgifdesc:=((d[1] = '(') and (pos('x',d) in [1..7]) and
              (pos('c)',d)<>0));
end;

function isgifext(const fn:astr):boolean;
begin
  isgifext:=(allcaps(copy(sqoutsp(stripname(fn)),length(fn)-2,3))='GIF');
end;

function isul(const s:astr):boolean;
begin
  isul:=((pos('/',s)<>0) or (pos('\',s)<>0) or (pos(':',s)<>0) or (pos('|',s)<>0));
end;

function iswildcard(const s:astr):boolean;
begin
  iswildcard:=((pos('*',s)<>0) or (pos('?',s)<>0));
end;

procedure lrecno(const fn:astr; var rn:integer);
var
  c:integer;
  f:ulfrec;
begin
  rn := 0;
  if (lrn <= filesize(DirFile)) and (lrn >= 0) then begin
      c := lrn - 1;
      while (c >= 0) and (rn = 0) do begin
             seek(DirFile,c);
             read(DirFile,f);
             if fit(lfn,f.filename) then rn := c;
             dec(c);
      end;
      lrn := rn;
    end
  else rn := -1;
  Lasterror := IOResult;
end;

procedure nrecno(const fn:astr; var rn:integer);
var
  c:integer;
  f:ulfrec;
begin
  rn := 0;
  if (lrn < filesize(DirFile)) and (lrn >= -1) then begin
      c := lrn + 1;
      while (c < filesize(DirFile)) and (rn = 0) do begin
             seek(DirFile,c);
             read(DirFile,f);
             if fit(lfn,f.filename) then rn := c + 1;
             inc(c);
      end;
      dec(rn);
      lrn := rn;
  end
  else rn := -1;
  Lasterror := IOResult;
end;

procedure recno(fn:astr; var rn:integer);
var f:ulfrec;
    c:integer;
begin
  fn:=align(fn);
  initfileboard;
  rn:=0; c:=0;
  while (c < filesize(DirFile)) and (rn=0) do begin
    seek(DirFile,c); read(DirFile,f);
    if fit(fn,f.filename) then rn:=c+1;
    inc(c);
  end;
  dec(rn);
  lrn:=rn;
  lfn:=fn;
  Lasterror := IOResult;
end;

function tcheck(s:longint; i:integer):boolean;
var
  r:longint;
begin
  r := timer - s;
  if (r < 0) then r := r + 86400;

  if (r > i) then tcheck := FALSE
  else tcheck := TRUE;
end;

procedure verbfileinfo(var pt:longint; editing:boolean);
var v:verbrec;
    i:integer;
    s:astr;
    vfo:boolean;
begin
 v.descr[1]:='';
 if pt <> -1 then begin
    vfo:=( filerec(verbf).mode <> fmclosed);
    if not vfo then reset(verbf);
    if ioresult = 0 then begin
       seek(verbf,pt);
       read(verbf,v);
       if (ioresult = 0) then
           with v do
               for i := 1 to MAXEXTDESC do
               if (descr[i]='') then break
               else begin
                  s:='^1';
                  if (editing) then s := s + '   ';
                  if (i=1) then s := s + 'Extended       '+IntToStr(i)+' : '
                  else s:=s+'               '+IntToStr(i)+' : ';
                  s:=s+'^9'+descr[i];
                  printacr(s);
           end
       else pt := -1;
       if (not vfo) then close(verbf);
    end;
  end;
  if editing then
     if pt = -1 then printacr('^5   No extended description.')
     else if (v.descr[1]='') then printacr('^7   No extended description.^2 ('+cstr(pt)+')');
end;


procedure countdown;
var
  i:word;
  c:char;
  st:longint;
begin
  print(^M^J'Hit [Enter] to logoff now.');
  print('Hit [Esc] to abort logoff.'^M^J);
  prompt('|12Hanging up in : ^99');
  st:=timer; i := 9;
  c:=#0;
  while (i > 0) and not (c in [#13,#27]) and not (hangup) do begin
        if not empty then c := char(inkey);
        if (timer <> st) then begin
            dec(i);
            prompt(^H+cstr(i));
            st := timer;
        end
        else
          asm
            int 28h
          end;
  end;
  if (c <> #27) then begin
      hangup := TRUE;
      outcom := FALSE;
  end;
end;

end.
