{$R-,S-,I-,D+,T+,F-,V+,B-,N-,L+ }
UNIT fossil;
(* Interface to one serial port, set by openfossil, only *)
(* Undefined operation if port has not been opened       *)

INTERFACE

  FUNCTION  openfossil(pnum : word) : boolean; (* true if device loaded *)
  PROCEDURE closefossil;
  PROCEDURE setbaudrate(baud : word);     (* no action for invalid rate *)
  PROCEDURE sendchar(a : char);
  FUNCTION  rcvchar : char;
  FUNCTION  serialstatus : word;            (* bit assortment - see X00 *)
  PROCEDURE setdtr(onoff : boolean);
  PROCEDURE flushoutput;
  PROCEDURE purgeoutput;
  PROCEDURE flushinput;
  FUNCTION  carrier : boolean;
  FUNCTION  rcvready : boolean;

IMPLEMENTATION

  VAR
    port   : word;
    isopen : boolean;

  (* 1---------------1 *)

  PROCEDURE foslink(ax, dx : word);
  (* Macro to speed up fossil communications *)

    inline($5a/         (* pop dx *)
           $58/         (* pop ax *)
           $cd/$14);    (* int 14h *)

  (* 1---------------1 *)

  FUNCTION foslinkf(ax, dx : word) : word;
  (* Macro to speed up fossil communications *)

    inline($5a/         (* pop dx *)
           $58/         (* pop ax *)
           $cd/$14);    (* int 14h *)

  (* 1---------------1 *)

  PROCEDURE setbaudrate(baud : word);

    VAR
      ax    : word;

    BEGIN (* setbaudrate *)
    IF      baud =   300 THEN ax := $43
    ELSE IF baud =   600 THEN ax := $63  (* ah := 0 *)
    ELSE IF baud =  1200 THEN ax := $83
    ELSE IF baud =  2400 THEN ax := $A3
    ELSE IF baud =  4800 THEN ax := $C3
    ELSE IF baud =  9600 THEN ax := $E3
    ELSE IF baud = 19200 THEN ax := $03
    ELSE IF baud = 38400 THEN ax := $23
    ELSE                      ax := 0;
    IF (ax <> 0) AND isopen THEN foslink(ax, port);
    END; (* setbaudrate *)

  (* 1---------------1 *)

  PROCEDURE sendchar(a : char);

    BEGIN (* sendchar *)
    IF isopen THEN foslink($100 + ord(a), port);
    END; (* sendchar *)

  (* 1---------------1 *)

  FUNCTION rcvchar : char;

    BEGIN (* rcvchar *)
    IF isopen THEN rcvchar := chr(foslinkf($200, port))
    ELSE rcvchar := chr(0);
    END; (* rcvchar *)

  (* 1---------------1 *)

  FUNCTION serialstatus : word;

    BEGIN (* serialstatus *)
    IF isopen THEN serialstatus := foslinkf($300, port)
    ELSE serialstatus := 0;
    END; (* serialstatus *)

  (* 1---------------1 *)

  FUNCTION openfossil(pnum : word) : boolean; (* true if device loaded *)

    BEGIN (* openfossil *)
    port := pnum;
    isopen := foslinkf($400, port) = $1954;
    openfossil := isopen;
    END; (* openfossil *)

  (* 1---------------1 *)

  PROCEDURE closefossil;

    BEGIN (* closefossil *)
    IF isopen THEN foslink($500, port);
    isopen := false;
    END; (* closefossil *)

  (* 1---------------1 *)

  PROCEDURE setdtr(onoff : boolean);

    BEGIN (* setdtr *)
    IF isopen THEN foslink($600 + ord(onoff), port);
    END; (* setdtr *)

  (* 1---------------1 *)

  PROCEDURE flushoutput;

    BEGIN (* flushoutput *)
    IF isopen THEN foslink($800, port);
    END; (* flushoutput *)

  (* 1---------------1 *)

  PROCEDURE purgeoutput;

    BEGIN (* purgeoutput *)
    IF isopen THEN foslink($900, port);
    END; (* purgeoutput *)

  (* 1---------------1 *)

  PROCEDURE flushinput;

    BEGIN (* flushinput *)
    IF isopen THEN foslink($0a00, port);
    END; (* flushinput *)

  (* 1---------------1 *)

  FUNCTION carrier : boolean;

    BEGIN (* carrier *)
    carrier := isopen AND ((foslinkf($300, port) AND $80) > 0)
    END; (* carrier *)

  (* 1---------------1 *)

  FUNCTION rcvready : boolean;

    BEGIN (* rcvready *)
    rcvready := isopen AND ((foslinkf($300, port) AND $100) <> 0);
    END; (* rcvready *)

  (* 1---------------1 *)

  BEGIN
  isopen := false;
  END. (* fossil *)