{-----------------------------------------------------------------------}
{-                          SHARERES.PAS v1.00                         -}
{- Tests the results of fileaccess with and without LFN v1.07 or later -}
{-               Written by Andreas Killer, Germany, NRW               -}
{-        homepage: http://home.t-online.de/home/andreas.killer        -}
{-----------------------------------------------------------------------}

{$I-}
uses
  Lfn;
const
  FileName = 'TEST.DAT';
var
  T : array[1..2] of Text;

  procedure TestTEXTAccess(Open1, Open2 : Boolean);
  var
    IO : Integer;

    procedure TestIO;
    begin
      IO := IoResult;
      Write(IO:6, ' ');
    end;

    procedure TEXTAccessTest(Which : Byte; ReadWrite : Boolean);
    var
      S : String;
    begin
      if ReadWrite then begin
        Write('Read':7, ',');
        Read(T[Which], S);
        TestIO;
      end
      else begin
        Write('Write':7, ',');
        S := 'test';
        Write(T[Which], S);
        TestIO;
      end;
    end;

    procedure TEXTOpenTest(Which : Byte; Open, RW : Boolean);
    begin
      if Open then begin
        Write('Reset':8, ',');
        Reset(T[Which]);
        TestIO;

        if IO = 0 then
          TEXTAccessTest(Which, RW)
        else
          Write('-':7, ',', '-':6, ' ');
      end
      else begin
        Write('Rewrite':8, ',');
        Rewrite(T[Which]);
        TestIO;

        if IO = 0 then
          TEXTAccessTest(Which, RW)
        else
          Write('-':7, ',', '-':6, ' ');
      end;
    end;

    procedure MakeFile;
    var
      S : String;
    begin
      Rewrite(T[1]);
      S := 'Hello World';
      Write(T[1], S);
      Close(T[1]);
      InOutRes := 0;
    end;

  var
    A, B : Boolean;
  begin
    for A := False to True do
      for B := False to True do begin
        MakeFile;
        TEXTOpenTest(1, Open1, A);
        TEXTOpenTest(2, Open2, B);
        Close(T[1]);
        Close(T[2]);
        IO := IoResult;
        WriteLn;
      end;
  end;

type
  StringFile = file of String;
var
  F : array[1..2] of StringFile;

  procedure TestFILEAccess(Open1, Open2 : Boolean);
  var
    IO : Integer;

    procedure TestIO;
    begin
      IO := IoResult;
      Write(IO:6, ' ');
    end;

    procedure FILEAccessTest(Which : Byte; ReadWrite : Boolean);
    var
      S : String;
    begin
      if ReadWrite then begin
        Write('Read':7, ',');
        Read(F[Which], S);
        TestIO;
      end
      else begin
        Write('Write':7, ',');
        S := 'test';
        Write(F[Which], S);
        TestIO;
      end;
    end;

    procedure FILEOpenTest(Which : Byte; Open, RW : Boolean);
    begin
      if Open then begin
        Write('Reset':8, ',');
        Reset(F[Which]);
        TestIO;

        if IO = 0 then
          FILEAccessTest(Which, RW)
        else
          Write('-':7, ',', '-':6, ' ');
      end
      else begin
        Write('Rewrite':8, ',');
        Rewrite(F[Which]);
        TestIO;

        if IO = 0 then
          FILEAccessTest(Which, RW)
        else
          Write('-':7, ',', '-':6, ' ');
      end;
    end;

    procedure MakeFile;
    var
      SaveMode : Word;
      S : String;
    begin
      SaveMode := FileMode;
      FileMode := 1;
      Rewrite(F[1]);
      S := 'Hello World';
      Write(F[1], S);
      Close(F[1]);
      InOutRes := 0;
      FileMode := SaveMode;
    end;

  var
    A, B : Boolean;
  begin
    for A := False to True do
      for B := False to True do begin
        MakeFile;
        Write(FileMode:8, ' ');
        FILEOpenTest(1, Open1, A);
        FILEOpenTest(2, Open2, B);
        Close(F[1]);
        Close(F[2]);
        IO := IoResult;
        WriteLn;
      end;
  end;

  procedure TestAllFileModes;
  var
    A, B : Boolean;
  begin
    WriteLn('Results when accessing a untyped or typed File:');
    WriteLn;
    WriteLn('FileMode    File1, IORes  Access, IOres    File2, IORes  Access, IOres ');
    for FileMode := 0 to 2 do
      for A := False to True do
        for B := False to True do
          TestFILEAccess(A, B);

    WriteLn;
    WriteLn('Results when accessing a textfile:');
    WriteLn;
    WriteLn('   File1, IORes  Access, IOres    File2, IORes  Access, IOres ');
    for A := False to True do
      for B := False to True do
        TestTEXTAccess(A, B);
    WriteLn;
  end;

begin
  Assign(F[1], FileName);
  Assign(F[2], FileName);
  Assign(T[1], FileName);
  Assign(T[2], FileName);

  WriteLn('Try access all situations with LFN:');
  WriteLn;
  TestAllFileModes;

  WriteLn('Try access all situations without LFN:');
  WriteLn;
  DisableLFN;
  TestAllFileModes;

  Erase(F[1]);
end.
