{$F+,I-,O-,R-,S-,V-,G+,N+,X+}
{$IFDEF Ver70}
{$T-}                                                                  {!!.10}
{$ENDIF}

{---
  Vor dem Benutzen dieser Unit oder ndern eines DEFINE's LFN.GER lesen!
  Ein deutscher Interfaceteils ist in LFNINT.GER verfgbar.
  Eine deutsche FILE_ID.DIZ ist in LFN_IDG.DIZ verfgbar.
  Siehe WHATSNEW.GER fr die nderungen nach der letzten Version.

  Before integrate this unit or changing any DEFINE's read LFN.ENG!
  An english interfacepart is in LFNINT.ENG avaible.
  An english FILE_ID.DIZ is in LFN_IDE.DIZ avaible.
  See WHATSNEW.ENG for the changes after the last version.
---}

{-DEFINE's die das Verhalten dieser Unit bestimen}
{$I LFN.IN0}

{$IFDEF Dpmi}
  {$C FIXED PRELOAD PERMANENT}
{$ENDIF}

{$IFDEF Windows}
  {$C FIXED PRELOAD PERMANENT}
{$ENDIF}

unit
  LFN;

  {--------------------------------------------------------------------}
  {-                   LFN.PAS v1.10 Final Release                    -}
  {-     Unterstztung der langen Dateinamen unter Win95/98 fr       -}
  {-               TP6, TP/BP7 und kompatible Compiler.               -}
  {-           Geschrieben von Andreas Killer, Germany, NRW           -}
  {-      homepage: http://home.t-online.de/home/andreas.killer       -}
  {--------------------------------------------------------------------}

interface
uses
{$IFDEF UseOpro}
  OpString, OpInline,
{$ENDIF}
{$IFDEF Windows}
  WinProcs,
{$ENDIF}
{$IFDEF UseDos}
  Dos
  {$IFDEF UseWinDos} , {$ELSE}
    {$IFDEF Ver70} , Strings ; {$ELSE} ; {$ENDIF}
  {$ENDIF}
{$ENDIF}
{$IFDEF UseWinDos}
  WinDos, Strings;
{$ENDIF}

{$IFDEF Ver60}
type
  PChar = ^Char;                                                       {!!.07}
{$ENDIF}

const
  {-Werden unter Win95 Dateien erstellt, so knnen diese mit einem bestimmten
    Alias (die Zahl hinter dem ~ z.B.: ABCDEF~1) versehen werden, um unter
    MSDOS die Datei noch identifizieren zu knnen. 0 = automatisch vergeben,
    bzw. ermitteln.}
  FileAlias : Byte = 0;

{$IFDEF AssignLongName}
type
  {-Anmerkung: in "var F" wird die jeweilige Filevariable bergeben}
  AssignNewProc = procedure(var F; FName : PChar);                     {!!.07}
  AssignGetNameFunc = function(var F) : Pointer;
  AssignDisposeProc = procedure(var F);
var
  {-Diese Procedure wird zum Anlegen des Dateinamens auf dem Heap benutzt.}
  AssignNew : AssignNewProc;
  {-Liefert einen Zeiger auf den Dateinamen zurck}
  AssignGetName : AssignGetNameFunc;
  {-Gibt den durch AssignNew belegten Heap wieder frei.}
  AssignDispose : AssignDisposeProc;
{$ENDIF}

{.F-}
const
  {-Mgliche zustzliche Flags fr Filemode:}
  fmDenyAll    = $0010;  {-file sharing mode}
  fmDenyWrite  = $0020;  {-file sharing mode}
  fmDenyRead   = $0030;  {-file sharing mode}
  fmDenyNone   = $0040;  {-file sharing mode}
  fmNoInherit  = $0080;  {-no-inherit flag}
  fmNoBuffer   = $0100;  {-do not buffer data (requires that all reads/writes be exact physical sectors)}
  fmNoCompress = $0200;  {-do not compress file even if volume normally compresses files}
  fmUseAlias   = $0400;  {-use alias hint in DI as numeric tail for short-name alias}
  {-Anmerkung: fmUseAlias wird automatisch gesetzt wenn FileAlias einen Wert <> 0 hat.}
  fmError24    = $2000;  {-return error code instead of generating INT 24h if critical error while opening file}
  fmCommit     = $4000;  {-commit file after every write operation}
{.F+}

const
  {-Mgliche zustzliche Trennzeichen in der Kommandozeile (siehe LFN.GER)}
  ParamDelims : set of Char = ['"'];
var
  {-Zeigt auf die Kommandozeile (siehe EXREDIR.PAS)}
  ParamPtr : ^String;

function ParamLine : String;
  {-Liefert die komplette Kommandozeile zurck}
function ParamPosition(Index : Word) : Word;
  {-Liefert die Position eines Parameters in der Kommandozeile}

  {============================== Abschnitt 1: =============================}
  {======== Alternative Funktionen, die als Ersatz konzipiert sind: ========}
  {=========================================================================}

type
  {-Dieser Record musste erweitert werden, da DOS.SearchRec nur
    12 stellige Dateinamen ermglicht.}
  SearchRec =
    record
      Fill : array[1..21] of Byte;
      Attr : Byte;
      Time : LongInt;
      Size : LongInt;
      {$IFDEF CompatToDos}
      Name : String;              {-String des langen Dateinamens}
      {$ELSE}
      Name : array[0..259] of Char; {-AsciiZ des langen Dateinamens}
      {$ENDIF}
      Handle : Word;              {-Filehandle fr Find-First,-Next,-Close}
    end;

{$IFDEF CompatToDos}
procedure FindFirst(Path : String; Attr : Word; var F : SearchRec);
  {-Sucht ein Verzeichnis nach dem ersten Vorkommen eines Dateinamens ab.}
{$ELSE}
type
  TSearchRec = SearchRec;

procedure FindFirst(Path : PChar; Attr : Word; var F : TSearchRec);
  {-Sucht ein Verzeichnis nach dem ersten Vorkommen eines Dateinamens ab.}
{$ENDIF}

procedure FindNext(var F : SearchRec);
  {-Setzt eine mit FindFirst begonnene Suche nach der dort angegebenen
    Datei fort.}
procedure FindClose(var F : SearchRec);
  {-Beendet eine mit FindFirst begonnene Suche. FindClose wird von FindNext
    automatisch aufgerufen, wenn keine weitere Datei mehr gefunden wurde.
    Achtung: Wird dieser Zustand NICHT erreicht, dann MUSS FindClose explizit
    aufgerufen werden um den von FindFirst belegten FileHandle wieder
    freizugeben. Unter DOS hat diese Procedure keine Auswirkung.}

type
  PathStr = String;                                                    {!!.05}
  DirStr = String;
  NameStr = String;
  ExtStr = String;

{$IFDEF UseDos}
procedure FSplit(Path : String; var Dir : DirStr; var Name : NameStr;
                 var Ext : ExtStr);
  {-Zerlegt einen vollstndigen Dateinamen in seine drei Komponenten.}
function FExpand(Path : PathStr) : PathStr;
   {-Erweitert einen unvollstndig angegebenen Dateinamen um den
     dazugehrigen Suchpfad.}
{$ENDIF}

function DiskFree(Drive : Byte) :
  {$IFDEF DFSReturnComp} Comp ; {$ELSE} LongInt; {$ENDIF}
  {-Liefert die Gre des freien Speicherplatzes auf einem Laufwerk zurck.}
function DiskSize(Drive : Byte) :
  {$IFDEF DFSReturnComp} Comp ; {$ELSE} LongInt; {$ENDIF}
  {-Liefert die Gesamtkapazitt eines Laufwerks zurck.}

{---
  Anmerkung: DiskFree/DiskSize rufen AX=$7303/INT $21 auf. Diese Funktion
  liefert im Programm unter Windows/DOS7.x einwandfreie Ergebnisse. Wenn man
  allerdings das Prg in der IDE (Turbo oder BP) entwickelt, dann liefern sie
  bei mir nur nach dem ersten Run das korrekte Ergebnis. Warum entzieht sich
  meiner Kenntnis.
---}

  {============================== Abschnitt 2: =============================}
  {==== Erweiterte Funktionen, auch unter DOS lauffhig (siehe LFN.GER): ===}
  {=========================================================================}

procedure SetCreateFTime(var F; Time : LongInt);
  {-Setzt Datum und Uhrzeit der Erstellung einer Datei.}
procedure GetCreateFTime(var F; var Time : LongInt);
  {-Ermittelt Datum und Uhrzeit der Erstellung einer Datei.}

{$IFDEF UseDos}
function TruePathName(PathName : String) : String;
  {-Liefert den krzesten Pfad zu einer Datei, oder erweitert den
    Dateinamen mit dem momentanen Verzeichnis}
function GetShortName(PathName : String) : String;
  {-Wandelt einen langen Pfadnamen in das 8.3 Format}
function GetLongName(PathName : String) : String;
  {-Wandelt einen kurzen Pfadnamen (im 8.3 Format) in einen
    langen um (unter MSDOS gibt diese Funktion den 8.3 Namen zurck)}
{$ENDIF}

{$IFDEF UseWinDos}
function TruePathNamePChar(Dest, PathName : PChar) : PChar;
  {-Liefert den krzesten Pfad zu einer Datei, oder erweitert den
    Dateinamen mit dem momentanen Verzeichnis}
function GetShortNamePChar(Dest, PathName : PChar) : PChar;
  {-Wandelt einen langen Pfadnamen in das 8.3 Format}
function GetLongNamePChar(Dest, PathName : PChar) : PChar;
  {-Wandelt einen kurzen Pfadnamen (im 8.3 Format) in einen langen um}
{$ENDIF}

procedure FlushDrive(Drive : Byte);
  {-Erzwingt das Schreiben der Buffers und des Cache.
      Fr Drive gilt: 0 = aktuelles Laufwerk, 1 = Laufwerk A, usw.}
procedure ResetDrive(Drive : Byte);
  {-Erzwingt das Schreiben und Lschen der Buffers und des Cache.
      Fr Drive gilt: 0 = aktuelles Laufwerk, 1 = Laufwerk A, usw.}
function IsNetworkDrive(Drive : Char) : Boolean;
  {-True wenn Drive ein Laufwerk im Netzwerk ist}

  {========================================================================}

function Win95_Aktiv : Boolean;
  {-Ermittelt ob Win95 aktiv ist}
procedure EnableLFN;
  {-Aktiviert die Untersttzung fr lange Dateinamen}
procedure DisableLFN;
  {-Deaktiviert die Untersttzung fr lange Dateinamen}

  {========================================================================}

implementation
{$F+,I-}
{$IFDEF UseWinDos}
type
  Registers = TRegisters;
  FileRec = TFileRec;
  TextRec = TTextRec;
  TextBuf = TTextBuf;
const
  {-Gre temporrer lokal genutzter PChars}
  PCharSize = 512;
{$ENDIF}
type
  PatchRec =
    record
      Code : Byte;
      Addr : Pointer;
    end;

  SpecialPatchRec =
    record
      Instr : array[0..1] of Byte;
      Code : Byte;
      Addr : Pointer;
    end;

  PatchType = (
    {-Unit System}
    pMkDir, pRmDir, pChDir, pGetDir,
    pFReset, pFRewrite, pErase, pRename,
    pAssignText,
    pAssignFile,                                                       {!!.05}
    pFClose,                                                           {!!.05}
    pParamCount, pParamStr,                                            {!!.04}
  {$IFDEF UseDos}
    {-Unit Dos}
    pGetFAttr_D, pSetFAttr_D, pGetFTime_D, pSetFTime_D,
    pFSearch,                                                          {!!.08}
    pGetEnv,                                                           {!!.09}
  {$ENDIF}
    {!!.06 begin}
  {$IFDEF UsewinDos}
    {-Unit WinDos}
    pCreateDir, pRemoveDir, pSetCurDir, pGetCurDir,
    pGetFAttr_W, pSetFAttr_W, pGetFTime_W, pSetFTime_W,
    pGetArgCount, pGetArgStr,
    pFileExpand, pFileSplit,
    pFileSearch,                                                       {!!.08}
  {$ENDIF}
    {!!.06 end}
    pDummy);

const
  LowPatchType = pMkDir;
  HighPatchType = pDummy;

var
  {-Array fr den Originalcode der gepatchten Routinen}
  SavePatch : array[PatchType] of PatchRec;
  SpecialSavePatch : array[pAssignText..pAssignFile] of SpecialPatchRec; {!!.07}
  {-Die Adressen der gepatchten Routinen}
  PatchAddr : array[PatchType] of Pointer;
  Regs : Registers;

const
  On = True;
  Off = False;
var
  SaveHeapFunc : Pointer;

  function LFNHeapFunc(Size : Word) : Integer; Far;
  begin
    LFNHeapFunc := 1;
  end;

  procedure HeapFunc(On : Boolean);
    {-Installiert temporr eine HeapFunc}
  begin
    if On then begin
      SaveHeapFunc := HeapError;
      HeapError := @LFNHeapFunc;
    end
    else
      HeapError := SaveHeapFunc;
  end;

{.F-}
const
  {-Bitkonstanten der Procs dieser Unit}
  bSetCreateFTime = $0001;
  bGetCreateFTime = $0002;
  bFindFirstNext  = $0004;
  bFSplit         = $0008;
  bTruePathName   = $0010;
  bGetShortName   = $0020;
  bGetLongName    = $0040;
  bFExpand        = $0080;

  LFN_AllProcs    = bSetCreateFTime+bGetCreateFTime+bFindFirstNext+bFSplit+
                    bTruePathName+bGetShortName+bGetLongName+bFExpand;

  LFN_Proc : Word = 0;  {-Bitmerker welche Proc aktiv ist}
{.F+}

  procedure EnableLFNFunc(Which : PatchType); Forward;                 {!!.04}
  {-Aktiviert die gewnschte Funktion dieser Unit}
  procedure DisableLFNFunc(Which : PatchType); Forward;
  {-Deaktiviert die gewnschte Funktion dieser Unit}

  {-Low Level Routinen:
      Asc2Str, Str2Asc, AscSize, AddZero, POPJumpFAR, Int21file, Int21name,
      Int21namePChar, StUpcase, JustPathName, JustName, ClearFlag, FlagIsSet,
      AddBackSlash, DefaultDrive}
  {$I LFN.IN1}

  {-Ersatzfunktionen fr Unit System (Teil 1):
      MkDir, RmDir, ChDir, GetDir, GetFAttr, SetFAttr,
      SetFTime, SetCreateFTime, GetFTime, GetCreateFTime}
  {$I LFN.IN2}

  {-Ersatzfunktionen fr Unit System (Teil 2):
      Erase, Rename, Reset, Rewrite, Assign, Close, etc.,
      LFNAssignNew, LFNAssignGetName, LFNAssignDispose}
  {$I LFN.IN3}

  {-Ersatzfunktionen fr Unit Dos:
      FExpand, FindFirst, FindNext, FindClose, FSplit, DiskFree, DiskSize
      FSearch, GetEnv}
  {$I LFN.IN4}

  {-Erweiterte Funktionen:
      TruePathName, GetShortName, GetLongName, FlushDrive, ResetDrive,
      GetShortNamePChar, GetLongNamePChar, TruePathNamePChar,
      FlushDrive, ResetDrive, IsNetworkDrive}
  {$I LFN.IN5}

  {-Funktionen der Kommandozeilenparameter:
      ParamLine, ParamCount, ParamPosition, ParamStr}
  {$I LFN.IN7}

  {-Ersatzfunktionen fr Unit WinDos:
      CreateDir, RemoveDir, SetCurDir, GetCurDir, GetArgStr,
      FileExpand, FileSplit, FileSearch}
  {$I LFN.IN8}

  {-Funktionen zur Initalisierung:
      Initialize, EnableLFN, DisableLFN, Win95_Aktiv}
  {$I LFN.IN6}

begin
  Initialize;
  if Win95_Aktiv then
    EnableLFN;

  {$IFDEF Windows}
  GetMem(ParamPtr, StrLen(CmdLine)+1);                                 {!!.06}
  ParamPtr^ := StrPas(CmdLine);                                        {!!.06}
  {$ELSE}
  ParamPtr := Ptr(PrefixSeg, $80);                                     {!!.05}
  {$ENDIF}

  {!!.05 begin}
  {$IFDEF AssignLongName}
  AssignNew := LFNAssignNew;
  AssignGetName := LFNAssignGetName;
  AssignDispose := LFNAssignDispose;
  {$ENDIF}
  {!!.05 end}
end.
