{$I+,S-,R-,V-,X+}

{--------------------------------------------------------------------}
{-                        EXASSIGN.PAS v1.02                        -}
{-  Example how to implement user defined functions for filenames   -}
{-  longer than 79 chars. This demo is only for this special case!  -}
{-                                                                  -}
{-  PLEASE READ THE DOCUMENTATION ABOUT THIS! YOU DONT HAVE TO USE  -}
{-  SUCH USER DEFINED FUNCTIONS TO GET LFN WORK WITH LARGER NAMES!  -}
{-                                                                  -}
{-             Written by Andreas Killer, Germany, NRW              -}
{-      homepage: http://home.t-online.de/home/andreas.killer       -}
{--------------------------------------------------------------------}

{-Enable the following define to use the functions in LFN for filenames
  larger than 79 chars}
{$DEFINE UseTheFunctionsInLFN}

uses
{$IFDEF Ver70}
  Strings,
{$ENDIF}
  Lfn, LfnList;

{$I LFN.IN0}
{$IFNDEF AssignLongName}
  Error 36: Please enable AssignLongName in LFN.IN0 to compile this demo.
{$ENDIF}

  function HeapFunc(Size : Word) : Integer; Far;
    {-See OLH to HeapError}
  begin
    HeapFunc := 1;
  end;

{$IFDEF Ver60}
  procedure StrCopy(Dest, Source : PChar); Assembler;
    {-StrCopy copies Source to Dest}
  asm
    push    ds
    les     di, Source
    mov     cx, 0FFFFH
    xor     al, al
    cld
    repne   scasb
    not     cx
    lds     si, Source
    les     di, Dest
    rep     movsb
    pop     ds
  end;

  procedure StrPCopy(Dest : PChar; Source : String); Assembler;
    {-StrPCopy copies the Pascal style string Source into Dest}
  asm
    push    ds
    les     di, Dest
    lds     si, Source
    cld
    lodsb
    xor     ah, ah
    mov     cx, ax
    rep     movsb
    xor     ax, ax
    stosb
    pop     ds
  end;

  function StrLen(Str : PChar) : Word; Assembler;
    {-StrLen returns the number of characters in Str}
  asm
    les     di,         str
    cld
    mov     cx, 0FFFFh
    xor     ax, ax
    rep     scasb
    not     cx
    dec     cx
    mov     ax, cx
  end;
{$ENDIF}

type
  MyNodePtr = ^MyNode;
  MyNode =
    object(AssignNode)
      AsciiName : PChar;
      FilePtr : Pointer;

      constructor Init(var F; FName : PChar);
        {-Initialize this object}
      destructor Done; virtual;
        {-Destroy this object}
    end;
var
  MyList : AssignList;

  constructor MyNode.Init(var F; FName : PChar);
    {-Initialize this object}
  begin
    {-Initialize the node}
    AssignNode.Init;
    {-Store the filename on the heap}
    GetMem(AsciiName, StrLen(FName)+1);
    {-Allocation successful?}
    if AsciiName = nil then
      Fail;
    {-Copy the filename on the heap}
    StrCopy(AsciiName, FName);
    {-Save the adress of the filevariable}
    FilePtr := @F;
  end;

  destructor MyNode.Done;
    {-Destroy this object}
  begin
    FreeMem(AsciiName, StrLen(AsciiName)+1);
  end;

{$F+}
  procedure MyAssignNew(var F; FName : PChar);
  var
    MPtr : MyNodePtr;
  begin
    {-Allocate a new node}
    New(MPtr, Init(F, FName));
    {-Was NEW successfully?}
    if MPtr = nil then begin
      WriteLn('Not enough memory.');
      Halt;
    end;
    {-FName will be stored in the filevariable}
    StrPCopy(FName, 'For debugging place in here what ever you want.');
    {-Add the node to the list}
    MyList.Append(MPtr);
  end;

  function MyAssignGetName(var F) : Pointer;
  var
    MPtr : MyNodePtr;
  begin
    MyAssignGetName := nil;
    {-Search for the name that belongs to F}
    MPtr := MyNodePtr(MyList.First);
    while MPtr <> nil do begin
      if @F = MPtr^.FilePtr then begin
        {-If we found it, return the pointer to the filename}
        MyAssignGetName := MPtr^.AsciiName;
        Exit;
      end;
      MPtr := MyNodePtr(MyList.Next(MPtr));
    end;
    {-If the returned value from AssignGetName is NIL, so LFN will figure
      that the name in the filevariable is valid.}
  end;

  procedure MyAssignDispose(var F);
  var
    MPtr : MyNodePtr;
  begin
    {-Search for the name that belongs to F}
    MPtr := MyNodePtr(MyList.First);
    while MPtr <> nil do begin
      if @F = MPtr^.FilePtr then begin
        {-And remove it from the list}
        MyList.Remove(MPtr);
        Exit;
      end;
      MPtr := MyNodePtr(MyList.Next(MPtr));
    end;
  end;
{$F-}

var
  T : Text;
  FName : String;
begin
  HeapError := @HeapFunc;

{$IFNDEF UseTheFunctionsInLFN}
  {-Setup the routines to hook into LFN}
  AssignNew := MyAssignNew;
  AssignGetName := MyAssignGetName;
  AssignDispose := MyAssignDispose;
{$ENDIF}

  {-Initialize our list}
  MyList.Init;

  {-Place Breakpoints in the routines above and
    run the program to see whats happen.}

  FName := 'C:\Only a short name.TXT';
  Assign(T, FName);
  Rewrite(T);
  WriteLn(T, FName);
  Close(T);

  FName := 'C:\In here must be placed a filename longer than 79 chars '+
           'if you want to see how this program works.TXT';
  Assign(T, FName);
  Rewrite(T);
  WriteLn(T, FName);
  Close(T);

  {-Destroy our list}
  MyList.Done;
end.
