{--------------------------------------------------------------------}
{-                         COPYHD.PAS v1.00                         -}
{-     Copyprogram as example for the use of LFN v1.07 or later     -}
{-             Written by Andreas Killer, Germany, NRW              -}
{-      homepage: http://home.t-online.de/home/andreas.killer       -}
{--------------------------------------------------------------------}

{$I-,X+}

uses
  {-Units from TP/BP7}
  Crt, WinDos, Strings,
  {-The unit PChars is avaible on my homepage}
  PChars,                         
  Lfn;

{$I LFN.IN0}

{$IFNDEF UseWinDos}
  The settings in LFN.IN0 are not compatible with this program!
{$ENDIF}
{$IFDEF CompatToDos}
  The settings in LFN.IN0 are not compatible with this program!
{$ENDIF}
{$IFNDEF AssignLongName}
  The settings in LFN.IN0 are not compatible with this program!
{$ENDIF}
{$IFDEF AutoAssignDispose}
  The settings in LFN.IN0 are not compatible with this program!
{$ENDIF}

const
  (*** Commandlineoptions for this program: ***)
  {-Logfile for filenames that can't be copied}
  LogFName : PathStr = 'C:\COPYHD.LOG';
  {-Append the logfile or overwrite it}
  AppendLogFile : Boolean = True;
  {-Search recursiv through directorys}
  Recursiv : Boolean = True;
  {-Create the directorysturcture only}
  CreateDirOnly : Boolean = False;
  {-Overwrite existing files}
  DontOverwriteFiles : Boolean = False;
  {-Overwrite only newer files}
  OverwriteNewer : Boolean = True;
  {-Overwrite only smaller files}
  OverwriteSmaller : Boolean = False;
  {-Dont copy files that doesn't exist}
  DontCopyNonExistFiles : Boolean = False;

const
  {-Number of visited directorys, starting direcotry doesn't count}
  DirCount : LongInt = -1;
  {-Number of found files}
  FileAllCount : LongInt = 0;
  {-Number of files that can't be copied}
  FileNotCount : LongInt = 0;
  {-Number of files that are copied}
  FileCopyCount : LongInt = 0;
  {-Size for temporary pathes, etc.}
  MaxPathNameLen = 1024;

type
  ByteArrayPtr = ^ByteArray;
  ByteArray = array[1..$7FFF] of Byte;

var
  {-The true source directory (first argument)}
  SourceDir : PChar;
  {-The true destination directory (second argument)}
  DestDir : PChar;
  {-The current complete source directory}
  SourcePath : PChar;
  {-The current complete destination directory}
  DestPath : PChar;
  {-IO-buffer used when copying a file}
  Buf : ByteArrayPtr;
  {-Workspace to save the current directorys}
  SaveSourceDir, SaveDestDir, SaveOurDir : PChar;
  {-To save a previour exitproc}
  SaveExit : Pointer;

  procedure CopyHDExitProc; Far;
    {-Display a message at the end of the program}
  begin
    {-Restore the pointer to a previous exitproc}
    ExitProc := SaveExit;

    {-Restore the directorys detected at startup}
    SetCurDir(SaveSourceDir);
    SetCurDir(SaveDestDir);
    SetCurDir(SaveOurDir);

    {-Displays informations what we have done}
    WriteLn;
    WriteLn(DirCount, ' directorys, ', FileAllCount, ' files passed, ', FileCopyCount, ' files copied.');
    if FileNotCount > 0 then
      WriteLn(FileNotCount, ' files not updated. See ', LogFName)
    else
      WriteLn('All files are up to date.');
  end;

  procedure Abort(Msg : String; ErrorCode : Byte);
    {-Display Msg and halts with a defined exitcode}
  begin
    WriteLn;
    WriteLn(Msg);
    Halt(ErrorCode);
  end;

  function HeapFunc(Size : Word) : Integer; Far;
    {-See HeapError in the OLH}
  begin
    HeapFunc := 1;
  end;

  function CharStr(C : Char; Len : Byte) : String; Assembler;
    {-Return a string in the length of Len and filled with C}
  asm
    les     di, @Result           {-ES:DI => CharStr}
    cld                           {-Aufwrts fllen}
    mov     al, Len               {-AL:= Len}
    stosb                         {-Lngenbyte schreiben}
    xor     ch, ch                {-CX:= Len}
    mov     cl, Len
    mov     al, C                 {-AL:= C}
    rep     stosb                 {-CX mal AL nach ES:DI schreiben}
  end;

  procedure AppendLog(FName : PChar);
    {-Write FName with it's path to the LOG-File}

    function ZeroPad(W : Word) : String;
      {-Returns W as a string with 0 padded}
    var
      S : String[2];
    begin
      Str(W, S);
      if Length(S) < 2 then
        S := '0'+S;
      ZeroPad := S;
    end;

  const
    Days : array[0..6] of String[9] = (
      'Sunday', 'Monday', 'Tuesday', 'Wednesday',
      'Thursday', 'Friday', 'Saturday');
  var
    F : Text;
    Year, Month, Day, DayOfWeek,
    Hour, Minute, Second, Sec100 : Word;
  begin
    {-Try open the logfile}
    Assign(F, LogFName);
    if (FileNotCount = 0) and not AppendLogFile then
      Rewrite(F)
    else begin
      Append(F);
      if AppendLogFile and (IoResult <> 0) then
        Rewrite(F);
    end;

    {-If an error occur, display the messages to the screen}
    if IoResult <> 0 then begin
      WriteLn;
      if FileNotCount = 0 then
        WriteLn('Can not write to ', LogFName);
      LogFName := 'CON';
      Assign(F, LogFName);
      Rewrite(F);
    end;

    {-If this is the first entry, than write a date/timestamp to the file}
    if FileNotCount = 0 then begin
      GetDate(Year, Month, Day, DayOfWeek);
      GetTime(Hour, Minute, Second, Sec100);
      WriteLn(F);
      WriteLn(F, CharStr('-', 79));
      WriteLn(F);
      WriteLn(F, 'Logfileentry from ', Days[DayOfWeek], ', ',
              ZeroPad(Day), '.', ZeroPad(Month), '.', Year, ' at ',
              ZeroPad(Hour), ':', ZeroPad(Minute), ':', ZeroPad(Second), '.', Sec100);
      WriteLn(F);
    end;

    {-Write the informations of the file}
    Write(F, SourcePath);
    WriteLn(F, FName);
    Close(F);
    Inc(FileNotCount);
  end;

  procedure AddBackSlash(var P : PChar);
    {-Add a backslash to the end of P if the isn't one}
  var
    Len : Word;
  begin
    Len := StrLen(P);
    if (Len > 0) and (P[Len-1] <> '\') then begin
      P[Len] := '\';
      P[Len+1] := #0;
    end;
  end;

  function ContinueCreateDir(Path : PChar) : Boolean;
    {-Create a complete directorypath}
  var
    SubDir, Temp : PChar;
    P, SlashPos : Word;
    Sr : TSearchRec;
    I : Integer;
  begin
    {-Get a directoryname without a trailing backslash}
    SubDir := CopyPChar(Path, 0, StrLen(Path)-1);

    {-Test if this directory exist}
    FindFirst(SubDir, faDirectory, Sr);
    {-Free the temporary pchar}
    DisposePChar(SubDir);

    {-Is the directory allready there?}
    if DosError = 0 then begin
      ContinueCreateDir := True;
      {-Try close the filehandle taken by FindFirst}
      FindClose(Sr);
      Exit;
    end;

    {-Try create the directory step by step}
    SlashPos := 0;
    repeat
      {-Search for the next backslash from the last position}
      P := PosPchar('\', @Path[SlashPos]);
      {-Found?}
      if P <> $FFFF then begin
        {-Update the position}
        Inc(SlashPos, P);
        {-Extract the shortest directory}
        SubDir := CopyPChar(DestPath, 0, SlashPos);

        {-Check if only a drivename is given}
        if (StrLen(SubDir) = 2) and (SubDir[1] = ':') then begin
          {-If we can change to it than this drive exist}
          SetCurDir(SubDir);
          SetCurDir('\');
          {-Check for errors without clearing it}
          if InOutRes = 0 then
            {-Change back to the last directory}
            SetCurDir(SourcePath);
        end
        else
          {-Try create it}
          CreateDir(SubDir);

        {-Dispose the allocated memory}
        DisposePChar(SubDir);
        {-If the loop ends, than we'll have the result}
        ContinueCreateDir := IoResult = 0;

        {-Continue the search from the next char}
        Inc(SlashPos);
      end;
    until P = $FFFF;
  end;

  function TestCopyOption(SourceFName, DestFName : PChar) : Boolean;
    {-Returns true if the file should be copied}
  var
    DestSize, DestFTime : LongInt;
    Sr : TSearchRec;
  begin
    {-Assume that the file should not be copied}
    TestCopyOption := False;

    {-Get the results from the destination file}
    FindFirst(DestFName, faAnyFile, Sr);
    {-Close the filehandle taken by findfirst}
    FindClose(Sr);


    {-Did the file exist?}
    if (DosError = 0) then begin
      {-Yes, should we overwrite existing files?}
      if DontOverwriteFiles then
        Exit;

      {-Save the result from the destination file}
      DestFTime := Sr.Time;
      DestSize := Sr.Size;

      {-Get the results from the source file}
      FindFirst(SourceFName, faAnyFile, Sr);
      {-Close the filehandle taken by findfirst}
      FindClose(Sr);

      {-Should we overwrite a newer file?}
      if OverwriteNewer and (Sr.Time <= DestFTime) then
        Exit;

      {-Should we overwrite a smaller file?}
      if OverwriteSmaller and (Sr.Size <= DestSize) then
        Exit;
    end
    else
      {-The file does not exist}
      if DontCopyNonExistFiles then
        Exit;

    {-This file should be copied}
    TestCopyOption := True;
  end;

  function CopyFILE(FName : PChar) : Boolean;
    {-Copy the file FName from SourcePath to DestPath}
  label
    ExitPoint;
  var
    SourceFName, DestFName : PChar;
    SourceF, DestF : file;
    Attr, BytesRead, BytesWritten : Word;
    Time : LongInt;
  begin
    {-Assume that an error occurs}
    CopyFILE := False;

    {-Make an complete pathname}
    SourceFName := ConcatPChar(SourcePath, FName);
    DestFName := ConcatPChar(DestPath, FName);
    {-Did the allocation success?}
    if (SourceFName = nil) or (DestFName = nil) then
      Abort('Not enough Memory', 1);

    {-Assign both files}
    Assign(SourceF, SourceFName);
    Assign(DestF, DestFName);

    {-Display the filename}
    GotoXY(1, WhereY);
    Write(TFileRec(SourceF).Name);
    ClrEol;

    {-Check the options before copy the file}
    if not TestCopyOption(SourceFName, DestFName) then begin
      {-This files should'nt be copied}
      CopyFILE := True;
      goto ExitPoint;
    end;

    {-Get the attributs from the sourcefile}
    GetFAttr(SourceF, Attr);
    if DosError <> 0 then
      Attr := 0;

    {-Try open the sourcefile for reading only}
    FileMode := 0;
    Reset(SourceF, 1);
    if IoResult <> 0 then
      goto ExitPoint;

    {-Get the timestamp from sourcefile}
    GetFTime(SourceF, Time);
    if DosError <> 0 then
      Time := 0;

    {-Clear attributs of an existing files, ignore errors}
    SetFAttr(DestF, 0);

    {-Try open the destfile for writing only}
    FileMode := 1;
    Rewrite(DestF, 1);
    if IoResult <> 0 then begin
      Close(SourceF);
      goto ExitPoint;
    end;

    {-Copy the file}
    repeat
      BlockRead(SourceF, Buf^, SizeOf(ByteArray), BytesRead);
      BlockWrite(DestF, Buf^, BytesRead, BytesWritten);
    until (BytesRead = 0) or (BytesRead <> BytesWritten);

    {-Set the timestamp at the destination file}
    SetFTime(DestF, Time);

    {-Close the destination file}
    Close(DestF);

    {-Check if all bytes are written}
    if BytesRead <> BytesWritten then begin
      {-Erase the destfile, because it's invalid}
      Erase(DestF);

      {-Check the free space on the destination drive}
      if FileSize(SourceF) > DiskFree(Byte(DestDir^)-64) then
        Abort('No enough diskspace on the destination drive', 2);

      {-Close the source file}
      Close(SourceF);

      {-Check the free space of the destination drive}
      goto ExitPoint;
    end;

    {-Close the source file}
    Close(SourceF);

    {-Set the attributs at the destfile}
    SetFAttr(DestF, Attr);

    {-Check if an error has occured and return it}
    if IoResult = 0 then begin
      Inc(FileCopyCount);
      CopyFILE := True;
    end;

ExitPoint:
    {-Deallocte any memory we have taken}
    AssignDispose(DestF);
    AssignDispose(SourceF);
    DisposePChar(DestFName);
    DisposePChar(SourceFName);
  end;

  procedure SyncronizePathNames;
    {-Copies the subdirectoryportion from sourcepath to the destpath}
  var
    DestEnd, SourceEnd : PChar;
  begin
    {-Get current directory}
    FileExpand(SourcePath, '');

    {-Search for the end of the given sourcedirectory}
    SourceEnd := StrPos(SourcePath, SourceDir);
    {-Set the pointer to the end}
    Inc(SourceEnd, StrLen(SourceDir));

    {-Overwrite the last destination directory and return a pointer to it's end}
    DestEnd := StrECopy(DestPath, DestDir);
    {-Add the current subdirectory to the destination directory}
    StrCopy(DestEnd, SourceEnd);
  end;

  function FindSubDir(StartDir : PChar) : Boolean;
    {-Visit through the subdirectorys starting at StartDir}
  var
    Sr : TSearchRec;
  begin
    FindSubDir := False;

    {-Change to the starting directory}
    SetCurDir(StartDir);
    if IoResult <> 0 then
      Exit;
    Inc(DirCount);

    {-Equalize source and destination pathnames}
    SyncronizePathNames;
    {-Create the destination directory}
    ContinueCreateDir(DestPath);

    {-Start searching for all files}
    FindFirst('*.*', faAnyFile, Sr);
    while DosError = 0 do begin
      {-Did the user abort?}
      if KeyPressed then
        if ReadKey = #27 then
          Abort('Userbreak', 3);

      {-Is it a directory?}
      if (Sr.Attr and faDirectory <> 0) then begin
        {-Yes, figure out if we have to go in it}
        if Recursiv and (Sr.Name[0] <> '.') then begin
          {-Try search the next subdirectory}
          if FindSubDir(Sr.Name) then begin
            {-If sucessfully go one directory up to our last}
            SetCurDir('..');
            {-Equalize source and destination pathnames}
            SyncronizePathNames;
          end;
        end;
      end

      {-Is it a file or just the name of the volume?}
      else
        if (Sr.Attr and faVolumeID = 0) then begin
          {-Should we copy it?}
          if not CreateDirOnly then begin
            {-Try copy the file}
            if not CopyFILE(Sr.Name) then
              {-Log the filename that can't be copied}
              AppendLog(Sr.Name);
            Inc(FileAllCount);
          end;
        end;

      {-Find the next entry}
      FindNext(Sr);
    end;
    FindSubDir := True;
  end;

  procedure ParseCommandLine;
    {-Parse the parameters from commandline}

    procedure Help;
      {-Display a helpmessage}
    const
      OnOff : array[Boolean] of String[3] = ('off', 'on');
    begin
      WriteLn;
      WriteLn('Syntax:');
      WriteLn(' COPYHD SourceDirectory DestinationDirectory [{+|-}Option]');
      WriteLn;
      WriteLn('An options can initated with a + or - in front. Set + to enable an option');
      WriteLn('and - to disable it. All options are optional.');
      WriteLn;
      WriteLn('Options for the LOGfile:');
      WriteLn('  a = append an existing logfile           default = ', OnOff[AppendLogFile]);
      WriteLn('  l = set logfilename                      default = ', LogFName);
      WriteLn;
      WriteLn('Options for directorys:');
      WriteLn('  d = create directory structure only      default = ', OnOff[CreateDirOnly]);
      WriteLn('  r = recursiv through directorys          default = ', OnOff[Recursiv]);
      WriteLn;
      WriteLn('Options for files:');
      WriteLn('  e = dont copy files that doesn'#39't exist   default = ', OnOff[DontCopyNonExistFiles]);
      WriteLn('  n = overwrite only newer files           default = ', OnOff[OverwriteNewer]);
      WriteLn('  o = dont overwrite existing files        default = ', OnOff[DontOverwriteFiles]);
      WriteLn('  s = overwrite only smaller files         default = ', OnOff[OverwriteSmaller]);
      Halt(255);
    end;

  var
    I : Byte;
    S : String;
  begin
    if ParamCount < 2 then
      Help;

    for I := 1 to ParamCount do begin
      S := ParamStr(I);
      case S[1] of
        '-', '+' : case Upcase(S[2]) of
                     'A' : AppendLogFile := S[1] = '+';
                     'D' : CreateDirOnly := S[1] = '+';
                     'E' : DontCopyNonExistFiles := S[1] = '+';
                     'L' : LogFName := Copy(S, 3, 255);
                     'N' : OverwriteNewer := S[1] = '+';
                     'O' : DontOverwriteFiles := S[1] = '+';
                     'R' : Recursiv := S[1] = '+';
                     'S' : OverwriteSmaller := S[1] = '+';
                   else
                     WriteLn('Invalid Option');
                     Help;
                   end;
      else
        if SourceDir^ = #0 then begin
          GetArgStr(SourceDir, I, MaxPathNameLen);
          StrCopy(SourcePath, TruePathNamePChar(SourceDir, SourceDir));
          AddBackSlash(SourceDir);
          AddBackSlash(SourcePath);
        end
        else
          if DestDir^ = #0 then begin
            GetArgStr(DestDir, I, MaxPathNameLen);
            StrCopy(DestPath, TruePathNamePChar(DestDir, DestDir));
            AddBackSlash(DestDir);
            AddBackSlash(DestPath);
          end
        else begin
          WriteLn('Too many directorys given.');
          Help;
        end;
      end;
    end;

    {-Check that the given parameters are correct}
    if (SourceDir^ = #0) or (DestDir^ = #0) then begin
      if SourceDir^ = #0 then
        WriteLn('No sourcedirectory given.')
      else
        WriteLn('No destinationdirectory given.');
      Help;
    end;

    if StrComp(SourceDir, DestDir) = 0 then
      Abort('Can not copy a directory into itself.', 4);

    if Recursiv then
      if (PosPchar(SourceDir, DestDir) <> $FFFF) or (PosPchar(DestDir, SourceDir) <> $FFFF) then
        Abort('The given directorys are part of each other.', 5);
  end;

begin
  {-Display a header}
  WriteLn(CharStr('-', 79));
  WriteLn(' CopyHD v1.00    Copyprogram as example for the use of LFN v1.07   by A.Killer');
  WriteLn(CharStr('-', 79));

  {-Setup our Heapfunc}
  HeapError := @HeapFunc;

  {-Allocate pchars for workingspace}
  GetMemPChar(SaveOurDir, MaxPathNameLen);
  GetMemPChar(SaveSourceDir, MaxPathNameLen);
  GetMemPChar(SaveDestDir, MaxPathNameLen);
  GetMemPChar(SourcePath, MaxPathNameLen);
  GetMemPChar(DestPath, MaxPathNameLen);
  GetMemPChar(SourceDir, MaxPathNameLen);
  GetMemPChar(DestDir, MaxPathNameLen);

  {-If DestDir is allocated than all other pchars are also allocated, because
    they all have the same size. Trick 32 and a half ;-)}
  if DestDir = nil then
    Abort('Not enough memory', 6);

  {-Allocate an IO-Buffer for filecopy}
  New(Buf);
  if Buf = nil then
    Abort('Not enough memory', 7);

  {-Save the current directory}
  GetCurDir(SaveOurDir, 0);

  {-Parse the commandlineparameters}
  ParseCommandLine;

  {-Save the pathes on the drives we try to access}
  GetCurDir(SaveSourceDir, Byte(SourceDir^)-64);
  GetCurDir(SaveDestDir, Byte(DestDir^)-64);

  {-Setup our exitproc}
  SaveExit := ExitProc;
  ExitProc := @CopyHDExitProc;

  {-Make sure the destination directory exist}
  if not ContinueCreateDir(DestPath) then
    Abort('Can not access or create '+StrPas(DestPath), 8);

  {-Start the copy}
  WriteLn('Start copying files to ', DestPath);
  FindSubDir(SourcePath);

  {-Report an exitcode 0 for success working}
  Halt(0);
end.
