uses ipx,dos,crt;
type
  PServerEntry=^serverentry;
  serverentry=record
                name: string[32];
                number: word;
                adress: ipxadress;
                last: boolean;
              end;

  PServerListRec=^TServerListRec;
  TServerListRec=record
                   s: serverentry;
                   next: PServerListRec;
                 end;

  PIPXAdress=^ipxadress;

  Oserverlist=object
                first,last,akt: PServerListRec;
                aktadress: ipxadress;
                function getaktentry: PServerEntry;
                procedure setownentry;
                procedure setlastentry;
                procedure createnewentry;
                function look4server (number: word;name: string): boolean;
                procedure init (sname: string;number: word);
                procedure done;
                procedure setnumber (num: word);
                procedure setlastflag (new: boolean);
                function getnumber: word;
                function getlastflag: boolean;
                function getadress: Pipxadress;
                function nextentry: boolean;
                function getname: string;
                procedure filesocket;
                procedure serversocket;
              end;









  fileinforec=record
                filename: string[12];
                length: longint;
                filedate: longint;
                socket: word;
              end;



const
  socketofs=1000;
  timeoutcount=$1000000;
  introduce2newservers:word=$5555;

var
  servers: OServerList;
  myownadress,schnulli,partner: ipxadress;
  timeout: longint;
  wait4newservers,wait4files: Pboolean;
  fileinfo: FileInfoRec;
  notify: word;
  ch: byte;
  s: string;
  a,b: word;
  n: boolean;

procedure sendfile (fname: string;adress: ipxadress);
var
  f: file;
  p: pointer;
  groe: longint;
  a,b: word;
  chksumset,chksumrec: longint;
  datei,dateirec: fileinforec;
  partner: ipxadress;
begin
  getmem (p,32768);
  assign (f,fname);ReSet (f,1);groe:=filesize(f);
  datei.filename:=fname;
  datei.length:=groe;
  GetFTime (f,datei.filedate);
  senddata (datei,sizeof(datei),adress);
  getdata (dateirec,sizeof(datei),partner);
  for a:=1 to (groe div 32768) do
  begin
    blockread (f,p^,32768);
    chksumset:=0;
    senddata (p^,32768,adress);
    for b:=0 to 32767 do
      chksumset:=chksumset+byte(ptr (seg(p^),word(p)+b)^);
    partner.socket:=adress.socket;
    getdata (chksumrec,sizeof(chksumrec),partner);
    if chksumrec<>chksumset then
    begin
      writeln ('bertragungsfehler.');
      finishipx;
      halt (2);
    end;
  end;
  blockread (f,p^,groe mod 32768);
  chksumset:=0;
  senddata (p^,groe mod 32768,adress);
  for b:=0 to (groe mod 32768)-1 do
    chksumset:=chksumset+byte(ptr (seg(p^),word(p)+b)^);
  partner.socket:=adress.socket;
  getdata (chksumrec,sizeof(chksumrec),partner);
  if chksumrec<>chksumset then
  begin
    writeln ('bertragungsfehler.');
    finishipx;
    halt (2);
  end;
  writeln ('Datei erfolgreich versandt.');
  close (f);
  freemem (p,32768);
end;



function OServerList.getaktentry: PServerEntry;
begin
  getaktentry:=@akt^.s;
end;

procedure OServerList.setownentry;
begin
  akt:=first;
  aktadress:=akt^.s.adress;
end;

procedure OServerList.setlastentry;
begin
  akt:=last;
  aktadress:=akt^.s.adress;
end;

procedure OServerList.createnewentry;
begin
  new (last^.next);last:=last^.next;
  last^.next:=NIL;akt:=last;
  fillchar (aktadress,sizeof(ipxadress),0);
end;

function OServerList.look4server (number: word;name: string): boolean;
begin
  akt:=first;
  while (akt<>NIL) and (akt^.s.number<>number) and (akt^.s.name<>name) do
    akt:=akt^.next;
  if akt<>NIL then aktadress:=akt^.s.adress
    else fillchar (aktadress,sizeof(ipxadress),0);
  look4server:=(akt<>NIL);
end;

procedure OServerList.init (sname: string;number: word);
begin
  new (first);akt:=first;akt^.next:=NIL;last:=akt;
  akt^.s.name:=sname;
  akt^.s.number:=number;
  akt^.s.last:=false;
  getmyadress (akt^.s.adress);
  akt^.s.adress.socket:=socketofs;
  aktadress:=akt^.s.adress;
end;

procedure OServerList.done;
begin
  akt:=first;
  while akt<>NIL do
  begin
    last:=akt^.next;
    dispose (akt);
    akt:=last;
  end;
  akt:=NIL;first:=NIL;last:=NIL;
end;

procedure OServerList.setnumber (num: word);
begin
  akt^.s.number:=num;
end;

procedure OServerList.setlastflag (new: boolean);
begin
  akt^.s.last:=new;
end;

function OServerList.getadress: Pipxadress;
begin
  aktadress:=akt^.s.adress;
  getadress:=@aktadress;
end;

function OServerList.getnumber: word;
begin
  getnumber:=akt^.s.number;
end;

function OServerList.getlastflag: boolean;
begin
  getlastflag:=akt^.s.last;
end;

function OServerList.nextentry: boolean;
begin
  nextentry:=(akt^.next<>NIL);
  if akt^.next<>NIL then
  begin
    akt:=akt^.next;
    aktadress:=akt^.s.adress;
  end;
end;

function OServerList.getname: string;
begin
  getname:=akt^.s.name;
end;

procedure OServerList.filesocket;
begin
  akt^.s.adress.socket:=socketofs+1;
  aktadress.socket:=socketofs+1;
end;

procedure OServerList.serversocket;
begin
  akt^.s.adress.socket:=socketofs;
  aktadress.socket:=socketofs;
end;





begin
  if not testipx then
  begin
    writeln;writeln ('Keine IPX-Netzwerktreiber installiert.');
    writeln ('Programm wird abgebrochen.');writeln;
    finishipx;
    halt(1);
  end;
  fileinfo.filename:='testfile.txt';
  fileinfo.length:=100;
  fileinfo.filedate:=0;
  fileinfo.socket:=socketofs+1;
  getmyadress (myownadress);myownadress.socket:=socketofs;
  write ('Name dieses Servers: ');readln (s);
  servers.init (s,0);
  opensocket (socketofs);
  senddata (servers.getaktentry^,sizeof(serverentry),broadcast);
  servers.createnewentry;
  wait4newservers:=prepdatarec (servers.getaktentry^,sizeof (serverentry),socketofs);
  repeat
    write ('.');
    timeout:=timeoutcount;
    while (wait4newservers^ and (timeout>0)) do dec (timeout);
  until not wait4newservers^;
  finishdatarec (wait4newservers,partner);
  if servers.getnumber=0 then			{ I'm the First }
  begin
    servers.setownentry;servers.setnumber (1);
    servers.setlastflag (true);servers.setlastentry;
    senddata (servers.getaktentry^,sizeof(serverentry),servers.getadress^);
    getdata (notify,sizeof(notify),partner);
    servers.setownentry;servers.setlastflag (false);
  end else
  begin
    notify:=introduce2newservers;
    senddata (notify,sizeof(notify),servers.getadress^);
    while not servers.getlastflag do
    begin
      servers.createnewentry;
      getdata (servers.getaktentry^,sizeof (serverentry),servers.getadress^);
      notify:=introduce2newservers;
      senddata (notify,sizeof(notify),servers.getadress^);
    end;
    notify:=servers.getnumber;
    servers.setownentry;servers.setnumber (notify+1);
    servers.setlastflag (true);
  end;
  writeln;
  servers.setownentry;
  repeat
    writeln (servers.getnumber,': ',servers.getname);
  until not servers.nextentry;
  servers.createnewentry;
  wait4newservers:=prepdatarec (servers.getaktentry^,sizeof(serverentry),socketofs);
  opensocket (socketofs+1);
  wait4files:=prepdatarec (fileinfo,sizeof(fileinforec),socketofs+1);
  repeat
    while (not keypressed) and wait4newservers^ and wait4files^ do;
    if not wait4newservers^ then
    begin
      finishdatarec (wait4newservers,partner);
      servers.setownentry;
      if servers.getnumber<>1 then
      begin
        getdata (notify,sizeof(notify),schnulli);
        if notify<>introduce2newservers then halt (3);
      end;
      senddata (servers.getaktentry^,sizeof(serverentry),partner);
      getdata (notify,sizeof(notify),partner);
      if not servers.getlastflag then
      begin
        n:=servers.nextentry;
        senddata (notify,sizeof(notify),servers.getadress^)
      end else servers.setlastflag (false);
      servers.setlastentry;servers.setlastflag (true);
      servers.createnewentry;
      wait4newservers:=prepdatarec (servers.getaktentry^,sizeof(serverentry),socketofs);
    end;
    if not wait4files^ then
    begin
      finishdatarec (wait4files,partner);
      writeln ('Dateisendung: ',fileinfo.filename);
      wait4files:=prepdatarec (fileinfo,sizeof(fileinfo),socketofs+1);
    end;
    if keypressed then
    begin
      ch:=ord(readkey);
      if ch=0 then ch:=ord(readkey);
      case ch of
      49..57: begin
                if servers.look4server (ch-48,'') then
                begin
                  servers.filesocket;
                  senddata (fileinfo,sizeof(fileinfo),servers.getadress^);
                  servers.serversocket;
                  writeln (fileinfo.filename,' sent.');
                end else writeln ('Ungltig.');
              end;
      32: begin
            write ('Dateiname: ');readln (fileinfo.filename);
          end;
      end;
    end;
  until (ch=27);
  closesocket (socketofs);closesocket (socketofs+1);
  finishipx;
  servers.done;
end.










