/*
 * Decompiled with CFR 0.152.
 */
package de.mud.flash;

import de.mud.terminal.VDUBuffer;
import de.mud.terminal.VDUDisplay;
import de.mud.terminal.VDUInput;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.Socket;
import java.util.Iterator;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Text;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class FlashTerminal
implements VDUDisplay,
Runnable {
    private static final int debug = 0;
    private boolean simpleMode = true;
    private boolean terminalReady = false;
    private VDUBuffer buffer;
    private BufferedWriter writer;
    private BufferedReader reader;
    private String[] color = new String[]{"#000000", "#ff0000", "#00ff00", "#ffff00", "#0000ff", "#ff00ff", "#00ffff", "#ffffff", null, null};
    private SAXBuilder builder = new SAXBuilder();
    private Element terminal = new Element("terminal");
    private XMLOutputter xmlOutputter = new XMLOutputter();

    public void start(Socket flashSocket) {
        try {
            this.writer = new BufferedWriter(new OutputStreamWriter(flashSocket.getOutputStream()));
            this.reader = new BufferedReader(new InputStreamReader(flashSocket.getInputStream()));
            new Thread(this).run();
        }
        catch (IOException e) {
            System.err.println("FlashTerminal: unable to accept connection: " + e);
        }
    }

    protected void disconnect() {
    }

    private void perf(String msg) {
        System.err.print(System.currentTimeMillis());
        System.err.println(" " + msg);
    }

    public void run() {
        char[] buf = new char[1024];
        int n = 0;
        do {
            try {
                n = this.reader.read(buf);
                if (n > 0 && buf[0] == '<') {
                    this.handleXMLCommand(new String(buf, 0, n - 1));
                    continue;
                }
                if (n <= 0 || !(this.buffer instanceof VDUInput)) continue;
                if (this.simpleMode) {
                    byte[] tmp = new byte[n];
                    for (int i = 0; i < n - 1; ++i) {
                        tmp[i] = (byte)buf[i];
                    }
                    ((VDUInput)((Object)this.buffer)).write(tmp);
                    continue;
                }
                for (int i = 0; i < n - 1; ++i) {
                    ((VDUInput)((Object)this.buffer)).keyTyped(buf[i], buf[i], 0);
                }
            }
            catch (IOException e) {
                System.err.println("FlashTerminal: i/o exception reading keyboard input");
            }
        } while (n >= 0);
        this.disconnect();
    }

    private void handleXMLCommand(String xml) {
        System.err.println("handleXMLCommand(" + xml + ")");
        StringReader src = new StringReader("<root>" + xml.replace('\u0000', ' ') + "</root>");
        try {
            Element root = this.builder.build((Reader)src).getRootElement();
            Iterator cmds = root.getChildren().iterator();
            while (cmds.hasNext()) {
                Element command = (Element)cmds.next();
                String name = command.getName();
                if ("mode".equals(name)) {
                    this.simpleMode = "true".equals(command.getAttribute("simple").getValue().toLowerCase());
                    continue;
                }
                if ("timestamp".equals(name)) {
                    this.perf(command.getAttribute("msg").getValue());
                    continue;
                }
                if (!"start".equals(name)) continue;
                this.terminalReady = true;
                this.buffer.update[0] = true;
                this.redraw();
            }
        }
        catch (JDOMException e) {
            System.err.println("error reading command: " + (Object)((Object)e));
        }
    }

    public void redraw() {
        if (this.terminalReady && this.writer != null) {
            try {
                this.terminal.removeChildren();
                if (this.simpleMode) {
                    Element result = this.redrawSimpleTerminal(this.terminal);
                    if (result.hasChildren()) {
                        this.xmlOutputter.output(result, (Writer)this.writer);
                    }
                } else {
                    this.xmlOutputter.output(this.redrawFullTerminal(this.terminal), (Writer)this.writer);
                }
                this.writer.write(0);
                this.writer.flush();
            }
            catch (IOException e) {
                System.err.println("FlashTerminal: error writing to client: " + e);
                this.writer = null;
            }
        }
    }

    private Element redrawSimpleTerminal(Element terminal) {
        int line;
        int checkPoint;
        terminal.setAttribute("simple", "true");
        int n = checkPoint = this.buffer.scrollMarker < 0 ? 0 : this.buffer.scrollMarker;
        while (checkPoint < this.buffer.screenBase) {
            terminal.addContent(this.redrawLine(0, checkPoint++));
        }
        while (checkPoint < this.buffer.bufSize && (line = checkPoint - (this.buffer.screenBase - 1)) <= this.buffer.getCursorRow()) {
            terminal.addContent(this.redrawLine(0, checkPoint++));
        }
        this.buffer.scrollMarker = checkPoint;
        this.buffer.update[0] = false;
        return terminal;
    }

    private Element redrawFullTerminal(Element terminal) {
        for (int l = 0; l < this.buffer.height; ++l) {
            if (!this.buffer.update[0] && !this.buffer.update[l + 1]) continue;
            this.buffer.update[l + 1] = false;
            terminal.addContent(this.redrawLine(l, this.buffer.windowBase));
        }
        this.buffer.update[0] = false;
        return terminal;
    }

    private Element redrawLine(int l, int base) {
        Element line = new Element("line");
        line.setAttribute("row", "" + l);
        for (int c = 0; c < this.buffer.width; ++c) {
            int addr = 0;
            int currAttr = this.buffer.charAttributes[base + l][c];
            while (c + addr < this.buffer.width && (this.buffer.charArray[base + l][c + addr] < ' ' || this.buffer.charAttributes[base + l][c + addr] == currAttr)) {
                if (this.buffer.charArray[base + l][c + addr] < ' ') {
                    this.buffer.charArray[base + l][c + addr] = 32;
                    this.buffer.charAttributes[base + l][c + addr] = 0;
                    continue;
                }
                ++addr;
            }
            if (addr > 0) {
                String tmp = new String(this.buffer.charArray[base + l], c, addr);
                Text text = new Text(tmp.replace(' ', '\u00a0'));
                Element chunk = null;
                if ((currAttr & 0xFFF) != 0) {
                    if ((currAttr & 1) != 0) {
                        chunk = this.addChunk(new Element("B"), chunk, text);
                    }
                    if ((currAttr & 2) != 0) {
                        chunk = this.addChunk(new Element("U"), chunk, text);
                    }
                    if ((currAttr & 4) != 0) {
                        chunk = this.addChunk(new Element("I"), chunk, text);
                    }
                    if ((currAttr & 0x1E0) != 0) {
                        String fg = this.color[((currAttr & 0x1E0) >> 4) - 1];
                        Element font = new Element("FONT").setAttribute("COLOR", fg);
                        chunk = this.addChunk(font, chunk, text);
                    }
                }
                if (chunk == null) {
                    line.addContent(text);
                } else {
                    line.addContent(chunk);
                }
            }
            c += addr - 1;
        }
        return line;
    }

    private Element addChunk(Element el, Element chunk, Text text) {
        if (chunk == null) {
            return el.addContent(text);
        }
        return el.addContent(chunk);
    }

    public void setVDUBuffer(VDUBuffer buffer) {
        this.buffer = buffer;
        if (this.simpleMode) {
            this.buffer.setCursorPosition(0, 23);
        }
        this.buffer.setDisplay(this);
        this.buffer.update[0] = true;
    }

    public VDUBuffer getVDUBuffer() {
        return this.buffer;
    }
}

