/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta.plugin;

import de.mud.jta.FilterPlugin;
import de.mud.jta.Plugin;
import de.mud.jta.PluginBus;
import de.mud.jta.VisualPlugin;
import de.mud.jta.plugin.URLFilter$1;
import de.mud.jta.plugin.URLFilter$2;
import de.mud.jta.plugin.URLFilter$3;
import de.mud.jta.plugin.URLFilter$4;
import de.mud.jta.plugin.URLFilter$5;
import de.mud.jta.plugin.URLFilter$6;
import java.applet.AppletContext;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.List;
import java.awt.Menu;
import java.awt.Panel;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.StreamTokenizer;
import java.net.URL;
import java.util.Vector;

public class URLFilter
extends Plugin
implements FilterPlugin,
VisualPlugin,
Runnable {
    protected Vector protocols = new Vector();
    protected List urlList = new List(4, false);
    protected Panel urlPanel;
    protected Menu urlMenu;
    protected PipedInputStream pin;
    protected PipedOutputStream pout;
    protected AppletContext context;
    private Vector f1 = new Vector();
    protected FilterPlugin source;

    public URLFilter(PluginBus pluginBus, String string) {
        super(pluginBus, string);
        this.urlPanel = new Panel(new BorderLayout());
        this.urlList.addActionListener(new URLFilter$1(this));
        this.urlPanel.add("Center", this.urlList);
        Panel panel = new Panel(new GridLayout(3, 1));
        Button button = new Button("Clear List");
        button.addActionListener(new URLFilter$2(this));
        panel.add(button);
        button = new Button("Remove URL");
        button.addActionListener(new URLFilter$3(this));
        panel.add(button);
        button = new Button("Show URL");
        button.addActionListener(new URLFilter$4(this));
        panel.add(button);
        this.urlPanel.add("East", panel);
        pluginBus.registerPluginListener(new URLFilter$5(this));
        pluginBus.registerPluginListener(new URLFilter$6(this, string));
        this.pin = new PipedInputStream();
        this.pout = new PipedOutputStream();
        try {
            this.pout.connect(this.pin);
        }
        catch (IOException iOException) {
            System.err.println("URLFilter: error installing recognizer: " + iOException);
        }
        new Thread(this).start();
    }

    public void run() {
        try {
            int n;
            StreamTokenizer streamTokenizer = new StreamTokenizer(new BufferedReader(new InputStreamReader(this.pin)));
            streamTokenizer.eolIsSignificant(true);
            streamTokenizer.slashSlashComments(false);
            streamTokenizer.slashStarComments(false);
            streamTokenizer.whitespaceChars(0, 31);
            streamTokenizer.ordinaryChar(34);
            streamTokenizer.ordinaryChar(60);
            streamTokenizer.ordinaryChar(62);
            streamTokenizer.ordinaryChar(47);
            streamTokenizer.ordinaryChar(58);
            while ((n = streamTokenizer.nextToken()) != -1) {
                String string;
                if (n != -3 || !this.protocols.contains(string = streamTokenizer.sval.toLowerCase()) || streamTokenizer.nextToken() != 58 || streamTokenizer.nextToken() != 47) continue;
                String string2 = string + ":/";
                while ((n = streamTokenizer.nextToken()) == -3 || n == 47) {
                    string2 = n == -3 ? string2 + streamTokenizer.sval : string2 + (char)n;
                }
                if (string2.endsWith(".")) {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                if (this.f1.contains(string2)) continue;
                this.f1.addElement(string2);
                this.urlList.add(string2);
                this.urlList.makeVisible(this.urlList.getItemCount() - 1);
                System.out.println("URLFilter: found \"" + string2 + "\"");
            }
            return;
        }
        catch (IOException iOException) {
            System.err.println("URLFilter: recognition aborted: " + iOException);
            return;
        }
    }

    protected void showURL(String string) {
        if (this.context == null) {
            System.err.println("URLFilter: no url-viewer available\n");
            return;
        }
        try {
            this.context.showDocument(new URL(string), "URLFilter");
            return;
        }
        catch (Exception exception) {
            System.err.println("URLFilter: cannot load url: " + exception);
            return;
        }
    }

    public void setFilterSource(FilterPlugin filterPlugin) {
        this.source = filterPlugin;
    }

    public int read(byte[] byArray) throws IOException {
        int n = this.source.read(byArray);
        if (n > 0) {
            this.pout.write(byArray, 0, n);
        }
        return n;
    }

    public void write(byte[] byArray) throws IOException {
        this.source.write(byArray);
    }

    public Component getPluginVisual() {
        return this.urlPanel;
    }

    public Menu getPluginMenu() {
        return this.urlMenu;
    }

    static Vector access$000(URLFilter uRLFilter) {
        return uRLFilter.f1;
    }
}

