/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta;

import de.mud.jta.Common;
import de.mud.jta.HelpFrame;
import de.mud.jta.Plugin;
import de.mud.jta.VisualTransferPlugin;
import de.mud.jta.event.FocusStatusListener;
import de.mud.jta.event.OnlineStatusListener;
import de.mud.jta.event.ReturnFocusRequest;
import de.mud.jta.event.SocketRequest;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.PrintJob;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class Main {
    private static final int debug = 0;
    private static final boolean personalJava = false;
    private static Plugin focussedPlugin;
    private static Clipboard clipboard;
    private static HelpFrame helpFrame;
    static /* synthetic */ Class class$de$mud$jta$Main;

    public static void main(String[] args) {
        String cfg;
        final Properties options = new Properties();
        try {
            options.load((class$de$mud$jta$Main == null ? (class$de$mud$jta$Main = Main.class$("de.mud.jta.Main")) : class$de$mud$jta$Main).getResourceAsStream("/de/mud/jta/default.conf"));
        }
        catch (IOException e) {
            System.err.println("jta: cannot load default.conf");
        }
        String error = Main.parseOptions(options, args);
        if (error != null) {
            System.err.println(error);
            System.err.println("usage: de.mud.jta.Main [-plugins pluginlist] [-addplugin plugin] [-config url_or_file] [-term id] [host [port]]");
            System.exit(0);
        }
        if ((cfg = options.getProperty("Main.config")) != null) {
            try {
                options.load(new URL(cfg).openStream());
            }
            catch (IOException e) {
                try {
                    options.load(new FileInputStream(cfg));
                }
                catch (Exception fe) {
                    System.err.println("jta: cannot load " + cfg);
                }
            }
        }
        final String host = options.getProperty("Socket.host");
        final String port = options.getProperty("Socket.port");
        final Frame frame = new Frame("jta: " + host + (port.equals("23") ? "" : " " + port));
        try {
            clipboard = frame.getToolkit().getSystemClipboard();
        }
        catch (Exception e) {
            System.err.println("jta: system clipboard access denied");
            System.err.println("jta: copy & paste only within the JTA");
            clipboard = new Clipboard("de.mud.jta.Main");
        }
        final Common setup = new Common(options);
        setup.registerPluginListener(new OnlineStatusListener(){

            public void online() {
                frame.setTitle("jta: " + host + (port.equals("23") ? "" : " " + port));
            }

            public void offline() {
                frame.setTitle("jta: offline");
            }
        });
        setup.registerPluginListener(new FocusStatusListener(){

            public void pluginGainedFocus(Plugin plugin) {
                focussedPlugin = plugin;
            }

            public void pluginLostFocus(Plugin plugin) {
            }
        });
        Hashtable componentList = setup.getComponents();
        Enumeration names = componentList.keys();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Component c = (Component)componentList.get(name);
            if (options.getProperty("layout." + name) == null) {
                System.err.println("jta: no layout property set for '" + name + "'");
                frame.add("South", c);
                continue;
            }
            frame.add(options.getProperty("layout." + name), c);
        }
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                setup.broadcast(new SocketRequest());
                ((Component)frame).setVisible(false);
                frame.dispose();
                System.exit(0);
            }
        });
        MenuBar mb = new MenuBar();
        Menu file = new Menu("File");
        file.setShortcut(new MenuShortcut(72, true));
        MenuItem tmp = new MenuItem("Connect");
        file.add(tmp);
        tmp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                setup.broadcast(new SocketRequest(host, Integer.parseInt(port)));
            }
        });
        tmp = new MenuItem("Disconnect");
        file.add(tmp);
        tmp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                setup.broadcast(new SocketRequest());
            }
        });
        file.add(new MenuItem("-"));
        tmp = new MenuItem("Print");
        file.add(tmp);
        tmp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (setup.getComponents().get("Terminal") != null) {
                    PrintJob printJob = frame.getToolkit().getPrintJob(frame, "JTA Terminal", null);
                    if (printJob == null) {
                        return;
                    }
                    ((Component)setup.getComponents().get("Terminal")).print(printJob.getGraphics());
                    printJob.end();
                }
            }
        });
        file.add(new MenuItem("-"));
        tmp = new MenuItem("Exit");
        file.add(tmp);
        tmp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                frame.dispose();
                System.exit(0);
            }
        });
        mb.add(file);
        Menu edit = new Menu("Edit");
        edit.setShortcut(new MenuShortcut(72, true));
        tmp = new MenuItem("Copy");
        edit.add(tmp);
        tmp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (focussedPlugin instanceof VisualTransferPlugin) {
                    ((VisualTransferPlugin)((Object)focussedPlugin)).copy(clipboard);
                }
            }
        });
        tmp = new MenuItem("Paste");
        edit.add(tmp);
        tmp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (focussedPlugin instanceof VisualTransferPlugin) {
                    ((VisualTransferPlugin)((Object)focussedPlugin)).paste(clipboard);
                }
            }
        });
        mb.add(edit);
        Hashtable menuList = setup.getMenus();
        names = menuList.keys();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            mb.add((Menu)menuList.get(name));
        }
        Menu help = new Menu("Help");
        help.setShortcut(new MenuShortcut(156, true));
        tmp = new MenuItem("General");
        help.add(tmp);
        tmp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (helpFrame == null) {
                    helpFrame = new HelpFrame(options.getProperty("Help.url"));
                }
                ((Component)helpFrame).setVisible(true);
            }
        });
        mb.setHelpMenu(help);
        frame.setMenuBar(mb);
        frame.pack();
        if (new Boolean(options.getProperty("Applet.detach.fullscreen")).booleanValue()) {
            ((Component)frame).setSize(frame.getToolkit().getScreenSize());
        } else {
            frame.pack();
        }
        frame.show();
        setup.broadcast(new SocketRequest(host, Integer.parseInt(port)));
        setup.broadcast(new ReturnFocusRequest());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String parseOptions(Properties options, String[] args) {
        boolean host = false;
        boolean port = false;
        int n = 0;
        while (n < args.length) {
            if (args[n].equals("-config")) {
                if (args[n + 1].startsWith("-")) return "missing parameter for -config";
                ((Hashtable)options).put("Main.config", args[++n]);
            } else if (args[n].equals("-plugins")) {
                if (args[n + 1].startsWith("-")) return "missing parameter for -plugins";
                ((Hashtable)options).put("plugins", args[++n]);
            } else if (args[n].equals("-addplugin")) {
                if (args[n + 1].startsWith("-")) return "missing parameter for -addplugin";
                ((Hashtable)options).put("plugins", args[++n] + "," + ((Hashtable)options).get("plugins"));
            } else if (args[n].equals("-term")) {
                if (args[n + 1].startsWith("-")) return "missing parameter for -term";
                ((Hashtable)options).put("Terminal.id", args[++n]);
            } else if (!host) {
                ((Hashtable)options).put("Socket.host", args[n]);
                host = true;
            } else {
                if (!host || port) return "unknown parameter '" + args[n] + "'";
                ((Hashtable)options).put("Socket.port", args[n]);
                port = true;
            }
            ++n;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

