{ MAIN.PAS - Main unit for the Windows Nexus/2 User Editor }
{ Created on 12/27/96 at 12:35 PM }

{ All code herein is by Brandon Sneed.  If it fubar's your userlist,
  its not my fault.  Any modifications are encouraged, and are also
  not the fault of the author.  Anything you steal or rip, don't bother
  giving me credit, cuz if your ripping this code, then you probably
  suck.  Do me a favor and don't mention my name.  However, if you're
  adding to this one.. then by all means, say "Thanks!" :) }
{
  Revision information

  1.00 - Initial creation
}

unit Main;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, Records, Buttons, Tabs, TabNotBk,
  Mask;

const
  Version : String[5] = ' 1.00';
  { this is the variable used to store the filename of the open list }
  UFileName : String = 'C:\NEXUS\DATA\USER.LST';

type
  TEditForm = class(TForm)
  { do NOT mess with these declarations.. Delphi handles everything
    above the Private Dec's.. }
    ToolPanel: TPanel;
    UserListBox: TListBox;
    OpenFile: TSpeedButton;
    OpenDialog: TOpenDialog;
    ExitBtn: TSpeedButton;
    EditNoteBook: TTabbedNotebook;
    HandleLabel: TLabel;
    RealNameLabel: TLabel;
    PwLabel: TLabel;
    StreetLabel: TLabel;
    CityStateLabel: TLabel;
    ZipcodeLabel: TLabel;
    SexLabel: TLabel;
    NameEdit: TEdit;
    RealNameEdit: TEdit;
    PwEdit: TEdit;
    DeletedCheck: TCheckBox;
    StreetEdit: TEdit;
    CityStateEdit: TEdit;
    ZipcodeEdit: TMaskEdit;
    SexComboBox: TComboBox;
    AutoSigLabel: TLabel;
    AutoSigEdit: TEdit;
    NoteLabel: TLabel;
    NoteEdit: TEdit;
    BDayLabel: TLabel;
    BdayEdit: TMaskEdit;
    PhLabel: TLabel;
    PhEdit: TMaskEdit;
    procedure FormCreate(Sender: TObject);
    procedure ExitBtnClick(Sender: TObject);
    procedure OpenFileClick(Sender: TObject);
    procedure UserListBoxClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure ReadInUserList(Sender: TObject);
    procedure LoadUserValues(Usernum : Word; Username : String);
    procedure SetUserValues;
  end;

var
  EditForm: TEditForm;
  UFile : File of UserRec;
  URec : UserRec;

implementation

{$R *.DFM}

{ do NOT put this in the TEditForm object!! This needs to be a
  Static Procedure.. }
procedure ErrorMessage(S : String);
begin
MessageDlg(S, mtError, [mbOK], 0);
end;

{ this procedure sets all the editor values to their corresponding
  values in the record.  This procedure should be VERY self-explanatory }
procedure TEditForm.SetUserValues;
begin
with URec do
  begin
  NameEdit.Text := Name;
  RealnameEdit.Text := Realname;
  PwEdit.Text := Pw;
  DeletedCheck.Checked := Deleted;
  StreetEdit.Text := Street;
  CityStateEdit.Text := CityState;
  ZipCodeEdit.Text := ZipCode;
  AutoSigEdit.Text := AutoSig;
  NoteEdit.Text := Note;
  BDayEdit.Text := Bday;
  PhEdit.Text := Ph;
  Case Sex of
    'M' : SexComboBox.Text := 'Male';
    'F' : SexComboBox.Text := 'Female';
    'L' : SexComboBox.Text := 'Lots';
    'N' : SexComboBox.Text := 'None';
    'D' : SexComboBox.Text := 'Dog';
    'P' : SexComboBox.Text := 'Possibility';
    end; { case }
  end; { with URec }
end;

procedure TEditForm.LoadUserValues(Usernum : Word; Username : String);
begin
{ When this is called, UFile should already have a file handle }
try
  Reset(UFile);
  try
    { a seek to Usernum should put us right where the highlighted
      users information is }
    seek(UFile, Usernum+1);
    read(UFile, URec);
    { this sets the values in the editor }
    SetUserValues;
  except
    on E : Exception do ErrorMessage('Unable to find '+Username);
  end; { try }
  { open and unused file handles are BAD!  Satan lives in your code. }
  CloseFile(UFile);
except
  on E : Exception do ErrorMessage('Unable to reset '+UFileName);
end; { try }
end;

procedure TEditForm.FormCreate(Sender: TObject);
begin
{ Read in the Initial user.lst }
ReadInUserList(Self);
{ i used Self as a sender because i felt like it.. :) }
LoadUserValues(0, 'First user');
end;

{ Open the userfile on startup and create our list }
{ uses UFileName to determine the file to be opened }
procedure TEditForm.ReadInUserList(Sender: TObject);
begin
{ first we gotta make sure the list is clear }
UserListBox.Clear;
try
  AssignFile(UFile, UFileName);
  try
    Reset(UFile);
  except
    on E : Exception do ErrorMessage('Unable to open '+UFileName);
  end; { 2nd try }
  { ok, if we've gotten here, then USER.LST is open for sure }
  { now, we need to seek to record #1 since #0 is a dummy record }
  seek(UFile, 1);
  while (not eof(UFile)) do
    try
      Read(UFile, URec);
      UserListBox.Items.Add(URec.Name);
    except
      on E : Exception do ErrorMessage('Error reading '+UFileName);
      { a little error handling never hurts.. }
    end;
finally
  {$I-}
  { finally, if everything goes well, then we close the file }
  { turn off error checking just in case.. since we don't care
    about an error or not.. }
  CloseFile(UFile);
  {$I+}
end; { 1st try }
end;

procedure TEditForm.ExitBtnClick(Sender: TObject);
begin
{ Closing the main form closes the application }
EditForm.Close;
{ boom.. we're gone like donkey kong.. }
end;

procedure TEditForm.OpenFileClick(Sender: TObject);
begin
{ ok.. now for the familiar windows Open a File dialog box. :) }
OpenDialog.Execute;
{ now, we pull the filename that the dialog selected.. }
UFilename := OpenDialog.Filename;
{ and boom.. read it in like jim.  Remember, it uses UFileName for
  the filename to open & read }
ReadInUserList(Sender);
end;

procedure TEditForm.UserListBoxClick(Sender: TObject);
begin
with UserListBox do
  LoadUserValues(ItemIndex, Items[ItemIndex]);
end;

end.
