
Program Oblivion_To_Impulse_Convert;

Uses Crt;

Type

  acrq='@'..'Z';                  { Access Restriction flags }

    uflags =
   (rlogon,                       { L - Restricted to one call a day }
    rchat,                        { C - Can't page the SysOp }
    rvalidate,                    { V - Posts marked unvalidated }
    rbackspace,                   { B - Can't do ^B/^N/etc in messages }
    ramsg,                        { A - Can't change the AutoMessage }
    rpostan,                      { * - Can't post anonymously }
    rpost,                        { P - Can't post at all }
    remail,                       { E - Can't send any e-mail }
    rvoting,                      { K - Can't vote }
    rmsg,                         { M - Force e-mail deletion }
    spcsr,                        { }
    onekey,                       { onekey input mode }
    avatar,                       { user has AVATAR }
    pause,                        { pause }
    novice,                       { user is at novice help level }
    ansi,                         { user has ANSI }
    color,                        { user has color }
    alert,                        { alert SysOp when user logs on }
    smw,                          { short-message waiting for user }
    nomail,                       { user mail-box is closed }
    fnodlratio,                   { 1 - No UL/DL ratio }
    fnopostratio,                 { 2 - No post/call ratio }
    fnofilepts,                   { 3 - No file points checking }
    fnodeletion);                 { 4 - Protection from deletion }


  colors   = array[FALSE..TRUE,0..9] of byte; { Color tables }
  secrange = array[0..255] of integer;        { Access tables }

  mzscanr  = set of 1..250;              { Which message bases to scan }
  fzscanr  = set of 1..250;             { Which file bases to scan }
  mhireadr = array[1..250] of longint;   { Lastread pointers }

  dlnscan =set of 0..96;
  str8=string[8];
  Mstr=String[35];
  LStr=String[80];

  obvuserRec = Record
    Handle,
    RealName,
    PhoneNum,
    Address,
    Location,
    Password,
    UserNote     : MStr;
    BirthDay     : Str8;
    Infoforms    : Array[1..5] Of Integer;
    Level,
    Flevel       : Integer;
    LastFiles,
    LastPosts,
    LastCall     : LongInt;
    LastLevel,
    LastFLevel   : Integer;
    FilePoints   : Integer;
    UpK,
    DnK          : LongInt;
    UDR,
    UDKR         : Byte;
    DnKPerDay,
    DnKToday,
    Uploads,
    Downloads,
    Posts,
    Calls,
    TimeLeft,
    TimeLimit    : Word;
    RegColor,
    PromptColor,
    InputColor,
    InverseColor,
    StatColor,
    BoxColor,
    PCR,
    Unused3,
    Unused4,
    PromptSel,
    MenuSel,
    StatusSel    : Byte;
    Ansi,
    Avatar,
    vt100        : Boolean;
    FlConfig     : Array[1..10] Of Boolean;
    NuvVotesYes,
    NuvVotesNo   : Byte;
    UVotingYes   : Array[1..30] Of Word;
    UVotingNo    : Array[1..30] Of Word;
    Reserved     : Array[0..187] Of Word;
    LastRepDate  : LongInt;
    ScrollFL,
    Rip          : Boolean;
    CallsToday,
    NewLevel,
    CSPassChange : Word;
    CurArchiver  : Byte;
    ReDisMes     : Boolean;
    CFlags       : Array[1..26] Of Boolean;
    Unused32     : Set Of Byte;
    AverageUpCPS,
    AverageDnCPS : Word;
    Wanted       : Boolean;
    AutoSig      : Array[1..5] Of Lstr;
    UseFSE       : Boolean;
    HeaderType,
    LastMesConf,
    LastFileConf : Byte;
    ReplyReading : Boolean;
    NetMailB     : Word;
    AnsiAbort    : Boolean;
    ExpDate      : LongInt;
    IsMale       : Boolean;
    FirstOn      : LongInt;
    YesNoBars    : Boolean;
    HackAttempts : Word;
    VotingRec    : Array[1..35] Of Byte;
    NUVComments  : Array[1..10] Of LStr;
    TimeBank     : Word;
    PageLen      : Byte;
    DoPause      : Boolean;
    TimeDesT     : Word;
    Unused       : Array[1..194] Of Byte;
  End;

   clrs = array[FALSE..TRUE,0..9] of byte;

  flistflags =
   (fname,                        {filename }
    fsize,                        {file size}
    fpts,                         {fiel points}
    fdesc,                        {file desc.}
    extdesc,                      {extended desc.}
    whoul,                        {who uploaded it}
    dateul,                       {date uploaded}
    numdl);                       {num of d/l's.}

  userrec=                            { USER.LST : User account records }
  record
    name:string[36];                  { user name        }
    realname:string[36];              { real name        }
    pw:string[20];                    { user password    }
    ph:string[12];                    { user phone #     }
    bday:string[8];                   { user birthdate   }
    firston:string[8];                { firston date     }
    x1xs  :array[1..2] of byte;
    laston:string[8];                 { laston date      }
    x2xs  :array[1..2] of byte;
    street:string[30];                { mailing address  }
    citystate:string[30];             { city, state      }
    zipcode:string[10];               { zipcode          }
    computer:string[30];              { type of computer }
    occupation:string[40];            { (borrowed variable) autosig }
    wherebbs:string[40];              { BBS reference    }
    note:string[39];                  { SysOp note       }
    prompt:byte;                   { Chosen Menu Prompt }
    lockedout:boolean;                { if locked out    }
    deleted:boolean;                  { if deleted       }
    lockedfile:string[8];             { lockout msg to print }
    novotes,
    yesvotes:byte;                    { # of yes/no votes in NUV }
    ac:set of uflags;                 { user flags   }
    fflag:set of flistflags;          { users configable file list }
    ar:set of acrq;                   { AR flags     }

    zzqscan:array[1..64] of word;     { last read msg pointers }
    xqxxx:array[1..64] of word;
    zzqscn:array[1..64] of boolean;   { scan boards flags  }
    zzdlnscn:dlnscan;                 { scan uboards flags }

    vote:array[1..20] of byte;        { voting data  }

    sex:char;                         { user sex }

    ttimeon:longint;                  { total mins spent on  }
    x1xx:integer;
    uk:longint;                       { UL k                 }
    x2xx:integer;
    dk:longint;                       { DL k                 }
    x3xx:integer;

    uploads,downloads,                { # of ULs / # of DLs  }
    loggedon,                         { # times logged on    }
    tltoday,                          { # min left today     }
    msgpost,                          { # public posts       }
    emailsent,                        { # email sent         }
    feedback,                         { # feedback sent      }
    forusr,                           { forward mail to user # }
    filepoints:integer;               { # of file points     }

    waiting,                          { mail waiting         }
    linelen,                          { line length (# cols) }
    pagelen,                          { page length (# rows) }
    ontoday,                          { # times on today     }
    illegal,                          { # illegal logon attempts }
    sl,dsl:byte;                      { SL / DSL }

    cols:clrs;                        { user colors }

    lastmsg,lastfil:byte;             { last msg/file areas   }
    credit:longint;                   { $$$ credit in dollars }
    x4xx:integer;
    timebank:integer;                 { # mins in Time Bank   }
    boardsysop:array[1..5] of byte;   { msg board SysOp       }

    trapactivity,                     { if trapping users activity }
    trapseperate:boolean;             { if trap to seperate TRAP file }

    timebankadd:integer;              { time added to timebank TODAY }
    mpointer:longint;                 { *REMOVED* }
    chatauto,                         { if auto chat trapping }
    chatseperate:boolean;             { if seperate chat file to trap to }
    userstartmenu:string[8];          { menu to start user out on }
    slogseperate:boolean;             { seperate SysOp log? }
    clsmsg:byte;                      { 1 if clear-screen msg, 2 if not }

{ NEW STUFF }

    flistopt:byte;                    { type of file list type to use }
    msgorder:byte;                    { 0:Chrono, 1:ReplyTree }
    avadjust:byte;                    { AVATAR color adjust: 1=no, 2=yes }

{ NEW STUFF *ENDS* }

    {res:array[1..54] of byte;         { RESERVED }
  end;

  smalrec=                            { NAMES.LST : Sorted names listing }
  record
    name:string[36];                  { user name }
    number:integer;                   { user number }
  end;


function allcaps(s:string):string;
var i:integer;
begin
  for i:=1 to length(s) do s[i]:=upcase(s[i]);
  allcaps:=s;
end;


Procedure lst_Convert;
Var UFile:File of obvuserRec;
    CEL:obvuserRec;
    VFile:File of UserRec;
    VFile1:file of SmalRec;
    VIS:UserRec;
    VIS1:Smalrec;
    Obv,Cnt,I:Integer;
const dcols:clrs=((15,7,7,15,15,15,112,7,15,7),(15,7,1,11,9,8,25,3,7,8));
Begin
  Writeln(^M^J'Converting: Obv/2 User List to Impulse Format!');
  Assign (UFile,'USER.LST');       { Open And Rename obv's Users File }
  {$I-} Reset (UFile); {$I+}
  If IOResult <> 0 Then Begin
    Writeln ('File: USER.LST not found.. Cannot continue!');
    Close (UFile);
    Exit
  End;
  rename(ufile,'OBVUSER.OLD');
  assign(ufile,'OBVUSER.OLD');
  reset(ufile);
  Assign (VFile,'USER.LST');      { Open and Create Impulse Users File }
  Rewrite (VFile);
  Assign (Vfile1,'NAMES.LST');
  Rewrite (vfile1);
  Obv:=0;
  Seek (UFile,obv);
  Seek (VFile,1);
  Seek (Vfile1,1);
  Cnt:=1;
  TextAttr:=11;
  While Not Eof(UFile) Do Begin
    Read (UFile,CEL);
    vis1.name:=allcaps(cel.handle);
    vis1.number:=cnt;
    vis.name:=allcaps(cel.handle);
    vis.realname:=cel.realname;
    vis.pw:=allcaps(cel.password);
    vis.ph:=cel.phonenum;
    vis.bday:=cel.birthday;
    vis.firston:='00/00/00';
    vis.laston:='00/00/00';
    vis.street:=cel.address;
    vis.citystate:=cel.location;
    vis.zipcode:='';
    vis.computer:='';
    vis.occupation:='';
    vis.wherebbs:='';
    vis.prompt:=0;
    vis.note:=cel.usernote;
    vis.lockedout:=FALSE;
    vis.deleted:=FALSE;
    vis.lockedfile:='';
    vis.ac:=vis.ac+[onekey,pause,novice,ansi,color];
    vis.fflag:=vis.fflag+[fname];
    vis.fflag:=vis.fflag+[fsize];
    vis.fflag:=vis.fflag+[fpts];
    vis.fflag:=vis.fflag+[fdesc];
    vis.fflag:=vis.fflag+[extdesc];
    vis.ar:=[];
    for i:=1 to 20 do vis.vote[i]:=0;
    if cel.ismale then
    vis.sex:='M' else vis.sex:='F';
    vis.ttimeon:=0;
    vis.uk:=cel.upk;
    vis.dk:=cel.dnk;
    vis.ac:=vis.ac-[rlogon]         { L - Restricted to one call a day }
    -[rchat]                        { C - Can't page the SysOp }
    -[rvalidate]                    { V - Posts marked unvalidated }
    -[rbackspace]                   { B - Can't do ^B/^N/etc in messages }
    -[ramsg]                        { A - Can't change the AutoMessage }
    -[rpostan]                      { * - Can't post anonymously }
    -[rpost]                        { P - Can't post at all }
    -[remail]                       { E - Can't send any e-mail }
    -[rvoting]                      { K - Can't vote }
    -[rmsg]                         { M - Force e-mail deletion }
    -[spcsr]                        { }
    +[onekey]                       { onekey input mode }
    -[avatar]                       { user has AVATAR }
    +[pause]                        { pause }
    -[novice]                       { user is at novice help level }
    +[ansi]                         { user has ANSI }
    +[color]                        { user has color }
    -[alert]                        { alert SysOp when user logs on }
    -[smw]                          { short-message waiting for user }
    -[nomail]                       { user mail-box is closed }
    -[fnodlratio]                   { 1 - No UL/DL ratio }
    -[fnopostratio]                 { 2 - No post/call ratio }
    -[fnofilepts]                   { 3 - No file points checking }
    -[fnodeletion];                 { 4 - Protection from deletion }
    vis.uploads:=cel.uploads;
    vis.downloads:=cel.downloads;
    vis.loggedon:=cel.calls;
    vis.tltoday:=cel.timelimit;
    vis.msgpost:=cel.posts;
    vis.emailsent:=0;
    vis.feedback:=0;
    vis.forusr:=0;
    vis.filepoints:=cel.filepoints;
    vis.waiting:=0;
    vis.linelen:=80;
    vis.pagelen:=24;
    vis.ontoday:=0;
    vis.illegal:=cel.hackattempts;
    if cel.level>255 then vis.sl:=255 else vis.sl:=cel.level;
    if cel.flevel>255 then vis.dsl:=255 else vis.dsl:=cel.flevel;
    vis.cols:=dcols;
    vis.lastmsg:=1;
    vis.lastfil:=1;
    vis.credit:=0;
    vis.timebank:=cel.timebank;
    vis.trapactivity:=FALSE;
    vis.trapseperate:=FALSE;
    vis.timebankadd:=0;
    vis.mpointer:=-1;
    vis.chatauto:=false;
    vis.chatseperate:=false;
    vis.userstartmenu:='';
    vis.slogseperate:=false;
    vis.clsmsg:=2;
    vis.flistopt:=1;
    vis.msgorder:=0;
    vis.avadjust:=1;
    if (cnt=1) then begin
      seek(vfile,0);
      write(vfile,vis);
      seek(vfile,0);
      write(vfile1,vis1);
    end else begin
      Write (VFile,VIS);
      Write (VFile1,VIS1);
    end;
    inc(cnt);
    inc(obv);
      Write (VFile,VIS);
      Write (vfile1,vis1);
      Seek (VFile,Cnt);
      Seek (VFile1,Cnt);
  End;
  Writeln (Cnt-1,' Users Converted over to Impulse.');
  Close (UFile);
  Close (VFile);
  Close (VFile1);
End;


Var K:Char;
Begin
  TextAttr:=7;
  ClrScr;
  TextAttr:=11;
  Write (#13#10#13#10'Oblivion/2 to ');
  TextAttr:=11;
  Write('Impulse ');
  TextAttr:=11;
  Writeln ('User Converter.');
  TextAttr:=15;
  Writeln;
  Repeat
   Write('Continue With Conversion [N]? ');
   K:=Upcase(ReadKey);
  Until K in [#13,'Y','N'];
  If K = 'Y' Then Begin
    lst_Convert;
    Writeln('Oblivion/2 USER.LST Saved as OBVUSER.OLD');
  End;
End.
