{$A+,B+,F+,I+,L-,O-,R-,S-,V-}
Unit Common4;

Interface

Uses Records,Common,Common5, Dos,  Crt;

Const
  RegistD:Boolean=FALSE;

Var
  FConf,
  MConf:byte;
  areanum:array [1..150] of byte;

Procedure registered;
procedure DisableInterrupts;
procedure EnableInterrupts;
procedure middle(c:string;s:string);
procedure top;
procedure bottom;
procedure header(s:string);
procedure command(s:string);
procedure calconf(cnf:byte); {1=msg, 2=file}
Function StripAnsi(InString : String) : String;

Implementation

Procedure registered;
var
   x1,y1,z1,x2,y2,z2,w1,w2:real;
   b1,b2,s1,s2:string;
   rb,check:string[10];
   rx,lx,uy,ly:integer;
   color1,color2,backg,add,add2,yn2:shortint;
   yn:char;

type
  keyfile = record
            dummy1 : array [1..2] of string[10];
            regkey : string[10];
            dummy2 : string[10];
            dummy3 : string[6];
            dummy4 : array [1..3] of string[10];
            end;
var
  keyf : file of keyfile;
  key : keyfile;

begin
 registd:=false;

 if not exist('NEX.KEY') then
  exit;
 assign(keyf, 'NEX.KEY');
 reset(keyf);
 read(keyf, key);
 close(keyf);

 b1:=systat.sysopname;
 b2:=systat.bbsname;
 w1:=0; w2:=0;
 x1:=length(b1)*0.5853;
 y1:=(x1)*(x1)*(x1);
 z1:=y1*132*ln(y1)*ln(x1);

   if z1 >= 10000000 then w1:=z1*0.001;
   if (z1 < 10000000) and (z1 >= 1000000) then w1:=z1*0.01;
   if (z1 < 1000000) and (z1 >= 100000) then w1:=z1*0.1;
   if (z1 < 100000) and (z1 >= 10000) then w1:=z1;
   if (z1 < 10000) and (z1 >= 1000) then w1:=z1*10;
   if (z1 < 1000) and (z1 >= 100) then w1:=z1*100;
   if (z1 < 100) and (z1 >= 10) then w1:=z1*1000;
   if (z1 < 10) then w1:=z1*10000;

 x2:=length(b2)*0.7183;
 y2:=(x2)*(x2)*(x2);
 z2:=y2*ln(y2)*ln(x2);

   if z2 >= 10000000 then w2:=z2*0.001;
   if (z2 < 10000000) and (z2 >= 1000000) then w2:=z2*0.01;
   if (z2 < 1000000) and (z2 >= 100000) then w2:=z2*0.1;
   if (z2 < 100000) and (z2 >= 10000) then w2:=z2;
   if (z2 < 10000) and (z2 >= 1000) then w2:=z2*10;
   if (z2 < 1000) and (z2 >= 100) then w2:=z2*100;
   if (z2 < 100) and (z2 >= 10) then w2:=z2*1000;
   if (z2 < 10) then w2:=z2*10000;

 str(trunc(w1),s1);
 str(trunc(w2),s2);
 check:=s1+s2;
 rb:=key.regkey;
 if (rb=check) then registd:=true else registd:=false;
end;

procedure DisableInterrupts;
begin
  inline($FA);  {cli}
end;

procedure EnableInterrupts;
begin
  inline($FB);  {sti}
end;

procedure header(s:string);
begin
sprint(#3#9+' '+#3#1+s);
end;

procedure top;
begin;
sprint('|08Ŀ');
end;

procedure middle(c:string;s:string);
begin
sprompt('|08 |15'+c+' |08  |07');
print(s);
end;

procedure bottom;
begin
sprint('|08');
end;

procedure command(s:string);
begin
sprompt(#3#0+'Command '+#3#5+'['+#3#1+s+#3#5+'] '+#3#0);
end;


Procedure CalConf(cnf:byte);
var clr:byte;

  Procedure FileConf;
  var fb,b,b2,i:integer;
      acc:boolean;
  begin
    b:=1;
    acc:=false;
    fb:=1;
    while (b<=maxulb) do begin
      acc:=fbaseac(b); { fbaseac will load memuboard }
      if ((fbunhidden in memuboard.fbstat) or (acc)) and
        ((memuboard.conf=fconf) or (fconf=0))
      then begin
        if (acc) then begin
          b2:=ccuboards[1][b];
          areanum[fb]:=b2;
          inc(fb);
        end;
      end;
      inc(b);
    end;
  end;

  procedure MsgConf;
  var mb,b,b2,i:integer;
      acc:boolean;
  begin
    b:=1;
    acc:=false;
    mb:=1;
    while (b<=numboards) do begin
      acc:=mbaseac(b);
      if ((mbunhidden in memboard.mbstat) or (acc)) and
        ((memboard.conf=mconf) or (mconf=0))
      then begin
        if (acc) then begin
          b2:=ccboards[1][b];
          areanum[mb]:=b2;
          inc(mb);
        end;
      end;
      inc(b);
    end;
  end;

begin
  for clr:=1 to 150 do areanum[clr]:=0;
  case cnf of
  1:msgconf;
  2:fileconf;
  end;
end;

Function StripAnsi(InString : String) : String;
Const Esc         = Chr(27);
      Ansi_Letter = 'JDCABHmfsuK'+Chr(13);

Var HiC,HiB              : Byte;
    SaveAnsiX,SaveAnsiY  : Byte;
    I : Byte;
    A : Byte;
    D : Boolean;
   Begin
      D := False;
      If InString = '' Then
         Begin
            StripAnsi := '';
            Exit;
         End;
      Repeat
         Begin
            A := Pos(Chr(27)+'[',InString);
            If A > 0 Then
               Begin
                  Delete(InString,A,2);
                  I := A;
                  While (I < Length(InString)) And (Pos(InString[I],Ansi_Letter) = 0) Do
                     Inc(I);
                  Delete(InString,A,I-A+1);
               End
            Else
               D := True;
         End;
      Until D Or (InString = '');
      StripAnsi := InString;
   End;

End.
