{$A+,B+,F+,I+,L-,O+,R-,S-,V-}
unit adfmenu;

interface

uses crt, mouse;

type
  menurec = record
            text : string; { description }
            xpos,              { X coord }
            ypos : byte;       { Y coord }
            key  : char;       { hot key }
            end;

function domenu(var menu; numitems, start, highclr, loclr : byte; mse, timer : boolean) : byte;
  { the MENU param must be untyped since we'll be passing an array to it }
  {  menu = menu array constant                   }
  {  numitems = number of items in the menu array }
  {  start = which item should be highlighted by default? usually 1 }
  {  highclr = color to highlight with            }
  {  loclr = color to deselect with               }
  {  mse = enable mouse                           }
  {  timer = use 10 second timer to auto-select   }

implementation

function domenu(var menu; numitems, start, highclr, loclr : byte; mse, timer : boolean) : byte;
type
  menucast = array [1..25] of menurec;
var
  cnt : byte;
	choice : byte;
  getkey : char;
  mousex,
  mousey : word;
	dummy : word;
  click : boolean;
  MClicks : word;
	oldchoice : byte;
  oldsec : word;
  hour,min,sec,hs : word;
begin
  click := false;
  if start > numitems then start := 1;
  begin
  { draw the menu }
  for cnt := 1 to numitems do
    with menucast(menu)[cnt] do
    begin
    textattr := loclr;
    gotoxy(xpos, ypos);
    write(text);
    end;
  end;

  getkey := #255;
  choice := start;
  if timer then
    begin
    Dos.GetTime(hour, min, oldsec, hs);
    if OldSec > 50 then OldSec := 10;
    end;
  repeat
    if timer then
      begin
      Dos.GetTime(hour, min, sec, hs);
      if (sec > oldsec + 10) then
        begin
        domenu := 1;
        exit;
        end;
      end;
    if (mouse_installed) and (mse) then
    begin
    mouseposition(mousex, mousey);
		if (mousex >= menucast(menu)[1].xpos) and
			 (mousex <= length(menucast(menu)[1].text) + menucast(menu)[1].xpos - 1) and
			 (mousey >= menucast(menu)[1].ypos) and
			 (mousey <= menucast(menu)[numitems].ypos) then
      with menucast(menu)[choice] do
      begin
			if (mousepress(LEFTPRESS, MClicks, dummy, dummy) > 0) then
				click := true;
      textattr := loclr;
			oldchoice := choice;
			choice := (mousey - menucast(menu)[1].ypos) + 1;
			if choice <> oldchoice then
				with menucast(menu)[oldchoice] do
				begin
				gotoxy(xpos, ypos);
				textattr := loclr;
      	write(text);
				end;
			if (choice < 1) or (choice > numitems) then choice := 1;
      end;
    end;
    if (choice <= numitems) and (choice > 0) and (not click) then
    with menucast(menu)[choice] do
      begin
      textattr := highclr;
      gotoxy(xpos, ypos);
      write(text);
      textattr := loclr;

			if (mse) then
				begin
        if keypressed then
          getkey := readkey;
				end
			else
        if keypressed then
          getkey := readkey;

      { if a arrowkey, or any function type key is sent, a #0 always is sent
        first, and THEN the actual key value is sent. so, the first call to
        readkey will get #0, and the second will get the key we're looking
        for. }
      if getkey = #0 then
        begin
        getkey := readkey;
        case getkey of
          { up }
          #72 : if choice > 1 then
                begin
                textattr := loclr;
                gotoxy(xpos, ypos);
                write(text);
                dec(choice);
                end;
          { down }
          #80 : if choice < numitems then
                begin
                textattr := loclr;
                gotoxy(xpos, ypos);
                write(text);
                inc(choice);
                end;
          end;
        end;
      { if they hit ESC, set choice to 0 and exit }
      if getkey = #27 then choice := 0;
      { if they press a key, see if the key the pressed is a hotkey }
      getkey := upcase(getkey);
      if getkey in ['A'..'Z'] then
        begin
        for cnt := 1 to numitems do
          if getkey = menucast(menu)[cnt].key then
            begin
            choice := cnt;
            getkey := #13;
            end;
        end;
      end;

		oldchoice := choice;

  until (getkey = #13) or (getkey = #27) or (click);
  domenu := choice;
end;

end.

