{$I M_OPS.PAS}

// mcfg: add next/prev commands in menu command editor
// make mystic 1 and 2 automatically move to next file when you flag it.

// When reading messages, users can use IGNORE and GOTONEXTBASE even on
// forced message bases.  FIX IT!  also JUMP

// MSGBASEANSI is used for the entire msg reading process.  make function
// to load current msg data into the ansi reader... then there is a display
// function which is based on the line or full reader....

// ADD ENTER to PAGEDOWN in msg reader and file listing like 1.08
// ADD QUOTE MODE TYPE:
//   1) standard
//   2) block
//
// standard = how it is now...
// block = adds begin text and end text to quoted text and doesnt add in the
// xx> initials.

// ADD QUOTE WINDOW BAR COLOR TO TEMPLATE IN FSE
// ADD STRIP HI ASCII IN USER NAMES?
// ADD USE LIGHTBARS IN USER APP
// ADD DEFAULT ARCHIVE INTO CONFIG
// ADD ARCHIVE INTO USER APP
// MAKE SEPARATE FUNC FOR REQUIRED PW CHANGES BECAUSE THEY CANNOT ENTER THE
//   SAME PW.  PLUS WE WANT TO USE SEPARATE PROMPTS!
// ADD MCI CODE FOR YES/NO PROMPTS?
// add data areas or infoforms?
// add file settings
// add archive configuration

// ADD USER UPGRADE TO SNOOP
// ADD EXTERNAL FILE FOR KEEPING WHOS ONLINE
// expand command line for doors
// gender mci code
// make terminal class a tthread that handles all the console stuff so it
// add account expiration based on # of calls.. ie expired after xx calls
// add door/post ratio
// look into autovalidate thing from renegade...
// add a COUNTER option.  acs cmd to check menu cmd to increase, decrease, set
// maybe 5 counters stored in the user's data?
// mci codes for the counters...
// add check to verify mbases.dat and other important files on loading
// to/subj fields are blank in msg editor template when sending email
// make mcfg's user editor refuse to edit the user's account if they are
//   online??
// DELETE in msg reader needs to redraw...
// add cleandir function into mpl?  or at least rmdir mkdir getdir
// clean up door drop files if in temp directory
// change |DX mci code to |DX<file>|
// make |Y1 mci code for yes/no lightbar prompt
// make |Y2 mci code for yes/no lightbar prompt
// todays calls / yesterdays calls
// history...
// rumors .mps
// add up/down scanning into menu_forms.pas ...
// add userflag for no timeleft check
// add menu command to execute dos option
// add menu command to "logoff and restart session"
// add mci codes for uppercase lowercase and char replace
// add mci code for doors ran
// add allow mpe execution outside script dirs? for |DX mci code
// add predefined const into mpl

Program Mystic;

Uses
  { USES BASED ON COMPILER }

  {$IFDEF DEBUG}
    {$IFDEF FPC}
      HeapTrc,
    {$ENDIF}
    {$IFDEF VPC}
      HeapChk,
    {$ENDIF}
  {$ENDIF}

  { USES BASED ON OPERATING SYSTEM }

  m_Output,
  m_Input,
  m_DateTime,
  m_Socket,
  m_Socket_Class,
  m_FileIO,
  m_Strings,
  BBS_Common,
  Sock_Server,
  Mystic_Telnet,
  Mystic_FTP,
  m_Term_Ansi;

Const
  FocusMax    = 1;
  FocusTelnet = 0;
  FocusFTP    = 1;

Var
  Console      : TOutput;
  Input        : TInput;
  TelnetServer : TServerManager;
  FTPServer    : TServerManager;
  FocusPTR     : TServerManager;
  FocusCurrent : Byte;
  TopPage      : Integer;
  BarPos       : Integer;

{$I ANSI_MYSTIC.PAS}

Procedure ReadConfiguration;

  Procedure CheckPath (Str: String);
  Begin
    If Not FileDirExists(Str) Then Begin
      WriteLn;
      WriteLn ('ERROR: Path does not exist: ' + Str);
      WriteLn;
      WriteLn ('Using MCFG, make sure that all paths defined in the System Configuration');
      WriteLn ('are valid.  You may also need to verify that all the paths found in the');
      WriteLn ('THEME editor are valid as well.');
      Halt(1);
    End;
  End;

Var
  FileConfig : TBufFile;
Begin
  FileConfig := TBufFile.Create(SizeOf(recConfig));

  If Not FileConfig.Open('mystic.dat', fmOpen, fmReadWrite + fmDenyNone, SizeOf(recConfig)) Then Begin
    WriteLn;
    WriteLn ('ERROR: Unable to read MYSTIC.DAT.  This file must exist in the same');
    WriteLn ('directory as MYSTIC.  If you for some reason do not have this file,');
    WriteLn ('it can be created by running MCFG.');
    Halt (1);
  End;

  FileConfig.Read(bbsConfig);
  FileConfig.Free;

  If Not CheckBBSVersion(bbsConfig) Then Begin
    WriteLn;
    WriteLn ('ERROR: Mystic has detected a version mismatch.  This means that');
    WriteLn ('one or more programs have not been upgraded properly.  Please');
    WriteLn ('make sure you follow the upgrade instructions completely!');
    Halt (1);
  End;

  CheckPath(bbsConfig.PathSystem);
  CheckPath(bbsConfig.PathData);
  CheckPath(bbsConfig.PathLogs);
  CheckPath(bbsConfig.PathMsgs);
  CheckPath(bbsConfig.PathAttach);
  CheckPath(bbsConfig.PathOffmail);
  CheckPath(bbsConfig.PathMenu);
  CheckPath(bbsConfig.PathText);
  CheckPath(bbsConfig.PathTemplate);
  CheckPath(bbsConfig.PathScripts);
End;

Function GetFocusPtr : TServerManager;
Begin
  Result := NIL;

  Case FocusCurrent of
    FocusTelnet : GetFocusPtr := TelnetServer;
    FocusFTP    : GetFocusPtr := FtpServer;
{
    FocusSMTP   : GetFocusPtr := SmtpServer;
    FocusPOP3   : GetFocusPtr := Pop3Server;
}
  End;
End;

Procedure UpdateConnectionList;
Var
  Count : Byte;
  Attr  : Byte;
  PosY  : Byte;
Begin
  If FocusPtr = NIL Then Exit;

  PosY := 0;

  For Count := TopPage to TopPage + 7 Do Begin
    Inc (PosY);

    If Count = BarPos Then Attr := 31 Else Attr := 7;

    If (Count <= FocusPtr.ClientList.Count) And (FocusPtr.ClientList[Count - 1] <> NIL) Then Begin
      If (FocusCurrent = 0) and (TTelnetServer(FocusPtr.ClientList[Count - 1]).BBS.User <> NIL) Then
        Console.WriteXY (4, 3 + PosY, Attr,
          strPadL(strI2S(Count), 3, '0') + '  ' +
          strPadR(TTelnetServer(FocusPtr.ClientList[Count - 1]).BBS.User.ThisUser.Handle, 17, ' ') + ' ' +
          strPadR(TTelnetServer(FocusPtr.ClientList[Count - 1]).BBS.User.UserAction, 20, ' ') + ' ' +
          strPadL(strI2S(TTelnetServer(FocusPtr.ClientList[Count - 1]).BBS.User.TimeOn) + 'm', 5, ' '))
          // 1234567890123456789012345678901234567890123456789
          // 000  12345678901234567 12345678901234567890 1234m
      Else
        Console.WriteXY (4, 3 + PosY, Attr, strPadL(strI2S(Count), 3, '0') + strPadR('  Online', 46, ' '))
    End Else
    If Count <= FocusPtr.ClientMax Then
      Console.WriteXY (4, 3 + PosY, Attr, strPadL(strI2S(Count), 3, '0') + strPadR('  Waiting', 46, ' '))
    Else
      Console.WriteXY (4, 3 + PosY, Attr, strRep(' ', 49));
  End;
End;

Procedure UpdateStatus;
Var
  Offset : Integer;
  Count  : Integer;
Begin
  If FocusPtr = NIL Then Exit;

  FocusPtr.Server.StatusUpdated := False;

  // UPDATE CONNECTION STATS

  Console.WriteXY (69,  7, 7, strPadR(strI2S(FocusPtr.ClientActive), 5, ' '));
  Console.WriteXY (69,  8, 7, strPadR(strI2S(FocusPtr.ClientBlocked), 5, ' '));
  Console.WriteXY (69,  9, 7, strPadR(strI2S(FocusPtr.ClientRefused), 5, ' '));
  Console.WriteXY (69, 10, 7, strPadR(strI2S(FocusPtr.ClientTotal), 5, ' '));

  // UPDATE STATUS MESSAGES

  Offset := FocusPtr.Server.SocketStatus.Count;

  For Count := 22 DownTo 15 Do Begin
    If Offset > 0 Then Begin
      Dec(Offset);
      Console.WriteXY (4, Count, 7, strPadR(FocusPtr.Server.SocketStatus.Strings[Offset], 74, ' '));
    End Else
      Console.WriteXY (4, Count, 7, strPadR(' ', 74, ' '));
  End;

  UpdateConnectionList;
End;

Procedure SwitchFocus;
Begin
  BarPos  := 1;
  TopPage := 1;

  Repeat
    If FocusCurrent = FocusMax Then FocusCurrent := 0 Else Inc(FocusCurrent);

    Case FocusCurrent of
      FocusTelnet : If TelnetServer <> NIL Then Break;
      FocusFTP    : If FtpServer <> NIL Then Break;
    End;
  Until False;

//  If FocusCurrent = FocusMax Then FocusCurrent := 0 Else Inc(FocusCurrent);

  Console.WriteXY (55, 1, 112, 'telnet/smtp/pop3/ftp/nntp');

  Case FocusCurrent of
    FocusTelnet : Console.WriteXY (55, 1, 113, 'TELNET');
{    FocusSMTP   : WriteXY (62, 1, 'SMTP', 1 + 7 * 16);
    FocusPOP3   : WriteXY (67, 1, 'POP3', 1 + 7 * 16); }
    FocusFTP    : Console.WriteXY (72, 1, 113, 'FTP');
{    FocusNNTP   : WriteXY (76, 1, 'NNTP', 1 + 7 * 16);}
  End;

  FocusPtr := GetFocusPtr;

  If FocusPtr <> NIL Then Begin
    Console.WriteXY (69, 5, 7, strPadR(strI2S(FocusPtr.Port), 5, ' '));
    Console.WriteXY (69, 6, 7, strPadR(strI2S(FocusPtr.ClientMax), 5, ' '));

    UpdateStatus;
  End;
End;

Procedure LocalLogin;
Const
  BufferSize = 1024 * 4;
Var
  Term   : TTermAnsi;
  Client : TSocketClass;
  Res    : LongInt;
  Buffer : Array[1..BufferSize] of Char;
  Done   : Boolean;
  Count  : LongInt;
  Ch     : Char;
Begin
  Console.ClearScreen;
  Console.WriteStr ('Connecting to 127.0.0.1... ');

  Client := TSocketClass.Create;

  If Not Client.Connect('127.0.0.1', strI2S(bbsConfig.InetTNPort)) Then
    Console.WriteLine('Unable to connect')
  Else Begin
    Done := False;
    Term := TTermAnsi.Create(Console);

    If bbsConfig.TaskBar Then Begin
      Console.SetWindow (1, 1, 80, 24, True);
      Console.WriteXY   (1, 25, 112, strPadC('Local mode: ALT-X to Quit', 80, ' '));
    End;

    Term.SetReplyClient(Client);

    Repeat
      If Client.WaitForData(0) > 0 Then Begin
        Repeat
          Res := Client.ReadBuf (Buffer, BufferSize);

          If Res < 0 Then Begin
            Done := True;
            Break;
          End;

          For Count := 1 to Res Do Term.Process(Buffer[Count]);
        Until Res <> BufferSize;
      End Else
      If Input.KeyPressed Then Begin
        Ch := Input.ReadKey;
        Case Ch of
          #00 : Case Input.ReadKey of
                  #45 : Break;
                  #71 : Client.WriteStr(#27 + '[H');
                  #72 : Client.WriteStr(#27 + '[A');
                  #73 : Client.WriteStr(#18);
                  #75 : Client.WriteStr(#27 + '[D');
                  #77 : Client.WriteStr(#27 + '[C');
                  #79 : Client.WriteStr(#27 + '[K');
                  #80 : Client.WriteStr(#27 + '[B');
                  #81 : Client.WriteStr(#3);
                  #83 : Client.WriteStr(#127);
                End;
        Else
          Client.WriteBuf(Ch, 1);
          If Client.FTelnetEcho Then Term.Process(Ch);
        End;
      End Else
        WaitMS(10);
    Until Done;

    Term.Free;
  End;

  Client.Free;
  // kill actual client thread here if <> NIL!

  Console.TextAttr := 7;
  Console.SetWindow (1, 1, 80, 25, True);

  FocusCurrent := FocusMax;
  DrawStatusScreen;
  SwitchFocus;
End;

Const
  WinTitle = 'Mystic Internet Server';

Var
  Count   : Integer;
  Started : Boolean;
Begin
  Randomize;

  {$IFDEF DEBUG}
    {$IFDEF FPC}
      SetHeapTraceOutput('mystic.mem');
    {$ENDIF}
  {$ENDIF}

  ReadConfiguration;

  TelnetServer := NIL;
  FtpServer    := NIL;
  Started      := False;

  Console := TOutput.Create(True);
  Input   := TInput.Create;

  Console.SetWindowTitle(WinTitle);

  If bbsConfig.InetTNUse and (bbsConfig.InetTNMax > 0) Then Begin
    TelnetServer := TServerManager.Create(bbsConfig.InetTNPort, bbsConfig.InetTNMax, {$IFDEF FPC}@{$ENDIF}CreateTelnet);

    TelnetServer.Server.FTelnetServer := True;
    TelnetServer.TextPath             := bbsConfig.PathData;
    TelnetServer.ClientMaxIPs         := bbsConfig.InetTNIPs;

    Started := True;
  End;

  If bbsConfig.InetFTPUse And (bbsConfig.INetFTPMax > 0) Then Begin
    FtpServer              := TServerManager.Create(bbsConfig.InetFTPPort, bbsConfig.InetFTPMax, {$IFDEF FPC}@{$ENDIF}CreateFTP);
    FtpServer.ClientMaxIPs := bbsConfig.InetFTPIPs;

    Started := True;
  End;

  If Not Started Then Begin
    Console.ClearScreen;

    WriteLn('ERROR: No servers are configured as active.  Run MCFG to configure your');
    WriteLn('Internet server options found under General Configuration.');

    Input.Free;
    Console.Free;

    Halt(10);
  End;

//  BarPos  := 1;
//  TopPage := 1;
  Count   := 0;

  DrawStatusScreen;

  FocusCurrent := FocusMax;
  SwitchFocus;

  Repeat
    If Input.KeyWait(1000) Then
      Case Input.ReadKey of
        #00 : Case Input.ReadKey of
                #37 : If (FocusPtr <> NIL) And (FocusPtr.ClientList[BarPos - 1] <> NIL) Then
                        TServerClient(FocusPtr.ClientList[BarPos - 1]).Client.Disconnect;
//                #46 : (If FocusPtr <> NIL) And (FocusPtr.ClientList[BarPos - 1] <> NIL Then
//                          DoChatSomehow;
                #72 : If BarPos > TopPage Then Begin
                        Dec(BarPos);
                        UpdateConnectionList;
                      End Else
                      If TopPage > 1 Then Begin
                        Dec(TopPage);
                        Dec(BarPos);

                        UpdateConnectionList;
                      End;
                #75 : Begin
                        Dec (TopPage, 8);
                        Dec (BarPos, 8);

                        If TopPage < 1 Then TopPage := 1;
                        If BarPos  < 1 Then BarPos  := TopPage;

                        UpdateConnectionList;
                      End;
                #77 : Begin
                        Inc (TopPage, 8);
                        Inc (BarPos, 8);

                        If TopPage + 7 > FocusPtr.ClientList.Count Then TopPage := FocusPtr.ClientList.Count - 7;
                        If BarPos > FocusPtr.ClientList.Count Then BarPos := FocusPtr.ClientList.Count;
                        If TopPage < 1 Then TopPage := 1;
                        UpdateConnectionList;
                      End;

                #80 : If (BarPos < FocusPtr.ClientMax) and (BarPos < TopPage + 7) Then Begin
                        Inc(BarPos);
                        UpdateConnectionList;
                      End Else
                      If (TopPage + 7 < FocusPtr.ClientMax) Then Begin
                        Inc(TopPage);
                        Inc(BarPos);
                        UpdateConnectionList;
                      End;
              End;
        #09 : SwitchFocus;
        #13 : If (FocusCurrent = FocusTelnet) and (FocusPtr <> NIL) and (FocusPtr.ClientList[BarPos - 1] <> NIL) Then Begin
                Console.SetWindowTitle ('(Mystic) Snoop #' + strI2S(BarPos));
                With TTelnetServer(TelnetServer.ClientList[BarPos - 1]).BBS Do Begin
                  Term.Console.Active := True;
                  Term.Console.ShowBuffer;
                  If bbsConfig.TaskBar Then
                    Term.Console.WriteXY (1, Term.Console.ScreenSize, 112, strPadC(' Snooping node ' + strI2S(BarPos) + ': ' + User.ThisUser.Handle + '  Alt-K/Kick   ESC/Quit', 80, ' '));
                End;

                Repeat
                  If Input.KeyWait(1000) Then
                    Case Input.ReadKey of
                      #00 : Case Input.ReadKey of
                              #37 : Begin
                                      If FocusPtr.ClientList[BarPos - 1] <> NIL Then
                                        TServerClient(FocusPtr.ClientList[BarPos - 1]).Client.Disconnect;
                                      Break;
                                    End;
                            End;
                      #27 : Break;
                    End;

                  If TelnetServer.ClientList[BarPos - 1] = NIL Then Break;
                Until False;

                If TelnetServer.ClientList[BarPos - 1] <> NIL Then Begin
                  TTelnetServer(TelnetServer.ClientList[BarPos - 1]).BBS.Term.Console.Active := False;
//                  TTelnetServer(TelnetServer.ClientList[BarPos - 1]).Client.Disconnect;
                End;

                Console.ClearScreen;
                FocusCurrent := FocusMax;
                DrawStatusScreen;
                SwitchFocus;
                Console.SetWindowTitle(WinTitle);
              End;
        #27 : Break;
        #32 : LocalLogin;
      End;

    If (FocusPtr <> NIL) Then
      If FocusPtr.Server.StatusUpdated Then Begin
        UpdateStatus;
        Count := 1;
      End Else
      If Count = 45 Then Begin
        UpdateStatus;
        Count := 1;
      End Else
        Inc (Count);
  Until False;

  Console.ClearScreen;

  Write ('Shutting down servers: TELNET');
  TelnetServer.Free;

  Write (' FTP');
  FtpServer.Free;

  WriteLn (' (DONE)');

  Input.Free;
  Console.Free;

  Halt(10);
End.
