
Function cGetVarChar (T: TIdentTypes) : Char;
Begin
  Case T of
    iString  : Result := 's';
    iByte    : Result := 'b';
    iShort   : Result := 'h';
    iWord    : Result := 'w';
    iInteger : Result := 'i';
    iLongInt : Result := 'l';
    iReal    : Result := 'r';
    iBool    : Result := 'o';
    iFile    : Result := 'f';
  Else
    Result := ' ';
  End;
End;

Function cVarType (C: Char) : TIdentTypes;
begin
  case UpCase(c) of
    'S' : cVarType := iString;
    'B' : cVarType := iByte;
    'H' : cVarType := iShort;
    'W' : cVarType := iWord;
    'I' : cVarType := iInteger;
    'L' : cVarType := iLongInt;
    'R' : cVarType := iReal;
    'O' : cVarType := iBool;
    'F' : cVarType := iFile;
  else
    cVarType := iNone;
  end;
end;

Function xVarSize (T: TIdentTypes) : Word;
Begin
  Case T of
    iNone    : xVarSize := 0;
    iString  : xVarSize := 256;
    iByte    : xVarSize := 1;
    iShort   : xVarSize := 1;
    iWord    : xVarSize := 2;
    iInteger : xVarSize := 2;
    iLongInt : xVarSize := 4;
    iReal    : xVarSize := SizeOf(Real); // {$IFDEF FPC}8{$ELSE}6{$ENDIF};
    iBool    : xVarSize := 1;
    iFile    : xVarSize := SizeOf(File); // was 128;
  End;
End;

Procedure InitProcedures (O: Pointer; S: Pointer; Var CV: VarDataRec; Var X: Word; Var IW: Word; Mode: Byte);

  Procedure AddProc ({$IFDEF MPLPARSER} I: String; {$ENDIF} P: String; T: TIdentTypes);
  Begin
    Inc(X);
    New(CV[X]);

    With CV[X]^ Do Begin
      VarID     := IW;
      Inc(IW);
      vType  := T;
      Move(P[1], Params, Ord(P[0]));
      NumParams := Ord(p[0]);
    {$IFNDEF MPLPARSER}
      VarSize   := 0;
      DataSize  := 0;
      Data   := NIL;
      FillChar (pID, SizeOf(pID), 0);
      pPos   := 0;
      Kill   := True;
    {$ELSE}
      Ident  := I;
      InProc := False;
      Proc   := True;
    {$ENDIF}
      ArrPos := 0;
    End;
  End;

  Procedure AddStr ({$IFDEF MPLPARSER} I: String; {$ENDIF} T: TIdentTypes; SI: Word);
  Begin
    Inc(X);
    New(CV[X]);

    With cV[x]^ Do Begin
      VarID     := IW;
      Inc(IW);
      vType  := T;
      NumParams := 0;
    {$IFNDEF MPLPARSER}
      VarSize   := SI + 1;
      DataSize  := VarSize;
      GetMem   (Data,  DataSize);
      FillChar (Data^, DataSize, 0);
      FillChar (pID, SizeOf(pID), 0);  //cant we just assign it to 0 here?
      pPos   := 0;
      Kill   := True;
    {$ELSE}
      Ident  := I;
      InProc := False;
      Proc := False;
    {$ENDIF}
      ArrPos := 0;
    End;
  End;

  Procedure AddVar ({$IFDEF MPLPARSER} I: String; {$ENDIF} T: TIdentTypes);
  Begin
    AddStr ({$IFDEF MPLPARSER} I, {$ENDIF} T, xVarSize(T) - 1);
  End;

  Procedure AddPointer ({$IFDEF MPLPARSER} I: String; {$ENDIF} T: TIdentTypes; SI: Word; PD: Pointer);
  Begin
    Inc(x);
    New(cV[x]);

    With cV[x]^ Do Begin
      VarID     := IW;
      Inc(IW);
      vType  := t;
      NumParams := 0;
    {$IFNDEF MPLPARSER}
      If T = iString Then VarSize := SI + 1 Else VarSize := SI;
      DataSize  := VarSize;
      Data   := PD;
      FillChar (pID, SizeOf(pID), 0);
      pPos   := 0;
      Kill   := False;
    {$ELSE}
      Ident  := I;
      InProc := False;
      Proc := False;
    {$ENDIF}
      ArrPos := 0;
    End;
  End;

Begin
  Case Mode of
    0 : Begin
          IW := 0;

          AddProc    ({$IFDEF MPLPARSER} 'write',          {$ENDIF} 's',      iNone);    // 0
          AddProc    ({$IFDEF MPLPARSER} 'writeln',        {$ENDIF} 's',      iNone);    // 1
          AddProc    ({$IFDEF MPLPARSER} 'clrscr',         {$ENDIF} '',       iNone);    // 2
          AddProc    ({$IFDEF MPLPARSER} 'clreol',         {$ENDIF} '',       iNone);    // 3
          AddProc    ({$IFDEF MPLPARSER} 'gotoxy',         {$ENDIF} 'bb',     iNone);    // 4
          AddProc    ({$IFDEF MPLPARSER} 'wherex',         {$ENDIF} '',       iByte);    // 5
          AddProc    ({$IFDEF MPLPARSER} 'wherey',         {$ENDIF} '',       iByte);    // 6
          AddProc    ({$IFDEF MPLPARSER} 'dispfile',       {$ENDIF} 's',      iBool);    // 7
          AddProc    ({$IFDEF MPLPARSER} 'disptemplate',   {$ENDIF} 's',      iNone);    // 8
          AddProc    ({$IFDEF MPLPARSER} 'outbs',          {$ENDIF} 'bo',     iNone);    // 9
          AddProc    ({$IFDEF MPLPARSER} 'textcolor',      {$ENDIF} 'bo',     iNone);    // 10
          AddProc    ({$IFDEF MPLPARSER} 'outpipe',        {$ENDIF} 's',      iNone);    // 11
          AddProc    ({$IFDEF MPLPARSER} 'outpipeln',      {$ENDIF} 's',      iNone);    // 12
          AddProc    ({$IFDEF MPLPARSER} 'outraw',         {$ENDIF} 's',      iNone);    // 13
          AddProc    ({$IFDEF MPLPARSER} 'outrawln',       {$ENDIF} 's',      iNone);    // 14
          AddProc    ({$IFDEF MPLPARSER} 'bufaddstr',      {$ENDIF} 's',      iNone);    // 15
          AddProc    ({$IFDEF MPLPARSER} 'bufflush',       {$ENDIF} '',       iNone);    // 16
          AddProc    ({$IFDEF MPLPARSER} 'readkey',        {$ENDIF} '',       iString);  // 17
          AddProc    ({$IFDEF MPLPARSER} 'getkey',         {$ENDIF} 'l',      iString);  // 18
          AddProc    ({$IFDEF MPLPARSER} 'getyn',          {$ENDIF} 'so',     iBool);    // 19
          AddProc    ({$IFDEF MPLPARSER} 'getstr',         {$ENDIF} 'bbhs',   iString);  // 20
          AddProc    ({$IFDEF MPLPARSER} 'pause',          {$ENDIF} '',       iNone);    // 21
          AddProc    ({$IFDEF MPLPARSER} 'more',           {$ENDIF} '',       iString);  // 22
          AddProc    ({$IFDEF MPLPARSER} 'onekey',         {$ENDIF} 'so',     iString);  // 23
          AddProc    ({$IFDEF MPLPARSER} 'stuffkey',       {$ENDIF} 's',      iNone);    // 24
          AddProc    ({$IFDEF MPLPARSER} 'delay',          {$ENDIF} 'l',      iNone);    // 25
          AddProc    ({$IFDEF MPLPARSER} 'random',         {$ENDIF} 'l',      iLongInt); // 26
          AddProc    ({$IFDEF MPLPARSER} 'mci2str',        {$ENDIF} 's',      iString);  // 27
          AddProc    ({$IFDEF MPLPARSER} 'sysoplog',       {$ENDIF} 's',      iNone);    // 28
          AddProc    ({$IFDEF MPLPARSER} 'acs',            {$ENDIF} 's',      iBool);    // 29
          AddProc    ({$IFDEF MPLPARSER} 'chr',            {$ENDIF} 'b',      iString);  // 30
          AddProc    ({$IFDEF MPLPARSER} 'ord',            {$ENDIF} 's',      iByte);    // 31
          AddProc    ({$IFDEF MPLPARSER} 'copy',           {$ENDIF} 'sll',    iString);  // 32
          AddProc    ({$IFDEF MPLPARSER} 'delete',         {$ENDIF} 'Sll',    iNone);    // 33
          AddProc    ({$IFDEF MPLPARSER} 'hangup',         {$ENDIF} '',       iNone);    // 34
          AddProc    ({$IFDEF MPLPARSER} 'insert',         {$ENDIF} 'sSl',    iNone);    // 35
          AddProc    ({$IFDEF MPLPARSER} 'length',         {$ENDIF} 's',      iLongInt); // 36
          AddProc    ({$IFDEF MPLPARSER} 'odd',            {$ENDIF} 'l',      iBool);    // 37
          AddProc    ({$IFDEF MPLPARSER} 'pos',            {$ENDIF} 'ss',     iLongInt); // 38
          AddProc    ({$IFDEF MPLPARSER} 'keypressed',     {$ENDIF} '',       iBool);    // 39
          AddProc    ({$IFDEF MPLPARSER} 'upuser',         {$ENDIF} 'b',      iNone);    // 40
          AddProc    ({$IFDEF MPLPARSER} 'nodenum',        {$ENDIF} '',       iByte);    // 41
          AddProc    ({$IFDEF MPLPARSER} 'strpadr',        {$ENDIF} 'sbs',    iString);  // 42
          AddProc    ({$IFDEF MPLPARSER} 'strpadl',        {$ENDIF} 'sbs',    iString);  // 43
          AddProc    ({$IFDEF MPLPARSER} 'strpadc',        {$ENDIF} 'sbs',    iString);  // 44
          AddProc    ({$IFDEF MPLPARSER} 'strupper',       {$ENDIF} 's',      iString);  // 45
          AddProc    ({$IFDEF MPLPARSER} 'strlower',       {$ENDIF} 's',      iString);  // 46
          AddProc    ({$IFDEF MPLPARSER} 'strrep',         {$ENDIF} 'sb',     iString);  // 47
          AddProc    ({$IFDEF MPLPARSER} 'strcomma',       {$ENDIF} 'l',      iString);  // 48
          AddProc    ({$IFDEF MPLPARSER} 'stri2s',         {$ENDIF} 'l',      iString);  // 49
          AddProc    ({$IFDEF MPLPARSER} 'strs2i',         {$ENDIF} 's',      iLongInt); // 50
          AddProc    ({$IFDEF MPLPARSER} 'stri2h',         {$ENDIF} 'l',      iString);  // 51
          AddProc    ({$IFDEF MPLPARSER} 'strwordget',     {$ENDIF} 'bss',    iString);  // 52
          AddProc    ({$IFDEF MPLPARSER} 'strwordpos',     {$ENDIF} 'bss',    iByte);    // 53
          AddProc    ({$IFDEF MPLPARSER} 'strwordnum',     {$ENDIF} 'ss',     iByte);    // 54
          AddProc    ({$IFDEF MPLPARSER} 'strstripl',      {$ENDIF} 'ss',     iString);  // 55
          AddProc    ({$IFDEF MPLPARSER} 'strstripr',      {$ENDIF} 'ss',     iString);  // 56
          AddProc    ({$IFDEF MPLPARSER} 'strstripb',      {$ENDIF} 'ss',     iString);  // 57
          AddProc    ({$IFDEF MPLPARSER} 'strstriplow',    {$ENDIF} 's',      iString);  // 58
          AddProc    ({$IFDEF MPLPARSER} 'strstripmci',    {$ENDIF} 's',      iString);  // 59
          AddProc    ({$IFDEF MPLPARSER} 'strmcilen',      {$ENDIF} 's',      iByte);    // 60
          AddProc    ({$IFDEF MPLPARSER} 'strinitials',    {$ENDIF} 's',      iString);  // 61
          AddProc    ({$IFDEF MPLPARSER} 'strwrap',        {$ENDIF} 'SSb',    iByte);    // 62
          AddProc    ({$IFDEF MPLPARSER} 'strreplace',     {$ENDIF} 'sss',    iString);  // 63
          AddProc    ({$IFDEF MPLPARSER} 'readenv',        {$ENDIF} 's',      iString);  // 64
          AddProc    ({$IFDEF MPLPARSER} 'fileexist',      {$ENDIF} 's',      iBool);    // 65
          AddProc    ({$IFDEF MPLPARSER} 'fileerase',      {$ENDIF} 's',      iNone);    // 66
          AddProc    ({$IFDEF MPLPARSER} 'direxist',       {$ENDIF} 's',      iBool);    // 67
          AddProc    ({$IFDEF MPLPARSER} 'timermin',       {$ENDIF} '',       iLongInt); // 68
          AddProc    ({$IFDEF MPLPARSER} 'timersec',       {$ENDIF} '',       iLongInt); // 69
          AddProc    ({$IFDEF MPLPARSER} 'datedos',        {$ENDIF} '',       iLongInt); // 70
          AddProc    ({$IFDEF MPLPARSER} 'datejulian',     {$ENDIF} '',       iLongInt); // 71
          AddProc    ({$IFDEF MPLPARSER} 'datedos2str',    {$ENDIF} 'lb',     iString);  // 72
          AddProc    ({$IFDEF MPLPARSER} 'datejulian2str', {$ENDIF} 'lb',     iString);  // 73
          AddProc    ({$IFDEF MPLPARSER} 'datestr2dos',    {$ENDIF} 's',      iLongInt); // 74
          AddProc    ({$IFDEF MPLPARSER} 'datestr2julian', {$ENDIF} 's',      iLongInt); // 75
          AddProc    ({$IFDEF MPLPARSER} 'dateg2j',        {$ENDIF} 'lllL',   iNone);    // 76
          AddProc    ({$IFDEF MPLPARSER} 'datej2g',        {$ENDIF} 'liii',   iNone);    // 77
          AddProc    ({$IFDEF MPLPARSER} 'datevalid',      {$ENDIF} 's',      iString);  // 78
          AddProc    ({$IFDEF MPLPARSER} 'timedos2str',    {$ENDIF} 'lo',     iString);  // 79
          AddProc    ({$IFDEF MPLPARSER} 'dayofweek',      {$ENDIF} '',       iByte);    // 80
          AddProc    ({$IFDEF MPLPARSER} 'daysago',        {$ENDIF} 'l',      iLongInt); // 81
          AddProc    ({$IFDEF MPLPARSER} 'justfile',       {$ENDIF} 's',      iString);  // 82
          AddProc    ({$IFDEF MPLPARSER} 'justfilename',   {$ENDIF} 's',      iString);  // 83
          AddProc    ({$IFDEF MPLPARSER} 'justfileext',    {$ENDIF} 's',      iString);  // 84
          AddProc    ({$IFDEF MPLPARSER} 'fassign',        {$ENDIF} 'Fsl',    iNone);    // 85
          AddProc    ({$IFDEF MPLPARSER} 'freset',         {$ENDIF} 'F',      iNone);    // 86
          AddProc    ({$IFDEF MPLPARSER} 'frewrite',       {$ENDIF} 'F',      iNone);    // 87
          AddProc    ({$IFDEF MPLPARSER} 'fclose',         {$ENDIF} 'F',      iNone);    // 88
          AddProc    ({$IFDEF MPLPARSER} 'fseek',          {$ENDIF} 'F',      iNone);    // 89
          AddProc    ({$IFDEF MPLPARSER} 'feof',           {$ENDIF} 'F',      iBool);    // 90
          AddProc    ({$IFDEF MPLPARSER} 'filesize',       {$ENDIF} 'F',      iLongInt); // 91
          AddProc    ({$IFDEF MPLPARSER} 'filepos',        {$ENDIF} 'F',      iLongInt); // 92
          AddProc    ({$IFDEF MPLPARSER} 'fread',          {$ENDIF} 'F*w',    iNone);    // 93
          AddProc    ({$IFDEF MPLPARSER} 'fwrite',         {$ENDIF} 'F*w',    iNone);    // 94
          AddProc    ({$IFDEF MPLPARSER} 'freadln',        {$ENDIF} 'FS',     iNone);    // 95
          AddProc    ({$IFDEF MPLPARSER} 'fwriteln',       {$ENDIF} 'Fs',     iNone);    // 96
          AddProc    ({$IFDEF MPLPARSER} 'pathsep',        {$ENDIF} '',       iString);  // 97
          AddProc    ({$IFDEF MPLPARSER} 'menucmd',        {$ENDIF} 'ss',     iNone);    // 98
          AddProc    ({$IFDEF MPLPARSER} 'bitcheck',       {$ENDIF} 'b*',     iBool);    // 99
          AddProc    ({$IFDEF MPLPARSER} 'bittoggle',      {$ENDIF} 'b*',     iNone);    // 100
          AddProc    ({$IFDEF MPLPARSER} 'bitset',         {$ENDIF} 'b*o',    iNone);    // 101
          AddProc    ({$IFDEF MPLPARSER} 'findfirst',      {$ENDIF} 'sw',     iNone);    // 102
          AddProc    ({$IFDEF MPLPARSER} 'findnext',       {$ENDIF} '',       iNone);    // 103
          AddProc    ({$IFDEF MPLPARSER} 'findclose',      {$ENDIF} '',       iNone);    // 104
          AddProc    ({$IFDEF MPLPARSER} 'mod',            {$ENDIF} 'll',     iLongInt); // 105
          AddProc    ({$IFDEF MPLPARSER} 'getprompt',      {$ENDIF} 'l',      iString);  // 106
          AddProc    ({$IFDEF MPLPARSER} 'getpromptinfo',  {$ENDIF} 's',      iString);  // 107
          AddProc    ({$IFDEF MPLPARSER} 'getscreeninfo',  {$ENDIF} 'bBBB',   iNone);    // 108
          AddProc    ({$IFDEF MPLPARSER} 'getscreenchar',  {$ENDIF} 'bbb',    iString);  // 109
          AddProc    ({$IFDEF MPLPARSER} 'getscreenattr',  {$ENDIF} 'bbb',    iString);  // 110
          AddProc    ({$IFDEF MPLPARSER} 'getthisuser',    {$ENDIF} '',       iNone);    // 111
          AddProc    ({$IFDEF MPLPARSER} 'putthisuser',    {$ENDIF} '',       iNone);    // 112
          AddProc    ({$IFDEF MPLPARSER} 'getuser',        {$ENDIF} 'l',      iBool);    // 113
          AddProc    ({$IFDEF MPLPARSER} 'putuser',        {$ENDIF} 'l',      iNone);    // 114
          AddProc    ({$IFDEF MPLPARSER} 'getuserbyname',  {$ENDIF} 's',      iBool);    // 115
          AddProc    ({$IFDEF MPLPARSER} 'getuserbyid',    {$ENDIF} 'l',      iBool);    // 116
          AddProc    ({$IFDEF MPLPARSER} 'getsauce',       {$ENDIF} 'sSSSS',  iBool);    // 117
          AddProc    ({$IFDEF MPLPARSER} 'isuser',         {$ENDIF} 's',      iBool);    // 118
          AddProc    ({$IFDEF MPLPARSER} 'justpath',       {$ENDIF} 's',      iString);  // 119
          AddProc    ({$IFDEF MPLPARSER} 'randomize',      {$ENDIF} '',       iNone);    // 120
          AddProc    ({$IFDEF MPLPARSER} 'paramcount',     {$ENDIF} '',       iByte);    // 121
          AddProc    ({$IFDEF MPLPARSER} 'paramstr',       {$ENDIF} 'b',      iString);  // 122
          AddProc    ({$IFDEF MPLPARSER} 'settimeleft',    {$ENDIF} 'i',      iNone);    // 123
          AddProc    ({$IFDEF MPLPARSER} 'setpromptinfo',  {$ENDIF} 'ss',     iNone);    // 124
          AddProc    ({$IFDEF MPLPARSER} 'textattr',       {$ENDIF} '',       iByte);    // 125

{ END OF PROCEDURE DEFINITIONS }

          AddPointer ({$IFDEF MPLPARSER} 'pausepos',     {$ENDIF} iByte,      1, {$IFNDEF MPLPARSER} @TBBSCore(O).Term.PausePos          {$ELSE} NIL {$ENDIF});
          AddPointer ({$IFDEF MPLPARSER} 'allowpause',   {$ENDIF} iBool,      1, {$IFNDEF MPLPARSER} @TBBSCore(O).Term.AllowPause        {$ELSE} NIL {$ENDIF});
          AddPointer ({$IFDEF MPLPARSER} 'allowarrow',   {$ENDIF} iBool,      1, {$IFNDEF MPLPARSER} @TBBSCore(O).Term.AllowArrow        {$ELSE} NIL {$ENDIF});
          AddPointer ({$IFDEF MPLPARSER} 'allowmci',     {$ENDIF} iBool,      1, {$IFNDEF MPLPARSER} @TBBSCore(O).Term.AllowMCI          {$ELSE} NIL {$ENDIF});
          AddPointer ({$IFDEF MPLPARSER} 'isarrow',      {$ENDIF} iBool,      1, {$IFNDEF MPLPARSER} @TBBSCore(O).Term.IsArrow           {$ELSE} NIL {$ENDIF});
          AddPointer ({$IFDEF MPLPARSER} 'bufnoflush',   {$ENDIF} iBool,      1, {$IFNDEF MPLPARSER} @TBBSCore(O).Term.NoBufFlush        {$ELSE} NIL {$ENDIF});
          AddPointer ({$IFDEF MPLPARSER} 'graphics',     {$ENDIF} iByte,      1, {$IFNDEF MPLPARSER} @TBBSCore(O).Term.Graphics          {$ELSE} NIL {$ENDIF});
          AddPointer ({$IFDEF MPLPARSER} 'ioresult',     {$ENDIF} iLongInt,   4, {$IFNDEF MPLPARSER} @TInterpEngine(S).IoError           {$ELSE} NIL {$ENDIF});
          AddPointer ({$IFDEF MPLPARSER} 'doserror',     {$ENDIF} iInteger,   2, {$IFNDEF MPLPARSER} @DosError                           {$ELSE} NIL {$ENDIF});
          AddPointer ({$IFDEF MPLPARSER} 'progparams',   {$ENDIF} iString,  256, {$IFNDEF MPLPARSER} @TInterpEngine(S).ParamsStr            {$ELSE} NIL {$ENDIF});
          AddPointer ({$IFDEF MPLPARSER} 'progname',     {$ENDIF} iString,  256, {$IFNDEF MPLPARSER} @TInterpEngine(S).MPEName           {$ELSE} NIL {$ENDIF});
          AddPointer ({$IFDEF MPLPARSER} 'ignoregroups', {$ENDIF} iBool,      1, {$IFNDEF MPLPARSER} @TBBSCore(O).User.IgnoreGroup       {$ELSE} NIL {$ENDIF});
          AddPointer ({$IFDEF MPLPARSER} 'shutdown',     {$ENDIF} iBool,      1, {$IFNDEF MPLPARSER} @TBBSCore(O).ShutDown               {$ELSE} NIL {$ENDIF});

          AddPointer ({$IFDEF MPLPARSER} 'themetext',  {$ENDIF} iString, mysMaxPathSize, {$IFNDEF MPLPARSER} @TBBSCore(O).Theme.PathText     {$ELSE} NIL {$ENDIF});
          AddPointer ({$IFDEF MPLPARSER} 'thememenu',  {$ENDIF} iString, mysMaxPathSize, {$IFNDEF MPLPARSER} @TBBSCore(O).Theme.PathMenu     {$ELSE} NIL {$ENDIF});
          AddPointer ({$IFDEF MPLPARSER} 'themeansi',  {$ENDIF} iString, mysMaxPathSize, {$IFNDEF MPLPARSER} @TBBSCore(O).Theme.PathTemplate {$ELSE} NIL {$ENDIF});
          AddPointer ({$IFDEF MPLPARSER} 'themempl',   {$ENDIF} iString, mysMaxPathSize, {$IFNDEF MPLPARSER} @TBBSCore(O).Theme.PathScripts  {$ELSE} NIL {$ENDIF});

          {$IFNDEF MPLPARSER} TInterpEngine(S).IdxVarDir := X + 1; {$ENDIF}

          AddPointer ({$IFDEF MPLPARSER} 'dirname',    {$ENDIF} iString,  256, {$IFNDEF MPLPARSER} @TInterpEngine(S).DirInfo.Name {$ELSE} NIL {$ENDIF});
          AddPointer ({$IFDEF MPLPARSER} 'dirsize',    {$ENDIF} iLongInt,   4, {$IFNDEF MPLPARSER} @TInterpEngine(S).DirInfo.Size {$ELSE} NIL {$ENDIF});
          AddPointer ({$IFDEF MPLPARSER} 'dirtime',    {$ENDIF} iLongInt,   4, {$IFNDEF MPLPARSER} @TInterpEngine(S).DirInfo.Time {$ELSE} NIL {$ENDIF});
          AddPointer ({$IFDEF MPLPARSER} 'dirattr',    {$ENDIF} iByte,      1, {$IFNDEF MPLPARSER} @TInterpEngine(S).DirInfo.Attr {$ELSE} NIL {$ENDIF});
        End;
    1 : Begin
          {$IFNDEF MPLPARSER} TInterpEngine(S).IdxVarUser := X + 1; {$ENDIF}

          AddVar ({$IFDEF MPLPARSER} 'userid',       {$ENDIF} iLongInt);
          AddStr ({$IFDEF MPLPARSER} 'username',     {$ENDIF} iString, 30);
          AddStr ({$IFDEF MPLPARSER} 'userhandle',   {$ENDIF} iString, 30);
          AddStr ({$IFDEF MPLPARSER} 'userpw',       {$ENDIF} iString, 20);
          AddStr ({$IFDEF MPLPARSER} 'useraddr',     {$ENDIF} iString, 30);
          AddStr ({$IFDEF MPLPARSER} 'usercity',     {$ENDIF} iString, 25);
          AddStr ({$IFDEF MPLPARSER} 'userzip',      {$ENDIF} iString, 10);
          AddStr ({$IFDEF MPLPARSER} 'userhphone',   {$ENDIF} iString, 15);
          AddStr ({$IFDEF MPLPARSER} 'userdphone',   {$ENDIF} iString, 15);
          AddStr ({$IFDEF MPLPARSER} 'usergender',   {$ENDIF} iString, 1); // char
          AddVar ({$IFDEF MPLPARSER} 'userbday',     {$ENDIF} iLongInt);
          AddStr ({$IFDEF MPLPARSER} 'useremail',    {$ENDIF} iString, 40);
          AddStr ({$IFDEF MPLPARSER} 'userinfo',     {$ENDIF} iString, 40);
          AddVar ({$IFDEF MPLPARSER} 'usersec',      {$ENDIF} iByte);
          AddStr ({$IFDEF MPLPARSER} 'userstart',    {$ENDIF} iString, 20);
          AddStr ({$IFDEF MPLPARSER} 'userexp',      {$ENDIF} iString, 8);
          AddVar ({$IFDEF MPLPARSER} 'userexpto',    {$ENDIF} iByte);
          AddVar ({$IFDEF MPLPARSER} 'useraf1',      {$ENDIF} iLongInt);
          AddVar ({$IFDEF MPLPARSER} 'useraf2',      {$ENDIF} iLongInt);
          AddVar ({$IFDEF MPLPARSER} 'userdtype',    {$ENDIF} iByte);
          AddVar ({$IFDEF MPLPARSER} 'userscrnsize', {$ENDIF} iByte);
          AddVar ({$IFDEF MPLPARSER} 'userhotkey',   {$ENDIF} iBool);
          AddVar ({$IFDEF MPLPARSER} 'userfsedit',   {$ENDIF} iBool);
          AddVar ({$IFDEF MPLPARSER} 'userquotewin', {$ENDIF} iBool);
          AddVar ({$IFDEF MPLPARSER} 'userflist',    {$ENDIF} iBool);
          AddVar ({$IFDEF MPLPARSER} 'usermread',    {$ENDIF} iBool);
          AddVar ({$IFDEF MPLPARSER} 'usermidx',     {$ENDIF} iBool);
          AddVar ({$IFDEF MPLPARSER} 'usermeidx',    {$ENDIF} iBool);
          AddVar ({$IFDEF MPLPARSER} 'userchat',     {$ENDIF} iBool);
          AddVar ({$IFDEF MPLPARSER} 'usersig',      {$ENDIF} iBool);
          AddVar ({$IFDEF MPLPARSER} 'usersigptr',   {$ENDIF} iLongInt);
          AddStr ({$IFDEF MPLPARSER} 'userarc',      {$ENDIF} iString, 4);
          AddStr ({$IFDEF MPLPARSER} 'usertheme',    {$ENDIF} iString, 20);
          AddStr ({$IFDEF MPLPARSER} 'usercname',    {$ENDIF} iString, 30);
          AddVar ({$IFDEF MPLPARSER} 'userinvis',    {$ENDIF} iBool);
          AddVar ({$IFDEF MPLPARSER} 'useravail',    {$ENDIF} iBool);
          AddStr ({$IFDEF MPLPARSER} 'userpip',      {$ENDIF} iString, 20);
          AddStr ({$IFDEF MPLPARSER} 'userpname',    {$ENDIF} iString, 50);
          AddVar ({$IFDEF MPLPARSER} 'usertime',     {$ENDIF} iInteger);
          AddVar ({$IFDEF MPLPARSER} 'usercmbase',   {$ENDIF} iWord);
          AddVar ({$IFDEF MPLPARSER} 'usercmgroup',  {$ENDIF} iWord);
          AddVar ({$IFDEF MPLPARSER} 'usercfbase',   {$ENDIF} iWord);
          AddVar ({$IFDEF MPLPARSER} 'usercfgroup',  {$ENDIF} iWord);
          AddVar ({$IFDEF MPLPARSER} 'usercall',     {$ENDIF} iLongInt);
          AddVar ({$IFDEF MPLPARSER} 'usertcall',    {$ENDIF} iWord);
          AddVar ({$IFDEF MPLPARSER} 'userdls',      {$ENDIF} iLongInt);
          AddVar ({$IFDEF MPLPARSER} 'usertdls',     {$ENDIF} iWord);
          AddVar ({$IFDEF MPLPARSER} 'userdlkb',     {$ENDIF} iLongInt);
          AddVar ({$IFDEF MPLPARSER} 'usertdlkb',    {$ENDIF} iLongInt);
          AddVar ({$IFDEF MPLPARSER} 'userfcall',    {$ENDIF} iLongInt);
          AddVar ({$IFDEF MPLPARSER} 'userlcall',    {$ENDIF} iLongInt);
          AddVar ({$IFDEF MPLPARSER} 'userposts',    {$ENDIF} iLongInt);
          AddVar ({$IFDEF MPLPARSER} 'useremails',   {$ENDIF} iLongInt);
          AddVar ({$IFDEF MPLPARSER} 'useruls',      {$ENDIF} iLongInt);
          AddVar ({$IFDEF MPLPARSER} 'userulkb',     {$ENDIF} iLongInt);
          AddVar ({$IFDEF MPLPARSER} 'userbank',     {$ENDIF} iWord);
          AddStr ({$IFDEF MPLPARSER} 'userlastpw',   {$ENDIF} iString, 8);
          AddVar ({$IFDEF MPLPARSER} 'uservyes',     {$ENDIF} iByte);
          AddVar ({$IFDEF MPLPARSER} 'uservno',      {$ENDIF} iByte);
          AddVar ({$IFDEF MPLPARSER} 'userdoors',    {$ENDIF} iLongInt);
          AddVar ({$IFDEF MPLPARSER} 'userflag',     {$ENDIF} iLongInt);

          AddStr ({$IFDEF MPLPARSER} 'useropts',     {$ENDIF} iString, 10 * 61 - 1);
          CV[X]^.ArrPos := 1;
          {$IFNDEF MPLPARSER}
            CV[X]^.VarSize   := 61;
            CV[X]^.ArrDim[1] := 10;
          {$ENDIF}
        End;
    2 : Begin
          AddPointer ({$IFDEF MPLPARSER} 'cfgpathsys',  {$ENDIF} iString, mysMaxPathSize, {$IFNDEF MPLPARSER} @bbsConfig.PathSystem   {$ELSE} NIL {$ENDIF});
          AddPointer ({$IFDEF MPLPARSER} 'cfgpathdata', {$ENDIF} iString, mysMaxPathSize, {$IFNDEF MPLPARSER} @bbsConfig.PathData     {$ELSE} NIL {$ENDIF});
          AddPointer ({$IFDEF MPLPARSER} 'cfgpathlogs', {$ENDIF} iString, mysMaxPathSize, {$IFNDEF MPLPARSER} @bbsConfig.PathLogs     {$ELSE} NIL {$ENDIF});
          AddPointer ({$IFDEF MPLPARSER} 'cfgpathmsgs', {$ENDIF} iString, mysMaxPathSize, {$IFNDEF MPLPARSER} @bbsConfig.PathMsgs     {$ELSE} NIL {$ENDIF});
          AddPointer ({$IFDEF MPLPARSER} 'cfgpathfile', {$ENDIF} iString, mysMaxPathSize, {$IFNDEF MPLPARSER} @bbsConfig.PathAttach   {$ELSE} NIL {$ENDIF});
          AddPointer ({$IFDEF MPLPARSER} 'cfgpathmail', {$ENDIF} iString, mysMaxPathSize, {$IFNDEF MPLPARSER} @bbsConfig.PathOffmail  {$ELSE} NIL {$ENDIF});
          AddPointer ({$IFDEF MPLPARSER} 'cfgpathmenu', {$ENDIF} iString, mysMaxPathSize, {$IFNDEF MPLPARSER} @bbsConfig.PathMenu     {$ELSE} NIL {$ENDIF});
          AddPointer ({$IFDEF MPLPARSER} 'cfgpathtext', {$ENDIF} iString, mysMaxPathSize, {$IFNDEF MPLPARSER} @bbsConfig.PathText     {$ELSE} NIL {$ENDIF});
          AddPointer ({$IFDEF MPLPARSER} 'cfgpathansi', {$ENDIF} iString, mysMaxPathSize, {$IFNDEF MPLPARSER} @bbsConfig.PathTemplate {$ELSE} NIL {$ENDIF});
          AddPointer ({$IFDEF MPLPARSER} 'cfgpathmpl',  {$ENDIF} iString, mysMaxPathSize, {$IFNDEF MPLPARSER} @bbsConfig.PathScripts  {$ELSE} NIL {$ENDIF});
          AddPointer ({$IFDEF MPLPARSER} 'cfgtimeout',  {$ENDIF} iWord,   4,              {$IFNDEF MPLPARSER} @bbsConfig.Inactivity   {$ELSE} NIL {$ENDIF});
        End;
  End;
End;
