{$I M_OPS.PAS}

Unit MCFG_Security;

Interface

Function SecurityEditor (Edit: Boolean) : LongInt;

Implementation

Uses
  m_Types,
  m_Output,
  m_Strings,
  m_MenuBox,
  m_MenuForm,
  m_FileIO,
  MCFG_Common;

Var
  SecFile : File;
  Sec     : RecSecurity;

Procedure Edit_Level (Level: Integer);
Var
  Box   : TMenuBox;
  Form  : TMenuForm;
  Topic : String;
  Image : TConsoleImageRec;
Begin
  Topic := '|03(|09Security|03) |01-|09> |15';

  ioSeek (SecFile, Level - 1);
  ioRead (SecFile, Sec);

  Console.GetScreenImage(1, 1, 80, 3, Image);

  Console.WriteXY (1, 1, 8, strRep('', 80));
  Console.WriteXY (1, 2, 8, strRep('', 80));
  Console.WriteXY (1, 3, 8, strRep('', 80));

  Box  := TMenuBox.Create(Console);
  Form := TMenuForm.Create(Console);

  Box.Header := ' Security Level ' + strI2S(Level) + ' ';

  Box.Open (12, 3, 68, 21);

//  Console.WriteXY (60, 5, 3, '[     ]');
//  Console.WriteXY (62, 5, 7, strPadL(strI2S(Level), 3, ' '));

  VerticalLine (35, 4, 20);

  Form.AddStr  ('D', ' Description '        , 22,  4, 37,  4, 13, 30, 30, @Sec.Desc, Topic + 'Description of security level');
  Form.AddWord ('T', ' Time Per Day '       , 21,  5, 37,  5, 14,  4,  0, 1440, @Sec.Time, Topic + 'Minutes per day');
  Form.AddWord ('C', ' Calls Per Day '      , 20,  6, 37,  6, 15,  5,  0, 65000, @Sec.MaxCalls, Topic + 'Maximum calls allowed per day');
  Form.AddWord ('P', ' Post/Call Ratio '    , 18,  7, 37,  7, 17,  5,  0, 65000, @Sec.PCRatio, Topic + 'Must post X messages per 100 calls');
  Form.AddWord ('E', ' Download Per Day '   , 17,  8, 37,  8, 18,  5,  0, 65000, @Sec.MaxDLs, Topic + 'Maximum downloads allowed per day');
  Form.AddLong ('K', ' Download KB Per Day ', 14,  9, 37,  9, 21,  7,  0, 9999999, @Sec.MaxDLk, Topic + 'Maximum downloaded kilobytes per day');
  Form.AddByte ('U', ' UL/DL Ratio '        , 22, 10, 37, 10, 13,  3,  0, 255, @Sec.DLRatio, Topic + 'Must upload 1 file for every X downloaded');
  Form.AddWord ('B', ' UL/DL KB Ratio '     , 19, 11, 37, 11, 16,  5,  0, 65000, @Sec.DLKRatio, Topic + 'Must upload 1KB for every X downloaded');
  Form.AddWord ('M', ' Max Time in Bank '   , 17, 12, 37, 12, 18,  5,  0, 65000, @Sec.MaxTB, Topic + 'Maximum minutes allowed in time bank');
  Form.AddStr  ('S', ' Start Menu '         , 23, 13, 37, 13, 12, 20, 20, @Sec.StartMenu, Topic + 'Menu name to load first when user logs in');
  Form.AddWord ('X', ' Expires '            , 26, 14, 37, 14,  9,  4,  0, 9999, @Sec.Expires, Topic + 'Number of days before level expires');
  Form.AddByte ('O', ' Expires To '         , 23, 15, 37, 15, 12,  3,  0, 255, @Sec.ExpiresTo, Topic + 'Security level to expire to');
  Form.AddWord ('G', ' Upgrade Posts '      , 20, 16, 37, 16, 15,  5,  0, 65000, @Sec.Posts, Topic + 'Upgrade user''s security after ## of posts (0/Disabled)');
  Form.AddByte ('R', ' Posts To '           , 25, 17, 37, 17, 10,  3,  0, 255, @Sec.PostsTo, Topic + 'Upgrade to what security level on Post upgrade');
  Form.AddFlag ('1', ' Access Flags 1 '     , 19, 18, 37, 18, 16, @Sec.AF1, Topic + 'Access flags: Set 1');
  Form.AddFlag ('2', ' Access Flags 2 '     , 19, 19, 37, 19, 16, @Sec.AF2, Topic + 'Access flags: Set 2');
  Form.AddBol  ('H', ' Hard Flag Upgrade '  , 16, 20, 37, 20, 19, 3, @Sec.Hard, Topic + 'Hard access flag upgrade?');

  Form.Execute;

  Box.Close;

  Box.Free;
  Form.Free;

  Console.PutScreenImage(Image);

  ioSeek  (SecFile, Level - 1);
  ioWrite (SecFile, Sec);
End;

Function SecurityEditor (Edit: Boolean) : LongInt;
Const
  Status = '|03(|09CTRL+H|03) |07Toggle Hide   |03(|09ENTER|03) |07to Select';
Var
  List     : TMenuList;
  Box      : TMenuBox;
  HideMode : Boolean;

  Procedure MakeList;
  Var
    Count : LongInt;
  Begin
    List.Clear;

    ioReset(SecFile, SizeOf(recSecurity), fmReadWrite + fmDenyNone);
    For Count := 1 to 255 Do Begin
      ioRead (SecFile, Sec);
      If Not HideMode Then
        List.Add(strPadR(strI2S(Count), 5, ' ') + Sec.Desc, 0)
      Else
        If Sec.Desc <> '' Then
          List.Add(strPadR(strI2S(Count), 5, ' ') + Sec.Desc, 0);
    End;
  End;

Var
  Count : Byte;
Begin
  HideMode := True;

  Assign (SecFile, bbsConfig.PathData + 'security.dat');
  If Not ioReset(SecFile, SizeOf(recSecurity), fmReadWrite + fmDenyNone) Then Begin
    ReWrite (SecFile, SizeOf(recSecurity));
    For Count := 1 to 255 Do ioWrite (SecFile, Sec);
  End;

  Box  := TMenuBox.Create(Console);
  List := TMenuList.Create(Console);

  Box.Header    := ' Security Levels ';
  List.LoChars  := #08#13#17#27;
  List.NoWindow := True;

  Box.Open (21, 6, 59, 19);

  Console.WriteXY (23, 7, 112, 'Lvl  Description');
  Console.WriteXY (22, 8, 112, strRep('', 37));

  Repeat
    Console.WriteXYPipe (5, 25, 7, 75, Status);

    MakeList;

    If HideMode and (List.ListMax = 0) Then Begin
      HideMode := False;
      MakeList;
    End;

    List.Open (21, 8, 59, 19);
    List.Close;

    Case List.ExitCode of
      #08 : HideMode := Not HideMode;
      #13 : Begin
              Count := strS2I(Copy(List.List[List.Picked]^.Name, 1, 3));
              If Edit Then
                Edit_Level(Count)
              Else Begin
                SecurityEditor := Count;
                Break;
              End;
            End;
//      #17 : ShowHelp(1);
      #27 : Begin
              SecurityEditor := -1;
              Break;
            End;
    End;
  Until False;

  Close (SecFile);

  Box.Close;
  Box.Free;
  List.Free;
End;

End.
