{$I M_OPS.PAS}

Unit MCFG_MENU;

Interface

Procedure MenuEditor;

Implementation

Uses
  m_Types,
  m_Output,
  m_MenuBox,
  m_MenuForm,
  m_Strings,
  m_QuickSort,
  m_FileIO,
  MCFG_Common,
  MCFG_Theme,
  DOS,
  BBS_MenuData;

Type
  CmdRec = Record
    Name : String[2];
    Desc : String[30];
  End;

Const
  Num_Cmds = 75;
  MenuCmds : Array[1..Num_Cmds] of CmdRec = (
    (  Name: '!T';   Desc: 'Telnet client'                ),
    (  Name: 'DC';   Desc: 'Last Callers'                 ),
    (  Name: 'FA';   Desc: 'File area change'             ),
    (  Name: 'FG';   Desc: 'File group change'            ),
    (  Name: 'GA';   Desc: 'Ansi file viewer'             ),
    (  Name: 'GD';   Desc: 'Show a display file'          ),
    (  Name: 'GE';   Desc: 'Edit user settings'           ),
    (  Name: 'GH';   Desc: 'Hangup'                       ),
    (  Name: 'GI';   Desc: 'Hangup Immediately'           ),
    (  Name: 'GO';   Desc: 'Goto a new menu'              ),
    (  Name: 'GR';   Desc: 'Return from Gosub'            ),
    (  Name: 'GS';   Desc: 'Gosub a new menu'             ),
    (  Name: 'GT';   Desc: 'Send line of text'            ),
    (  Name: 'GU';   Desc: 'User listing'                 ),
    (  Name: 'GX';   Desc: 'Execute MPL program'          ),
    (  Name: 'GZ';   Desc: 'Execute door'                 ),
    (  Name: 'I1';   Desc: 'RIndex: Down one line'        ),
    (  Name: 'I2';   Desc: 'RIndex: Up one line'          ),
    (  Name: 'I3';   Desc: 'RIndex: Down one page'        ),
    (  Name: 'I4';   Desc: 'RIndex: Up one page'          ),
    (  Name: 'IG';   Desc: 'RIndex: Goto next base'       ),
    (  Name: 'II';   Desc: 'RIndex: Ignore message'       ),
    (  Name: 'IQ';   Desc: 'RIndex: Quit'                 ),
    (  Name: 'IS';   Desc: 'RIndex: Select message'       ),
    (  Name: 'MA';   Desc: 'Change message area'          ),
    (  Name: 'MC';   Desc: 'Check for new Email'          ),
    (  Name: 'MD';   Desc: 'Set lastread pointers'        ),
    (  Name: 'ME';   Desc: 'Edit auto signature'          ),
    (  Name: 'MF';   Desc: 'View auto signature'          ),
    (  Name: 'MG';   Desc: 'Change message group'         ),
    (  Name: 'MM';   Desc: 'Mass Email'                   ),
    (  Name: 'MN';   Desc: 'New message scan'             ),
    (  Name: 'MP';   Desc: 'Post a message'               ),
    (  Name: 'MR';   Desc: 'Read messages'                ),
    (  Name: 'MW';   Desc: 'Post new Email'               ),
    (  Name: 'MX';   Desc: 'Post text file'               ),
    (  Name: 'MZ';   Desc: 'Toggle scan settings'         ),
    (  Name: 'NA';   Desc: 'Set Node Action'              ),
    (  Name: 'NC';   Desc: 'Enter node chat'              ),
    (  Name: 'NP';   Desc: 'Page user for private chat'   ),
    (  Name: 'NS';   Desc: 'Send node message'            ),
    (  Name: 'NW';   Desc: 'Who''s Online'                ),
    (  Name: 'R+';   Desc: 'Reader: Next message'         ),
    (  Name: 'R-';   Desc: 'Reader: Previous message'     ),
    (  Name: 'RA';   Desc: 'Reader: Again'                ),
    (  Name: 'RC';   Desc: 'Reader: Copy message'         ),
    (  Name: 'RD';   Desc: 'Reader: Delete'               ),
    (  Name: 'RE';   Desc: 'Reader: Edit message'         ),
    (  Name: 'RG';   Desc: 'Reader: Goto Next Base'       ),
    (  Name: 'RH';   Desc: 'Reader: Set Lastread'         ),
    (  Name: 'RI';   Desc: 'Reader: Ignore'               ),
    (  Name: 'RJ';   Desc: 'Reader: Jump to message'      ),
    (  Name: 'RL';   Desc: 'Reader: List messages'        ),
    (  Name: 'RM';   Desc: 'Reader: Move message'         ),
    (  Name: 'RP';   Desc: 'Reader: Post new message'     ),
    (  Name: 'RQ';   Desc: 'Reader: Quit'                 ),
    (  Name: 'RR';   Desc: 'Reader: Reply'                ),
    (  Name: 'RT';   Desc: 'Reader: Toggle newscan'       ),
    (  Name: 'R[';   Desc: 'Reader: Prev in thread'       ),
    (  Name: 'R]';   Desc: 'Reader: Next in thread'       ),
    (  Name: 'R1';   Desc: 'Reader: Down one line'        ),
    (  Name: 'R2';   Desc: 'Reader: Up one line'          ),
    (  Name: 'R3';   Desc: 'Reader: Page down'            ),
    (  Name: 'R4';   Desc: 'Reader: Page up'              ),
    (  Name: 'R5';   Desc: 'Reader: Home'                 ),
    (  Name: 'R6';   Desc: 'Reader: End'                  ),
    (  Name: 'XA';   Desc: 'Matrix apply for access'      ),
    (  Name: 'XL';   Desc: 'Matrix login'                 ),
    (  Name: '-D';   Desc: 'Set access flags (set 2)'     ),
    (  Name: '-F';   Desc: 'Set access flags (set 1)'     ),
    (  Name: '-K';   Desc: 'Add keys to input buffer'     ),
    (  Name: '-N';   Desc: 'Ask Yes/No (default No)'      ),
    (  Name: '-P';   Desc: 'Prompt for a password'        ),
    (  Name: '-S';   Desc: 'Add text to Sysop log'        ),
    (  Name: '-Y';   Desc: 'Ask Yes/No (default Yes)'     )
  );                       {123456789012345678901234567890}

Var
  Menu     : TMenuData;
  MenuName : String;
  Changed  : Boolean;

Function GetCommandDesc (Str: String) : String;
Var
  Count : Byte;
Begin
  Result := 'Unknown Command';
  For Count := 1 to Num_Cmds Do
    If Str = MenuCmds[Count].Name Then Begin
      Result := MenuCmds[Count].Desc;
      Break;
    End;
End;

Function GetCommand (Str: String) : String;
Var
  List  : TMenuList;
  Count : Byte;
Begin
  List := TMenuList.Create(Console);

  For Count := 1 to Num_Cmds Do Begin
    List.Add (MenuCmds[Count].Name + '   ' + MenuCmds[Count].Desc, 0);
    If Str = MenuCmds[Count].Name Then
      List.Picked := Count;
  End;

//  List.Box.Header   := ' Select Menu Command ';

  List.Open (21, 4, 59, 19);
  List.Close;

  If List.ExitCode = #13 Then Begin
    Changed := Str = MenuCmds[List.Picked].Name;
    Str     := MenuCmds[List.Picked].Name;
  End;

  List.Free;

  Result := Str;
End;

Procedure GetExtendedKey (Var Key: String);
Var
  List : TMenuList;
Begin
  List := TMenuList.Create(Console);

  List.Add ('FIRSTCMD', 0);
  List.Add ('EVERY', 0);
  List.Add ('AFTER', 0);
  List.Add ('LINEFEED', 0);
  List.Add ('TIMER', 0);
  List.Add ('UP', 0);
  List.Add ('DOWN', 0);
  List.Add ('LEFT', 0);
  List.Add ('RIGHT', 0);
  List.Add ('ENTER', 0);
  List.Add ('TAB', 0);
  List.Add ('ESCAPE', 0);
  List.Add ('HOME', 0);
  List.Add ('END', 0);
  List.Add ('PAGEUP', 0);
  List.Add ('PAGEDOWN', 0);

  List.Open (35, 4, 46, 21);
  List.Close;

  If List.ExitCode <> #27 Then Begin
    Changed := List.List[List.Picked]^.Name <> Key;
    Key     := List.List[List.Picked]^.Name;
  End;

  List.Free;
End;

Procedure EditCommand (Num, CmdNum: Word);
Var
  Box    : TMenuBox;
  Form   : TMenuForm;
  Topic  : String;
  CmdStr : String;
Begin
  Topic := '|03(|09Menu Cmd Editor|03) |01-|09> |15';
  Box   := TMenuBox.Create(Console);
  Form  := TMenuForm.Create(Console);

  Box.Header := ' Menu (' + MenuName + '): Command #' + strI2S(Num) + ' ';

  Box.Open (13, 9, 68, 16);

  VerticalLine (24, 11, 14);

  Form.AddNone ('C', ' Command ', 15, 11,  9, Topic + 'Menu command function');
  Form.AddStr  ('A', ' Access ' , 16, 12, 26, 12,  8, 30, 30, @Menu.Item[Num]^.CmdData[CmdNum]^.Access, Topic + 'Access level to run this command');
  Form.AddStr  ('D', ' Data '   , 18, 13, 26, 13,  6, 40, 80, @Menu.Item[Num]^.CmdData[CmdNum]^.Data, Topic + 'Menu command optional data');
  Form.AddTog  ('G', ' Execute ', 15, 14, 26, 14,  9,  6,  0, 8, 'Normal Up Down Left Right Tab Escape PgUp PgDn', @Menu.Item[Num]^.CmdData[CmdNum]^.JumpID, Topic + '(Grid) Execute command on what Grid event?');

  Repeat
    CmdStr := '(' + Menu.Item[Num]^.CmdData[CmdNum]^.MenuCmd + ') ' + GetCommandDesc(Menu.Item[Num]^.CmdData[CmdNum]^.MenuCmd);
    Console.WriteXY (26, 11, 113, strPadR(CmdStr, 40, ' '));

    Case Form.Execute of
      #27 : Break;
      'C' : Begin
              Menu.Item[Num]^.CmdData[CmdNum]^.MenuCmd := GetCommand(Menu.Item[Num]^.CmdData[CmdNum]^.MenuCmd);
              Changed := True;
            End;
    End;

    Changed := Changed or Form.Changed;
  Until False;

  Changed := Changed or Form.Changed;

  Box.Close;

  Box.Free;
  Form.Free;
End;

Procedure EditItem (Num: Word);
Const
  Status1 = 'Press (TAB) to edit menu commands';
  Status2 = '(CTRL-A) Add   (CTRL-D) Delete   (ENTER) Edit   (TAB) Switch';
Var
  Box   : TMenuBox;
  List  : TMenuList;
  Form  : TMenuForm;
  Topic : String;
  Image : TConsoleImageRec;

  Procedure MakeList;
  Var
    Count : Word;
  Begin
    List.Clear;

    For Count := 1 to Menu.Item[Num]^.Commands Do
      With Menu.Item[Num]^.CmdData[Count]^ Do Begin
        List.Add(strPadR('(' + MenuCmd + ') ' + GetCommandDesc(MenuCmd), 26, ' ') + ' ' +
                 strPadR(Access, 12, ' ') + ' ' + Data, 0);
      End;

    List.Add ('', 0);
  End;

Begin
  Console.GetScreenImage (1, 1, 80, 3, Image);

  Console.WriteXY (1, 1, 8, strRep('', 80));
  Console.WriteXY (1, 2, 8, strRep('', 80));
  Console.WriteXY (1, 3, 8, strRep('', 80));

  Box   := TMenuBox.Create(Console);
  List  := TMenuList.Create(Console);
  Form  := TMenuForm.Create(Console);

  Form.LoExitChars := #05#09#27;
  List.LoChars     := #01#04#09#13#27;
  List.LoAttr      := 113;
  List.NoInput     := True;
  List.NoWindow    := True;
  Box.Header       := ' Command #' + strI2S(Num) + ' (' + MenuName + ') ';
  Topic            := '|03(|09Menu Editor|03) |01-|09> |15';

  Box.Open (3, 2, 77, 21);

  VerticalLine (20, 4, 10);
  VerticalLine (71, 3, 11);

  Console.WriteXY (5, 12, 112, 'Command                     Access       Data');
  Console.WriteXY (5, 13, 112, strRep('', 71));
  Console.WriteXY (5, 20, 112, strPadC(Status1, 72, ' '));
  Console.WriteXY (5, 19, 112, strRep('', 71));

  MakeList;

  List.Open (4, 13, 77, 19);
  List.Picked := 0;
  List.Update;

  Form.AddPipe ('D', ' Display Text ' ,  6,  4, 22,  4, 14, 40, 80, @Menu.Item[Num]^.Text,    Topic + 'Text displayed on generated menus');
  Form.AddPipe ('O', ' LightBar Low ' ,  6,  5, 22,  5, 14, 40, 80, @Menu.Item[Num]^.TextLo,  Topic + 'Normal text in lightbar menu');
  Form.AddPipe ('I', ' LightBar High ',  5,  6, 22,  6, 15, 40, 80, @Menu.Item[Num]^.TextHi,  Topic + 'Highlighted text in lightbar menu');
  Form.AddCaps ('H', ' Hot Key '      , 11,  7, 22,  7,  9, 12, 12, @Menu.Item[Num]^.HotKey,  Topic + 'Key to run this command (CTRL-E = Extended Key List)');
  Form.AddStr  ('A', ' Access '       , 12,  8, 22,  8,  8, 30, 30, @Menu.Item[Num]^.Access, Topic + 'ACS level required to access this command');
  Form.AddTog  ('N', ' Display Type ' ,  6,  9, 22,  9, 14,  6,  0, 2, 'Access Always Never', @Menu.Item[Num]^.ShowType, Topic + 'How should this command be displayed?');
  Form.AddByte ('X', 'X'              , 16, 10, 22, 10,  1,  2,  0, 80, @Menu.Item[Num]^.X,   Topic + 'X coordinate of lightbar');
  Form.AddByte ('Y', 'Y'              , 18, 10, 25, 10,  1,  2,  0, 50, @Menu.Item[Num]^.Y,   Topic + 'Y coordinate of lightbar');
  Form.AddByte ('U', ' Up '           , 67,  3, 73,  3,  4,  3,  0, 255, @Menu.Item[Num]^.JumpUp, Topic + '(Grid) Item # to jump to when UP is pressed');
  Form.AddByte ('D', ' Down '         , 65,  4, 73,  4,  6,  3,  0, 255, @Menu.Item[Num]^.JumpDown, Topic + '(Grid) Item # to jump to when DOWN is pressed');
  Form.AddByte ('L', ' Left '         , 65,  5, 73,  5,  6,  3,  0, 255, @Menu.Item[Num]^.JumpLeft, Topic + '(Grid) Item # to jump to when LEFT is pressed');
  Form.AddByte ('R', ' Right '        , 64,  6, 73,  6,  7,  3,  0, 255, @Menu.Item[Num]^.JumpRight, Topic + '(Grid) Item # to jump to when RIGHT is pressed');
  Form.AddByte ('E', ' Escape '       , 63,  7, 73,  7,  8,  3,  0, 255, @Menu.Item[Num]^.JumpEscape, Topic + '(Grid) Item # to jump to when ESCAPE is pressed');
  Form.AddByte ('T', ' Tab '          , 66,  8, 73,  8,  5,  3,  0, 255, @Menu.Item[Num]^.JumpTab, Topic + '(Grid) Item # to jump to when TAB is pressed');
  Form.AddByte ('P', ' PageUp '       , 63,  9, 73,  9,  8,  3,  0, 255, @Menu.Item[Num]^.JumpPgUp, Topic + '(Grid) Item # to jump to when PGUP is pressed');
  Form.AddByte ('G', ' PageDn '       , 63, 10, 73, 10,  8,  3,  0, 255, @Menu.Item[Num]^.JumpPgDn, Topic + '(Grid) Item # to jump to when PGDN is pressed');
  Form.AddBol  ('W', ' Redraw '       , 63, 11, 73, 11,  8,  3,  @Menu.Item[Num]^.ReDraw, Topic + 'Redraw menu after running this command?');

  Repeat
    Case Form.Execute of
      #05 : GetExtendedKey(Menu.Item[Num]^.HotKey);
      #09 : Begin
              Repeat
                MakeList;

                Console.WriteXY (5, 20, 112, strPadC(Status2, 72, ' '));

                List.NoInput := False;
                List.Open (4, 13, 77, 19);

                Case List.ExitCode of
                  #01 : Begin
                          Menu.InsertCommand(Num, List.Picked);
                          Changed := True;
                        End;
                  #04 : If List.Picked <> List.ListMax Then Begin
                          Menu.DeleteCommand(Num, List.Picked);
                          Changed := True;
                        End;
                  #09 : Begin
                          List.Picked := 0;
                          List.Update;
                          Break;
                        End;
                  #13 : If List.Picked <> List.ListMax Then EditCommand(Num, List.Picked);
                  #27 : Break;
                End;
              Until False;

              Console.WriteXY (5, 20, 112, strPadC(Status1, 72, ' '));

              If List.ExitCode = #27 Then Break;
            End;
      #27 : Break;
    End;

    Changed := Changed or Form.Changed;
  Until False;

  Changed := Changed or Form.Changed;

  Box.Close;

  Form.Free;
  List.Free;
  Box.Free;

  Console.PutScreenImage(Image);
End;

Procedure EditFlags;
Var
  Box   : TMenuBox;
  Form  : TMenuForm;
  Topic : String;
Begin
  Box  := TMenuBox.Create(Console);
  Form := TMenuForm.Create(Console);

  Box.Header := ' Menu Flags (' + MenuName + ') ';
  Topic      := '|03(|09Menu Flags|03) |01-|09> |15';;

  Box.Open (6, 5, 75, 21);

  VerticalLine (22, 7, 20);

  Form.AddStr  ('D', ' Description ' ,   9,  7, 24,  7, 13, 30, 30, @Menu.Info.Description, Topic + 'Description of menu');
  Form.AddStr  ('A', ' Access '      ,  14,  8, 24,  8,  8, 30, 30, @Menu.Info.Access, Topic + 'Security requirements to access this menu');
  Form.AddTog  ('T', ' Menu Type '   ,  11,  9, 24,  9, 11, 13,  0, 2, 'Standard Lightbar Lightbar/Grid', @Menu.Info.MenuType, Topic + 'Type of menu');
  Form.AddTog  ('I', ' Input Type '  ,  10, 10, 24, 10, 12, 12,  0, 2, 'User_Defined HotKey LongKey', @Menu.Info.InputType, Topic + 'Input type for this menu');
  Form.AddTog  ('C', ' Input Chars ' ,   9, 11, 24, 11, 13,  9,  0, 2, 'Uppercase Lowercase Hidden', @Menu.Info.CharType, Topic + 'Input format display');
  Form.AddBol  ('G', ' Use Global '  ,  10, 12, 24, 12, 12,  3, @Menu.Info.Global, Topic + 'Include global menu options in this menu?');
  Form.AddStr  ('N', ' Node Status ' ,   9, 13, 24, 13, 13, 30, 30, @Menu.Info.NodeStatus, Topic + 'Node/User status set when this menu is loaded');
  Form.AddStr  ('F', ' Display File ',   8, 14, 24, 14, 14, 20, 20, @Menu.Info.DispFile, Topic + 'Display file shown instead of generated menu');
  Form.AddTog  ('L', ' Display Cols ',   8, 15, 24, 15, 14,  1,  1,  4, '1 2 3 4', @Menu.Info.DispCols, Topic + 'Number of columns in generated menu');
  Form.AddPipe ('H', ' Menu Header ' ,   9, 16, 24, 16, 13, 50, 70, @Menu.Info.Header, Topic + 'Menu header displayed in generated menu');
  Form.AddPipe ('P', ' Menu Prompt ' ,   9, 17, 24, 17, 13, 50, 70, @Menu.Info.Footer, Topic + 'Menu prompt displayed in generated menu');
  Form.AddByte ('M', ' Cmd Timer '   ,  11, 18, 24, 18, 11,  3,  0, 255, @Menu.Info.CmdTimer, Topic + 'Second interval between TIMER commands (0/Disabled)');
  Form.AddByte ('X', ' X '           ,  19, 19, 24, 19,  3,  2,  0,  80, @Menu.Info.DoneX, Topic + 'Locate to X coordinate after lightbar menu');
  Form.AddByte ('Y', ' Y '           ,  19, 20, 24, 20,  3,  2,  0,  50, @Menu.Info.DoneY, Topic + 'Locate to Y coordinate after lightbar menu');

  Form.Execute;

  Changed := Changed Or Form.Changed;

  Box.Close;

  Box.Free;
  Form.Free;
End;

Procedure EditMenu;
Var
  Box      : TMenuBox;
  List     : TMenuList;
  Count    : Word;
  CopyItem : Word;
Begin
  Menu := TMenuData.Create;
  Menu.Load (False, Theme.PathMenu + MenuName + '.mnu');

  Box  := TMenuBox.Create(Console);
  List := TMenuList.Create(Console);

  List.NoWindow := True;
  List.LoChars  := #01#03#04#06#13#16#27;
  Box.Header    := ' Command list (' + MenuName + ') ';

  Box.Open (9, 5, 72, 21);

  Console.WriteXY (11,  6, 112, 'Hot Key        Text                                     Cmds');
  Console.WriteXY (11,  7, 112, strRep('', 60));
  Console.WriteXY (11, 19, 112, strRep('', 60));
  Console.WriteXY (11, 20, 112, 'CTRL (A)dd  (C)opy  (P)aste  (D)elete  (F)lags  (ENTER) Edit');

  CopyItem := 0;

  Repeat
    List.Clear;

    For Count := 1 to Menu.NumItems Do
      List.Add (strPadR(Menu.Item[Count]^.HotKey, 15, ' ') +
                strPadR(strStripMCI(Menu.Item[Count]^.Text), 43, ' ') +
                strPadL(strI2S(Menu.Item[Count]^.Commands), 2, ' '), 0);

    List.Add ('', 0);

    List.Open (9, 7, 72, 19);

    Case List.ExitCode of
      #01 : Begin
              Menu.InsertItem(List.Picked);
              Changed := True;
            End;
      #03 : If List.Picked <> List.ListMax Then
              CopyItem := List.Picked;
      #04 : If List.Picked <> List.ListMax Then Begin
              Menu.DeleteItem(List.Picked);
              Changed := True;
            End;
      #06 : EditFlags;
      #13 : If List.Picked <> List.ListMax Then
              EditItem (List.Picked);
      #16 : If Menu.Item[CopyItem] <> NIL Then Begin
              Menu.CopyItem(CopyItem, List.Picked);
              Changed := True;
            End;
      #27 : Break;
    End;
  Until False;

  Box.Close;

  List.Free;
  Box.Free;

  If Changed Then
    If ShowMsgBox(1, 'Save changes to ' + MenuName + '?') Then
      If Not Menu.Save(Theme.PathMenu + MenuName + '.mnu') Then
        ShowMsgBox(0, 'Unable to save menu');

  Menu.Free;
End;

Function GetMenuName (OldName: String) : String;
Var
  Box  : TMenuBox;
  List : TMenuList;
  MF   : File;

  Procedure MakeList;
  Var
    Dir   : SearchRec;
    Sort  : TQuickSort;
    Count : Word;
    Info  : recMenuInfo;
    Desc  : String;
  Begin
    Sort := TQuickSort.Create;

    FindFirst (Theme.PathMenu + '*.mnu', Archive, Dir);
    While DosError = 0 Do Begin
      Sort.Add(JustFileName(Dir.Name), 0);
      FindNext (Dir);
    End;

    FindClose(Dir);

    Sort.Sort(1, Sort.Total, qAscending);

    List.Clear;

    For Count := 1 to Sort.Total Do Begin
      Assign (MF, Theme.PathMenu + Sort.Data[Count]^.Name + '.mnu');
      If ioReset(MF, SizeOf(Info), fmReadWrite + fmDenyNone) Then Begin
        ioRead (MF, Info);
        Close  (MF);
        Desc := Info.Description;
      End Else
        Desc := '';

      List.Add(strPadR(Sort.Data[Count]^.Name, 22, ' ') + Desc, 0);

      If Sort.Data[Count]^.Name = OldName Then
        List.Picked := List.ListMax;
    End;

    Sort.Free;
  End;

  Procedure InsertMenu;
  Var
    Str : String;
    OK  : Boolean;
  Begin
    Str := GetStr('Insert Menu', 'New menu name: ', '', 20, 20);

    If Str = '' Then Exit;

    OK := Not FileExist(Theme.PathMenu + Str + '.mnu');
    If Not OK Then
      OK := ShowMsgBox(1, Str + ' already exists.  Overwrite?');

    If OK Then Begin
      Menu := TMenuData.Create;
      Menu.CreateNewMenu(Theme.PathMenu + Str + '.mnu');
      Menu.Free;
    End;
  End;

Begin
  Result := '';

  Box  := TMenuBox.Create(Console);
  List := TMenuList.Create(Console);

  List.NoWindow := True;
  List.LoChars  := #01#04#13#27;
  Box.Header    := ' Menu Editor (' + Theme.Description + ') ';

  Box.Open (12, 5, 68, 21);

  Console.WriteXY (14,  6, 112, 'Menu Name             Description');
  Console.WriteXY (14,  7, 112, strRep('', 53));
  Console.WriteXY (14, 19, 112, strRep('', 53));
  Console.WriteXY (17, 20, 112, '(CTRL-A) Add   (CTRL-D) Delete   (ENTER) Select');

  Repeat
    Changed := False;

    MakeList;

    List.Open (12, 7, 68, 19);

    Case List.ExitCode of
      #01 : InsertMenu;
      #04 : If List.ListMax > 0 Then
              If ShowMsgBox(1, 'Delete menu: ' + strWordGet(1, List.List[List.Picked]^.Name, ' ')) Then Begin
                Assign (MF, Theme.PathMenu + strWordGet(1, List.List[List.Picked]^.Name, ' ') + '.mnu');
                Erase  (MF);
                If IoResult <> 0 Then
                  ShowMsgBox(0, 'Unable to delete menu');
              End;
      #13 : Begin
              If List.ListMax <> 0 Then
                Result := strWordGet(1, List.List[List.Picked]^.Name, ' ');
              Break;
            End;
      #27 : Break;
    End;
  Until False;

  Box.Close;

  List.Free;
  Box.Free;
End;

Procedure MenuEditor;
Var
  Saved : String;
Begin
  Saved    := '';
  MenuName := ThemeGetFileName(True);

  If MenuName = '' Then Exit;

  Repeat
    MenuName := GetMenuName(Saved);
    Saved    := MenuName;

    If MenuName = '' Then Exit;

    EditMenu;
  Until False;
End;

End.
