{$I M_OPS.PAS}

// add pgup/dn to move between records in menu editor, etc
// add copy/paste into menu editor

Program MCFG;

Uses
  {$IFDEF DEBUG}
    {$IFDEF FPC}
      HeapTrc,
    {$ENDIF}
    {$IFDEF VPC}
      HeapChk,
    {$ENDIF}
  {$ENDIF}

  m_Types,
  m_Output,
  m_MenuBox,
  m_MenuForm,
  m_Strings,
  m_FileIO,
  MCFG_Common,
  MCFG_SysConfig,
  MCFG_Theme,
  MCFG_Security,
  MCFG_User,
  MCFG_Menu,
  MCFG_Group,
  MCFG_MBases,
  MCFG_FBases,
  MCFG_Doors,
  MCFG_Chat,
  MCFG_Arcs;

{$I ANSI_MCFG_MAIN.PAS}

Const
  MenuPos : Array[0..4] of Byte = (1, 1, 1, 1, 1);
  MenuPtr : Byte = 0;

Var
  Menu  : TMenuForm;
  Box   : TMenuBox;
  Image : TConsoleImageRec;
  Res   : Char;

  Procedure BoxOpen (X1, Y1, X2, Y2: Byte);
  Begin
    Box := TMenuBox.Create(Console);

    Box.Open(X1, Y1, X2, Y2);
  End;

  Procedure CoolBoxOpen (X1: Byte; Text: String);
  Var
    Len : Byte;
  Begin
    Len := Length(Text) + 6;

    Console.GetScreenImage(X1, 1, X1 + Len, 3, Image);

    Console.WriteXYPipe (X1, 1, 8, Len, '|15|11|03|09|03|09' + strRep('', Len - 9) + '|08');
    Console.WriteXYPipe (X1 ,2, 8, Len, '|09|17 |15' + Text + ' |00|16|08');
    Console.WriteXYPipe (X1, 3, 8, Len, '|01|17 |11|03|08' + strRep('', Length(Text) - 4) + '|00 |16|08');
  End;

  Procedure BoxClose;
  Begin
    Box.Close;
    Box.Free;
  End;

  Procedure CoolBoxClose;
  Begin
    Console.PutScreenImage(Image);
  End;

  Procedure DrawHelp;
  Var
    Topic : String;
  Begin

    Case MenuPtr of
      0 : Topic := 'Main';
      1 : Topic := 'Configuration';
      2 : Topic := 'Editors';
      3 : Topic := 'Info';
      4 : Topic := 'About';
    End;

    Console.WriteXYPipe (5, 25, 3, 75, '(|09' + Topic + '|03) |01-|09> |15' + Menu.ItemData[Menu.ItemPos]^.Help + '|15.|07.|08.');
  End;


  Procedure AboutBox;
  Begin
    BoxOpen (19, 7, 62, 19);

    Console.WriteXY (21,  8,  31, strPadC('Mystic BBS Software', 40, ' '));
    Console.WriteXY (21,  9, 112, strRep('', 40));
    Console.WriteXY (22, 11, 113, 'Copyright (C) ' + mysCopyYear + ' By James Coyle');
    Console.WriteXY (31, 12, 113, 'All Rights Reserved');
    Console.WriteXY (21, 14, 113, strPadC('Version ' + mysVersionText, 40, ' '));
    Console.WriteXY (32, 16, 113, 'www.mysticbbs.com');
    Console.WriteXY (21, 17, 112, strRep('', 40));
    Console.WriteXY (21, 18,  31, strPadC('(PRESS A KEY)', 40, ' '));

    Menu.Input.ReadKey;

    BoxClose;
  End;

  Procedure DoDirCheck (DirName: String);
  Begin
    If (DirName = '') or (Not FileDirExists(DirName)) Then
      ShowMsgBox(0, DirName + ' path does not exist');
  End;

Var
  FileConfig : TBufFile;
  AskCreate  : Boolean;
  Temp       : String;
  Count      : LongInt;
Begin
  AskCreate  := False;
  FileConfig := TBufFile.Create(SizeOf(recConfig));

  If Not FileConfig.Open('mystic.dat', fmOpen, fmReadWrite + fmDenyNone, SizeOf(recConfig)) Then Begin
    AskCreate := strUpper(ParamStr(1)) = 'CREATE';

    If Not AskCreate Then Begin
      WriteLn;
      WriteLn ('ERROR: Unable to open MYSTIC.DAT.  This file must exist in the same directory');
      WriteLn ('as MCFG or must exist in the path with the environment variable MYSTICBBS');
      WriteLn ('MCFG can optionally recreate MYSTIC.DAT, however, all settings all will lost.');
      WriteLn ('If you wish to do this, rerun MCFG with the command line option CREATE.');

      FileConfig.Free;
      Halt(1);
    End;
  End Else Begin
    FileConfig.Read(bbsConfig);
    FileConfig.Free;

    If Not CheckBBSVersion(bbsConfig) Then Begin
      WriteLn;
      WriteLn ('ERROR: Mystic has detected an version mismatch.  If appears that one or more');
      WriteLn ('of the programs within Mystic have not been properly upgraded.  Make sure you');
      WriteLn ('have followed all procedures carefully!');
      Halt (1);
    End;
  End;

  Console := TOutput.Create(True);
  Menu    := TMenuForm.Create(Console);

  {$IFDEF WIN32}
    Console.SetWindowTitle('Mystic Configuration');
  {$ENDIF}

  Console.LoadScreenImage(CFGMAIN, CFGMAIN_LENGTH, CFGMAIN_WIDTH, 1, 1);

  If AskCreate Then Begin
    If ShowMsgBox(1, 'Create a new MYSTIC.DAT?') Then Begin
      FillChar(bbsConfig, SizeOf(bbsConfig), 0);

      GetDIR(0, Temp);

      Temp := CheckPath(Temp);

      With bbsConfig Do Begin
        VersionMajor  := mysVersionMajor;
        VersionMinor  := mysVersionMinor;
        VersionBuild  := mysVersionBuild;
        PathSystem    := Temp;
        PathData      := Temp + 'data' + PathSep;
        PathLogs      := Temp + 'logs' + PathSep;
        PathMsgs      := Temp + 'msgs' + PathSep;
        PathAttach    := Temp + 'fattach' + PathSep;
        PathOffmail   := Temp + 'offmail' + PathSep;
        PathMenu      := Temp + 'menus' + PathSep;
        PathText      := Temp + 'text' + PathSep;
        PathTemplate  := Temp + 'text' + PathSep;
        PathScripts   := Temp + 'scripts' + PathSep;
        Inactivity    := 120;
        AllowNewUsers := True;
        BBSName       := 'New Mystic BBS';
        SysopName     := 'Your Name Here';
        DefStartMenu  := 'start';
        DefThemeName  := 'default';
        DefTermMode   := 1;
        DefScreenSize := 24;
        AcsSysop      := 's255';
        SysopPW       := 'SYSOP';
        LoginAttempts := 5;
        PWAttempts    := 3;
        AskAlias      := True;
        AskRealName   := True;
        HotKeys       := 2;
        MatrixMenu    := 'matrix';
        MatrixAccess  := 's20';
        MColumns      := 1;
        ColorQuote    := 11;
        ColorText     := 7;
        ColorTear     := 15;
        ColorOrigin   := 9;
        ColorKludge   := 8;
        NewUserSec    := 10;
        InetTNUse     := True;
        InetTNPort    := 23;
        InetTNMax     := 4;
        InetTNIPs     := 1;
        TaskBar       := True;
        SystemCalls   := 0;
        MaxAutoSig    := 3;
        MColumns      := 1;
        FColumns      := 2;

        For Count := 1 to 10 Do Begin
          OptionalField[Count].Desc   := 'Optional #' + strI2S(Count);
          OptionalField[Count].iField := 40;
          OptionalField[Count].iMax   := 60;
        End;

        { default internet options }
      End;

      FileConfig.Open ('mystic.dat', fmCreate, fmReadWrite + fmDenyAll, SizeOf(recConfig));
      FileConfig.Write(bbsConfig);
    End;

    Console.ClearScreen;
    FileConfig.Free;
    Menu.Free;
    Console.Free;
    WriteLn ('A new MYSTIC configuration has been created.  Reload MCFG and verify that');
    WriteLn ('all options are set correctly immediately before restarting Mystic');
    Halt(1);
  End;

  DoDirCheck(bbsConfig.PathSystem);
  DoDirCheck(bbsConfig.PathData);
  DoDirCheck(bbsConfig.PathLogs);
  DoDirCheck(bbsConfig.PathMsgs);
  DoDirCheck(bbsConfig.PathAttach);
  DoDirCheck(bbsConfig.PathOffmail);

  Menu.HelpProc := {$IFDEF FPC}@{$ENDIF}DrawHelp;

  Repeat
    Menu.Clear;

    Menu.ExitOnFirst := True;
    Menu.ItemPos     := MenuPos[MenuPtr];
    MenuPos[0]       := MenuPtr;

    If MenuPtr = 0 Then
      Menu.HiExitChars := #80
    Else
      Menu.HiExitChars := #75#77; // install left and right arrows

    Case MenuPtr of
      0 : Begin
            Menu.ExitOnFirst := False;

            Menu.AddNone('C', ' Configuration ', 4,  2, 15, 'System configuration options');
            Menu.AddNone('E', ' Editors ',       27, 2, 9,  'Configuration editors');
            Menu.AddNone('I', ' Info ',          44, 2, 6,  'BBS statistics and monitors');
            Menu.AddNone('A', ' About ',         58, 2, 7,  'Information about Mystic BBS');
            Menu.AddNone('X', ' Exit ',          72, 2, 6,  'Quit configuration program');

            Res := Menu.Execute;

            If Menu.WasHiExit Then
              If Menu.ItemPos = 5 Then
                Break
              Else
                MenuPtr := Menu.ItemPos
            Else
              Case Res of
                'C' : MenuPtr := 1;
                'E' : MenuPtr := 2;
                'I' : MenuPtr := 3;
                'A' : MenuPtr := 4;
                #27,
                'X' : Break;
              End;
          End;
      1 : Begin
            CoolBoxOpen (2, 'Configuration');
            BoxOpen (3, 4, 31, 13);

            Menu.AddNone('S', '  System Paths  '           , 4,  5, 27, 'Configure system paths');
            Menu.AddNone('G', '  General Settings  '       , 4,  6, 27, 'General BBS settings');
            Menu.AddNone('M', '  Message Base Settings  '  , 4,  7, 27, 'Message base settings');
            Menu.AddNone('F', '  File Base Settings  '     , 4,  8, 27, 'File base settings');
            Menu.AddNone('1', '  New User Settings 1  '    , 4,  9, 27, 'New user settings');
            Menu.AddNone('2', '  New User Settings 2  '    , 4, 10, 27, 'More new user settings');
            Menu.AddNone('E', '  EchoMail Addresses  '     , 4, 11, 27, 'Echomail addresses');
            Menu.AddNone('I', '  Internet Server Options  ', 4, 12, 27, 'Internet server options');

            Res := Menu.Execute;

            MenuPos[1] := Menu.ItemPos;

            BoxClose;
            CoolBoxClose;

            If Menu.WasHiExit Then
              Case Res of
                #75 : MenuPtr := 4;
                #77 : MenuPtr := 2;
              End
            Else
              Case Res of
                'E' : NetworkAddress(True);
                'F' : FileBaseSettings;
                'G' : GeneralSettings1;
                'I' : InternetOptions;
                'M' : MessageSettings;
                'S' : SystemPaths;
                '1' : NewUserSettings1;
                '2' : NewUserSettings2;
              Else
                MenuPtr := 0;
              End;
          End;
      2 : Begin
            BoxOpen (26, 4, 51, 19);
            CoolBoxOpen (25, 'Editors');

            Menu.AddNone('U', '  User Editor  '         , 27,  5, 24, 'User editor');
            Menu.AddNone('M', '  Menu Editor  '         , 27,  6, 24, 'Menu editor');
            Menu.AddNone('T', '  Theme Editor  '        , 27,  7, 24, 'Theme editor');
            Menu.AddNone('S', '  Security Levels  '     , 27,  8, 24, 'Security levels');
            Menu.AddNone('F', '  File Base Editor  '    , 27,  9, 24, 'File base editor');
            Menu.AddNone('G', '  File Group Editor  '   , 27, 10, 24, 'File group editor');
            Menu.AddNone('B', '  Message Base Editor  ' , 27, 11, 24, 'Message base editor');
            Menu.AddNone('R', '  Message Group Editor  ', 27, 12, 24, 'Message group editor');
            Menu.AddNone('D', '  Door Editor  '         , 27, 13, 24, 'Door editor');
            Menu.AddNone('A', '  Archive Editor  '      , 27, 14, 24, 'Archive editor');
            Menu.AddNone('V', '  Voting Booth Editor  ' , 27, 15, 24, 'Voting booth editor');
            Menu.AddNone('L', '  BBS List Editor  '     , 27, 16, 24, 'BBS list editor');
            Menu.AddNone('P', '  Protocol Editor  '     , 27, 17, 24, 'Protocol editor');
            Menu.AddNone('C', '  Chat Room Editor '     , 27, 18, 24, 'Chat room editor');

            Res := Menu.Execute;

            MenuPos[2] := Menu.ItemPos;

            CoolBoxClose;
            BoxClose;

            If Menu.WasHiExit Then
              Case Res of
                #75 : MenuPtr := 1;
                #77 : MenuPtr := 3;
              End
            Else
              Case Res of
                'A' : ArchiveEditor;
                'B' : MessageBaseEditor;
                'C' : ChatRoomEditor;
                'D' : DoorEditor;
                'F' : FileBaseEditor;
                'G' : GroupEditor(False);
                'M' : MenuEditor;
                'R' : GroupEditor(True);
                'S' : SecurityEditor(True);
                'T' : ThemeGetFileName(False);
                'U' : UserEditor;
              Else
                MenuPtr := 0;
              End;
          End;
      3 : Begin
            BoxOpen (42, 4, 59, 10);
            CoolBoxOpen (42, 'Info');

            Menu.AddNone('S', '  Statistics  ',   43,  5, 16, 'View BBS statistics');
            Menu.AddNone('H', '  History  ',      43,  6, 16, 'View BBS history');
            Menu.AddNone('L', '  SysOp Logs  ',   43,  7, 16, 'View Sysop logs');
            Menu.AddNone('C', '  Chat Logs  ',    43,  8, 16, 'View user chat logs');
            Menu.AddNone('N', '  Node Monitor  ', 43,  9, 16, 'Monitor active BBS nodes');

            Res := Menu.Execute;

            MenuPtr    := 0;
            MenuPos[3] := Menu.ItemPos;

            Case Res of
              #75 : MenuPtr := 2;
              #77 : MenuPtr := 4;
            End;

            BoxClose;
            CoolBoxClose;
          End;
      4 : Begin
            BoxOpen (56, 4, 74, 8);
            CoolBoxOpen (56, 'About');

            Menu.AddNone('A', '  About Mystic  ',  57, 5, 17, 'About Mystic BBS software');
            Menu.AddNone('H', '  Help  ',          57, 6, 17, 'View online help');
            Menu.AddNone('S', '  Command Shell  ', 57, 7, 17, 'Shell to the command prompt');

            Res := Menu.Execute;

            MenuPos[4] := Menu.ItemPos;

            BoxClose;
            CoolBoxClose;

            Case Res of
              'A' : AboutBox;
              #75 : MenuPtr := 3;
              #77 : MenuPtr := 1;
            Else
              MenuPtr := 0;
            End;
          End;
    End;
  Until False;

  Menu.Free;

  Console.ClearScreen;

  WriteLn ('Mystic Configuration Utility Version ' + mysVersionText);
  WriteLn ('Copyright (C) ' + mysCopyYear + ' By James Coyle.  All Rights Reserved');

  Console.Free;

  FileConfig := TBufFile.Create(SizeOf(recConfig));

  FileConfig.Open  ('mystic.dat', fmOpen, fmReadWrite + fmDenyWrite, SizeOf(recConfig));
  FileConfig.Write (bbsConfig);
  FileConfig.Free;
End.
