{$I M_OPS.PAS}

Unit m_Socket_Windows;

Interface

Uses
  m_Socket_Types;

Const
  PF_INET            = 2;
  AF_INET            = 2;
  INADDR_ANY : u_long = $00000000;
  INADDR_NONE        = $ffffffff;
  SOCK_STREAM        = 1;
  FD_SETSIZE         = 64;
  WSADESCRIPTION_LEN = 256;
  WSASYS_STATUS_LEN  = 128;
  SOCKET_ERROR       = -1;
  IOCPARM_MASK       = $7F;          { parameters must be < 128 bytes }
  IOC_VOID           = $20000000;    { no parameters }
  IOC_OUT            = $40000000;    { copy out parameters }
  IOC_IN             = $80000000;    { copy in parameters }
  IOC_INOUT          = (IOC_IN OR IOC_OUT);
  FIONREAD   = (IOC_OUT OR ((4 AND IOCPARM_MASK) SHL 16) OR (ord('f') SHL 8) OR 127);  { get # bytes to read }
  FIONBIO    = (IOC_IN OR ((4 AND IOCPARM_MASK) SHL 16) OR (ord('f') SHL 8) OR 126);   { set/clear non-blocking i/o }
  FIOASYNC   = (IOC_IN OR ((4 AND IOCPARM_MASK) SHL 16) OR (ord('f') SHL 8) OR 125);   { set/clear async i/o }

Type
//  THostAddr = array[1..4] of byte;
//  PHostAddr = ^THostAddr;

  WSAData = Record
    wVersion       : system.Word;
    wHighVersion   : system.Word;
    szDescription  : Array[0..WSADESCRIPTION_LEN+1] OF Char;
    szSystemStatus : Array[0..WSASYS_STATUS_LEN+1] OF Char;
    iMaxSockets    : system.Word;
    iMaxUdpDg      : system.Word;
    lpVendorInfo   : PChar;
  End;

  PFDSet = ^FDSet;
  FDSet = Record
    fd_count : LongInt;
    fd_array : Array[1..FD_SETSIZE] of TSocket;
  End;

  PTimeVal = ^TimeVal;
  TimeVal = Record
    sec  : LongInt;
    usec : LongInt;
  End;

{&StdCall+}
Function Accept      (S: TSocket; Var Addr: TSockAddr; Var AddrLen: LongInt): TSocket;
Function Bind        (S: TSocket; Var Addr: TSockAddr; NameLen: LongInt): LongInt;
Function Connect     (S: TSocket; Var Name: TSockAddr; NameLen: LongInt): LongInt;
Function GetPeerName (S: TSocket; Var Name: TSockAddr; Var NameLen: LongInt): LongInt;
Function GetSockName (S: TSocket; Var Name: TSockAddr; Var NameLen: LongInt): LongInt;
Function GetSockOpt  (S: TSocket; Level: LongInt; OptName: LongInt; Var OptVal; Var OptLen: LongInt): LongInt;
Function ioCtlSocket (S: TSocket; Cmd: LongInt; Var ArgP: u_long): LongInt;
Function Listen      (S: TSocket; BackLog: LongInt): LongInt;
Function Recv        (S: TSocket; Var Buf; Len: LongInt; Flags: LongInt): LongInt;
Function RecvFrom    (S: TSocket; Var Buf; Len: LongInt; Flags: LongInt; Var From: TSockAddr; Var FromLen: LongInt): LongInt;
Function Select      (NFDS: LongInt; ReadFDS: PFDSet; WriteFDS: PFDSet; ExceptFDS: PFDSet; TimeOut: PTimeVal): LongInt;
Function Send        (S: TSocket; Var Buf; Len: LongInt; Flags: LongInt): LongInt;
Function SendTo      (S: TSocket; Var Buf; Len: LongInt; Flags: LongInt; Var ToAddr: TSockAddr; ToLen: LongInt): LongInt;
Function SetSockOpt  (S: TSocket; Level: LongInt; OptName: LongInt; Var OptVal; OptLen: LongInt): LongInt;
Function Socket      (AF: LongInt; SType: LongInt; Protocol: LongInt): TSocket;
Function CloseSocket (S: TSocket): LongInt;
Function ShutDown    (S: TSocket; How: LongInt): LongInt;
Function WSAGetLastError: LongInt;
Function WSAStartup  (wVersionRequired: Word; Var lpWSAData: WSAData): LongInt;
Function WSACleanup: LongInt;
Function ntohs          (NetShort: u_short): u_short;
Function inet_addr      (CP: PChar): LongInt;
Function inet_ntoa      (InA: THostAddr): PChar;
Function GetServByName  (Name: PChar; Proto: PChar): PServEnt;
Function GetHostByName  (Name: PChar): PHostEnt;
Function GetHostByAddr  (Name: PChar; Len: LongInt; AType: LongInt): PHostEnt;
Function GetProtoByName (Name: PChar): PProtoEnt;
{&StdCall-}

Implementation

Const
  SockDLL = 'wsock32.dll';

{&StdCall+}
Function Accept      (S: TSocket; Var Addr: TSockAddr; Var AddrLen: LongInt): TSocket; External SockDLL Name 'accept';
Function Bind        (S: TSocket; Var Addr: TSockAddr; NameLen: LongInt): LongInt;     External SockDLL Name 'bind';
Function Connect     (S: TSocket; Var Name: TSockAddr; NameLen: LongInt): LongInt;     External SockDLL Name 'connect';
Function GetPeerName (S: TSocket; Var Name: TSockAddr; Var NameLen: LongInt): LongInt; External SockDLL Name 'getpeername';
Function GetSockName (S: TSocket; Var Name: TSockAddr; Var NameLen: LongInt): LongInt; External SockDLL Name 'getsockname';
Function GetSockOpt  (S: TSocket; Level: LongInt; OptName: LongInt; Var OptVal; Var OptLen: LongInt): LongInt; External SockDLL Name 'getsockopt';
Function ioCtlSocket (S: TSocket; Cmd: LongInt; Var ArgP: u_long): LongInt; External SockDLL Name 'ioctlsocket';
Function Listen      (S: TSocket; BackLog: LongInt): LongInt; External SockDLL Name 'listen';
Function Recv        (S: TSocket; Var Buf; Len: LongInt; Flags: LongInt): LongInt; External SockDLL Name 'recv';
Function RecvFrom    (S: TSocket; Var Buf; Len: LongInt; Flags: LongInt; Var From: TSockAddr; Var FromLen: LongInt): LongInt; External SockDLL Name 'recvfrom';
Function Select      (NFDS: LongInt; ReadFDS: PFDSet; WriteFDS: PFDSet; ExceptFDS: PFDSet; TimeOut: PTimeVal): LongInt; External SockDLL Name 'select';
Function Send        (S: TSocket; Var Buf; Len: LongInt; Flags: LongInt): LongInt; External SockDLL Name 'send';
Function SendTo      (S: TSocket; Var Buf; Len: LongInt; Flags: LongInt; Var ToAddr: TSockAddr; ToLen: LongInt): LongInt; External SockDLL Name 'sendto';
Function SetSockOpt  (S: TSocket; Level: LongInt; OptName: LongInt; Var OptVal; OptLen: LongInt): LongInt; External SockDLL Name 'setsockopt';
Function Socket      (AF: LongInt; SType: LongInt; Protocol: LongInt): TSocket; External SockDLL Name 'socket';
Function CloseSocket (S: TSocket): LongInt; External SockDLL Name 'closesocket';
Function ShutDown    (S: TSocket; How: LongInt): LongInt; External SockDLL Name 'shutdown';
Function WSAGetLastError: LongInt; External SockDLL Name 'WSAGetLastError';
Function WSAStartup  (wVersionRequired: Word; Var lpWSAData: WSAData): LongInt; External SockDLL Name 'WSAStartup';
Function WSACleanup: LongInt; External SockDLL Name 'WSACleanup';

Function ntohs          (NetShort: u_short): u_short; External SockDLL Name 'ntohs';
Function inet_addr      (CP: PChar): LongInt; External SockDLL Name 'inet_addr';
Function inet_ntoa      (InA: THostAddr): PChar; External SockDLL Name 'inet_ntoa';
Function GetServByName  (Name: PChar; Proto: PChar): PServEnt; External SockDLL Name 'getservbyname';
Function GetHostByName  (Name: PChar): PHostEnt; External SockDLL Name 'gethostbyname';
Function GetHostByAddr  (Name: PChar; Len: LongInt; AType: LongInt): PHostEnt; External SockDLL Name 'gethostbyaddr';
Function GetProtoByName (Name: PChar): PProtoEnt; External SockDLL Name 'getprotobyname';
{&StdCall-}

End.
