{
  Mystic Software Development Library
  ===========================================================================
  File    | M_INPUT_WINDOWS.PAS
  Desc    | Console input class functions for Windows
  Created | August 22, 2002
  ---------------------------------------------------------------------------
}

{$I M_OPS.PAS} {$R-}

Unit m_Input_Windows;

Interface

Uses
  Windows;

Type
  TInputWindows = Class
    ConIn         : THandle;
    Buffer        : Array[1..64] of Char;
    BufPos        : Byte;
    BufSize       : Byte;
    DoingNumChars : Boolean;
    DoingNumCode  : Byte;

    Constructor Create;
    Destructor  Destroy; Override;
    Procedure   AddBuffer (Ch: Char);
    Function    RemapScanCode (ScanCode: Word; CtrlKeyState: dWord; Keycode: Word) : Byte;

    Function    KeyWait (MS: LongInt) : Boolean;
    Function    KeyPressed : Boolean;
    Function    ReadKey : Char;
  End;

Implementation

Constructor TInputWindows.Create;
Begin
  Inherited Create;

  ConIn := GetStdHandle(STD_INPUT_HANDLE);

  SetConsoleMode (ConIn, 0);

  BufPos  := 0;
  BufSize := 0;
End;

Destructor TInputWindows.Destroy;
Begin
  Inherited Destroy;
End;

Procedure TInputWindows.AddBuffer (Ch: Char);
Begin
  Inc (BufSize);

  If BufSize > 64 Then BufSize := 1;

  Buffer[BufSize] := Ch;
End;

Function TInputWindows.RemapScanCode (ScanCode: Word; CtrlKeyState: dWord; keycode: Word) : Byte;
Var
  AltKey,
  CtrlKey,
  ShiftKey : Boolean;
Const
  CtrlKeypadKeys: Array[$47..$53] of Byte = (
    $77,
    $8D,
    $84,
    $8E,
    $73,
    $8F,
    $74,
    $4E,
    $75,
    $91,
    $76,
    $92,
    $93
  );
Begin
  AltKey   := ((CtrlKeyState AND (RIGHT_ALT_PRESSED OR LEFT_ALT_PRESSED)) > 0);
  CtrlKey  := ((CtrlKeyState AND (RIGHT_CTRL_PRESSED OR LEFT_CTRL_PRESSED)) > 0);
  ShiftKey := ((CtrlKeyState AND SHIFT_PRESSED) > 0);

  If AltKey Then Begin
    Case KeyCode of
      VK_NUMPAD0 ..
      VK_NUMPAD9    : Begin
                       DoingNumChars := True;
                       DoingNumCode  := Byte((DoingNumCode * 10) + (KeyCode - VK_NUMPAD0));
                      End;
    End;

    Case ScanCode of
      $02..$0D: Inc(ScanCode, $76);  // Digits, -, =
      $3B..$44: Inc(ScanCode, $2D);  // Function keys
      $57..$58: Inc(ScanCode, $34);  // Function keys
      $47..$49,
      $4B, $4D,
      $4F..$53: Inc(ScanCode, $50);
      $1C     : ScanCode := $A6;   // Enter
      $35     : ScanCode := $A4;   // /
    End
  End Else If CtrlKey Then
    Case ScanCode of
      $0F     : ScanCode := $94;     // TAB
      $3B..$44: Inc(ScanCode, $23);  // Function keys
      $57..$58: Inc(ScanCode, $32);  // Function keys
      $35:      ScanCode := $95;     // \
      $37:      ScanCode := $96;     // *
      $47..$53: ScanCode := CtrlKeypadKeys[ScanCode];
    End
  Else If ShiftKey Then
    Case ScanCode of
      $3B..$44: inc(ScanCode, $19);
      $57..$58: inc(ScanCode, $30);
    End
  Else
    Case ScanCode of
      $57..$58: Inc(Scancode, $2E); // F11 and F12
    End;

  Result := ScanCode;
End;

{$IFDEF VPC}
Function TInputWindows.KeyWait (MS: DWord) : Boolean;
Var
  Ch       : Char;
  InputRec : TInputRecord;
  NumRead  : Longint;
//  AltKey   : Boolean;
Begin
  If BufPos <> BufSize Then Begin
    Result := True;
    Exit;
  End;

  Result := False;

  Repeat
    Case WaitForSingleObject(ConIn, MS) of
      Wait_Object_0 : begin
                        repeat
                          ReadConsoleInput(ConIn, InputRec, 1, NumRead);

//                          if numread = 0 then exit;
//                          writeln(numread);

                          if inputrec.eventtype = key_event then
                            if inputrec.KeyEvent.bKeyDown then begin
//                              AltKey := ((inputrec.KeyEvent.dwControlKeyState AND (RIGHT_ALT_PRESSED OR LEFT_ALT_PRESSED)) > 0);

                              if not(inputrec.KeyEvent.wVirtualKeyCode in [VK_SHIFT, VK_MENU, VK_CONTROL, VK_CAPITAL, VK_NUMLOCK, VK_SCROLL]) then begin
                                if (ord(inputrec.KeyEvent.AsciiChar) = 0) or (inputrec.KeyEvent.dwControlKeyState and (LEFT_ALT_PRESSED or ENHANCED_KEY or RIGHT_ALT_PRESSED) > 0) then begin
                                  if (ord(inputrec.KeyEvent.AsciiChar) = 13) and (inputrec.KeyEvent.wVirtualKeyCode = VK_RETURN) then begin
                                    addbuffer(#13);
                                    result := true;
                                    exit;
                                  end else begin
                                    addbuffer(#0);
                                    addbuffer(chr(RemapScanCode(inputrec.KeyEvent.wVirtualScanCode, inputrec.KeyEvent.dwControlKeyState, inputrec.KeyEvent.wVirtualKeyCode)));
                                    result := true;
                                    exit;
                                  end;
                                end else begin
                                  addbuffer(Chr(Ord(inputrec.KeyEvent.AsciiChar)));
                                  result := true;
                                  exit;
                                end;
                              end;
                            end else
                            if (inputrec.KeyEvent.wVirtualKeyCode in [VK_MENU]) then
                              if DoingNumChars then
                                if DoingNumCode > 0 then begin
                                  AddBuffer(Chr(DoingNumCode));
                                  DoingNumChars := false;
                                  DoingNumCode := 0;
                                  result := true;
                                  break
                                end;

                          getnumberofconsoleinputevents(ConIn, numread);
                        until numread = 0;
                      end;
    else
      result := false;
      exit;
    end;
  until false;
end;
{$ENDIF}
{$IFDEF FPC}
Function TInputWindows.KeyWait (MS: LongInt) : Boolean;
Var
//  Ch       : Char;
  InputRec : TInputRecord;
  NumRead  : ULong;
//  AltKey   : Boolean;
Begin
  If BufPos <> BufSize Then Begin
    Result := True;
    Exit;
  End;

  Repeat
    Case WaitForSingleObject(ConIn, MS) of
      Wait_Object_0 : begin
                        repeat
                          ReadConsoleInput(ConIn, InputRec, 1, NumRead);

                          if inputrec.eventtype = key_event then
                            if inputrec.event.KeyEvent.bKeyDown then begin
//                              AltKey := ((inputrec.event.KeyEvent.dwControlKeyState AND (RIGHT_ALT_PRESSED OR LEFT_ALT_PRESSED)) > 0);

                              if not(inputrec.event.KeyEvent.wVirtualKeyCode in [VK_SHIFT, VK_MENU, VK_CONTROL, VK_CAPITAL, VK_NUMLOCK, VK_SCROLL]) then begin
                                if (ord(inputrec.event.KeyEvent.AsciiChar) = 0) or (inputrec.event.KeyEvent.dwControlKeyState and (LEFT_ALT_PRESSED or ENHANCED_KEY or RIGHT_ALT_PRESSED) > 0) then begin
                                  if (ord(inputrec.event.KeyEvent.AsciiChar) = 13) and (inputrec.event.KeyEvent.wVirtualKeyCode = VK_RETURN) then begin
                                    addbuffer(#13);
                                    result := true;
                                    exit;
                                  end else begin
                                    addbuffer(#0);
                                    addbuffer(chr(RemapScanCode(inputrec.event.KeyEvent.wVirtualScanCode, inputrec.event.KeyEvent.dwControlKeyState, inputrec.event.KeyEvent.wVirtualKeyCode)));
                                    result := true;
                                    exit;
                                  end;
                                end else begin
                                  addbuffer(Chr(Ord(inputrec.event.KeyEvent.AsciiChar)));
                                  result := true;
                                  exit;
                                end;
                              end;
                            end else
                            if (inputrec.event.KeyEvent.wVirtualKeyCode in [VK_MENU]) then
                              if DoingNumChars then
                                if DoingNumCode > 0 then begin
                                  AddBuffer(Chr(DoingNumCode));
                                  DoingNumChars := false;
                                  DoingNumCode := 0;
                                  result := true;
                                  break
                                end;

                          getnumberofconsoleinputevents(ConIn, numread);
                        until numread = 0;
                      end;
    else
      result := false;
      break;
    end;
  until false;
end;
{$ENDIF}

function TInputWindows.readkey : char;
begin
  if bufpos = bufsize then
    keywait(infinite);
//    repeat
//    until keywait(infinite);

  inc (bufpos);
  if bufpos > 64 then bufpos := 1;
  result := buffer[bufpos];
end;

function TInputWindows.keypressed : boolean;
Var
  Temp : ULong;
begin
  if bufpos = bufsize then begin
    getnumberofconsoleinputevents(ConIn, Temp);
    if temp > 0 then keywait(1);
  end;

  result := bufpos <> bufsize;
end;

End.
