Unit BBS_NodeChat;

{$I M_OPS.PAS}

Interface

Uses
  BBS_Common;

Type
  TBBSNodeChat = Class
    Owner    : Pointer;
    Room     : RecChatRoom;
    CurRoom  : Byte;
    FullChat : Boolean;

    Constructor Create (O: Pointer);
    Destructor  Destroy; Override;
    Procedure   ProcessChatMessage (mOrigin, mType: Byte; mText: String; mRoom: Byte);
    Procedure   SendMessage (mType: Byte; mText: String; mRoom: Byte);
    Procedure   NodeChat;
  End;

Implementation

Uses
  Mystic_Telnet,
  m_FileIO,
  m_Strings,
  BBS_Core,
  BBS_Multinode;

Constructor TBBSNodeChat.Create (O: Pointer);
Begin
  Inherited Create;

  Owner := O;
End;

Destructor TBBSNodeChat.Destroy;
Begin
  Inherited Destroy;
End;

Procedure TBBSNodeChat.ProcessChatMessage (mOrigin, mType: Byte; mText: String; mRoom: Byte);
Var
  SavedAttr : Byte;
  Str       : String;
Begin
  If (mRoom <> CurRoom) And (mRoom <> 0) Then Exit;

  SavedAttr := TBBSCore(Owner).Term.Console.TextAttr;

  TBBSCore(Owner).Term.OutPipe('|16');

  If TBBSCore(Owner).Term.Graphics = 0 Then
    TBBSCore(Owner).Term.OutBS (TBBSCore(Owner).Term.Console.CursorX, True)
  Else
    TBBSCore(Owner).Term.OutRaw(TBBSCore(Owner).Term.AnsiMoveX(1) + TBBSCore(Owner).Term.AnsiClrEOL);

  Case mType of
    nodeTelePublic : Str := TBBSCore(Owner).GetPrompt(290);
    nodeTeleStatus : Str := '';
    nodeTeleAll    : Str := TBBSCore(Owner).GetPrompt(275);
  End;

  Str := strReplace(Str, '|&A', TTelnetServer(TBBSCore(Owner).Owner.Manager.ClientList[mOrigin - 1]).BBS.User.ThisUser.ChatName);
  Str := strReplace(Str, '|&B', strI2S(mOrigin));

  If FullChat Then Begin
    // add text to scrollback
    // save it
  End Else Begin
    If TBBSCore(Owner).Term.Graphics = 0 Then
      TBBSCore(Owner).Term.OutBS(TBBSCore(Owner).Term.Console.CursorX, True)
    Else Begin
      TBBSCore(Owner).Term.OutRaw(TBBSCore(Owner).Term.AnsiMoveX(1));
      TBBSCore(Owner).Term.OutRaw(TBBSCore(Owner).Term.AnsiClrEol);
    End;

    TBBSCore(Owner).Term.OutPipe (Str);
    TBBSCore(Owner).Term.OutPipeLn (mText);
  End;

  TBBSCore(Owner).Term.PromptInfo['A'] := TBBSCore(Owner).User.ThisUser.ChatName;
  TBBSCore(Owner).Term.OutFull(TBBSCore(Owner).GetPrompt(278));
  TBBSCore(Owner).Term.OutRaw (TBBSCore(Owner).Term.Attr2Ansi(SavedAttr, False));
End;

Procedure TBBSNodeChat.SendMessage (mType: Byte; mText: String; mRoom: Byte);
Var
  T     : TBBSCore;
  Count : Byte;
Begin
  For Count := 1 to bbsConfig.INetTNMax Do
    If TBBSCore(Owner).Owner.Manager.ClientList[Count - 1] <> NIL Then Begin
      T := TTelnetServer(TBBSCore(Owner).Owner.Manager.ClientList[Count - 1]).BBS;
      If T.User.InNodeChat Then
        T.NodeMsg.AddMsg(TBBSCore(Owner).Node, mType, mText, mRoom);
    End;
End;

Procedure TBBSNodeChat.NodeChat;

  Function LoadRoom (NewRoom: Byte) : Boolean;
  Var
    F : File;
    T : RecChatRoom;
  Begin
    Result := False;

    Assign (F, bbsConfig.PathData + 'chatroom.dat');
    If Not ioReset(F, SizeOf(RecChatRoom), fmReadWrite + fmDenyNone) Then Exit;

    If Not ioSeek(F, NewRoom - 1) Then Begin
      Close(F);
      Exit;
    End;

    If Not ioRead (F, T) Then Begin
      Close(F);
      Exit;
    End;

    Close(F);

    If Not TBBSCore(Owner).User.Access(T.JoinACS) Then Exit;

    Room    := T;
    CurRoom := NewRoom;
    Result  := True;

    TBBSCore(Owner).Term.PromptInfo['A'] := strI2S(CurRoom);
    TBBSCore(Owner).Term.PromptInfo['B'] := Room.Topic;
    TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(292));
  End;

  Procedure ChangeNick (CmdData: String);
  Var
    Count : Byte;
    Temp  : TBBSCore;
    Str   : String;
  Begin
    CmdData := strStripB(CmdData, ' ');

    If CmdData = '' Then Begin
      TBBSCore(Owner).Term.OutFullLn('');
      Exit;
    End;

    For Count := 1 to bbsConfig.INetTNMax Do
      If TBBSCore(Owner).Owner.Manager.ClientList[Count - 1] <> NIL Then Begin

        If Count = TBBSCore(Owner).Node Then Continue;

        Temp := TTelnetServer(TBBSCore(Owner).Owner.Manager.ClientList[Count - 1]).BBS;

        If (strUpper(Temp.User.ThisUser.Handle) = strUpper(CmdData)) or (strUpper(Temp.User.ThisUser.ChatName) = strUpper(CmdData)) Then Begin
          TBBSCore(Owner).Term.OutFullLn('|CR' + TBBSCore(Owner).GetPrompt(293));
          Exit;
        End;
      End;

    Str := TBBSCore(Owner).GetPrompt(294);
    Str := strReplace(Str, '|&A', TBBSCore(Owner).User.ThisUser.ChatName);
    Str := strReplace(Str, '|&C', CmdData);

    TBBSCore(Owner).User.ThisUser.ChatName := CmdData;

    SendMessage(nodeTeleStatus, Str, 0);
  End;

  Procedure DrawScreen;
  Begin
    If FullChat Then
      TBBSCore(Owner).Term.ShowTemplate('ansinodechat')
    Else
      TBBSCore(Owner).Term.OutFile('chatstart');
  End;

Var
  CmdData : String;
  Cmd     : String;
Begin
  TBBSCore(Owner).User.InNodeChat := True;
  TBBSCore(Owner).User.UserAction := TBBSCore(Owner).GetPrompt(277);

  // check for duplicate chat name?
  // FullChat := (TBBSCore(Owner).Term.Graphics <> 0) And (TBBSCore(Owner).User.ThisUser.FSNodeChat);

  FullChat := False;

  DrawScreen;

  SendMessage (nodeTeleStatus, strReplace(TBBSCore(Owner).GetPrompt(291), '|&A', TBBSCore(Owner).User.ThisUser.ChatName), 0);

  If Not LoadRoom(1) Then Exit;

  While Not TBBSCore(Owner).ShutDown Do Begin
    If FullChat Then
      TBBSCore(Owner).Term.OutRaw(TBBSCore(Owner).Term.AnsiGotoXY(1, TBBSCore(Owner).Term.ScreenInfo[5].Y))
    Else Begin
      If TBBSCore(Owner).Term.Graphics = 0 Then
        TBBSCore(Owner).Term.OutBS(TBBSCore(Owner).Term.Console.CursorX, True)
      Else Begin
        TBBSCore(Owner).Term.OutRaw(TBBSCore(Owner).Term.AnsiMoveX(1));
        TBBSCore(Owner).Term.OutRaw(TBBSCore(Owner).Term.AnsiClrEol);
      End;
    End;

    TBBSCore(Owner).Term.OutFull(TBBSCore(Owner).GetPrompt(278));
    CmdData := TBBSCore(Owner).Term.GetStr(79 - TBBSCore(Owner).Term.Console.CursorX + 1, 255, 9, '');

    If CmdData[1] = '/' Then Begin
      Cmd := strUpper(strWordGet(1, CmdData, ' '));

      If Pos(' ', CmdData) > 0 Then
        CmdData := Copy(CmdData, strWordPos(2, CmdData, ' '), 255)
      Else
        CmdData := '';

      If (Cmd = '/B') Then Begin
        If CmdData <> '' Then SendMessage(nodeTeleAll, CmdData, 0)
      End Else
      If (Cmd = '/J') or (Cmd = '/JOIN') Then Begin
        TBBSCore(Owner).Term.OutRawLn('');
        If Not LoadRoom(strS2I(CmdData)) Then
          TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(276));
      End Else
      If (Cmd = '/N') or (Cmd = '/NICK') Then
        ChangeNick(CmdData)
      Else
      If (Cmd = '/?') or (Cmd = '/HELP') Then
        TBBSCore(Owner).Term.OutFile('chathelp')
      Else
      If (Cmd = '/T') or (Cmd = '/TOPIC') Then Begin
      End Else
      If (Cmd = '/W') or (Cmd = '/WHO') Then
        WhosOnline(TBBSCore(Owner), '')
      Else
      If (Cmd = '/Q') or (Cmd = '/QUIT') Then Break
    End Else If CmdData <> '' Then
      SendMessage(nodeTelePublic, CmdData, CurRoom);
  End;

  TBBSCore(Owner).User.InNodeChat := False;

  // XXX has left chat
  // set user action?
End;

End.
