{$I M_OPS.PAS}

// make fusion of fs editor and an ansi editor.  change msgtextrec to be a
// recording containing the text attribute and character, and use that in the
// editor and within the message reading.  this would be elite, as the fs
// editor could also be a text editor and an ansi editor...
// make sure everything is buffered.
// make sure anything with 1/2 column lists have separate prompts
// add prompts to msg read 'H' and 'I' commands.
// add prompts to the lightbar [ and ] commands.
// add msg# jumping into menu engine.. R# menu command
// random origin lines
// mbbsutil: pack autosigs
// add new message char into theme editor.. or make new msg PROMPT!!!!
// add "searching" prompts????
// add search text highlighting????
// remove crap vars from ReplyMessage and make it ReaderReplyMessage;
// investigate READ vars to see if we can remove some
// current base prompt for area/group changes...

Unit BBS_MsgBase;

Interface

Uses
  BBS_Common,
  BBS_MsgBase_ABS,
  BBS_MsgBase_JAM,
  BBS_MsgBase_Squish,
  BBS_MsgBase_Ansi;

Type
  MsgInfoRec = Record
    Num     : LongInt;
    MsgFrom : String[30];
    MsgTo   : String[30];
    Subj    : String[60];
    NewMsgs : Boolean;
  End;

  TMsgBase = Class
    Owner          : Pointer;
    MBase          : RecMessageBase;
    MGroup         : RecGroup;
    WereMsgs       : Boolean;
    Reading        : Boolean;
 // MESSAGE READING VARS
    ReadBase       : PMsgBaseAbs;
    ReadData       : TMsgBaseAnsi;
    ReadRes        : Boolean;
    ReadMode       : Byte;
    ReadType       : Byte;
    ReadReplyID    : String[31];
    ReadLastRead   : LongInt;
    ReadModeChar   : Char;
    ReadSearchStr  : String;
    ReadRedraw     : Boolean;
    ReadQuit       : Boolean;
    ReadGotoIndex  : Boolean;
    ReadPageEnd    : Integer;
    ReadPageStart  : Integer;
    ReadPageSize   : Integer;
    ReadIndexSize  : Integer;
    ReadIndexPos   : Integer;
    ReadIndexTotal : Integer;
    ReadIndexPage  : Word;
    ReadIndexInfo  : Array[1..24] of MsgInfoRec;

    Constructor Create (O: Pointer);
    Destructor  Destroy; Override;

    Function    Editor            (Var Buf: RecMessageText; Var Lines: Integer; WrapPos: Byte; MaxLines: Integer; TEdit, Forced : Boolean; Var Subj: String) : Boolean;
    Function    ListAreas         (Compress: Boolean) : LongInt;
    Procedure   ChangeArea        (Data: String);
    Procedure   ChangeGroup       (Data: String; FirstBase, ShowFile: Boolean);
    Function    GetMessageScan    (Var Base: RecMessageBase) : Byte;
    Procedure   SetMessageScan    (Var Base: RecMessageBase; Mode: Byte);
    Procedure   ToggleMessageScan;
    Function    OpenCreateBase    (Var Msg: PMsgBaseAbs; Var Area: RecMessageBase) : Boolean;
    Procedure   AssignMessageData (Var Msg: PMsgBaseAbs);
    Procedure   AppendMessageText (Var Msg: PMsgBaseABS; Var MsgText: RecMessageText; Lines: Integer; ReplyID: String);
    Procedure   PostMessage       (Email: Boolean; Data: String);
    Procedure   ReplyMessage      (Var MsgBase: PMsgBaseAbs; Email: Boolean; ListMode: Byte; ReplyID: String);
    Function    ReadMessages      (Mode: Char; SearchStr: String) : Boolean;
    Procedure   CheckEmail        (NoList: Boolean);
    Procedure   SetMessagePointers;
    Procedure   MessageNewScan    (Data: String);
    Procedure   SaveMessage       (Var mArea: RecMessageBase; mFrom, mTo, mSubj: String; mAddr: RecEchoMailAddr; Var mText: RecMessageText; mLines: Integer);
    Procedure   PostTextFile      (Data: String; AllowCodes: Boolean);
    Procedure   MassEmail;
    Procedure   AutoSignatureEdit;
    Procedure   AutoSignatureView;
 // READ MESSAGE FUNCTIONS
    Procedure   ReaderAssignHeaderInfo;
    Procedure   ReaderEditMessage;
    Function    ReaderMoveMessage (CopyMsg: Boolean) : Boolean;
    Function    ReaderSeekNextMsg (First, Back: Boolean) : Boolean;
    Procedure   ReaderDeleteMessage;
    Procedure   ReaderToggleScan;
    Procedure   ReaderThreadPrevious;
    Procedure   ReaderThreadNext;
    Procedure   ReaderJumpMessage;
    Procedure   ReaderListMessages;
    Function    ReaderMessageNext (DoExit, PageCheck: Boolean) : Boolean;
    Procedure   ReaderMessagePrevious;
    Procedure   ReaderDrawText;
    Procedure   IndexUpdateBar (IsOn: Boolean);
    Procedure   IndexReDraw;
    Procedure   IndexDrawPage;
    Function    IndexReadPage (First, Back: Boolean) : Boolean;
    Procedure   AnsiViewMessage;
    Procedure   ReaderLoadMessage;
  End;

Implementation

Uses
  m_FileIO,
  m_Strings,
  m_DateTime,
  Mystic_Telnet,
  BBS_Core,
  BBS_User,
  BBS_Editor_Line,
  BBS_Editor_Full;

Constructor TMsgBase.Create (O: Pointer);
Begin
  Inherited Create;

  Owner          := O;
  MBase.Name     := 'None';
  MGroup.Desc    := MBase.Name;
  MBase.Sponsor  := bbsConfig.SysopName;
  MBase.SysopACS := 's255';
  WereMsgs       := False;
  ReadData       := TMsgBaseAnsi.Create(O, True);
End;

Destructor TMsgBase.Destroy;
Begin
  ReadData.Free;

  Inherited Destroy;
End;

Procedure TMsgBase.MassEmail;
Const
  MaxNames = 50;
  LogStr : String[15] = 'Mass email to: ';
Var
  User      : RecUser;
  EmailBase : RecMessageBase;
  UserFile  : File;
  Prompt    : String;
  Keys      : String[4];
  AcsStr    : String[mysMaxAcsSize];
  Mode      : Byte;
  NamePos   : Byte;
  Names     : Array[1..MaxNames] of String[30];
  Str       : String;
  Count     : Byte;
  MsgSubj   : String[60];
  MsgText   : RecMessageText;
  MsgAddr   : RecEchoMailAddr;
  MsgLines  : Integer;
  Temp      : LongInt;
Begin
  Assign  (UserFile, bbsConfig.PathData + mysMBasesDat);
  ioReset (UserFile, SizeOf(RecMessageBase), fmReadWrite + fmDenyNone);
  ioRead  (UserFile, EmailBase);
  Close   (UserFile);

  Assign (UserFile, bbsConfig.PathData + 'users.dat');

  Prompt := TBBSCore(Owner).GetPrompt(235);
  Keys   := strWordGet(1, Prompt, ' ');
  Delete (Prompt, 1, 5);

  TBBSCore(Owner).Term.OutFull(Prompt);

  Mode := Pos(TBBSCore(Owner).Term.OneKey(Keys, True), Keys);

  Case Mode of
    1 : Begin
          TBBSCore(Owner).Term.OutFull(TBBSCore(Owner).GetPrompt(236));
          AcsStr := TBBSCore(Owner).Term.GetStr(mysMaxAcsSize, mysMaxAcsSize, -1, '');

          If AcsStr = '' Then Exit;

          TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(237));

          ioReset (UserFile, SizeOf(RecUser), fmReadWrite + fmDenyNone);
          While Not Eof(UserFile) Do Begin
            ioRead (UserFile, User);
            If (User.Flags And UserDeleted = 0) and TBBSCore(Owner).User.AccessUser(User, AcsStr) Then Begin
              TBBSCore(Owner).Term.PromptInfo['A'] := User.Handle;
              TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(238));
            End;
          End;

          Close(UserFile);

          If Not TBBSCore(Owner).Term.GetYN(TBBSCore(Owner).GetPrompt(239), True) Then
            Exit;
        End;
    2 : Begin
          NamePos := 0;

          TBBSCore(Owner).Term.OutFull(TBBSCore(Owner).GetPrompt(240));

          While NamePos < MaxNames Do Begin
            TBBSCore(Owner).Term.PromptInfo['A'] := strI2S(NamePos);
            TBBSCore(Owner).Term.OutFull(TBBSCore(Owner).GetPrompt(241));
            Str := TBBSCore(Owner).Term.GetStr(30, 30, -8, '');
            If Str <> '' Then Begin
              Temp := TBBSCore(Owner).User.IsValidUser(Str, EMailBase.Flags And RecMessageRealName <> 0);

              If Temp <> -1 Then Begin
                Inc (NamePos);
                Names[NamePos] := Str;
              End;
            End Else
            If NamePos = 0 Then
              Exit
            Else
              Break;
          End;

          TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(237));

          For Count := 1 to NamePos Do Begin
            TBBSCore(Owner).Term.PromptInfo['A'] := Names[Count];
            TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(238));
          End;

          If Not TBBSCore(Owner).Term.GetYN(TBBSCore(Owner).GetPrompt(239), True) Then
            Exit;
        End;
    3 : Begin
          Mode   := 1;
          AcsStr := '^';
        End;
    4 : Exit;
  End;

  TBBSCore(Owner).Term.OutFull(TBBSCore(Owner).GetPrompt(242));

  MsgSubj := TBBSCore(Owner).Term.GetStr(60, 60, -1, '');

  If MsgSubj = '' Then Exit;

  TBBSCore(Owner).Term.PromptInfo['A'] := 'Mass Mail';
  TBBSCore(Owner).Term.PromptInfo['B'] := MsgSubj;

  MsgLines := 0;

  If Not Editor (MsgText, MsgLines, 78, mysMaxMsgLines, False, False, MsgSubj) Then Exit;

  TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(243));

  Case Mode of
    1 : Begin
          ioReset (UserFile, SizeOf(RecUser), fmReadWrite + fmDenyNone);
          While Not Eof(UserFile) Do Begin
            ioRead (UserFile, User);
            If (User.Flags And UserDeleted = 0) and TBBSCore(Owner).User.AccessUser(User, AcsStr) Then Begin
              SaveMessage(EmailBase, TBBSCore(Owner).User.ThisUser.Handle, User.Handle, MsgSubj, MsgAddr, MsgText, MsgLines);
              TBBSCore(Owner).SystemLog(LogStr + User.Handle);
            End;
          End;
          Close (UserFile);
        End;
    2 : For Count := 1 to NamePos Do Begin
          SaveMessage(EmailBase, TBBSCore(Owner).User.ThisUser.Handle, Names[Count], MsgSubj, MsgAddr, MsgText, MsgLines);
          TBBSCore(Owner).SystemLog(LogStr + Names[Count]);
        End;
  End;
End;

Procedure TMsgBase.AutoSignatureEdit;
// could make a generic function called AutoSigLoad which loads or appends
// onto a recmessagetext buffer.. it could be used here and in the view and
// in the savemessage stuff etc.
Var
  DF      : File;
  Lines   : Integer;
  Str     : String;
  MsgText : RecMessageText;
Begin
  If bbsConfig.MaxAutoSig = 0 Then Exit;

  Assign (DF, bbsConfig.PathData + 'autosig.dat');

  If TBBSCore(Owner).User.ThisUser.AutoSigSize > 0 Then Begin
    ioReset (DF, 1, fmReadWrite + fmDenyNone);
    If ioSeek(DF, TBBSCore(Owner).User.ThisUser.AutoSigPtr) Then Begin
      For Lines := 1 to TBBSCore(Owner).User.ThisUser.AutoSigSize Do Begin
        BlockRead (DF, MsgText[Lines][0], 1);
        BlockRead (DF, MsgText[Lines][1], Ord(MsgText[Lines][0]));
      End;
    End;
    Close (DF);
  End Else
    Lines := 0;

  Str := '';

  If Editor (MsgText, Lines, 78, bbsConfig.MaxAutoSig, True, False, Str) Then Begin
    If Not ioReset (DF, 1, fmReadWrite + fmDenyAll) Then
      ioReWrite (DF, 1, fmReadWrite + fmDenyAll);

    TBBSCore(Owner).User.ThisUser.AutoSigSize := Lines;
    TBBSCore(Owner).User.ThisUser.AutoSigPtr  := FileSize(DF);
    ioSeek (DF, TBBSCore(Owner).User.ThisUser.AutoSigPtr);

    For Lines := 1 to Lines Do
      BlockWrite (DF, MsgText[Lines][0], Length(MsgText[Lines]) + 1);
    Close (DF);
  End;
End;

Procedure TMsgBase.AutoSignatureView;
Var
  DF    : File;
  Count : Byte;
  Str   : String[79];
Begin
  If TBBSCore(Owner).User.ThisUser.AutoSigSize > 0 Then Begin
    Assign  (DF, bbsConfig.PathData + 'autosig.dat');
    ioReset (DF, 1, fmReadWrite + fmDenyNone);

    If ioSeek(DF, TBBSCore(Owner).User.ThisUser.AutoSigPtr) Then Begin
      For Count := 1 to TBBSCore(Owner).User.ThisUser.AutoSigSize Do Begin
        BlockRead (DF, Str[0], 1);
        BlockRead (DF, Str[1], Ord(Str[0]));
        TBBSCore(Owner).Term.OutPipeLn(Str);
      End;
    End;

    Close (DF);
  End Else
    TBBSCore(Owner).Term.OutFull(TBBSCore(Owner).GetPrompt(244));
End;

Function TMsgBase.Editor (Var Buf: RecMessageText; Var Lines: Integer; WrapPos: Byte; MaxLines: Integer; TEdit, Forced: Boolean; Var Subj: String) : Boolean;
Begin
  If (TBBSCore(Owner).Term.Graphics > 0) and (TBBSCore(Owner).User.ThisUser.FSEditor) Then
    Result := AnsiEditor (TBBSCore(Owner).Term, Buf, Lines, WrapPos, MaxLines, TEdit, Forced, Subj)
  Else
    Result := LineEditor (TBBSCore(Owner).Term, Buf, Lines, WrapPos, MaxLines, Forced, Subj);
End;

Function TMsgBase.ListAreas (Compress: Boolean) : LongInt;
Var
  MBaseFile : TBufFile;
  MsgBase   : PMsgBaseAbs;
  TempBase  : RecMessageBase;
  Total     : Word;
  Listed    : Word;
  StrHeader : String;
  StrMiddle : String;
Begin
  Result    := 0;
  MBaseFile := TBufFile.Create(4096);

  If Not MBaseFile.Open (bbsConfig.PathData + mysMBasesDat, fmOpen, fmReadWrite + fmDenyNone, SizeOf(RecMessageBase)) Then Begin
    MBaseFile.Free;
    Exit;
  End;

  TBBSCore(Owner).Term.AllowPause := True;
  TBBSCore(Owner).Term.PausePos   := 1;

  Total  := 0;
  Listed := 0;

  Case bbsConfig.MColumns of
    1 : Begin
          StrHeader := TBBSCore(Owner).GetPrompt(66);
          StrMiddle := TBBSCore(Owner).GetPrompt(67);
        End;
    2 : Begin
          StrHeader := TBBSCore(Owner).GetPrompt(69);
          StrMiddle := TBBSCore(Owner).GetPrompt(70);
        End;
  End;

  While Not MBaseFile.EOF And Not TBBSCore(Owner).ShutDown Do Begin
    MBaseFile.Read (TempBase);

    If TBBSCore(Owner).User.Access(TempBase.ListACS) Then Begin
      Inc (Listed);

      If Listed = 1 Then TBBSCore(Owner).Term.OutFullLn(StrHeader);

      If Compress Then
        Inc (Total)
      Else
        Total := MBaseFile.FilePos;

      TBBSCore(Owner).Term.PromptInfo['A'] := strI2S(Total);
      TBBSCore(Owner).Term.PromptInfo['B'] := TempBase.Name;
      TBBSCore(Owner).Term.PromptInfo['C'] := '0';
      TBBSCore(Owner).Term.PromptInfo['D'] := TempBase.Sponsor;

      If OpenCreateBase (MsgBase, TempBase) Then Begin
        TBBSCore(Owner).Term.PromptInfo['C'] := strI2S(MsgBase^.NumberOfMsgs);
        MsgBase^.CloseMsgBase;
        Dispose (MsgBase, Done);
      End;

      TBBSCore(Owner).Term.OutFull (StrMiddle);
      If (Listed Mod bbsConfig.MColumns = 0) and (Listed > 0) Then
        TBBSCore(Owner).Term.OutFullLn('');
    End;

    If MBaseFile.EOF And (Listed Mod bbsConfig.MColumns <> 0) Then
      TBBSCore(Owner).Term.OutFullLn('');

    If (TBBSCore(Owner).Term.PausePos = TBBSCore(Owner).User.ThisUser.ScreenSize) and (TBBSCore(Owner).Term.AllowPause) Then
      Case TBBSCore(Owner).Term.MorePrompt of
        'N' : Begin
                Total := MBaseFile.FileSize;
                Break;
              End;
        'C' : TBBSCore(Owner).Term.AllowPause := False;
      End;
  End;

  MBaseFile.Free;

  Result := Total;
End;

Procedure TMsgBase.ChangeArea (Data: String);
Var
  Count     : LongInt;
  Total     : LongInt;
  TempBase  : RecMessageBase;
  Str       : String[5];
  MBaseFile : File;
  StrFooter : String;
Begin
  Assign (MBaseFile, bbsConfig.PathData + mysMBasesDat);

  If bbsConfig.MColumns = 1 Then
    StrFooter := TBBSCore(Owner).GetPrompt(68)
  Else
    StrFooter := TBBSCore(Owner).GetPrompt(71);

  If (Data = '+') or (Data = '-') Then Begin
    ioReset (MBaseFile, SizeOf(RecMessageBase), fmReadWrite + fmDenyNone);

    Count := TBBSCore(Owner).User.ThisUser.LastMBase - 1;

    Repeat
      Case Data[1] of
        '+' : Inc(Count);
        '-' : Dec(Count);
      End;

      If Not ioSeek(MBaseFile, Count)    Then Break;
      If Not ioRead(MBaseFile, TempBase) Then Break;

      If TBBSCore(Owner).User.Access(TempBase.ListACS) Then Begin
        TBBSCore(Owner).User.ThisUser.LastMBase := FilePos(MBaseFile);
        MBase := TempBase;
        Close (MBaseFile);
        Exit;
      End;
    Until False;

    Close (MBaseFile);
    Exit;
  End;

  Count := strS2I(Data);

  If Count > 0 Then Begin
    ioReset (MBaseFile, SizeOf(RecMessageBase), fmReadWrite + fmDenyNone);
    If Count <= FileSize(MBaseFile) Then Begin
      ioSeek (MBaseFile, Count - 1);
      ioRead (MBaseFile, TempBase);
      If TBBSCore(Owner).User.Access(TempBase.ListACS) Then Begin
        TBBSCore(Owner).User.ThisUser.LastMBase := FilePos(MBaseFile);
        MBase := TempBase;
      End;
    End;
    Close (MBaseFile);
    Exit;
  End;

  If Pos('NOLIST', strUpper(Data)) > 0 Then Begin
    ioReset (MBaseFile, SizeOf(RecMessageBase), fmReadWrite + fmDenyNone);
    Total := FileSize(MBaseFile);
    Close (MBaseFile);
  End Else
    Total := ListAreas(bbsConfig.MCompress);

  If Total = 0 Then
    TBBSCore(Owner).Term.OutFullLn (TBBSCore(Owner).GetPrompt(72))
  Else Begin
    Repeat
      TBBSCore(Owner).Term.OutFull (StrFooter);

      Str := TBBSCore(Owner).Term.GetStr(5, 5, -2, '');

      If Str = '?' Then
        Total := ListAreas(bbsConfig.MCompress)
      Else
        Break;
    Until TBBSCore(Owner).ShutDown;

    Count := strS2I(Str);

    If (Count > 0) and (Count <= Total) Then Begin
      ioReset (MBaseFile, SizeOf(RecMessageBase), fmReadWrite + fmDenyNone);
      If Not bbsConfig.MCompress Then Begin
        ioSeek (MBaseFile, Count - 1);
        ioRead (MBaseFile, TempBase);
        If Not TBBSCore(Owner).User.Access(TempBase.ListACS) Then Begin
          Close (MBaseFile);
          Exit;
        End;
      End Else Begin
        Total := 0;

        While Not Eof(MBaseFile) And (Count <> Total) Do Begin
          ioRead (MBaseFile, TempBase);
          If TBBSCore(Owner).User.Access(TempBase.ListACS) Then Inc(Total);
        End;

        If Count <> Total Then Begin
          Close (MBaseFile);
          Exit;
        End;
      End;

      TBBSCore(Owner).User.ThisUser.LastMBase := FilePos(MBaseFile);
      MBase := TempBase;

      Close (MBaseFile);
    End;
  End;
End;

Procedure TMsgBase.ChangeGroup (Data: String; FirstBase, ShowFile: Boolean);
// todo: add NOLIST option
Var
  GroupFile : File;
  MBaseFile : File;
  TempGroup : RecGroup;
  TempMBase : RecMessageBase;
  Listed    : LongInt;
  Saved     : LongInt;
  MsgAreas  : LongInt;
  Count     : LongInt;
Begin
  Assign (GroupFile, bbsConfig.PathData + 'groups_m.dat');

  If (Data = '+') or (Data = '-') Then Begin
    If Not ioReset (GroupFile, SizeOf(RecGroup), fmReadWrite + fmDenyNone) Then Exit;

    Count := TBBSCore(Owner).User.ThisUser.LastMGroup - 1;

    Repeat
      Case Data[1] of
        '+' : Inc(Count);
        '-' : Dec(Count);
      End;

      If Not ioSeek(GroupFile, Count)     Then Break;
      If Not ioRead(GroupFile, TempGroup) Then Break;

      If TBBSCore(Owner).User.Access(TempGroup.Access) Then Begin
        TBBSCore(Owner).User.ThisUser.LastMGroup := FilePos(GroupFile);
        MGroup := TempGroup;
        Close (GroupFile);

        If ShowFile Then
          TBBSCore(Owner).Term.OutFile ('mgroup' + strI2S(TBBSCore(Owner).User.ThisUser.LastMGroup));

        If FirstBase Then Begin
          TBBSCore(Owner).User.ThisUser.LastMBase := 0;
          ChangeArea('+');
        End;

        Exit;
      End;
    Until False;

    Close (GroupFile);
    Exit;
  End;

  If Not ioReset (GroupFile, SizeOf(RecGroup), fmReadWrite + fmDenyNone) Then Exit;

  Count := strS2I(Data);

  If Count > 0 Then Begin
    If Count > FileSize(GroupFile) Then Begin
      Close (GroupFile);
      Exit;
    End;

    ioSeek (GroupFile, Count - 1);
    ioRead (GroupFile, TempGroup);

    If TBBSCore(Owner).User.Access(TempGroup.Access) Then Begin
      TBBSCore(Owner).User.ThisUser.LastMGroup := FilePos(GroupFile);
      MGroup := TempGroup;
      If ShowFile Then
        TBBSCore(Owner).Term.OutFile('mgroup' + strI2S(Count));
    End;

    Close (GroupFile);

    If FirstBase Then Begin
      TBBSCore(Owner).User.ThisUser.LastMBase := 1;
      ChangeArea('+');
    End;

    Exit;
  End;

  TBBSCore(Owner).Term.PausePos   := 1;
  TBBSCore(Owner).Term.AllowPause := True;

  Saved  := TBBSCore(Owner).User.ThisUser.LastMGroup;
  Listed := 0;

  While Not Eof(GroupFile) And Not TBBSCore(Owner).ShutDown Do Begin
    ioRead (GroupFile, TempGroup);

    If TempGroup.Hidden Then Continue;

    If TBBSCore(Owner).User.Access(TempGroup.Access) Then Begin
      MsgAreas := 0;
      TBBSCore(Owner).User.ThisUser.LastMGroup := FilePos(GroupFile);

      If bbsConfig.MGroups Then Begin
        Assign  (MBaseFile, bbsConfig.PathData + mysMBasesDat);
        ioReset (MBaseFile, SizeOf(RecMessageBase), fmReadWrite + fmDenyNone);
        ioRead  (MBaseFile, TempMBase);
        While Not Eof(MBaseFile) Do Begin
          ioRead (MBaseFile, TempMBase);
          If TBBSCore(Owner).User.Access(TempMBase.ListACS) Then Inc(MsgAreas);
        End;
        Close (MBaseFile);
      End;

      Inc (Listed);

      If Listed = 1 Then
        TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(73));

      TBBSCore(Owner).Term.PromptInfo['A'] := strI2S(Listed);
      TBBSCore(Owner).Term.PromptInfo['B'] := TempGroup.Desc;
      TBBSCore(Owner).Term.PromptInfo['C'] := strI2S(MsgAreas);
      TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(74));

      If (TBBSCore(Owner).Term.PausePos = TBBSCore(Owner).User.ThisUser.ScreenSize) and (TBBSCore(Owner).Term.AllowPause) Then
        Case TBBSCore(Owner).Term.MorePrompt of
          'N' : Break;
          'C' : TBBSCore(Owner).Term.AllowPause := False;
        End;
    End;
  End;

  If TBBSCore(Owner).ShutDown Then Exit;

  TBBSCore(Owner).User.ThisUser.LastMGroup := Saved;

  If Listed = 0 Then
    TBBSCore(Owner).Term.OutFullLn (TBBSCore(Owner).GetPrompt(76))
  Else Begin
    TBBSCore(Owner).Term.OutFull(TBBSCore(Owner).GetPrompt(75));

    Count := strS2I(TBBSCore(Owner).Term.GetStr(5, 5, -1, ''));

    If (Count > 0) and (Count <= Listed) Then Begin
      Listed := 0;

      ioReset (GroupFile, SizeOf(RecGroup), fmReadWrite + fmDenyNone);
      Repeat
        ioRead(GroupFile, TempGroup);
        If TempGroup.Hidden Then Continue;
        If TBBSCore(Owner).User.Access(TempGroup.Access) Then Inc(Listed);
        If Count = Listed Then Break;
      Until False;

      TBBSCore(Owner).User.ThisUser.LastMGroup := FilePos(GroupFile);
      MGroup := TempGroup;

      If ShowFile Then
        TBBSCore(Owner).Term.OutFile ('mgroup' + strI2S(TBBSCore(Owner).User.ThisUser.LastMGroup));

      TBBSCore(Owner).User.ThisUser.LastMBase := 1;
      ChangeArea('+');
    End;
  End;

  Close (GroupFile);
End;

Procedure TMsgBase.SetMessageScan (Var Base: RecMessageBase; Mode: Byte);
Var
  Count     : LongInt;
  MScanFile : File;
Begin
  Assign  (MScanFile, Base.Path + Base.FileName + '.scn');
  ioReset (MScanFile, 1, fmReadWrite + fmDenyAll);

  If IoCode <> 0 Then
    ioReWrite (MScanFile, 1, fmReadWrite + fmDenyAll);

  If FileSize(MScanFile) < TBBSCore(Owner).User.ThisUserPos - 1 Then Begin
    ioSeek (MScanFile, FileSize(MScanFile));
    For Count := FileSize(MScanFile) to TBBSCore(Owner).User.ThisUserPos - 1 Do
      ioWrite (MScanFile, Mode);
  End;

  ioSeek  (MScanFile, TBBSCore(Owner).User.ThisUserPos - 1);
  ioWrite (MScanFile, Mode);
  Close   (MScanFile);
End;

Function TMsgBase.GetMessageScan (Var Base: RecMessageBase) : Byte;
Var
  MScanFile : File;
Begin
  Result := Byte((Base.NewScan) or (Base.Flags And RecMessageForced <> 0));

  Assign  (MScanFile, Base.Path + Base.FileName + '.scn');
  ioReset (MScanFile, 1, fmReadWrite + fmDenyNone);

  If IoCode <> 0 Then Exit;

  If FileSize(MScanFile) >= TBBSCore(Owner).User.ThisUserPos Then Begin
    ioSeek (MScanFile, TBBSCore(Owner).User.ThisUserPos - 1);
    ioRead (MScanFile, Result);
  End;

  Close (MScanFile);
End;

Procedure TMsgBase.ToggleMessageScan;
Var
  Total     : LongInt;
  TempBase  : RecMessageBase;
  MBaseFile : File;

  Procedure List_Bases;
  Var
    YesStr : String;
    NoStr  : String;
    Prompt : String;
  Begin
    Prompt := TBBSCore(Owner).GetPrompt(109);
    NoStr  := strWordGet(1, Prompt, ' ');
    YesStr := strWordGet(2, Prompt, ' ');
    Prompt := Copy(Prompt, strWordPos(3, Prompt, ' '), Length(Prompt));
    Total  := 0;

    TBBSCore(Owner).Term.NoBufFlush := True;
    TBBSCore(Owner).Term.PausePos   := 1;
    TBBSCore(Owner).Term.AllowPause := True;
    TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(108));

    ioReset (MBaseFile, SizeOf(RecMessageBase), fmReadWrite + fmDenyNone);
    While Not Eof(MBaseFile) Do Begin
      ioRead (MBaseFile, TempBase);
      If TBBSCore(Owner).User.Access(TempBase.ListACS) Then Begin
        Inc (Total);

        TBBSCore(Owner).Term.PromptInfo['A'] := strI2S(Total);
        TBBSCore(Owner).Term.PromptInfo['B'] := TempBase.Name;

        If GetMessageScan(TempBase) > 0 Then
          TBBSCore(Owner).Term.PromptInfo['C'] := YesStr
        Else
          TBBSCore(Owner).Term.PromptInfo['C'] := NoStr;

        TBBSCore(Owner).Term.OutFull(Prompt);

        If (Total MOD 2 = 0) And (Total > 0) Then TBBSCore(Owner).Term.OutFullLn('');
      End;

      If EOF(MBaseFile) and (Total MOD 2 <> 0) Then TBBSCore(Owner).Term.OutFullLn('');

      If (TBBSCore(Owner).Term.PausePos = TBBSCore(Owner).User.ThisUser.ScreenSize) and (TBBSCore(Owner).Term.AllowPause) Then
        Case TBBSCore(Owner).Term.MorePrompt of
          'N' : Break;
          'C' : TBBSCore(Owner).Term.AllowPause := False;
        End;
    End;

    Close (MBaseFile);

    TBBSCore(Owner).Term.OutFull(TBBSCore(Owner).GetPrompt(110));
    TBBSCore(Owner).Term.NoBufFlush := False;
    TBBSCore(Owner).Term.BufFlush;
  End;

  Procedure ToggleBase (A : Word);
  Var
    B : Word;
  Begin
    B := 0;
    ioReset (MBaseFile, SizeOf(RecMessageBase), fmReadWrite + fmDenyNone);
    Repeat
      ioRead (MBaseFile, TempBase);
      If TBBSCore(Owner).User.Access(TempBase.ListACS) Then Inc(B);
      If A = B Then Break;
    Until False;
    Close (MBaseFile);

    TBBSCore(Owner).Term.PromptInfo['A'] := TempBase.Name;

    If TempBase.Flags AND RecMessageForced <> 0 Then Begin
      TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(114));
      SetMessageScan(TempBase, 1);
      Exit;
    End;

    Case GetMessageScan(TempBase) of
      0 : Begin
            SetMessageScan(TempBase, 1);
            TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(113));
          End;
      1 : Begin
            SetMessageScan(TempBase, 0);
            TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(112));
          End;
    End;
  End;

Var
  Temp  : String[11];
  Count : Word;
  Num1  : Word;
  Num2  : Word;
  First : Boolean;
Begin
  Assign (MBaseFile, bbsConfig.PathData + mysMBasesDat);

  List_Bases;

  If Total = 0 Then Begin
    TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(115));
    Exit;
  End;

  Repeat
    TBBSCore(Owner).Term.OutFull(TBBSCore(Owner).GetPrompt(111));
    Temp := TBBSCore(Owner).Term.GetStr(11, 11, -2, '');
    If (Temp = 'Q') or (Temp = '') Then Break;
    If Temp = '?' Then
      List_Bases
    Else Begin
      If Pos('-', Temp) > 0 Then Begin
        Num1 := strS2I(Copy(Temp, 1, Pos('-', Temp) - 1));
        Num2 := strS2I(Copy(Temp, Pos('-', Temp) + 1, Length(Temp)));
      End Else Begin
        Num1 := strS2I(Temp);
        Num2 := Num1;
      End;

      First := True;

      For Count := Num1 to Num2 Do
        If (Count > 0) and (Count <= Total) Then Begin
          If First Then Begin
            TBBSCore(Owner).Term.OutRawLn('');
            First := False;
          End;
          ToggleBase(Count);
        End;
    End;
  Until TBBSCore(Owner).ShutDown;
End;

Function TMsgBase.OpenCreateBase (Var Msg: PMsgBaseAbs; Var Area: RecMessageBase) : Boolean;
Begin
  OpenCreateBase := False;

  Case Area.BaseType of
    0 : Msg := New(PMsgBaseJam,    Init);
    1 : Msg := New(PMsgBaseSquish, Init);
  End;

  Msg^.SetMsgPath (Area.Path + Area.FileName);
  Msg^.SetTempFile (TBBSCore(Owner).TempPath + 'msgbuf.');

  If Not Msg^.OpenMsgBase Then
    If Not Msg^.CreateMsgBase (Area.MaxMsgs, Area.MaxAge) Then Begin
      Dispose (Msg, Done);
      Exit;
    End Else
    If Not Msg^.OpenMsgBase Then Begin
      Dispose (Msg, Done);
      Exit;
    End;

  OpenCreateBase := True;
End;

Procedure TMsgBase.AssignMessageData (Var Msg: PMsgBaseAbs);
// add user and msg base?
Var
  SemFile : File;
Begin
  Msg^.StartNewMsg;

  If MBase.Flags AND RecMessageRealName <> 0 Then
    Msg^.SetFrom(TBBSCore(Owner).User.ThisUser.RealName)
  Else
    Msg^.SetFrom(TBBSCore(Owner).User.ThisUser.Handle);

  Msg^.SetLocal (True);

  If MBase.NetType > 0 Then Begin
    If MBase.NetType = 2 Then Begin
      Msg^.SetMailType (mmtNetMail);
      Msg^.SetCrash    (bbsConfig.nmCrash);
      Msg^.SetHold     (bbsConfig.nmHold);
      Msg^.SetKillSent (bbsConfig.nmKill);
    End Else
      Msg^.SetMailType(mmtEchoMail);

    // Do AKA matching here if NetMail

    Msg^.SetOrig(bbsConfig.NetAddress[MBase.NetAddr]);

    FileMode := 66;

    Case MBase.NetType of
      1 : Assign (SemFile, bbsConfig.PathData + 'echomail.now');
      2 : Assign (SemFile, bbsConfig.PathData + 'netmail.now');
      3 : Assign (SemFile, bbsConfig.PathData + 'newsmail.now');
    End;

    ReWrite (SemFile);
    Close   (SemFile);
  End Else
    Msg^.SetMailType(mmtNormal);

  Msg^.SetPriv(MBase.PostType = 1);
  Msg^.SetDate(DateDos2Str(CurDateDos, 1));
  Msg^.SetTime(TimeDos2Str(CurDateDos, False));
End;

Procedure TMsgBase.AppendMessageText (Var Msg: PMsgBaseABS; Var MsgText: RecMessageText; Lines: Integer; ReplyID: String);
// add userrec
Var
  DF    : File;
  Str   : String;
  Count : Integer;
Begin
  If MBase.NetType > 0 Then Begin
    Msg^.DoStringLn (#1 + 'MSGID: ' + strAddr2Str(bbsConfig.NetAddress[MBase.NetAddr]) + ' ' + strI2H(CurDateDos));

    If ReplyID <> '' Then
      Msg^.DoStringLn (#1 + 'REPLY: ' + ReplyID);
  End;

  For Count := 1 to Lines Do Msg^.DoStringLn(MsgText[Count]);

  If TBBSCore(Owner).User.ThisUser.AutoSig And
     (TBBSCore(Owner).User.ThisUser.AutoSigSize > 0) And
     (MBase.Flags And RecMessageAutoSig <> 0) Then Begin
    Assign  (DF, bbsConfig.PathData + 'autosig.dat');
    ioReset (DF, 1, fmReadWrite + fmDenyNone);
    ioSeek  (DF, TBBSCore(Owner).User.ThisUser.AutoSigPtr);
    Msg^.DoStringLn('');
    For Count := 1 to TBBSCore(Owner).User.ThisUser.AutoSigSize Do Begin
      BlockRead (DF, Str[0], 1);
      BlockRead (DF, Str[1], Ord(Str[0]));
      Msg^.DoStringLn(Str);
    End;
    Close (DF);
  End;

  If MBase.NetType > 0 Then Begin
    Msg^.DoStringLn (#13 + '--- Mystic BBS v' + mysVersionText + ' (' + mysOSID + ')');
    Msg^.DoStringLn (' * Origin: ' + MBase.Origin + ' (' + strAddr2Str(bbsConfig.NetAddress[MBase.NetAddr]) + ')');
  End;
End;

Procedure TMsgBase.PostMessage (Email: Boolean; Data: String);
Var
  MBaseFile : File;
  TempMBase : RecMessageBase;
  TempUser  : RecUser;
  DestAddr  : RecEchoMailAddr;
  MsgText   : RecMessageText;
  MsgBase   : PMsgBaseAbs;
  MsgTo     : String[30];
  MsgSubj   : String[60];
  MsgAddr   : String[20];
  TempStr   : String;
  Count     : LongInt;
  Lines     : Integer;
  Forced    : Boolean;
Begin
  TempMBase := MBase;

  Assign (MBaseFile, bbsConfig.PathData + mysMBasesDat);

  If Email Then Begin
    ioReset (MBaseFile, SizeOf(RecMessageBase), fmReadWrite + fmDenyNone);
    ioRead  (MBaseFile, MBase);
    Close   (MBaseFile);
  End;

  If MBase.FileName = '' Then Begin
    TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(77));
    MBase := TempMBase;
    Exit;
  End;

  If Not TBBSCore(Owner).User.Access(MBase.PostACS) Then Begin
    TBBSCore(Owner).Term.OutFullLn (TBBSCore(Owner).GetPrompt(78));
    MBase := TempMBase;
    Exit;
  End;

  TBBSCore(Owner).User.SetUserAction(TBBSCore(Owner).GetPrompt(229));

  MsgTo    := '';
  MsgSubj  := '';
  MsgAddr  := '';
  Forced   := False;

 // GET POST DATA PARAMETERS

  For Count := 1 to strWordNum(Data, ' ') Do Begin
    TempStr := strWordGet(Count, Data, ' ');

    If Pos ('/F', strUpper(TempStr)) > 0 Then
      Forced := True
    Else
    If Pos ('/T:', strUpper(TempStr)) > 0 Then
      MsgTo := strReplace(Copy(TempStr, Pos('/T:', strUpper(TempStr)) + 3, Length(TempStr)), '_', ' ')
//      TBBSCore(Owner).term.outfull(msgto + '|PA');
    Else
    If Pos ('/S:', strUpper(TempStr)) > 0 Then
      MsgSubj := strReplace(Copy(TempStr, Pos('/S:', strUpper(TempStr)) + 3, Length(TempStr)), '_', ' ')
    Else
    If Pos('/A:', strUpper(TempStr)) > 0 Then
      MsgAddr := strReplace(Copy(TempStr, Pos('/A:', strUpper(TempStr)) + 3, Length(TempStr)), '_', ' ');
  End;

 // CALCULATE TO: FIELD

  Case MBase.NetType of //0=local 1=echomail, 2=netmail, 3=newsgroup
    0,
    1 : If MBase.PostType = 1 Then Begin
          If MsgTo = '' Then Begin
            TBBSCore(Owner).Term.OutFull(TBBSCore(Owner).GetPrompt(81));
            MsgTo := TBBSCore(Owner).Term.GetStr(30, 30, -8, '');
            If TBBSCore(Owner).User.IsValidUser(MsgTo, MBase.Flags AND RecMessageRealName <> 0) = -1 Then
              MsgTo := '';
          End Else
          If strUpper(MsgTo) = 'SYSOP' Then
            MsgTo := bbsConfig.SysopName;

          If SearchForUser(MsgTo, TempUser, Count) Then Begin
            TBBSCore(Owner).Term.PromptInfo['A'] := MsgTo;
            TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(82));
          End Else
            MsgTo := '';
        End Else Begin
          TBBSCore(Owner).Term.OutFull(TBBSCore(Owner).GetPrompt(83));
          MsgTo := TBBSCore(Owner).Term.GetStr(30, 30, -8, 'All');
        End;
    2 : Begin
          If MsgTo = '' Then Begin
            TBBSCore(Owner).Term.OutFull(TBBSCore(Owner).GetPrompt(79));
            MsgTo := TBBSCore(Owner).Term.GetStr(30, 30, -8, '');
          End;

          If MsgAddr = '' Then Begin
            TBBSCore(Owner).Term.OutFull(TBBSCore(Owner).GetPrompt(80));
            MsgAddr := TBBSCore(Owner).Term.GetStr(20, 20, -2, '');
            If Not strStr2Addr(MsgAddr, DestAddr) Then MsgTo := '';
          End;
        End;
    3 : MsgTo := 'All';
  End;

  If MsgTo = '' Then Begin
    MBase := TempMBase;
    Exit;
  End;

 // GET SUBJECT

  If MsgSubj = '' Then
    Repeat
      TBBSCore(Owner).Term.OutFull(TBBSCore(Owner).GetPrompt(86));
      MsgSubj := TBBSCore(Owner).Term.GetStr(60, 60, -1, '');
      If MsgSubj = '' Then
        If Forced Then
          TBBSCore(Owner).Term.OutFull(TBBSCore(Owner).GetPrompt(87))
        Else Begin
          MBase := TempMBase;
          Exit;
        End;

      If TBBSCore(Owner).ShutDown Then Exit;
    Until MsgSubj <> '';

  TBBSCore(Owner).Term.PromptInfo['A'] := MsgTo;
  TBBSCore(Owner).Term.PromptInfo['B'] := MsgSubj;

  Lines := 0;

  If Editor(MsgText, Lines, 78, mysMaxMsgLines, False, Forced, MsgSubj) Then Begin
    TBBSCore(Owner).Term.OutFull(TBBSCore(Owner).GetPrompt(100));

    If Not OpenCreateBase(MsgBase, MBase) Then Begin
      MBase := TempMBase;
      Exit;
    End;

    AssignMessageData(MsgBase);

    MsgBase^.SetTo   (MsgTo);
    MsgBase^.SetSubj (MsgSubj);

    If MBase.NetType = 2 Then MsgBase^.SetDest (DestAddr);

    AppendMessageText(MsgBase, MsgText, Lines, '');

    If MsgBase^.WriteMsg <> 0 Then;

    MsgBase^.CloseMsgBase;

    If Email Then Begin
      TBBSCore(Owner).SystemLog ('Sent Email to ' + MsgTo);
      Inc (TBBSCore(Owner).User.ThisUser.Emails);
//      Inc (HistoryEmails);
// UPDATE THEM WITH NEW EMAIL NOTIFICATION
    End Else Begin
      TBBSCore(Owner).SystemLog ('Posted #' + strI2S(MsgBase^.GetMsgNum) + ': "' + MsgSubj + '" to ' + MBase.Name);
      Inc (TBBSCore(Owner).User.ThisUser.MsgPosts);
//      Inc (HistoryPosts);
    End;

    Dispose (MsgBase, Done);
    TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(101));

    Count := TBBSCore(Owner).User.IsUserOnline(MsgTo);

    If (Count <> -1) And (Count <> TBBSCore(Owner).Node - 1) Then
      TTelnetServer(TBBSCore(Owner).Owner.Manager.ClientList[Count]).BBS.NodeMsg.AddMsg(TBBSCore(Owner).Node, nodeSystemMsg, TBBSCore(Owner).GetPrompt(267), 0);
  End Else
    TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(102));

  MBase := TempMBase;
End;

Procedure TMsgBase.ReplyMessage (Var MsgBase: PMsgBaseAbs; Email: Boolean; ListMode: Byte; ReplyID: String);
Var
  QFile    : Text;
  MsgNew   : PMsgBaseAbs;
  MsgText  : RecMessageText;
  msgAddr  : RecEchoMailAddr;
  msgTo    : String[30];
  msgSubj  : String[60];
  TempStr  : String[80];
  Lines    : Integer;
  Initials : String[2];
Begin
  If Not TBBSCore(Owner).User.Access(MBase.PostACS) Then Begin
    TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(149));
    Exit;
  End;

  TBBSCore(Owner).User.SetUserAction(TBBSCore(Owner).GetPrompt(229));

  Repeat
    If ListMode = 0 Then
      TBBSCore(Owner).Term.OutFull(TBBSCore(Owner).GetPrompt(150))
    Else
      TBBSCore(Owner).Term.OutFull(TBBSCore(Owner).GetPrompt(151));

    msgTo := TBBSCore(Owner).Term.GetStr(30, 30, -8, MsgBase^.GetFrom);

    If msgTo = '' Then Exit;

    If Not Email Then Break;

    If TBBSCore(Owner).User.IsValidUser(msgTo, False) = -1 Then Begin
      TBBSCore(Owner).Term.PromptInfo['A'] := msgTo;
      TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(152));
      msgTo := MsgBase^.GetFrom;
    End Else
      Break;
  Until False;

  If MBase.NetType = 2 Then Begin
    TBBSCore(Owner).Term.OutFull(TBBSCore(Owner).GetPrompt(153));
    MsgBase^.GetOrig(msgAddr);
    TempStr := TBBSCore(Owner).Term.GetStr(20, 20, -2, strAddr2Str(msgAddr));
    If Not strStr2Addr(TempStr, msgAddr) Then Exit;
  End;

  msgSubj := MsgBase^.GetSubj;
  If Pos ('Re:', msgSubj) = 0 Then msgSubj := 'Re: ' + msgSubj;

  TBBSCore(Owner).Term.OutFull(TBBSCore(Owner).GetPrompt(154));
  msgSubj := TBBSCore(Owner).Term.GetStr(60, 60, -1, msgSubj);

  If msgSubj = '' Then Exit;

  Assign (QFile, TBBSCore(Owner).TempPath + 'msgtmp');
  {$I-} ReWrite (QFile); {$I+}
  If IoResult = 0 Then Begin
    TempStr := TBBSCore(Owner).GetPrompt(158);
    TempStr := strReplace(TempStr, '|&A', MsgBase^.GetDate);
    TempStr := strReplace(TempStr, '|&B', MsgBase^.GetFrom);

    WriteLn (QFile, TempStr);
    WriteLn (QFile, ' ');

    Lines    := 0;
    Initials := strInitials(MsgBase^.GetFrom);

    MsgBase^.MsgTxtStartUp;

    While Not MsgBase^.EOM and (Lines < mysMaxMsgLines - 2) Do Begin
      Inc (Lines);

      TempStr := MsgBase^.GetString(79);

      If TempStr[1] <> #1 Then
        WriteLn (QFile, Initials + '> ' + Copy(TempStr, 1, 74));
    End;

    Close (QFile);
  End;

  Lines := 0;

  TBBSCore(Owner).Term.PromptInfo['A'] := msgTo;
  TBBSCore(Owner).Term.PromptInfo['B'] := msgSubj;

  If Editor(MsgText, Lines, 78, mysMaxMsgLines, False, False, MsgSubj) Then Begin

    TBBSCore(Owner).Term.OutFull(TBBSCore(Owner).GetPrompt(155));

    If Not OpenCreateBase (MsgNew, MBase) Then Exit;

    AssignMessageData(MsgNew);

    Case MBase.NetType of
      2 : Begin
            MsgNew^.SetDest(msgAddr);
            MsgNew^.SetTo(msgTo);
          End;
      3 : MsgNew^.SetTo('All');
    Else
      MsgNew^.SetTo(msgTo);
    End;

    MsgNew^.SetSubj(msgSubj);
    MsgNew^.SetRefer(MsgBase^.GetMsgNum);

    AppendMessageText(MsgNew, MsgText, Lines, ReplyID);

    If MsgNew^.WriteMsg <> 0 Then;

    MsgNew^.CloseMsgBase;

    If MsgBase^.GetSeeAlso = 0 Then Begin
      MsgBase^.MsgStartUp;
      MsgBase^.SetSeeAlso(MsgNew^.GetMsgNum);
      MsgBase^.ReWriteHdr;
    End;

    If Email Then Begin
      TBBSCore(Owner).SystemLog('Sent Email to ' + MsgNew^.GetTo);
      Inc (TBBSCore(Owner).User.ThisUser.Emails);
//      Inc (HistoryEmails);
    End Else Begin
      TBBSCore(Owner).SystemLog('Posted #' + strI2S(MsgNew^.GetMsgNum) + ': "' + msgSubj + '" to ' + MBase.Name);
      Inc (TBBSCore(Owner).User.ThisUser.MsgPosts);
//      Inc (HistoryPosts);
    End;

    Dispose (MsgNew, Done);
    TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(156));
  End Else
    TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(157));

  FileErase(TBBSCore(Owner).TempPath + 'msgtmp');
End;

Procedure TMsgBase.CheckEmail (NoList: Boolean);
Var
  MBaseFile : File;
  TempBase  : RecMessageBase;
  MsgBase   : PMsgBaseABS;
  Total     : Integer;
Begin
  TBBSCore(Owner).Term.OutFull(TBBSCore(Owner).GetPrompt(159));

  TempBase := MBase;

  Assign  (MBaseFile, bbsConfig.PathData + mysMBasesDat);
  ioReset (MBaseFile, SizeOf(RecMessageBase), fmReadWrite + fmDenyNone);
  ioRead  (MBaseFile, MBase);
  Close   (MBaseFile);

  If Not OpenCreateBase(MsgBase, MBase) Then Begin
    TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(143));
    MBase := TempBase;
    Exit;
  End;

  Total := 0;

  MsgBase^.YoursFirst(TBBSCore(Owner).User.ThisUser.RealName, TBBSCore(Owner).User.ThisUser.Handle);
  If MsgBase^.YoursFound Then Begin
    If Not NoList Then
      TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(160));

    Total := 0;
    While MsgBase^.YoursFound Do Begin
      MsgBase^.MsgStartUp;

      Inc (Total);

      TBBSCore(Owner).Term.PromptInfo['A'] := strI2S(Total);
      TBBSCore(Owner).Term.PromptInfo['B'] := MsgBase^.GetFrom;
      TBBSCore(Owner).Term.PromptInfo['C'] := MsgBase^.GetSubj;
      TBBSCore(Owner).Term.PromptInfo['D'] := MsgBase^.GetDate;

      If Not NoList Then
        TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(161));

      MsgBase^.YoursNext;
    End;

    If TBBSCore(Owner).Term.GetYN(TBBSCore(Owner).GetPrompt(162), True) Then Begin
      MsgBase^.CloseMsgBase;
      Dispose (MsgBase, Done);

      ReadMessages('E', '');

      TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(163));

      MBase := TempBase;
      Exit;
    End;
  End Else
    TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(143));

  MsgBase^.CloseMsgBase;
  Dispose (MsgBase, Done);
  MBase := TempBase;
End;

Procedure TMsgBase.SetMessagePointers;
Var
  NewDate : LongInt;

  Procedure UpdateBase (Var TempBase: RecMessageBase);
  Var
    Found   : Boolean;
    MsgBase : PMsgBaseABS;
  Begin
    Found := False;

    If OpenCreateBase(MsgBase, TempBase) Then Begin
      MsgBase^.SeekFirst(1);

      While MsgBase^.SeekFound Do Begin
        MsgBase^.MsgStartUp;
        If DateStr2Dos(MsgBase^.GetDate) >= NewDate Then Begin
          MsgBase^.SetLastRead(TBBSCore(Owner).User.ThisUserPos, MsgBase^.GetMsgNum - 1);
          Found := True;
          Break;
        End;
        MsgBase^.SeekNext;
      End;

      If Not Found Then
        MsgBase^.SetLastRead(TBBSCore(Owner).User.ThisUserPos, MsgBase^.GetHighMsgNum);

      Dispose (MsgBase, Done);
    End;
  End;

Var
  Global    : Boolean;
  Str       : String[8];
  MBaseFile : File;
  TempBase  : RecMessageBase;
Begin
  TBBSCore(Owner).Term.OutFull(TBBSCore(Owner).GetPrompt(164));

  Str := TBBSCore(Owner).Term.GetStr(8, 8, -5, '');

  If Not DateValid(Str) Then Begin
    TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(165));
    Exit;
  End;

  NewDate := DateStr2Dos(Str);
  Global  := TBBSCore(Owner).Term.GetYN(TBBSCore(Owner).GetPrompt(166), False);

  TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(167));

  If Global Then Begin
    Assign  (MBaseFile, bbsConfig.PathData + mysMBasesDat);
    ioReset (MBaseFile, SizeOf(RecMessageBase), fmReadWrite + fmDenyNone);
    ioRead  (MBaseFile, TempBase);

    While Not Eof(MBaseFile) Do Begin
      ioRead (MBaseFile, TempBase);
      UpdateBase(TempBase);
    End;

    Close (MBaseFile);
  End Else
    UpdateBase(MBase);
End;

Procedure TMsgBase.MessageNewScan (Data: String);
{    /P : scan for personal mail in all bases }
{    /M : scan only mandatory bases           }
{    /G : scan all bases in all groups        }
Var
  MBaseFile : File;
  TempBase  : RecMessageBase;
  Forced    : Boolean;
  Found     : Boolean;
  Mode      : Char;
Begin
  TempBase := MBase;
  Forced   := False;

  Assign  (MBaseFile, bbsConfig.PathData + mysMBasesDat);
  ioReset (MBaseFile, SizeOf(RecMessageBase), fmReadWrite + fmDenyNone);

  If Pos ('/P', Data) > 0 Then Begin
    Mode := 'P';
    TBBSCore(Owner).SystemLog('Scan for personal messages');
  End Else Begin
    Forced := Pos('/M', Data) > 0;
    Mode   := 'G';

    ioRead (MBaseFile, MBase); { skip e-mail base if not personal scan }
    TBBSCore(Owner).SystemLog('Scan for new messages');
  End;

  TBBSCore(Owner).User.IgnoreGroup := Pos('/G', Data) > 0;
  WereMsgs := False;
  Found    := False;

  TBBSCore(Owner).Term.OutRawLn ('');
  While Not Eof(MBaseFile) Do Begin
    ioRead (MBaseFile, MBase);

    If TBBSCore(Owner).User.Access(MBase.ReadACS) Then Begin
      If (MBase.Flags AND RecMessageForced <> 0) or (Not Forced And (GetMessageScan(MBase) > 0)) Then Begin
        Found := True;

        TBBSCore(Owner).Term.OutBS (TBBSCore(Owner).Term.Console.CursorX, True);
        TBBSCore(Owner).Term.OutFull(TBBSCore(Owner).GetPrompt(119));

        If Not ReadMessages(Mode, '') Then Begin
          TBBSCore(Owner).Term.OutRawLn('');
          Break;
        End;

        If WereMsgs Then TBBSCore(Owner).Term.OutRawLn('');
      End;
    End;
  End;

  If Not WereMsgs And Found Then TBBSCore(Owner).Term.OutFullLn('|CR');

  TBBSCore(Owner).Term.OutFull(TBBSCore(Owner).GetPrompt(168));
  Close (MBaseFile);

  TBBSCore(Owner).User.IgnoreGroup := False;
  MBase := TempBase;
End;

// make new savemessage procedure:
// mbaserec, userrec, to, subj, addr, mtext, mlines
// make EVERYTHING use opencreatebase and savemessage function... remove
// assignmsgdata and assignautosig etc stuff

Procedure TMsgBase.SaveMessage (Var mArea: RecMessageBase; mFrom, mTo, mSubj: String; mAddr: RecEchoMailAddr; Var mText: RecMessageText; mLines: Integer);
Var
  MsgBase   : PMsgBaseAbs;
  SemFile   : File;
  Count     : Integer;
Begin
// things to do:
// 1) add origin line if echomail base
// 2) see if we can use assignmessagedata, etc
// 3) add autosig?  if we cannot use the assignmsgdata things

  If Not OpenCreateBase(MsgBase, mArea) Then Exit;

  MsgBase^.StartNewMsg;
  MsgBase^.SetLocal (True);

  If mArea.NetType > 0 Then Begin
    If mArea.NetType = 2 Then Begin
      MsgBase^.SetMailType (mmtNetMail);
      MsgBase^.SetCrash    (bbsConfig.nmCrash);
      MsgBase^.SetHold     (bbsConfig.nmHold);
      MsgBase^.SetKillSent (bbsConfig.nmKill);
      MsgBase^.SetDest     (mAddr);
    End Else
      MsgBase^.SetMailType (mmtEchoMail);

    MsgBase^.SetOrig (bbsConfig.NetAddress[mArea.NetAddr]);

    Case mArea.NetType of
      1 : Assign (SemFile, bbsConfig.PathData + 'echomail.now');
      2 : Assign (SemFile, bbsConfig.PathData + 'netmail.now');
      3 : Assign (SemFile, bbsConfig.PathData + 'newsmail.now');
    End;

    ReWrite (SemFile);
    Close   (SemFile);
  End Else
    MsgBase^.SetMailType (mmtNormal);

  MsgBase^.SetPriv (mArea.PostType = 1);
  MsgBase^.SetDate (DateDos2Str(CurDateDos, 1));
  MsgBase^.SetTime (TimeDos2Str(CurDateDos, False));
  MsgBase^.SetFrom (mFrom);
  MsgBase^.SetTo   (mTo);
  MsgBase^.SetSubj (mSubj);

  For Count := 1 to mLines Do
    MsgBase^.DoStringLn(mText[Count]);

  MsgBase^.WriteMsg;
  MsgBase^.CloseMsgBase;

  Dispose (MsgBase, Done);
End;

Procedure TMsgBase.PostTextFile (Data: String; AllowCodes: Boolean);
Const
  MaxLines = 10000;
Var
  MBaseFile : File;
  mName     : String;
  mArea     : Word;
  mFrom     : String;
  mTo       : String;
  mSubj     : String;
  mAddr     : RecEchoMailAddr;
  mLines    : Integer;
  InFile    : Text;
  TextBuf   : Array[1..4096] of Char;
  Buffer    : Array[1..MaxLines] of ^String;
  Str       : String[79];
  Lines     : Integer;
  Pages     : Integer;
  Count     : Integer;
  Offset    : Integer;
  TempBase  : RecMessageBase;
  MsgText   : RecMessageText;
Begin
  mName := strWordGet(1, Data, ';');
  mArea := strS2I(strWordGet(2, Data, ';'));
  mFrom := strWordGet(3, Data, ';');
  mTo   := strWordGet(4, Data, ';');
  mSubj := strWordGet(5, Data, ';');

  strStr2Addr (strWordGet(6, Data, ';'), mAddr);

  If FileExist(bbsConfig.PathData + mName) Then
    mName := bbsConfig.PathData + mName
  Else
  If Not FileExist(mName) Then Begin
    TBBSCore(Owner).SystemLog('TextPost: ' + mName + ' not found');
    Exit;
  End;

  Assign  (MBaseFile, bbsConfig.PathData + mysMBasesDat);
  ioReset (MBaseFile, SizeOf(RecMessageBase), fmReadWrite + fmDenyNone);
  ioSeek  (MBaseFile, mArea - 1);

  If Not ioRead (MBaseFile, TempBase) Then Begin
    Close (MBaseFile);
    Exit;
  End;

  Close (MBaseFile);

  Assign     (InFile, mName);
  SetTextBuf (InFile, TextBuf, 4096);
  Reset      (InFile);

  Lines := 0;

  While Not Eof(InFile) And (Lines < MaxLines) Do Begin
    ReadLn (InFile, Str);

    If AllowCodes Then Str := TBBSCore(Owner).Term.StrMci(Str);

    Inc (Lines);
    New (Buffer[Lines]);

    Buffer[Lines]^ := Str;
  End;

  Close (InFile);

  Pages := Lines DIV mysMaxMsgLines + 1;

  For Count := 1 to Pages Do Begin
    Offset := (mysMaxMsgLines * Pred(Count));
    mLines := 0;

    While (Offset < Lines) and (mLines < mysMaxMsgLines) Do Begin
      Inc (mLines);
      Inc (Offset);

      MsgText[mLines] := Buffer[Offset]^;
    End;

    If Pages > 1 Then
      Str := mSubj + ' (' + strI2S(Count) + '/' + strI2S(Pages) + ')'
    Else
      Str := mSubj;

    SaveMessage (TempBase, mFrom, mTo, Str, mAddr, MsgText, mLines);
  End;

  While Lines > 0 Do Begin
    Dispose (Buffer[Lines]);
    Dec     (Lines);
  End;
End;

// ==========================================================================
// ==========================================================================
// ==========================================================================
// ==========================================================================
// ==========================================================================
// ==========================================================================
// ==========================================================================
// ==========================================================================
// ==========================================================================
// ==========================================================================
// ==========================================================================
// ==========================================================================
// ==========================================================================
// ==========================================================================
// ==========================================================================
// ==========================================================================
// ==========================================================================
// ==========================================================================
// ==========================================================================
// MESSAGE READER FUNCTIONS
// ==========================================================================

Procedure TMsgBase.ReaderAssignHeaderInfo;
Var
  NetAddr : RecEchoMailAddr;
  Prompt  : String;
Begin
  TBBSCore(Owner).Term.PromptInfo['A'] := ReadBase^.GetFrom;

  If MBase.NetType = 2 Then Begin
    ReadBase^.GetOrig(NetAddr);
    TBBSCore(Owner).Term.PromptInfo['A'] := TBBSCore(Owner).Term.PromptInfo['B'] + ' (' + strAddr2Str(NetAddr) + ')';
  End;

  TBBSCore(Owner).Term.PromptInfo['B'] := ReadBase^.GetTo;

  If MBase.NetType = 2 Then Begin
    ReadBase^.GetDest(NetAddr);
    TBBSCore(Owner).Term.PromptInfo['B'] := TBBSCore(Owner).Term.PromptInfo['B'] + ' (' + strAddr2Str(NetAddr) + ')';
  End;

  TBBSCore(Owner).Term.PromptInfo['C'] := ReadBase^.GetSubj;
  TBBSCore(Owner).Term.PromptInfo['D'] := ReadBase^.GetDate;
  TBBSCore(Owner).Term.PromptInfo['J'] := ReadBase^.GetTime;
  TBBSCore(Owner).Term.PromptInfo['E'] := strI2S(ReadBase^.GetMsgNum);
  TBBSCore(Owner).Term.PromptInfo['F'] := strI2S(ReadBase^.GetHighMsgNum);
  TBBSCore(Owner).Term.PromptInfo['G'] := strI2S(ReadBase^.GetRefer);
  TBBSCore(Owner).Term.PromptInfo['H'] := strI2S(ReadBase^.GetSeeAlso);

  Prompt := TBBSCore(Owner).GetPrompt(201);

  If ReadBase^.IsLocal   Then TBBSCore(Owner).Term.PromptInfo['I'] := strWordGet(1, Prompt, ' ') Else TBBSCore(Owner).Term.PromptInfo['I'] := strWordGet(2, Prompt, ' ');
  If ReadBase^.IsPriv    Then TBBSCore(Owner).Term.PromptInfo['I'] := TBBSCore(Owner).Term.PromptInfo['I'] + ' ' + strWordGet(3, Prompt, ' ');
  If ReadBase^.IsSent    Then TBBSCore(Owner).Term.PromptInfo['I'] := TBBSCore(Owner).Term.PromptInfo['I'] + ' ' + strWordGet(4, Prompt, ' ');
  If ReadBase^.IsDeleted Then TBBSCore(Owner).Term.PromptInfo['I'] := TBBSCore(Owner).Term.PromptInfo['I'] + ' ' + strWordGet(5, Prompt, ' ');
End;

Function TMsgBase.ReaderMoveMessage (CopyMsg: Boolean) : Boolean;
// to do:
// see if we can use the SaveMessage function here...
// same with in PostMessage and ReplyMessage functions...
// maybe we could even combine assign message info with save message??
// use buffered file io?
Var
  MsgNew    : PMsgBaseAbs;
  Str       : String;
  TempBase  : RecMessageBase;  // see if we can remove this...
  Area      : Integer;
  Addr      : RecEchoMailAddr;
  MBaseFile : File;
Begin
  Result := False;
  TBBSCore(Owner).User.IgnoreGroup := True;

  Repeat
    TBBSCore(Owner).Term.OutFull(TBBSCore(Owner).GetPrompt(117));

    Str := TBBSCore(Owner).Term.GetStr(5, 5, -2, '');

    If Str = '?' Then
      ListAreas(False)
    Else Begin
      Assign  (MBaseFile, bbsConfig.PathData + mysMBasesDat);
      ioReset (MBaseFile, SizeOf(RecMessageBase), fmReadWrite + fmDenyNone);

      Area := strS2I(Str);

      If (Area > 0) and (Area <= FileSize(MBaseFile)) Then Begin
        ioSeek (MBaseFile, Area - 1);
        ioRead (MBaseFile, TempBase);
        Close  (MBaseFile);

        If Not TBBSCore(Owner).User.Access(TempBase.PostACS) Then Begin
          TBBSCore(Owner).Term.OutFullLn (TBBSCore(Owner).GetPrompt(198));
          Break;
        End;

        TBBSCore(Owner).Term.PromptInfo['A'] := TempBase.Name;
        TBBSCore(Owner).Term.OutFullLn (TBBSCore(Owner).GetPrompt(118));

        If Not OpenCreateBase(MsgNew, TempBase) Then Break;

        MsgNew^.StartNewMsg;
        MsgNew^.SetFrom (ReadBase^.GetFrom);
        MsgNew^.SetLocal (True);

        Case TempBase.NetType of
          0 : MsgNew^.SetMailType(mmtNormal);
          2 : MsgNew^.SetMailType(mmtNetMail);
        Else
          MsgNew^.SetMailType(mmtEchoMail);
        End;

        ReadBase^.GetOrig (Addr);
        MsgNew^.SetOrig   (Addr);
        MsgNew^.SetPriv   (ReadBase^.IsPriv);
        MsgNew^.SetDate   (ReadBase^.GetDate);
        MsgNew^.SetTime   (ReadBase^.GetTime);
        MsgNew^.SetTo     (ReadBase^.GetTo);
        MsgNew^.SetSubj   (ReadBase^.GetSubj);

        ReadBase^.MsgTxtStartUp;

        While Not ReadBase^.EOM Do Begin
          Str := ReadBase^.GetString(79);
          MsgNew^.DoStringLn(Str);
        End;

        If MsgNew^.WriteMsg <> 0 Then;

        MsgNew^.CloseMsgBase;

        TBBSCore(Owner).SystemLog('Moved msg to ' + TempBase.Name);

        Dispose (MsgNew, Done);

        If Not CopyMsg Then ReadBase^.DeleteMsg;

        Result := True;
        Break;
      End Else Begin
        Close (MBaseFile);
        Break;
      End;
    End;
  Until TBBSCore(Owner).ShutDown;

  TBBSCore(Owner).User.IgnoreGroup := False;
End;

Function TMsgBase.ReaderSeekNextMsg (First, Back: Boolean) : Boolean;
Var
  Str : String;
Begin
  Result := False;

  If (ReadMode = 3) and First Then Begin
    If ReadModeChar = 'S' Then TBBSCore(Owner).Term.OutRawLn('');
    TBBSCore(Owner).Term.OutFull(TBBSCore(Owner).GetPrompt(119));
  End;

  If Not First Then
    If Back Then
      ReadBase^.SeekPrior
    Else
      ReadBase^.SeekNext;

  While Not Result And ReadBase^.SeekFound Do Begin
    ReadBase^.MsgStartUp;

    Case ReadMode of
      0 : Result := True;
      1 : Result := TBBSCore(Owner).User.IsThisUser(ReadBase^.GetTo);
      2 : Result := TBBSCore(Owner).User.IsThisUser(ReadBase^.GetTo) or TBBSCore(Owner).User.IsThisUser(ReadBase^.GetFrom);
      3 : Begin
            Result := (Pos(ReadSearchStr, strUpper(ReadBase^.GetTo)) > 0) or (Pos(ReadSearchStr, strUpper(ReadBase^.GetFrom)) > 0) or
                      (Pos(ReadSearchStr, strUpper(ReadBase^.GetSubj)) > 0);

            If Not Result Then Begin
              ReadBase^.MsgTxtStartUp;

              While Not Result And Not ReadBase^.EOM Do Begin
                Str    := strUpper(ReadBase^.GetString(79));
                Result := Pos(ReadSearchStr, Str) > 0;
              End;
            End;
          End;
      4 : Result := TBBSCore(Owner).User.IsThisUser(ReadBase^.GetFrom);
    End;

    If Not Result Then
      If Back Then
        ReadBase^.SeekPrior
      Else
        ReadBase^.SeekNext;
  End;

  If (ReadMode = 3) And First Then
    TBBSCore(Owner).Term.OutBS (TBBSCore(Owner).Term.Console.CursorX, True);

  If Not WereMsgs Then WereMsgs := Result;
  // could be: weremsgs := weremsgs or result;
End;

Procedure TMsgBase.ReaderEditMessage;
Var
  A        : Integer;
  Lines    : Integer;
  Temp1    : String;
  Temp2    : String;
  DestAddr : RecEchoMailAddr;
  MsgText  : RecMessageText;
  Ch       : Char;
  Subj     : String;

  Procedure ReadText;
  Begin
    ReadBase^.MsgTxtStartUp;
    Lines := 0;
    While Not ReadBase^.EOM and (Lines < mysMaxMsgLines) Do Begin
      Inc (Lines);
      MsgText[Lines] := ReadBase^.GetString(79);
    End;

    If Lines < mysMaxMsgLines Then Begin
      Inc (Lines);
      MsgText[Lines] := '';
    End;
  End;

Begin
  ReadText;

  Repeat
    Subj := ReadBase^.GetSubj;

    TBBSCore(Owner).Term.PromptInfo['A'] := ReadBase^.GetTo;
    TBBSCore(Owner).Term.PromptInfo['B'] := Subj;

    If MBase.NetType = 2 Then Begin
      ReadBase^.GetDest(DestAddr);
      TBBSCore(Owner).Term.PromptInfo['A'] := TBBSCore(Owner).Term.PromptInfo['A'] + ' (' + strAddr2Str(DestAddr) + ')';
    End;

    Temp1 := TBBSCore(Owner).GetPrompt(174);
    Temp2 := strUpper(strWordGet(1, Temp1, ' '));

    Delete (Temp1, 1, 5);

    TBBSCore(Owner).Term.OutFull(Temp1);

    Ch := TBBSCore(Owner).Term.OneKey(Temp2, True);

    If Ch = Temp2[1] Then Begin
      TBBSCore(Owner).Term.OutFull(TBBSCore(Owner).GetPrompt(175));
      If MBase.NetType = 2 Then Begin
        Temp1 := TBBSCore(Owner).Term.GetStr(30, 30, -1, ReadBase^.GetTo);
        TBBSCore(Owner).Term.OutFull(TBBSCore(Owner).GetPrompt(176));
        If strStr2Addr(TBBSCore(Owner).Term.GetStr(20, 20, -2, strAddr2Str(DestAddr)), DestAddr) Then Begin
          ReadBase^.SetTo(Temp1);
          ReadBase^.SetDest(DestAddr)
        End;
      End Else
      If MBase.PostType = 1 Then Begin
        Temp1 := TBBSCore(Owner).Term.GetStr(30, 30, -1, ReadBase^.GetTo);
        If TBBSCore(Owner).User.IsValidUser(Temp1, MBase.Flags AND RecMessageRealName <> 0) <> -1 Then
          ReadBase^.SetTo(Temp1);
      End Else
        ReadBase^.SetTo(TBBSCore(Owner).Term.GetStr(30, 30, -1, ReadBase^.GetTo));
    End Else
    If Ch = Temp2[2] Then Begin
      TBBSCore(Owner).Term.OutFull(TBBSCore(Owner).GetPrompt(177));
      ReadBase^.SetSubj(TBBSCore(Owner).Term.GetStr(50, 50, -1, ReadBase^.GetSubj));
    End Else
    If Ch = Temp2[3] Then Begin
      If Not Editor(MsgText, Lines, 78, mysMaxMsgLines, False, False, Subj) Then ReadText Else ReadBase^.SetSubj(Subj);
    End Else Begin
      If TBBSCore(Owner).Term.GetYN(TBBSCore(Owner).GetPrompt(178), False) Then Begin
        ReadBase^.EditMsgInit;

        For A := 1 to Lines Do
          ReadBase^.DoStringLn(MsgText[A]);

        ReadBase^.EditMsgSave;
      End;
      Break;
    End;
  Until TBBSCore(Owner).ShutDown;

  ReadReDraw := True;
End;

Procedure TMsgBase.ReaderDeleteMessage;
Var
  Temp : LongInt;
  Ok   : Boolean;
Begin
  ReadReDraw := True;
  Temp       := ReadBase^.GetMsgNum;

  Case ReadType of
    0 : Ok := TBBSCore(Owner).Term.GetYN(TBBSCore(Owner).GetPrompt(130), True);
    1 : Ok := TBBSCore(Owner).Term.GetYN(TBBSCore(Owner).GetPrompt(120), True);
  End;

  If Ok Then Begin
    ReadBase^.DeleteMsg;
    ReadQuit := Not ReaderSeekNextMsg(False, False);
  End Else
    ReadBase^.SeekFirst(Temp);
End;

Procedure TMsgBase.ReaderToggleScan;
Begin
  Case ReadType of
    0 : If MBase.Flags AND RecMessageForced <> 0 Then Begin
          TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(135));
          SetMessageScan(MBase, 1);
        End Else
          Case GetMessageScan(MBase) of
            0 : Begin
                  SetMessageScan(MBase, 1);
                  TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(136));
                End;
            1 : Begin
                  SetMessageScan(MBase, 0);
                  TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(137));
                End;
          End;
    1 : Begin
          If MBase.Flags AND RecMessageForced <> 0 Then Begin
            TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(122));
            SetMessageScan(MBase, 1);
          End Else Begin
            Case GetMessageScan(MBase) of
              0 : Begin
                    SetMessageScan(MBase, 1);
                    TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(123));
                  End;
              1 : Begin
                    SetMessageScan(MBase, 0);
                    TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(124));
                  End;
            End;
          End;

          ReadReDraw := True;
        End;
  End;
End;

Procedure TMsgBase.ReaderThreadPrevious;
Begin
  If ReadBase^.GetRefer > 0 Then Begin
    ReadBase^.SeekFirst(ReadBase^.GetRefer);
    ReadBase^.MsgStartUp;
    ReadReDraw := True;
  End Else
    Case ReadType of
      0 : TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(138));
      1 : Begin
            TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(203));
            ReadReDraw := True;
          End;
    End;
End;

Procedure TMsgBase.ReaderThreadNext;
Begin
  If ReadBase^.GetSeeAlso > 0 Then Begin
    ReadBase^.SeekFirst(ReadBase^.GetSeeAlso);
    ReadBase^.MsgStartUp;
    ReadReDraw := True;
  End Else
    Case ReadType of
      0 : TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(139));
      1 :  Begin
             TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(204));
             ReadReDraw := True;
           End;
    End;
End;

Procedure TMsgBase.ReaderJumpMessage;
Var
  A : LongInt;
  B : LongInt;
Begin
  Case ReadType of
    0 : TBBSCore(Owner).Term.OutFull(TBBSCore(Owner).GetPrompt(131));
    1 : TBBSCore(Owner).Term.OutFull(TBBSCore(Owner).GetPrompt(121));
  End;

  B := ReadBase^.GetMsgNum;
  A := strS2I(TBBSCore(Owner).Term.GetStr(9, 9, -2, ''));

  If (A > 0) and (A <= ReadBase^.GetHighMsgNum) Then Begin
    ReadBase^.SeekFirst(A);
    If Not ReaderSeekNextMsg(True, False) Then Begin
      ReadBase^.SeekFirst(B);
      ReaderSeekNextMsg(True, False);
    End;
  End;

  ReadReDraw := True;
End;

Procedure TMsgBase.ReaderListMessages;
Var
  A : LongInt;
Begin
  If ReadType = 1 Then Begin
    ReadQuit      := True;
    ReadGotoIndex := True;
    Exit;
  End;

  TBBSCore(Owner).Term.PausePos   := 1;
  TBBSCore(Owner).Term.AllowPause := True;

  A := ReadBase^.GetMsgNum;

  TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(132));

  While ReaderSeekNextMsg(False, False) Do Begin
    ReaderAssignHeaderInfo;
    TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(133));

    If (TBBSCore(Owner).Term.PausePos = TBBSCore(Owner).User.ThisUser.ScreenSize) and (TBBSCore(Owner).Term.AllowPause) Then
      Case TBBSCore(Owner).Term.MorePrompt of
        'N' : Break;
        'C' : TBBSCore(Owner).Term.AllowPause := False;
      End;
  End;

  TBBSCore(Owner).Term.OutFull(TBBSCore(Owner).GetPrompt(134));

  ReadBase^.SeekFirst(A);
  ReadBase^.MsgStartup;

  ReadReDraw := True;
End;

Function TMsgBase.ReaderMessageNext (DoExit, PageCheck: Boolean) : Boolean;
Var
  Temp : LongInt;
Begin
  Result := False;
  Temp   := ReadBase^.GetMsgNum;

  If PageCheck Then Begin
    If (ReadData.Lines > ReadPageSize) and (ReadPageEnd < ReadData.Lines) Then Begin
      If ReadPageStart + ReadPageSize <= ReadData.Lines - ReadPageSize Then
        Inc (ReadPageStart, ReadPageSize)
      Else
        ReadPageStart := ReadData.Lines - ReadPageSize + 1;

      ReaderDrawText;
      Exit;
    End;
  End;

  If ReaderSeekNextMsg(False, False) Then
    ReadReDraw := True
  Else
  If DoExit Then Begin
    ReadQuit      := True;
    ReadGotoIndex := False; // needed?
    Result        := True;
  End Else Begin
    ReadBase^.SeekFirst(Temp);
    ReaderSeekNextMsg(True, False);
    ReadReDraw := ReadType = 0;
  End;
End;

Procedure TMsgBase.ReaderMessagePrevious;
Var
  Temp : LongInt;
Begin
  Temp := ReadBase^.GetMsgNum;

  If ReaderSeekNextMsg(False, True) Then
    ReadReDraw := True
  Else Begin
    ReadBase^.SeekFirst(Temp);
    ReaderSeekNextMsg(True, False);
    ReadReDraw := ReadType = 0;
  End;
End;

Procedure TMsgBase.ReaderDrawText;
Begin
  ReadData.DrawPage(TBBSCore(Owner).Term.ScreenInfo[1].Y, TBBSCore(Owner).Term.ScreenInfo[2].Y, ReadPageStart);

  ReadPageEnd := ReadPageStart + ReadPageSize - 1;

  If ReadPageEnd > ReadData.Lines Then ReadPageEnd := ReadData.Lines;

  // draw percent and other stuff here
End;

(*
  Procedure Export_Message;
  Var
    FN   : String;
    Temp : String;
    TF   : Text;
  Begin
    If Local Then Begin
      If ListMode = 0 Then
        Send (GetPrompt(363))
      Else
        Send (GetPrompt(415));

      FN := GetInput(70, 70, 11, '');
    End Else Begin
      If ListMode = 0 Then
        Send (GetPrompt(326))
      Else
        Send (GetPrompt(414));

      FN := TempPath + GetInput(70, 70, 11, '');
    End;

    If FN = '' Then Exit;

    PromptInfo[1] := JustFile(FN);

    Assign  (TF, FN);
    {$I-} ReWrite (TF); {$I+}
    If IoResult = 0 Then Begin
      WriteLn (TF, 'From: ' + MsgBase^.GetFrom);
      WriteLn (TF, '  To: ' + MsgBase^.GetTo);
      WriteLn (TF, 'Subj: ' + MsgBase^.GetSubj);
      WriteLn (TF, 'Date: ' + MsgBase^.GetDate + ' ' + MsgBase^.GetTime);
      WriteLn (TF, 'Base: ' + MBase.Name);
      WriteLn (TF, '');
      MsgBase^.MsgTxtStartUp;
      While Not MsgBase^.EOM Do Begin
        Temp := MsgBase^.GetString(79);
        If Temp[1] <> #1 Then WriteLn (TF, Temp);
      End;
      Close (TF);
      SendLn (GetPrompt(327));
      If Not Local Then Begin
        If Send_File(FN) Then;
        If Delete_File(FN) Then;
      End;
    End;
  End;
*)

Procedure TMsgBase.IndexUpdateBar (IsOn: Boolean);
Var
  Str : String;
Begin
  If ReadIndexTotal = 0 Then Exit;

// make function to assign this shit?
// add new message character into language... or make an entirely separate
// prompt for new messages?

  TBBSCore(Owner).Term.PromptInfo['A'] := strI2S(ReadIndexInfo[ReadIndexPos].Num);
  TBBSCore(Owner).Term.PromptInfo['B'] := ReadIndexInfo[ReadIndexPos].Subj;
  TBBSCore(Owner).Term.PromptInfo['C'] := ReadIndexInfo[ReadIndexPos].MsgFrom;
  TBBSCore(Owner).Term.PromptInfo['D'] := ReadIndexInfo[ReadIndexPos].MsgTo;

  If ReadIndexInfo[ReadIndexPos].NewMsgs Then
    TBBSCore(Owner).Term.PromptInfo['E'] := '*' // <- make configurable
  Else
    TBBSCore(Owner).Term.PromptInfo['E'] := ' ';

  Str := TBBSCore(Owner).Term.AnsiGotoXY (1, TBBSCore(Owner).Term.ScreenInfo[1].Y + ReadIndexPos - 1);

  If IsOn Then
    TBBSCore(Owner).Term.OutFull (Str + TBBSCore(Owner).GetPrompt(126))
  Else
    TBBSCore(Owner).Term.OutFull (Str + TBBSCore(Owner).GetPrompt(125));
End;

Procedure TMsgBase.IndexReDraw;
Begin
  TBBSCore(Owner).Term.ShowTemplate ('ansimsglist');
  ReadIndexSize := TBBSCore(Owner).Term.ScreenInfo[2].Y - TBBSCore(Owner).Term.ScreenInfo[1].Y + 1;
End;

Procedure TMsgBase.IndexDrawPage;
Var
  Count : Byte;
  Str   : String;
Begin
  TBBSCore(Owner).Term.NoBufFlush := True;

  Str := TBBSCore(Owner).GetPrompt(125);

  TBBSCore(Owner).Term.BufAddStr(TBBSCore(Owner).Term.AnsiGotoXY(1, TBBSCore(Owner).Term.ScreenInfo[1].Y));

  For Count := 1 to ReadIndexSize Do
    If Count <= ReadIndexTotal Then Begin
      With ReadIndexInfo[Count] Do Begin
        TBBSCore(Owner).Term.PromptInfo['A'] := strI2S(Num);
        TBBSCore(Owner).Term.PromptInfo['B'] := Subj;
        TBBSCore(Owner).Term.PromptInfo['C'] := MsgFrom;
        TBBSCore(Owner).Term.PromptInfo['D'] := MsgTo;

        If NewMsgs Then
          TBBSCore(Owner).Term.PromptInfo['E'] := '*'
        Else
          TBBSCore(Owner).Term.PromptInfo['E'] := ' ';
      End;

      TBBSCore(Owner).Term.OutFullLn(Str + TBBSCore(Owner).Term.AnsiClrEOL);
    End Else
      TBBSCore(Owner).Term.BufAddStr(TBBSCore(Owner).Term.AnsiClrEOL + #13#10);

  TBBSCore(Owner).Term.NoBufFlush := False;
  TBBSCore(Owner).Term.BufFlush;
End;

Function TMsgBase.IndexReadPage (First, Back : Boolean) : Boolean;
Var
  A    : Byte;
  B    : Byte;
  Temp : MsgInfoRec;
Begin
  Result := False;

  If ReaderSeekNextMsg(First, Back) Then Begin

    If First Then Begin
      IndexReDraw;
      ReadIndexPage := 0;
    End;

{ if scanmode=3 then show scanning prompt }

    ReadIndexTotal := 0;

    Repeat
      Inc (ReadIndexTotal);
      ReadIndexInfo[ReadIndexTotal].Num     := ReadBase^.GetMsgNum;
      ReadIndexInfo[ReadIndexTotal].MsgFrom := ReadBase^.GetFrom;
      ReadIndexInfo[ReadIndexTotal].MsgTo   := ReadBase^.GetTo;
      ReadIndexInfo[ReadIndexTotal].Subj    := ReadBase^.GetSubj;
      ReadIndexInfo[ReadIndexTotal].NewMsgs := ReadBase^.GetMsgNum > ReadLastRead;
    Until (ReadIndexTotal = ReadIndexSize) or (Not ReaderSeekNextMsg(False, Back));

    If Back Then Begin { reverse message order }
      Dec (ReadIndexPage);
      B := ReadIndexTotal;
      For A := 1 to ReadIndexTotal DIV 2 Do Begin
        Temp             := ReadIndexInfo[A];
        ReadIndexInfo[A] := ReadIndexInfo[B];
        ReadIndexInfo[B] := Temp;
        Dec (B);
      End;
    End Else
      Inc (ReadIndexPage);

    Result := True;

    IndexDrawPage;
  End;
End;

Procedure TMsgBase.ReaderLoadMessage;
// add pipe code filtering in loader...
Var
  Ch    : Char;
  Str   : String;
  Count : Word;
  Temp  : Byte;
Begin
  ReadData.Clear;

  If ReadBase^.GetMsgNum > ReadLastRead Then
    ReadLastRead := ReadBase^.GetMsgNum;

  ReadBase^.MsgTxtStartUp;

  While Not ReadBase^.EOM Do Begin
    Ch := ReadBase^.GetChar;

    Case Ch of
      #13 : Begin
              ReadData.ProcessBuf(Ch, 1);
              Ch := #10;
              ReadData.ProcessBuf(Ch, 1);
            End;
    Else
      ReadData.ProcessBuf(Ch, 1);
    End;
  End;

  // Message filtering process:
  // 1. Remove @Kludge lines (make it an option for each msgbase)
  // 2. Add Text/Quote/Tear/Origin/Kludge colors
  // 3. Set REPLYID of MSGID for future reply tracking/threading

  Count := 1;

  While Count <= ReadData.Lines Do Begin
    Str  := ReadData.GetLineText(Count);
    Temp := Pos('>', strStripL(Str, ' '));

    If Str[1] = #1 Then Begin
      ReadData.SetLineColor(MBase.ColorKludge, Count);

      If Copy(Str, 2, 5) = 'MSGID' Then
        ReadReplyID := Copy(Str, 9, Length(Str));

      If MBase.Flags AND RecMessageKFilter <> 0 Then Begin
        ReadData.RemoveLine(Count);
        Continue;
      End;
    End Else
    If Copy(Str, 1, 4) = '--- ' Then Begin
      ReadData.SetLineColor(MBase.ColorTear, Count);
    End Else
    If Copy(Str, 1, 3) = ' * ' Then Begin
      ReadData.SetLineColor(MBase.ColorOrigin, Count);
    End Else
    If (Temp > 0) And (Temp < 5) Then Begin
      ReadData.SetLineColor(MBase.ColorQuote, Count);
    End;

    Inc (Count);
  End;

  ReaderAssignHeaderInfo;
End;

Procedure TMsgBase.AnsiViewMessage;
Begin
  ReadGotoIndex := False;
  ReadQuit      := False;

  Repeat
    ReaderLoadMessage;

    TBBSCore(Owner).Term.AllowArrow := True;

    ReadPageStart := 1;

    TBBSCore(Owner).Term.ScreenInfo[4].Y := 0;
    TBBSCore(Owner).Term.ScreenInfo[5].Y := 0;

    TBBSCore(Owner).Term.ShowTemplate (MBase.Template);

    ReadPageSize := TBBSCore(Owner).Term.ScreenInfo[2].Y - TBBSCore(Owner).Term.ScreenInfo[1].Y + 1;

    ReaderDrawText;

    ReadReDraw := False;

    Repeat
      If TBBSCore(Owner).Menu.MenuName <> 'readfull' Then Begin
        TBBSCore(Owner).Menu.MenuName := 'readfull';
        If Not TBBSCore(Owner).Menu.LoadMenu(True) Then Exit;
      End;

      TBBSCore(Owner).Term.PromptInfo['A']  := strI2S(ReadBase^.GetMsgNum);
      TBBSCore(Owner).Term.PromptInfo['B']  := strI2S(ReadBase^.GetHighMsgNum);

      TBBSCore(Owner).Menu.ExecuteMenu(False, True, False);
    Until TBBSCore(Owner).ShutDown or ReadReDraw or ReadQuit;
  Until TBBSCore(Owner).ShutDown or ReadQuit;
End;

Function TMsgBase.ReadMessages (Mode: Char; SearchStr: String) : Boolean;

  Procedure AnsiMessageIndex;
  Begin
    TBBSCore(Owner).Term.AllowArrow := True;

    If IndexReadPage (True, False) Then Begin
      WereMsgs     := True;
      ReadIndexPos := 1;

      TBBSCore(Owner).Msgs.IndexUpdateBar(True);

      Repeat
        If TBBSCore(Owner).Menu.MenuName <> 'readindex' Then Begin
          TBBSCore(Owner).Menu.MenuName := 'readindex';
          TBBSCore(Owner).Menu.LoadMenu(True);
        End;

        TBBSCore(Owner).Menu.ExecuteMenu(False, True, False);
      Until TBBSCore(Owner).ShutDown or ReadQuit;
    End;

    TBBSCore(Owner).Term.AllowArrow := False;

    If WereMsgs Then
      TBBSCore(Owner).Term.OutRawLn(TBBSCore(Owner).Term.AnsiGotoXY (1, TBBSCore(Owner).Term.ScreenInfo[3].Y));
  End;

  Procedure AnsiReadMessages;
  Begin
    If ((Mode = 'E') and TBBSCore(Owner).User.ThisUser.FSMsgEIndex) or ((Mode <> 'E') and TBBSCore(Owner).User.ThisUser.FSMsgIndex) Then
      AnsiMessageIndex
    Else Begin
      If ReaderSeekNextMsg(True, False) Then Begin
        AnsiViewMessage;
        If ReadGotoIndex Then AnsiMessageIndex;
      End;
    End;
  End;

  Procedure AsciiReadMessages;

    Procedure DisplayHeader;
    Begin
      TBBSCore(Owner).Term.PausePos := 1;

      If Not TBBSCore(Owner).Term.OutFile(MBase.Header) Then Begin
        TBBSCore(Owner).Term.NoBufFlush := True;
        TBBSCore(Owner).Term.OutFullLn ('|CL|03From : |14|$R40|&A |03Msg #    : |14|&E |03of |14|&F');
        TBBSCore(Owner).Term.OutFullLn ('|03To   : |10|$R40|&B |03Refer to : |10|&G');
        TBBSCore(Owner).Term.OutFullLn ('|03Subj : |12|$R40|&C |03See Also : |12|&H');
        TBBSCore(Owner).Term.OutFullLn ('|03Date : |11|&D |$R31|&J |03Status   : |13|&I');
        TBBSCore(Owner).Term.OutFullLn ('|03Base : |14|MB|CR');
        TBBSCore(Owner).Term.NoBufFlush := False;
        TBBSCore(Owner).Term.BufFlush;
      End;

      TBBSCore(Owner).Term.OutRaw(TBBSCore(Owner).Term.Attr2Ansi(MBase.ColorText, False));
    End;

  Var
    Str   : String[79];
    Count : LongInt;
  Begin
    ReadQuit := False;

    If ReaderSeekNextMsg(True, False) Then Begin
      TBBSCore(Owner).Menu.MenuName := 'readstd';
      TBBSCore(Owner).Menu.LoadMenu(True);

      WereMsgs := True;

      Repeat
        ReaderLoadMessage;
        DisplayHeader;

        TBBSCore(Owner).Term.AllowPause := True;
        TBBSCore(Owner).Term.NoBufFlush := True;

        Count := 0;

        While (Count < ReadData.Lines) And (Not TBBSCore(Owner).ShutDown) Do Begin
          Inc (Count);

          ReadData.WriteLine(Count, True);

          If (TBBSCore(Owner).Term.PausePos >= TBBSCore(Owner).User.ThisUser.ScreenSize) and (TBBSCore(Owner).Term.AllowPause) Then Begin
            Case TBBSCore(Owner).Term.MorePrompt of
              'N' : Break;
              'C' : TBBSCore(Owner).Term.AllowPause := False;
            End;

            If bbsConfig.DispMsgHdr Then DisplayHeader;
          End;
        End;

        TBBSCore(Owner).Term.BufFlush;
        TBBSCore(Owner).Term.AllowPause := False;
        TBBSCore(Owner).Term.NoBufFlush := False;

        Repeat
          TBBSCore(Owner).Term.PromptInfo['A']  := strI2S(ReadBase^.GetMsgNum);
          TBBSCore(Owner).Term.PromptInfo['B']  := strI2S(ReadBase^.GetHighMsgNum);

          TBBSCore(Owner).Menu.ExecuteMenu(False, True, False);
        Until TBBSCore(Owner).ShutDown or ReadQuit or ReadReDraw;
      Until TBBSCore(Owner).ShutDown or ReadQuit;
    End;
  End;

//F = Forward               S = Search         E = Electronic Mail
//N = New messages          Y = Your messages  G = Global scan
//P = Global personal scan  B = By You         T = Global text search

Var
  MsgNum : LongInt;
  Keys   : String;
  Prompt : String;
  Saved  : String[12];
Begin
  Result        := True;
  ReadRes       := True;
  WereMsgs      := False;
  ReadReplyID   := '';
  ReadModeChar  := Mode;
  ReadSearchStr := SearchStr;

  If MBase.FileName = '' Then Begin
    TBBSCore(Owner).Term.OutFullLn (TBBSCore(Owner).GetPrompt(116));
    Exit;
  End;

  If Not TBBSCore(Owner).User.Access(MBase.ReadACS) Then Begin
    If Not (Mode in ['G', 'P', 'T']) Then TBBSCore(Owner).Term.OutFullLn (TBBSCore(Owner).GetPrompt(140));
    Exit;
  End;

  TBBSCore(Owner).User.SetUserAction(TBBSCore(Owner).GetPrompt(230));

  If Not (Mode in ['B', 'T', 'S', 'E', 'F', 'G', 'N', 'P', 'Y']) Then Begin
    Prompt := TBBSCore(Owner).GetPrompt(141);
    Keys   := strWordGet(1, Prompt, ' ');
    Delete (Prompt, 1, 7);

    TBBSCore(Owner).Term.OutFull(Prompt);
    Mode := TBBSCore(Owner).Term.OneKey(Keys, True);

    If Mode = Keys[1] Then Mode := 'F' Else
    If Mode = Keys[2] Then Mode := 'N' Else
    If Mode = Keys[3] Then Mode := 'B' Else
    If Mode = Keys[4] Then Mode := 'Y' Else
    If Mode = Keys[5] Then Mode := 'S' Else
    Mode := 'Q';
  End;

  Case Mode of
    'Q' : Exit;
    'S' : If SearchStr = '' Then Begin
            TBBSCore(Owner).Term.OutFull(TBBSCore(Owner).GetPrompt(142));
            SearchStr := TBBSCore(Owner).Term.GetStr(50, 50, -2, '');
            If SearchStr = '' Then Exit;
          End;
  End;

  // make opencreate work here?  make it return a byte value instead of
  // boolean.  so opencreate = 1 opened, opencreate = 2 created, 0=error

  Case MBase.BaseType of
    0 : ReadBase := New(PMsgBaseJam, Init);
    1 : ReadBase := New(PMsgBaseSquish, Init);
  End;

  ReadBase^.SetMsgPath  (MBase.Path + MBase.FileName);
  ReadBase^.SetTempFile (TBBSCore(Owner).TempPath + 'msgbuf.');

  If Not ReadBase^.OpenMsgBase Then Begin
    If Mode = 'E' Then
      TBBSCore(Owner).Term.OutFull(TBBSCore(Owner).GetPrompt(143))
    Else
      If Not (Mode in ['G', 'P', 'T']) Then TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(144));
    Dispose (ReadBase, Done);
    Exit;
  End;

  If Mode = 'E' Then
    ReadMode := 1
  Else
  If (MBase.PostType = 1) or (Mode = 'Y') or (Mode = 'P') Then
    ReadMode := 2
  Else
  If (Mode = 'S') or (Mode = 'T') Then
    ReadMode := 3
  Else
  If Mode = 'B' Then
    ReadMode := 4
  Else
    ReadMode := 0;

  ReadLastRead := ReadBase^.GetLastRead(TBBSCore(Owner).User.ThisUserPos);
  MsgNum   := 1;

  If Mode = 'F' Then Begin
    TBBSCore(Owner).Term.PromptInfo['A'] := strI2S(ReadBase^.GetHighMsgNum);
    TBBSCore(Owner).Term.OutFull(TBBSCore(Owner).GetPrompt(145));
    MsgNum := strS2I(TBBSCore(Owner).Term.GetStr(6, 6, -2, ''));
  End;

  If Mode in ['B', 'S', 'T', 'Y', 'E', 'F'] Then
    ReadBase^.SeekFirst(MsgNum)
  Else
    ReadBase^.SeekFirst(ReadLastRead + 1);

  Saved      := TBBSCore(Owner).Menu.MenuName;
  Reading    := True;
  ReadQuit   := False;
  ReadReDraw := False;

  If (TBBSCore(Owner).User.ThisUser.FSMsgReader) and (TBBSCore(Owner).Term.Graphics > 0) Then Begin
    ReadType := 1;
    AnsiReadMessages;
  End Else Begin
    ReadType := 0;
    AsciiReadMessages;
  End;

  TBBSCore(Owner).Menu.MenuName  := Saved;
  TBBSCore(Owner).Menu.SetAction := True;
  TBBSCore(Owner).Menu.LoadMenu(True);

  Reading := False;

  If Not (Mode in ['E', 'S', 'T']) Then ReadBase^.SetLastRead (TBBSCore(Owner).User.ThisUserPos, ReadLastRead);

  ReadBase^.CloseMsgBase;

  Dispose (ReadBase, Done);

  If WereMsgs Then Begin
    If Not (Mode in ['B', 'E', 'P']) And ReadRes And (TBBSCore(Owner).User.Access(MBase.PostACS)) Then
      If ReadType = 0 Then Begin
        TBBSCore(Owner).Term.OutRawLn('');
        If TBBSCore(Owner).Term.GetYN(TBBSCore(Owner).GetPrompt(146), False) Then
          PostMessage (False, '');
      End Else
        If TBBSCore(Owner).Term.GetYN(TBBSCore(Owner).GetPrompt(147), False) Then
          PostMessage (False, '');
  End Else // separate two prompts?  both are #148 below...
    Case Mode of
      'S' : TBBSCore(Owner).Term.OutFullLn(TBBSCore(Owner).GetPrompt(148));
      'B',
      'Y',
      'N' : TBBSCore(Owner).Term.OutFullLn('|CR' + TBBSCore(Owner).GetPrompt(148));
    End;

  Result := ReadRes;
End;

End.
