{$I M_OPS.PAS}

// todo: buffer the line editor's output...

Unit BBS_Editor_Line;

Interface

Uses
  BBS_Common,
  BBS_Core,
  BBS_IO;

Function LineEditor (Var Term    : TBBSIO;
                     Var MsgText : RecMessageText;
                     Var Lines   : Integer;
                     WrapPos     : Byte;
                     MaxLines    : Integer;
                     Forced      : Boolean;
                     Var Subj    : String) : Boolean;

Implementation

Uses
  m_Strings;

Function LineEditor (Var Term: TBBSIO; Var MsgText: RecMessageText; Var Lines: Integer; WrapPos: Byte; MaxLines: Integer; Forced: Boolean; Var Subj: String) : Boolean;
Var
  CurLine : LongInt;
  Done    : Boolean;
  Save    : Boolean;

  Procedure Quote;
  Var
    QFile     : Text;
    QStart    : LongInt;
    QFinish   : LongInt;
    QLines    : LongInt;
//    QTemp     : String;
    QuoteText : RecMessageText;
  Begin
    Assign (QFile, TBBSCore(Term.Owner).TempPath + 'msgtmp');
    Reset  (QFile);

    If IoResult <> 0 Then Begin
      Term.OutFullLn (TBBSCore(Term.Owner).GetPrompt(88));
      Exit;
    End;

    QLines          := 0;
    Term.AllowPause := True;

    While Not Eof(QFile) Do Begin
      Inc    (QLines);
      ReadLn (QFile, QuoteText[QLines]);
    End;

    Close (QFile);

    Term.OutFullLn(TBBSCore(Term.Owner).GetPrompt(89));

    For QStart := 1 to QLines Do Begin
      Term.PromptInfo['A'] := strI2S(QStart);
      Term.PromptInfo['B'] := QuoteText[QStart];

      Term.OutFullLn(TBBSCore(Term.Owner).GetPrompt(90));

      If (Term.PausePos = TBBSCore(Term.Owner).User.ThisUser.ScreenSize) and (Term.AllowPause) Then
        Case Term.MorePrompt of
          'N' : Break;
          'C' : Term.AllowPause := False;
        End;
    End;

    Term.AllowPause := True;

    Term.OutFull(TBBSCore(Term.Owner).GetPrompt(91));
    QStart := strS2I(Term.GetStr(3, 3, -1, ''));

    Term.OutFull(TBBSCore(Term.Owner).GetPrompt(92));
    QFinish := strS2I(Term.GetStr(3, 3, -1, ''));

    If (QStart > 0) and (QStart <= QLines) and (QFinish <= QLines) Then Begin
      If QFinish = 0 Then QFinish := QStart;
      For QLines := QStart to QFinish Do Begin
        If CurLine = mysMaxMsgLines Then Break;
        MsgText[CurLine] := QuoteText[QLines];
        Inc (CurLine);
      End;
    End;
  End;

  Procedure Commands;
  Var
    Keys   : String[8];
    Prompt : String;
    Ch     : Char;
    Str    : String;
  Begin
    Done   := False;
    Save   := False;
    Prompt := TBBSCore(Term.Owner).GetPrompt(93);
    Keys   := strWordGet(1, Prompt, ' ');

    Delete (Prompt, 1, 9);

    Repeat
      Term.OutFull(Prompt);

      Ch := Term.OneKey(Keys, True);

      If Ch = Keys[1] Then
        Term.OutFullLn (TBBSCore(Term.Owner).GetPrompt(94))
      Else
      If Ch = Keys[2] Then Begin
        If Forced Then Begin
          Term.OutFull(TBBSCore(Term.Owner).GetPrompt(95));
          Exit;
        End Else
          Done := Term.GetYN(TBBSCore(Term.Owner).GetPrompt(96), False);
      End Else
      If Ch = Keys[3] Then
        Exit
      Else
      If Ch = Keys[4] Then Begin
        Quote;
        Exit;
      End Else
      If Ch = Keys[5] Then
        Exit
      Else
      If Ch = Keys[6] Then Begin
        Save := True;
        Done := True;
      End Else
      If Ch = Keys[7] Then Begin
//        Msg_Upload (CurLine);
        Exit;
      End Else
      If Ch = Keys[8] Then Begin
        Term.OutFull (TBBSCore(Term.Owner).GetPrompt(199));
        Str := Term.GetStr(60, 60, -1, Subj);
        If Str <> '' Then Subj := Str;
      End;
    Until Done or TBBSCore(Term.Owner).ShutDown;
  End;

  Procedure FullReDraw;
  Var
    Count : LongInt;
  Begin
    Term.PromptInfo['A'] := strI2S(WrapPos);
    Term.PromptInfo['B'] := strI2S(MaxLines);

    Term.OutFullLn(TBBSCore(Term.Owner).GetPrompt(97));
    Term.OutFullLn(TBBSCore(Term.Owner).GetPrompt(98));

    For Count := 1 to CurLine Do Begin
      Term.OutRaw (MsgText[Count]);
      If Count <> CurLine Then Term.OutRawLn('');
    End;
  End;

  Procedure GetText;
  Var
    Ch : Char;
//    BS : Byte;
  Begin
    Repeat
      Ch := Term.NewGetKey(0);
      Case Ch of
        ^R  : FullReDraw;
        #8  : If Length(MsgText[CurLine]) > 0 Then Begin
                Term.OutBS(1, True);
                Dec(MsgText[CurLine][0]);
              End Else If CurLine > 1 Then Begin
                Dec(CurLine);
                Term.PromptInfo['A'] := strI2S(CurLine);
                Term.OutFullLn(TBBSCore(Term.Owner).GetPrompt(99));
                Term.OutRaw (MsgText[CurLine]);
                If MsgText[CurLine] <> '' Then Begin
                  Term.OutBS(1, True);
                  Dec(MsgText[CurLine][0]);
                End;
              End;
        #13 : Begin
                If CurLine < MaxLines Then Begin
                  Inc(CurLine);
                  Term.OutRaw(#13#10);
                End;
              End;
      Else
        If (Ch = '/') and (Length(MsgText[CurLine]) = 0) Then Begin
          Commands;
          If (Not Save) and (Not Done) Then FullReDraw;
        End Else
        If Ch in [#32..#254] Then Begin
          If Length(MsgText[Curline]) < WrapPos Then Begin
            MsgText[CurLine] := MsgText[CurLine] + Ch;
            Term.OutRaw(Ch);
          End;
          If (Length(MsgText[CurLine]) > WrapPos - 1) and (CurLine < MaxLines) Then Begin
            strWrap(MsgText[CurLine], MsgText[Succ(CurLine)], WrapPos);

            Inc           (CurLine);
            Term.OutBS    (Length(MsgText[CurLine]), True);
            Term.OutRawLn ('');
            Term.OutRaw   (MsgText[CurLine]);
          End;
        End;
      End;
    Until Done or TBBSCore(Term.Owner).ShutDown;
  End;

Var
  Count : LongInt;
Begin
  CurLine := Lines;
  Done    := False;

  If CurLine < MaxLines Then Inc(CurLine);

  For Count := Lines + 1 to mysMaxMsgLines Do MsgText[Count] := '';

  FullReDraw;
  GetText;

  If Save Then Begin
    Lines      := CurLine - 1;
    LineEditor := True;
  End Else
    LineEditor := False;
End;

End.
