{$I M_OPS.PAS}

Unit BBS_Core;

Interface

Uses
  m_Socket_Class,
  Sock_Server,
  Class_Sync,
  m_FileIO,
  BBS_Events,
  BBS_IO,
  BBS_Common,
  BBS_User,
  BBS_MenuRun,
  BBS_MsgBase,
  BBS_FileBase,
  BBS_Doors,
  BBS_NodeMsg,
  BBS_NodeChat,
  MPL_Execute;

Type
  TBBSCore = Class
    Node       : Word;
    ShutDown   : Boolean;
    TempPath   : String;
    Theme      : recTheme;
    PromptFile : File of recPrompt;
    Owner      : TServerClient;
    Client     : TSocketClass;
    Event      : TBBSEvent;
    Term       : TBBSIO;
    User       : TBBSUser;
    Menu       : TMenuEngine;
    Msgs       : TMsgBase;
    Door       : TBBSDoor;
    Files      : TFileBase;
    NodeMsg    : TBBSNodeMsg;
    Chat       : TBBSNodeChat;
    Critical   : TCriticalSection;

    Constructor Create (O: TServerClient; NodeNum: Word; Socket: TSocketClass);
    Destructor  Destroy; Override;
    Procedure   Execute;

    Function    LoadThemeFile (FN: String) : Boolean;
    Function    GetPrompt     (Num: LongInt) : String;
    Function    CheckPassword (P1, P2: LongInt; PW: String) : Boolean;
    Procedure   SystemLog     (Str: String);

    Procedure   UpdateLastCallInfo;
    Procedure   ShowLastCallers (Num: Byte);
  End;

Implementation

Uses
  m_DateTime,
  m_Strings;

Procedure bbsEvent_Error (Sender: Pointer; Msg: String);
Begin
  // make screen cap of error screen ala old tg?
  TBBSCore(Sender).SystemLog('ERROR: ' + Msg);
  TBBSCore(Sender).Term.OutRawLn('ERROR: ' + Msg);
  TBBSCore(Sender).ShutDown := True;
End;

Procedure bbsEvent_Inactive (Sender: Pointer; Msg: String);
Begin
  TBBSCore(Sender).SystemLog('Inactivity timeout');
  TBBSCore(Sender).Term.OutFullLn(TBBSCore(Sender).GetPrompt(56));
  TBBSCore(Sender).Shutdown := True;
End;

Procedure bbsEvent_ConnectionLost (Sender: Pointer; Msg: String);
Begin
  TBBSCore(Sender).SystemLog('Connection lost');
  TBBSCore(Sender).Shutdown := True;
End;

{ ======================================================================== }
{ BBS CLASS INITIALIZATION                                                 }
{ ======================================================================== }

Constructor TBBSCore.Create (O: TServerClient; NodeNum: Word; Socket: TSocketClass);
Begin
  Inherited Create;

  Node     := NodeNum;
  ShutDown := False;
  TempPath := bbsConfig.PathSystem + 'temp' + strI2S(Node) + mysPathSep;
  Owner    := O;
  Client   := Socket;
  Event    := TBBSEvent.Create;
  Term     := TBBSIO.Create(Self);
  User     := TBBSUser.Create(Self);
  Menu     := TMenuEngine.Create(Self);
  Msgs     := TMsgBase.Create(Self);
  Files    := TFileBase.Create(Self);
  Door     := TBBSDoor.Create(Self);
  NodeMsg  := TBBSNodeMsg.Create(Self);
  Critical := TCriticalSection.Create;

  Event.SetHandlerProc (evt_Error,          {$IFDEF FPC}@{$ENDIF}bbsEvent_Error);
  Event.SetHandlerProc (evt_Inactive,       {$IFDEF FPC}@{$ENDIF}bbsEvent_Inactive);
  Event.SetHandlerProc (evt_ConnectionLost, {$IFDEF FPC}@{$ENDIF}bbsEvent_ConnectionLost);

  // create the node's log here if it doesnt exist...???
  MkDir (bbsConfig.PathSystem + 'temp' + strI2S(Node));
  If IoResult <> 0 Then;
End;

Destructor TBBSCore.Destroy;
Begin
  SystemLog('Session ended');

  Close (PromptFile);
  If IoResult = 0 Then;

  If User <> NIL Then Begin
    User.ThisUser.LastCall := CurDateDos;
    User.ThisUser.TimeLeft := User.TimeLeft;
    User.SaveUser;
  End;

  If Term <> NIL Then Begin
    Term.Console.TextAttr := 7;
    Term.Console.WriteLine(#13#10 + 'Session terminated');
  End;

  Msgs.Free;
  Files.Free;
  Menu.Free;
  User.Free;
  Door.Free;
  Term.Free;
  Event.Free;
  NodeMsg.Free;
  Critical.Free;

  Inherited Destroy;
End;

Procedure TBBSCore.UpdateLastCallInfo;
Var
  F      : File;
  Offset : LongInt;
  Start  : LongInt;
  Info   : RecCallInfo;
Begin
  If User.ThisUser.Flags And UserNoLastCall <> 0 Then Exit;
  If User.ThisUser.Invisible Then Exit;

  Assign (F, bbsConfig.PathData + 'lastcalls.dat');

  If Not ioReset(F, SizeOf(RecCallInfo), fmReadWrite + fmDenyAll) Then
    If Not ioReWrite (F, SizeOf(RecCallInfo), fmReadWrite + fmDenyAll) Then Exit;

  If FileSize(F) > mysMaxCallInfo Then Begin
    Offset := FileSize(F) - mysMaxCallInfo;
    Start  := Offset;

    While Start < FileSize(F) Do Begin
      ioSeek  (F, Start);
      ioRead  (F, Info);
      ioSeek  (F, Start - Offset);
      ioWrite (F, Info);

      Inc (Start);
    End;

    ioSeek   (F, mysMaxCallInfo);
    Truncate (F);
  End;

  Info.NewUser  := User.ThisUser.Calls = 1;
  Info.Name     := User.ThisUser.Handle;
  Info.City     := User.ThisUser.CityState;
  Info.Node     := Node;
  Info.Caller   := bbsConfig.SystemCalls;
  Info.DateTime := CurDateDos;
  Info.Email    := User.ThisUser.Email;
  Info.UserInfo := User.ThisUser.UserInfo;
  Info.Gender   := User.ThisUser.Gender;

  Move (User.ThisUser.Optional, Info.Optional, SizeOf(Info.Optional));

  ioSeek  (F, FileSize(F));
  ioWrite (F, Info);
  Close   (F);
End;

Procedure TBBSCore.ShowLastCallers (Num: Byte);
Var
  F     : File;
  Info  : RecCallInfo;
  Ch    : Char;
  Saved : Boolean;
Begin
  Saved := Term.NoBufFlush;
  Term.NoBufFlush := True;

  If (Num < 1)              Then Num := 10;
  If (Num > mysMaxCallInfo) Then Num := mysMaxCallInfo;

  Term.PromptInfo['A'] := strI2S(Num);

  Term.OutFullLn(GetPrompt(127));

  Assign (F, bbsConfig.PathData + 'lastcalls.dat');

  If ioReset(F, SizeOf(RecCallInfo), fmReadWrite + fmDenyNone) Then Begin

    Term.AllowPause := True;
    Term.PausePos   := 1;

    If FileSize(F) > Num Then
      ioSeek (F, FileSize(F) - Num);

    While Not Eof(F) Do Begin
      ioRead (F, Info);

      Term.PromptInfo['A'] := Info.Name;
      Term.PromptInfo['B'] := strI2S(Info.Node);
      Term.PromptInfo['C'] := Info.City;
      Term.PromptInfo['D'] := DateDos2Str(Info.DateTime, User.ThisUser.DateType);
      Term.PromptInfo['E'] := TimeDos2Str(Info.DateTime, True);
      Term.PromptInfo['F'] := strI2S(Info.Caller);
      Term.PromptInfo['G'] := Info.UserInfo;

      For Ch := 'H' to 'Q' Do
        Term.PromptInfo[Ch] := Info.Optional[Ord(Ch) - 71];

      If Info.NewUser Then
        Term.OutFullLn(GetPrompt(129))
      Else
        Term.OutFullLn(GetPrompt(128));

      If (Term.PausePos = User.ThisUser.ScreenSize) And (Term.AllowPause) Then
        Case Term.MorePrompt of
          'N' : Break;
          'C' : Term.AllowPause := False;
        End;
    End;

    Close (F);
  End;

  Term.OutFullLn(GetPrompt(226));

  Term.BufFlush;
  Term.NoBufFlush := Saved;
End;

Procedure TBBSCore.Execute;
Var
  Count : LongInt;
  Ch    : Char;
Begin
  If Not LoadThemeFile(bbsConfig.DefThemeName) Then Begin
    SystemLog('Unable to load default theme');
    Exit;
  End;

  User.SetUserAction (GetPrompt(227));

  SystemLog ('');
  SystemLog ('-------- Connection ' + DateDos2Str(CurDateDos, 1) + ' ' + TimeDos2Str(CurDateDos, False) + ' on Node ' + strI2S(Node));
  SystemLog ('Client ' + Client.PeerIP + ' ' + Client.PeerName);

  Term.OutFull('');

  ExecuteMPE(Self, 'connect');

  Term.OutFullLn ('|CLMystic BBS Version ' + mysVersionText + ' (' + mysOSID + ')');
  Term.OutFullLn ('Copyright (C) ' + mysCopyYear + ' By James Coyle.  All Rights Reserved.|CR');

  Term.DetectGraphics;

  If bbsConfig.LoginTime > 0 Then
    User.SetTimeLeft(bbsConfig.LoginTime);

  ExecuteMPE(Self, 'startup');

  If Not Theme.AllowANSI and (Term.Graphics = 1) Then Begin
    Term.OutFull(GetPrompt(15));
    Exit;
  End;

  If Not Theme.AllowASCII and (Term.Graphics = 0) Then Begin
    Term.OutFull(GetPrompt(16));
    Exit;
  End;

  If bbsConfig.SystemPW <> '' Then
    If Not CheckPassword(0, 1, bbsConfig.SystemPW) Then Exit;

  If ShutDown Then Exit;

  If Not User.DoUserLogin Then Exit;

//  If ShutDown Then Exit;

  SystemLog(User.ThisUser.Handle + ' logged on');

  If User.ThisUser.Theme <> bbsConfig.DefThemeName Then
    If Not LoadThemeFile(User.ThisUser.Theme) Then
      LoadThemeFile(bbsConfig.DefThemeName);

  User.ThisUser.PeerIP   := Client.PeerIP;
  User.ThisUser.PeerName := Client.PeerName;

  User.Security_Load(User.ThisUser.Security);

  If DateDos2Str(User.ThisUser.LastCall, 1) <> DateDos2Str(CurDateDos, 1) Then Begin
    User.ThisUser.CallsToday := 0;
    User.ThisUser.DLsToday   := 0;
    User.ThisUser.DLkbToday  := 0;
    User.ThisUser.TimeLeft   := User.Security.Time;
  End;

  Inc (User.ThisUser.CallsToday);
  Inc (User.ThisUser.Calls);
  Inc (bbsConfig.SystemCalls);

  User.SetTimeLeft(User.ThisUser.TimeLeft);

  If User.ThisUser.LastMGroup > 0 Then
    Msgs.ChangeGroup(strI2S(User.ThisUser.LastMGroup), False, False)
  Else
    Msgs.ChangeGroup('+', User.ThisUser.LastMBase = 0, False);

  If User.ThisUser.LastMBase > 0 Then
    Msgs.ChangeArea(strI2S(User.ThisUser.LastMBase))
  Else
    Msgs.ChangeArea('+');

  If User.ThisUser.LastFGroup > 0 Then
    Files.ChangeGroup(strI2S(User.ThisUser.LastFGroup), False, False)
  Else
    Files.ChangeGroup('+', True, False);

  If User.ThisUser.LastFBase > 0 Then
    Files.ChangeArea(strI2S(User.ThisUser.LastFBase))
  Else
    Files.ChangeArea('+');

  If User.ThisUser.Flags AND UserLockedOut <> 0 Then Begin
    SystemLog('User is locked out');
    Term.OutFullLn(GetPrompt(61));
    Exit;
  End;

  If (User.ThisUser.CallsToday >= User.Security.MaxCalls) and (User.Security.MaxCalls > 0) Then Begin
    SystemLog('User reached calls per day limit');
    Term.OutFullLn(GetPrompt(60));
    Exit;
  End;

  If User.Access(bbsConfig.AcsInvLogin) Then
    User.ThisUser.Invisible := Term.GetYN(GetPrompt(194), False);

  UpdateLastCallInfo;
  User.SetUserAction(GetPrompt(227));

  If DateValid(User.ThisUser.Expires) Then
    If CurDateJulian - DateStr2Julian(User.ThisUser.Expires) >= 0 Then Begin
      SystemLog('Account expired to level ' + strI2S(User.ThisUser.ExpiresTo));

      User.Security_Upgrade(User.ThisUser, User.ThisUser.ExpiresTo);

      If User.ThisUser.Security = 0 Then Begin
        Term.OutFullLn(GetPrompt(59));
        User.ThisUser.Flags := User.ThisUser.Flags AND UserDeleted;
        Exit;
      End Else
        Term.OutFullLn(GetPrompt(57));
    End;

  If (bbsConfig.PWChange > 0) and (User.ThisUser.Flags AND UserNoPWChange = 0) Then
    If Not DateValid(User.ThisUser.LastPWChange) Then
      User.ThisUser.LastPWChange := DateDos2Str(CurDateDos, 1)
    Else
    If CurDateJulian - DateStr2Julian(User.ThisUser.LastPWChange) >= 0 Then Begin
      SystemLog('Requiring password change');
      Term.OutFullLn(GetPrompt(62));
      User.AskPassword(False);
    End;

  If (User.Security.Posts > 0) And (User.ThisUser.MsgPosts >= User.Security.Posts) Then Begin
    Term.PromptInfo['A'] := strI2S(User.Security.Posts);
    Term.PromptInfo['B'] := strI2S(User.Security.PostsTo);
    User.Security_Upgrade(User.ThisUser, User.Security.PostsTo);
    Term.OutFullLn(GetPrompt(197));
    SystemLog('Upgraded user access for # of posts');
    If User.ThisUser.Security = 0 Then Begin
      Term.OutFullLn(GetPrompt(59));
      User.ThisUser.Flags := User.ThisUser.Flags AND UserDeleted;
      Exit;
    End;
  End;

  For Count := 1 to 9 Do
    Term.OutFile('logon' + strI2S(Count));

  Term.OutFile('sl' + strI2S(User.ThisUser.Security));

  For Ch := 'A' to 'Z' Do
    If Ord(Ch) - 64 in User.ThisUser.AF1 Then Term.OutFile ('flag1' + Ch);

  For Ch := 'A' to 'Z' Do
    If Ord(Ch) - 64 in User.ThisUser.AF2 Then Term.OutFile ('flag2' + Ch);

  If Copy(DateDos2Str(CurDateDos, 1), 1, 5) = Copy(DateJulian2Str(User.ThisUser.Birthdate, 1), 1, 5) Then
    Term.OutFile('birthday');

  // forced voting
  // nuv voting

  If User.ThisUser.StartMenu <> '' Then
    Menu.MenuName := User.ThisUser.StartMenu
  Else
    Menu.MenuName := bbsConfig.DefStartMenu;

  Repeat
//    SystemLog ('Menu: ' + Menu.MenuName);
    Menu.ExecuteMenu(True, True, True);
  Until ShutDown;
End;

Function TBBSCore.GetPrompt (Num: LongInt) : String;
Var
  Str : RecPrompt;
Begin
  Result := '';

  If Num = -1 Then Exit;

  If Num > mysMaxThemeText Then Begin
    Event.Trigger(evt_Error, Self, 'Prompt out of range #' + strI2S(Num));
    Exit;
  End;

  If IoResult = 0 Then; // clear IOresult

  Seek (PromptFile, Num);
  Read (PromptFile, Str);

  If IoResult <> 0 Then
    Event.Trigger(evt_Error, Self, 'Unable to load prompt #' + strI2S(Num))
  Else
    Result := Str;
End;

Function TBBSCore.LoadThemeFile (FN: String) : Boolean;
Var
  ThemeFile : File of recTheme;
Begin
  Result   := False;
  FileMode := 66;

  Assign (ThemeFile, bbsConfig.PathData + 'themes.dat');
  Reset  (ThemeFile);

  If IoResult <> 0 Then Begin
    Event.Trigger(evt_Error, Self, 'Unable to load theme: ' + FN);
    Exit;
  End;

  While Not Eof(ThemeFile) Do Begin
    Read (ThemeFile, Theme);
    {$IFDEF FS_IGNORE}
      If strUpper(Theme.FileName) = strUpper(FN) Then Begin
    {$ELSE}
      If Theme.FileName = FN Then Begin
    {$ENDIF}
        Close  (ThemeFile);
        Close  (PromptFile);

        If IoResult = 0 Then;

        Assign (PromptFile, bbsConfig.PathData + FN + '.thm');
        Reset  (PromptFile);

        If IoResult <> 0 Then Begin
          Event.Trigger(evt_Error, Self, 'Unable to load theme: ' + FN + '.thm');
          Exit;
        End;

        User.ThisUser.Theme := Theme.FileName;
        Result              := True;
        Exit;
      End;
  End;

  Close(ThemeFile);

  Event.Trigger(evt_Error, Self, 'Unable to load theme: ' + FN);
End;

Function TBBSCore.CheckPassword (P1, P2: LongInt; PW: String) : Boolean;
Var
  Str   : String;
  Count : Byte;
Begin
  Result := False;
  Count  := 0;

  While (Count < bbsConfig.PWAttempts) And Not ShutDown Do Begin
    Inc (Count);

    Term.OutFull(GetPrompt(P1));

    Str := Term.GetStr(15, 15, -6, '');

    If Str = strUpper(PW) Then Begin
      Result := True;
      Exit;
    End Else Begin
      SystemLog('Invalid password attempt: ' + Str);
      Term.OutFullLn(GetPrompt(P2));
    End;
  End;
End;

Procedure TBBSCore.SystemLog (Str: String);
Var
  TF : Text;
Begin
  If (Str[1] <> '-') and (Str <> '') Then
    Str := '(' + TimeDos2Str(CurDateDos, False) + ')  ' + Str;

  Assign (TF, bbsConfig.PathLogs + 'node' + strI2S(Node) + '.log');
  Append (TF);

  If IoResult <> 0 Then ReWrite(TF);

  WriteLn (TF, Str);
  Close   (TF);
End;

End.
