unit Windows;

interface

uses
  Crt, Dos;

const
  STD_OUTPUT_HANDLE = 0;
  TIME_ZONE_ID_UNKNOWN = 0;
  TIME_ZONE_ID_STANDARD = 1;
  TIME_ZONE_ID_DAYLIGHT = 2;

type
  SmallInt  = Integer;
  SmallWord = Word;

  TCoord = Record
    X: Integer;
    Y: Integer;
  end;

  THandle = LongInt;

  TSmallRect = Record
    Left: Integer;
    Top: Integer;
    Right: Integer;
    Bottom: Integer;
  end;

  TSystemTime = Record
    wYear: Word;
    wMonth: Word;
    wDayOfWeek: Word;
    wDay: Word;
    wHour: Word;
    wMinute: Word;
    wSecond: Word;
    wMilliseconds: Word;
  end;

  TTimeZoneInformation = Record
    Bias: LongInt;
    StandardName: Array[0..31] of Char;
    StandardDate: TSystemTime;
    StandardBias: LongInt;
    DaylightName: Array[0..31] of Char;
    DaylightDate: TSystemTime;
    DaylightBias: LongInt;
  end;

  TWin32Cell = Record
    Ch: Word;
    Attr: Word;
  end;

procedure GetLocalTime(var ASystemTime: TSystemTime);
function GetStdHandle(AHandle: LongInt): THandle;
function GetTimeZoneInformation(var ATimeZone: TTimeZoneInformation): LongInt;
function HiByte(AWord: Word): Byte;
function LoByte(AWord: Word): Byte;
function MakeWord(ALow, AHigh: Byte): Word;
procedure ReadConsoleOutputAttribute(AHandle: THandle; AAttr: Pointer; ALen: LongInt; APos: TCoord; var ANumRead: LongInt);
procedure ReadConsoleOutputCharacter(AHandle: THandle; ACh: Pointer; ALen: LongInt; APos: TCoord; var ANumRead: LongInt);
procedure Sleep(AMiliSeconds: LongInt);
procedure WriteConsoleOutput(AHandle: THandle; ABuf: Pointer; ABufSize, ABufPos: TCoord; var APos: TSMallRect);
procedure WriteConsoleOutputAttribute(AHandle: THandle; AAttr: Pointer; ALen: LongInt; APos: TCoord; var ANumWritten: LongInt);
procedure WriteConsoleOutputCharacter(AHandle: THandle; ACh: Pointer; ALen: LongInt; APos: TCoord; var ANumWritten: LongInt);

implementation

type
  TCell = Record
    Ch: Char;
    Attr: Byte;
  end;

  TScreen = Array[1..25, 1..80] of TCell;

var
  Screen: TScreen absolute $B800:0000;

procedure GetLocalTime(var ASystemTime: TSystemTime);
var
   Ye, Mo, Da, Dow, Ho, Mi, Se, Hu: Word;
begin
     GetDate(Ye, Mo, Da, Dow);
     GetTime(Ho, Mi, Se, Hu);
     with ASystemTime do
     begin
          wYear := Ye;
          wMonth := Mo;
          wDayOfWeek := Dow;
          wDay := Da;
          wHour := Ho;
          wMinute := Mi;
          wSecond := Se;
          wMilliseconds := Hu * 10;
     end;
end;

function GetStdHandle(AHandle: LongInt): THandle;
begin
     GetStdHandle := 0;
end;

function GetTimeZoneInformation(var ATimeZone: TTimeZoneInformation): LongInt;
begin
     GetTimeZoneInformation := TIME_ZONE_ID_UNKNOWN;
end;

function HiByte(AWord: Word): Byte;
begin
     HiByte := (AWord and $FF00) shr 8;
end;

function LoByte(AWord: Word): Byte;
begin
     LoByte := AWord and $00FF;
end;

function MakeWord(ALow, AHigh: Byte): Word;
begin
     MakeWord := ALow or (AHigh shl 8);
end;

procedure ReadConsoleOutputAttribute(AHandle: THandle; AAttr: Pointer; ALen: LongInt; APos: TCoord; var ANumRead: LongInt);
var
   Attr: ^Word;
begin
     Attr := AAttr;
     Attr^ := Screen[APos.Y + 1, APos.X + 1].Attr;
end;

procedure ReadConsoleOutputCharacter(AHandle: THandle; ACh: Pointer; ALen: LongInt; APos: TCoord; var ANumRead: LongInt);
var
   Ch: ^Char;
begin
     Ch := ACh;
     Ch^ := Screen[APos.Y + 1, APos.X + 1].Ch;
end;

procedure Sleep(AMiliSeconds: LongInt);
var
   Regs: Registers;
begin
     Regs.AX := $1680;
     Intr($2F, Regs);
     if (AMiliSeconds <> 1) then
        Delay(AMiliSeconds);
end;

procedure WriteConsoleOutput(AHandle: THandle; ABuf: Pointer; ABufSize, ABufPos: TCoord; var APos: TSMallRect);
type
  TBuffer = Array[0..255] of TWin32Cell;
var
   Buffer: ^TBuffer;
   I: Integer;
begin
     Buffer := ABuf;
     for I := 0 to ABufSize.X - 1 do
     begin
          Screen[APos.Top + 1, APos.Left + 1 + I].Ch := Char(Buffer^[I + ABufPos.X].Ch);
          Screen[APos.Top + 1, APos.Left + 1 + I].Attr := Buffer^[I + ABufPos.X].Attr;
     end;
end;

procedure WriteConsoleOutputAttribute(AHandle: THandle; AAttr: Pointer; ALen: LongInt; APos: TCoord; var ANumWritten: LongInt);
var
   Attr: ^Word;
begin
     Attr := AAttr;
     Screen[APos.Y + 1, APos.X + 1].Attr := Attr^;
end;

procedure WriteConsoleOutputCharacter(AHandle: THandle; ACh: Pointer; ALen: LongInt; APos: TCoord; var ANumWritten: LongInt);
var
   Ch: ^Char;
begin
     Ch := ACh;
     Screen[APos.Y + 1, APos.X + 1].Ch := Ch^;
end;

end.
