unit SysUtils;

interface

uses
  Dos;

function ExtractFileName(AFile: String): String;
function ExtractFilePath(AFile: String): String;
function FileExists(AFile: String): Boolean;
function IntToStr(ANum: LongInt): String;
function StrToIntDef(AStr: String; ADef: LongInt): LongInt;
function UpperCase(AStr: String): String;

implementation

function ExtractFileName(AFile: String): String;
var
   D: DirStr;
   N: NameStr;
   E: ExtStr;
begin
     FSplit(AFile, D, N, E);
     ExtractFileName := N + E;
end;

function ExtractFilePath(AFile: String): String;
var
   D: DirStr;
   N: NameStr;
   E: ExtStr;
begin
     FSplit(AFile, D, N, E);
     ExtractFilePath := D;
end;

function FileExists(AFile: String): Boolean;
var
   F: File of Byte;
begin
     Assign(F, AFile);
     {$I-}Reset(F);{$I+}
     if (IOResult = 0) then
     begin
          Close(F);
          FileExists := True;
     end else
         FileExists := False;
end;

function IntToStr(ANum: LongInt): String;
var
   S: String;
begin
     Str(ANum, S);
     IntToStr := S;
end;

function StrToIntDef(AStr: String; ADef: LongInt): LongInt;
var
   I: LongInt;
   Err: Integer;
begin
     Val(AStr, I, Err);
     if (Err <> 0) then
        I := ADef;
     StrToIntDef := I;
end;

function UpperCase(AStr: String): String;
var
   I: Integer;
begin
     for I := 1 to Length(AStr) do
         AStr[I] := UpCase(AStr[I]);
     UpperCase := AStr;
end;

end.