/* --------------------------------------------------------------------------
 *
 * $Workfile: LCmdSelect.h $
 * $Revision: 12 $
 *   $Author: Lel $
 *     $Date: 06.01.24 16:15 $
 *
 *   Project: Larsen Commander
 *   Created: January 09, 2000.
 * Copyright: Leif Erik Larsen. 2000. Ski, Norway.
 *            This is unpublished property, all rights reserved.
 *
 * ------------------------------------------------------------------------ */

#pragma once // Tell MVC++ to include and open this module only once.

#ifndef __LCMD_SELECT
#define __LCMD_SELECT

#include "glib/primitives/GObject.h"

/**
 * This is the base class of all File Panel selection models.
 *
 * Each selection model has the responsibility to perform file item
 * selections with respect to its corresponding view mode.
 *
 * @author  Leif Erik Larsen
 * @since   2000.01.09
 */
class LCmdSelect : public GObject
{
   protected:

      class LCmdFilePanel& fpanel;

   public:

      /**
       * These are the ID's used to select items via the keyboard arrow keys.
       */
      enum NAVIGATE
      {
         NAVIGATE_UP = -10000,
         NAVIGATE_DOWN,
         NAVIGATE_LEFT,
         NAVIGATE_RIGHT,
         NAVIGATE_PAGEUP,
         NAVIGATE_PAGEDOWN,
         NAVIGATE_HOME,
         NAVIGATE_END
      };

   public:

      explicit LCmdSelect ( class LCmdFilePanel& fpanel );
      virtual ~LCmdSelect ();

   private:

      const LCmdSelect& operator= ( const LCmdSelect& ) const { return *this; }

   public:

      int select ( int index );

   protected:

      virtual int selectIfDown () = 0;
      virtual int selectIfUp () = 0;
      virtual int selectIfEnd () = 0;
      virtual int selectIfHome () = 0;
      virtual int selectIfLeft () = 0;
      virtual int selectIfRight () = 0;
      virtual int selectIfPageDown () = 0;
      virtual int selectIfPageUp () = 0;
      virtual int selectIfRandom  ( int index ) = 0;
};

/**
 * This is the File Panel selection model for the "Brief" view mode.
 *
 * @author  Leif Erik Larsen
 * @since   2000.01.09
 */
class LCmdSelectBrief : public LCmdSelect
{
   public:

      explicit LCmdSelectBrief ( class LCmdFilePanel& fpanel );

   private:

      const LCmdSelectBrief& operator= ( const LCmdSelectBrief& ) const { return *this; }

   protected:

      virtual int selectIfDown ();
      virtual int selectIfUp ();
      virtual int selectIfEnd ();
      virtual int selectIfHome ();
      virtual int selectIfLeft ();
      virtual int selectIfRight ();
      virtual int selectIfPageDown ();
      virtual int selectIfPageUp ();
      virtual int selectIfRandom  ( int index );
};

/**
 * This is the File Panel selection model for the "Wide" view mode.
 *
 * @author  Leif Erik Larsen
 * @since   2000.01.09
 */
class LCmdSelectWide : public LCmdSelect
{
   public:

      explicit LCmdSelectWide ( class LCmdFilePanel& fpanel );

   private:

      const LCmdSelectWide& operator= ( const LCmdSelectWide& ) const { return *this; }

   protected:

      virtual int selectIfDown ();
      virtual int selectIfUp ();
      virtual int selectIfEnd ();
      virtual int selectIfHome ();
      virtual int selectIfLeft ();
      virtual int selectIfRight ();
      virtual int selectIfPageDown ();
      virtual int selectIfPageUp ();
      virtual int selectIfRandom  ( int index );
};

/**
 * This is the File Panel selection model for the "Full" view mode.
 *
 * @author  Leif Erik Larsen
 * @since   2000.01.09
 */
class LCmdSelectFull : public LCmdSelectWide
{
   public:

      explicit LCmdSelectFull ( class LCmdFilePanel& fpanel );

   private:

      const LCmdSelectFull& operator= ( const LCmdSelectFull& ) const { return *this; }

   protected:

      virtual int selectIfLeft ();
      virtual int selectIfRight ();
};

/**
 * This is the File Panel selection model for the "Info" view mode.
 *
 * @author  Leif Erik Larsen
 * @since   2000.01.09
 */
class LCmdSelectInfo : public LCmdSelect
{
   public:

      explicit LCmdSelectInfo ( class LCmdFilePanel& fpanel );

   private:

      const LCmdSelectInfo& operator= ( const LCmdSelectInfo& ) const { return *this; }

   protected:

      virtual int selectIfDown ();
      virtual int selectIfUp ();
      virtual int selectIfEnd ();
      virtual int selectIfHome ();
      virtual int selectIfLeft ();
      virtual int selectIfRight ();
      virtual int selectIfPageDown ();
      virtual int selectIfPageUp ();
      virtual int selectIfRandom  ( int index );
};

#endif // #ifndef __LCMD_SELECT
