/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "lcmd/LCmdInternalCmd.h"

#include "glib/GProgram.h"
#include "glib/util/GSectionBag.h"

InternalCommand::InternalCommand ( const char* name_, bool transferToShell )
                :name(name_),
                 shortHelp(GProgram::LoadText("%TxtInternalCommandHelp_" + name)),
                 longHelp(GProgram::LoadText("%TxtInternalCommandHelp_" + name, GResourceTable::LT_PREFER_HINT)),
                 disabled(false),
                 transferToShell(transferToShell)
{
}

InternalCommand::~InternalCommand ()
{
}

const GString& InternalCommand::getCommandStr () const 
{ 
   return name; 
}

const GString& InternalCommand::getShortHelp () const 
{ 
   return shortHelp; 
}

const GString& InternalCommand::getLongHelp () const 
{ 
   return longHelp; 
}

void InternalCommand::setDisabled ( bool disabled )
{
   this->disabled = disabled;
}

bool InternalCommand::isDisabled ()
{
   return disabled;
}

bool InternalCommand::isTransferToShell ()
{
   return transferToShell;
}

void InternalCommand::writeProfile ( GSectionBag& ini, bool doIt )
{
   GString sectName = "InternalCommand." + name;
   ini.putBool(sectName, "Disabled", isDisabled(), doIt);
}

void InternalCommand::readProfile ( GSectionBag& ini )
{
   GString sectName = "InternalCommand." + name;
   setDisabled(ini.getBool(sectName, "Disabled", isDisabled()));
}

InternalCommandToShell::InternalCommandToShell ( const char* cmd, bool transferToShell )
                       :InternalCommand(cmd, transferToShell)
{
}

InternalCommandToShell::~InternalCommandToShell ()
{
}

void InternalCommandToShell::writeProfile ( GSectionBag& ini, bool doIt )
{
   ini.putBool("TransferToSystemShell", getCommandStr(), !isDisabled(), doIt);
}

void InternalCommandToShell::readProfile ( GSectionBag& ini )
{
   setDisabled(!ini.getBool("TransferToSystemShell", getCommandStr(), !isDisabled()));
}
