/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __LCMD_FILEPANELVIEWOPTIONS
#define __LCMD_FILEPANELVIEWOPTIONS

#include "lcmd/LCmdAbstractOptions.h"

/**
 * This class is used to contain the various view-options
 * of a file panel.
 */
class LCmdFilePanelViewOptions : public LCmdAbstractOptions
{
   public:

      /**
       * These are the ID's used to represent the various supported
       * view modes of the two file panels in Larsen Commander.
       */
      enum VIEWMODE
      {
         VIEWMODE_BRIEF,
         VIEWMODE_WIDE,
         VIEWMODE_FULL,
         VIEWMODE_INFO,
#if __ENABLE_TREE_VIEW
         VIEWMODE_TREE
#endif
      };

      /**
       * These are the ID's used to represent the various supported ways
       * of how to display file item icons.
       */
      enum SHOWICON
      {
         SHOWICON_INTERNAL,
         SHOWICON_SMALL,
         SHOWICON_LARGE
      };

   public:

      /** True if we shall show the header bar of the panel. */
      bool showHeaderbar;

      /** True if we shall show the infobar of the panel. */
      bool showInfobar;

      /** True if we shall show the columns bar in full mode. */
      bool showColumnsBar;

      /** True if we shall show icon of each item. */
      bool showItemIcon;

      /** ID of how to show file icons, ignored if showItemIcon is false. */
      SHOWICON showIcon;

      /** ID of current view mode of panel. */
      VIEWMODE viewMode;

      /** True if we shall show the Drives Button in the header bar. */
      bool showHeaderDrivButt;

      /** True if we shall show the Walk-Up-Directory Button in the header bar. */
      bool showHeaderUpDirButt;

      /** True if we shall show the Root-Directory Button in the header bar. */
      bool showHeaderRootButt;

   public:

      /**
       * Initiate all the options in the new object with their
       * respective default value.
       */
      LCmdFilePanelViewOptions ();
      virtual ~LCmdFilePanelViewOptions ();

   public:

      /**
       * Reset all the options in the object with their
       * respective default value.
       */
      void resetToDefault ();
};

#endif // #ifndef __LCMD_FILEPANELVIEWOPTIONS
