/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __LCMD_FILEPANELSTARTUPOPTIONS
#define __LCMD_FILEPANELSTARTUPOPTIONS

#include "lcmd/LCmdAbstractOptions.h"
#include "glib/primitives/GString.h"

/**
 * This class is used to contain the file panel startup options.
 */
class LCmdFilePanelStartupOptions : public LCmdAbstractOptions
{
   public:

      /** True if we shall activate the "current" directory upon startup. */
      bool useCurrentDir;

      /** True if we shall activate the startup directory. */
      bool useDir;

      /** Initial (startup) directory. */
      GString dir;

   public:

      /**
       * Initiate all the options in the new object with their
       * respective default value.
       */
      LCmdFilePanelStartupOptions ();
      virtual ~LCmdFilePanelStartupOptions ();

   public:

      /**
       * Reset all the options in the object with their
       * respective default value.
       */
      void resetToDefault ();
};

#endif // #ifndef __LCMD_FILEPANELSTARTUPOPTIONS
