/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __LCMD_FILEPANELSORTOPTIONS
#define __LCMD_FILEPANELSORTOPTIONS

#include "lcmd/LCmdAbstractOptions.h"

/**
 * This class is used to contain the file panel sort options.
 */
class LCmdFilePanelSortOptions : public LCmdAbstractOptions
{
   public:

      /**
       * Describes what to sort for in a panel.
       */
      enum SORT_WHAT
      {
         PSW_UNSORTED,

         /** Directory or file. */
         PSW_TYPE,

         PSW_NAME,
         PSW_EXTENTION,
         PSW_DATE,
         PSW_TIME,
         PSW_SIZE,

         /** Used only to know number of enums of this type. */
         PSW_UNKNOWN
      };

      /**
       * Describes wether to sort ascending or descending.
       */
      enum SORT_HOW
      {
         PSH_ASCENDING,
         PSH_DESCENDING,
         PSH_TOGGLE // Toggle the current sort order.
      };

   public:

      /** Sort what (first, second, third, fourth). */
      SORT_WHAT what[4];

      /** Sort how (first, second, third, fourth). */
      SORT_HOW how[4];

   public:

      /**
       * Initiate all the options in the new object with their
       * respective default value.
       */
      LCmdFilePanelSortOptions ();
      virtual ~LCmdFilePanelSortOptions ();

   public:

      /**
       * Reset all the options in the object with their
       * respective default value.
       */
      void resetToDefault ();
};

#endif // #ifndef __LCMD_FILEPANELSORTOPTIONS
