/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#ifndef __LCMD_FILEPANELOBJRENDERER
#define __LCMD_FILEPANELOBJRENDERER

#include "glib/GThread.h"
#include "glib/util/GArray.h"
#include "lcmd/LCmdCopyFileItem.h"

/**
 * The class used to render Drag-N-Drop file objects to and from
 * one of the two file panels.
 *
 * @author  Leif Erik Larsen
 * @since   1998.10.09
 */
class LCmdFilePanelObjRenderer : public GThread
{
   public:

      /** A reference to the owner file panel object. */
      class LCmdFilePanel& ownerPanel;

      /** The handle of the object window. */
      HWND hWndObj;

      /** ID's used to define which action to take on the drop event. */
      enum DROPOPTYPE
      {
         /** Move the file from source path to destination path. */
         DROPOPTYPE_MOVE,

         /** Copy the file from source path to destination path. */
         DROPOPTYPE_COPY,

         /** Launch program (destination path) with the source path. */
         DROPOPTYPE_LAUNCHPROG
      };

      /** 
       * Parameter #2 for UM_DROPFILES. 
       *
       * @author  Leif Erik Larsen
       * @since   2003.12.01
       */
      class DropInfo : public GObject
      {
         public:

            DROPOPTYPE opType;
            GArray<LCmdCopyFileItem>* items;
            DropInfo ( DROPOPTYPE opType, GArray<LCmdCopyFileItem>* items ) : opType(opType), items(items) {}
            ~DropInfo () { delete items; }
      };

   public:

      explicit LCmdFilePanelObjRenderer ( class LCmdFilePanel& ownerPanel );
      virtual ~LCmdFilePanelObjRenderer ();

   protected:

      void run ();

   public:

      /**
       * Post the specified drop operation to the object window to
       * perform the rendering in a separate thread.
       */
      void postDropOperation ( class GDragInfo& di );

   private:

      enum { UM_OBJRENDERER_DODROP = WM_USER };
      void doDrop ( class GDragInfo& di );
      void killXfer ( DRAGTRANSFER* xfer );
      DRAGTRANSFER* makeXfer ( DRAGITEM* dragItem, USHORT usOp, LCmdFileItem* destItem );
      static MRESULT APIENTRY ObjectWndProc ( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 );
};

#endif // #ifndef __LCMD_FILEPANELOBJRENDERER
