/* --------------------------------------------------------------------------
 *
 * Copyright (C) 2007 Leif Erik Larsen, Kjerringvik, Norway.
 *
 * This file is part of the Open Source Edition of Larsen Commander, as
 * available from http://home.online.no/~leifel/lcmd/.  This code is free 
 * software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License version 3 only, as published by the 
 * Free Software Foundation.  
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 3 at http://www.gnu.org/licenses/gpl-3.0.txt for more details 
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * ------------------------------------------------------------------------ */

#include "lcmd/LCmdFilePanelModeWide.h"
#include "lcmd/LCmdFilePanel.h"

LCmdFilePanelModeWide::LCmdFilePanelModeWide ( LCmdFilePanel& fpanel,
                                               const GString& winName )
                      :LCmdFilePanelModeFull(fpanel, winName)
{
   columnsBar.ignoreIniProfile = true;
   columnsBar.setVisible(false);
   columnsBar.clmnExt.setVisible(false);
   columnsBar.clmnDate.setVisible(false);
   columnsBar.clmnTime.setVisible(false);

   // Full mode columns (that we inherit) are:
   // Icon - Filename - Extension - Size - Date - Time.
   //
   // But in Wide mode we want:
   // Icon - Size - Filename
   //
   // We have already hidden the columns Extension - Size - Date - Time.
   // Now, swap the Size and Filename columns on screen.
   columnsBar.setColumnPositionOnScreen(3, 1);

   // In Wide mode, we want the size column to be left aligned, - always!
   columnsBar.clmnSize.alwaysLeftAlign = true;
}

LCmdFilePanelModeWide::~LCmdFilePanelModeWide ()
{
}
